/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.load.AttributeDecl;
import com.xmlmind.xml.load.Decl;
import com.xmlmind.xml.load.ElementDecl;
import com.xmlmind.xml.load.NotationDecl;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public final class DTDSpec {
    public final String documentTypeName;
    public final String publicId;
    public final String systemId;
    public final URL baseURL;
    private ArrayList<Decl> internalSubset;
    private ArrayList<Decl> externalSubset;
    private Decl[] internalSubsetDecls;
    private Decl[] externalSubsetDecls;
    private byte internalSubsetFlag;
    private static final Decl[] NO_DECLS = new Decl[0];

    public DTDSpec(String string, String string2, String string3, URL uRL) {
        this(string, string2, string3, uRL, null);
    }

    public DTDSpec(String string, String string2, String string3, URL uRL, Decl[] declArray) {
        this.documentTypeName = string;
        this.publicId = string2;
        this.systemId = string3;
        this.baseURL = uRL;
        this.externalSubsetDecls = declArray;
        this.internalSubsetFlag = (byte)-1;
    }

    public ElementDecl elementDecl(String string, String string2, boolean bl) {
        ElementDecl elementDecl = new ElementDecl(string, string2);
        this.add(elementDecl, bl);
        return elementDecl;
    }

    public AttributeDecl attributeDecl(String string, String string2, String string3, String string4, String string5, boolean bl) {
        AttributeDecl attributeDecl = new AttributeDecl(string, string2, string3, string4, string5);
        this.add(attributeDecl, bl);
        return attributeDecl;
    }

    public NotationDecl notationDecl(String string, String string2, String string3, URL uRL, boolean bl) {
        NotationDecl notationDecl = new NotationDecl(string, string2, string3, uRL);
        this.add(notationDecl, bl);
        return notationDecl;
    }

    private void add(Decl decl, boolean bl) {
        if (bl) {
            if (this.externalSubset == null) {
                this.externalSubset = new ArrayList();
                if (this.externalSubsetDecls != null) {
                    DTDSpec.addAll(this.externalSubset, this.externalSubsetDecls);
                    this.externalSubsetDecls = null;
                }
            }
            this.externalSubset.add(decl);
        } else {
            if (this.internalSubset == null) {
                this.internalSubset = new ArrayList();
                if (this.internalSubsetDecls != null) {
                    DTDSpec.addAll(this.internalSubset, this.internalSubsetDecls);
                    this.internalSubsetDecls = null;
                }
            }
            this.internalSubset.add(decl);
        }
    }

    private static final void addAll(ArrayList<Decl> arrayList, Decl[] declArray) {
        for (Decl decl : declArray) {
            arrayList.add(decl);
        }
    }

    public void setInternalSubsetFlag(int n) {
        this.internalSubsetFlag = (byte)n;
    }

    public byte getInternalSubsetFlag() {
        return this.internalSubsetFlag;
    }

    public Decl[] getInternalSubsetDecls() {
        if (this.internalSubsetDecls == null) {
            if (this.internalSubset != null) {
                this.internalSubsetDecls = new Decl[this.internalSubset.size()];
                this.internalSubset.toArray(this.internalSubsetDecls);
                this.internalSubset = null;
            } else {
                this.internalSubsetDecls = NO_DECLS;
            }
        }
        return this.internalSubsetDecls;
    }

    public Decl[] getExternalSubsetDecls() {
        if (this.externalSubsetDecls == null) {
            if (this.externalSubset != null) {
                this.externalSubsetDecls = new Decl[this.externalSubset.size()];
                this.externalSubset.toArray(this.externalSubsetDecls);
                this.externalSubset = null;
            } else {
                this.externalSubsetDecls = NO_DECLS;
            }
        }
        return this.externalSubsetDecls;
    }

    public boolean isGrammar() {
        return this.externalSubsetIsGrammar() || this.internalSubsetIsGrammar();
    }

    public boolean externalSubsetIsGrammar() {
        for (Decl decl : this.getExternalSubsetDecls()) {
            if (decl.declType != Decl.Type.ELEMENT) continue;
            return true;
        }
        return false;
    }

    public boolean internalSubsetIsGrammar() {
        for (Decl decl : this.getInternalSubsetDecls()) {
            if (decl.declType != Decl.Type.ELEMENT) continue;
            return true;
        }
        return false;
    }

    public URL getExternalSubsetURL() {
        if (this.systemId == null) {
            return null;
        }
        URL uRL = null;
        String string = XMLCatalogs.getResolvedEntity(this.publicId, this.systemId);
        try {
            uRL = string != null ? URLUtil.createURL(string) : URLUtil.createURL(this.baseURL, this.systemId);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }
}

