/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.Console;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.load.AttributeDecl;
import com.xmlmind.xml.load.DTDAccelerator;
import com.xmlmind.xml.load.DTDSpec;
import com.xmlmind.xml.load.Decl;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.Entities;
import com.xmlmind.xml.load.EntityDecl;
import com.xmlmind.xml.load.ExternalEntityDecl;
import com.xmlmind.xml.load.InternalEntityDecl;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.UnparsedEntityDecl;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import org.xml.sax.InputSource;

public final class DTDAcceleratorImpl
implements DTDAccelerator {
    private int capacity;
    private Entry first;
    private Entry last;
    private int size;

    public DTDAcceleratorImpl(int n) {
        this.capacity = n;
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized InputSource get(URL uRL, DTDSpec[] dTDSpecArray, Console console) {
        String string = URLUtil.toLabel(uRL);
        DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.fetchingDTD", string));
        Entry entry = null;
        Entry entry2 = this.last;
        while (entry2 != null) {
            if (entry2.url.equals(uRL)) {
                entry = entry2;
                break;
            }
            entry2 = entry2.previous;
        }
        if (entry != null && entry.isObsolete()) {
            DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.discardingObsoleteDTD", string));
            this.detach(entry);
            entry = null;
        }
        if (entry == null) {
            entry = this.load(uRL, string, console);
            this.attach(entry);
            DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.dtdCached", string, entry.source == null ? "*" : ""));
        } else {
            if (entry != this.last) {
                this.detach(entry);
                this.attach(entry);
            }
            DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.dtdFetched", string, entry.source == null ? "*" : ""));
        }
        if (entry.source == null) {
            return null;
        }
        dTDSpecArray[0] = new DTDSpec(dTDSpecArray[0].documentTypeName, dTDSpecArray[0].publicId, dTDSpecArray[0].systemId, dTDSpecArray[0].baseURL, entry.decls);
        dTDSpecArray[0].setInternalSubsetFlag(0);
        InputSource inputSource = new InputSource(new StringReader(entry.source));
        inputSource.setSystemId(entry.url.toExternalForm());
        return inputSource;
    }

    private Entry load(URL uRL, String string, Console console) {
        long l = System.currentTimeMillis();
        DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.loadingDTD", string));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version='1.0'?>\n");
        stringBuilder.append("<!DOCTYPE dummy SYSTEM ");
        String string2 = uRL.toExternalForm();
        char c = string2.indexOf(34) < 0 ? (char)'\"' : '\'';
        stringBuilder.append(c);
        stringBuilder.append(string2);
        stringBuilder.append(c);
        stringBuilder.append(">\n");
        stringBuilder.append("<dummy/>\n");
        InputSource inputSource = new InputSource(new StringReader(stringBuilder.toString()));
        inputSource.setSystemId("(string)");
        DocumentLoader documentLoader = new DocumentLoader();
        Document document = null;
        try {
            document = documentLoader.load(inputSource);
            DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.dtdLoaded", string, System.currentTimeMillis() - l));
        }
        catch (Exception exception) {
            DTDAcceleratorImpl.verbose(console, Msg.msg("DAI.cannotLoadDTD", string, ThrowableUtil.reason(exception)));
        }
        String string3 = null;
        Decl[] declArray = null;
        if (document != null) {
            Entities entities = (Entities)document.getProperty(Constants.ENTITIES_PROPERTY);
            DTDSpec dTDSpec = documentLoader.getDTDSpec();
            if (entities != null && dTDSpec != null && (declArray = dTDSpec.getExternalSubsetDecls()) != null) {
                stringBuilder = new StringBuilder();
                if (!this.appendNamespaces(declArray, stringBuilder)) {
                    declArray = null;
                    string3 = null;
                } else {
                    this.appendEntities(entities, stringBuilder);
                    string3 = stringBuilder.toString();
                }
            }
        }
        return new Entry(uRL, string3, declArray);
    }

    private boolean appendNamespaces(Decl[] declArray, StringBuilder stringBuilder) {
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        block4: for (Decl decl : declArray) {
            switch (decl.declType) {
                case ELEMENT: {
                    bl = true;
                    continue block4;
                }
                case ATTRIBUTE: {
                    AttributeDecl attributeDecl = (AttributeDecl)decl;
                    if (!attributeDecl.aName.startsWith("xmlns")) continue block4;
                    if (!hashSet.contains(attributeDecl.eName)) {
                        hashSet.add(attributeDecl.eName);
                        stringBuilder.append("<!ELEMENT ");
                        stringBuilder.append(attributeDecl.eName);
                        stringBuilder.append(" ANY>\n");
                    }
                    attributeDecl.toString(stringBuilder);
                    stringBuilder.append('\n');
                }
            }
        }
        return bl;
    }

    private void appendEntities(Entities entities, StringBuilder stringBuilder) {
        block5: for (EntityDecl entityDecl : entities.getAll()) {
            switch (entityDecl.declType) {
                case INTERNAL_ENTITY: {
                    EntityDecl entityDecl2 = (InternalEntityDecl)entityDecl;
                    stringBuilder.append("<!ENTITY ");
                    stringBuilder.append(((InternalEntityDecl)entityDecl2).name);
                    stringBuilder.append(' ');
                    Decl.appendValue(((InternalEntityDecl)entityDecl2).value, stringBuilder);
                    stringBuilder.append(">\n");
                    continue block5;
                }
                case EXTERNAL_ENTITY: {
                    EntityDecl entityDecl2 = (ExternalEntityDecl)entityDecl;
                    URL uRL = ((ExternalEntityDecl)entityDecl2).getURL();
                    String string = uRL == null ? ((ExternalEntityDecl)entityDecl2).systemId : uRL.toExternalForm();
                    stringBuilder.append("<!ENTITY ");
                    stringBuilder.append(((ExternalEntityDecl)entityDecl2).name);
                    stringBuilder.append(' ');
                    Decl.appendExternalId(((ExternalEntityDecl)entityDecl2).publicId, string, stringBuilder);
                    stringBuilder.append(">\n");
                    continue block5;
                }
                case UNPARSED_ENTITY: {
                    EntityDecl entityDecl2 = (UnparsedEntityDecl)entityDecl;
                    URL uRL = ((ExternalEntityDecl)entityDecl2).getURL();
                    String string = uRL == null ? ((UnparsedEntityDecl)entityDecl2).systemId : uRL.toExternalForm();
                    stringBuilder.append("<!ENTITY ");
                    stringBuilder.append(((UnparsedEntityDecl)entityDecl2).name);
                    stringBuilder.append(' ');
                    Decl.appendExternalId(((UnparsedEntityDecl)entityDecl2).publicId, string, stringBuilder);
                    stringBuilder.append(" NDATA ");
                    stringBuilder.append(((UnparsedEntityDecl)entityDecl2).notationName);
                    stringBuilder.append(">\n");
                }
            }
        }
    }

    private void detach(Entry entry) {
        assert (entry.previous != null || entry.next != null || entry == this.last);
        Entry entry2 = entry.previous;
        Entry entry3 = entry.next;
        entry.previous = null;
        entry.next = null;
        if (entry2 == null) {
            this.first = entry3;
        } else {
            entry2.next = entry3;
        }
        if (entry3 == null) {
            this.last = entry2;
        } else {
            entry3.previous = entry2;
        }
        --this.size;
    }

    private void attach(Entry entry) {
        assert (entry.previous == null && entry.next == null && entry != this.last);
        if (this.last == null) {
            this.first = this.last = entry;
        } else {
            this.last.next = entry;
            entry.previous = this.last;
            this.last = entry;
        }
        ++this.size;
    }

    @Override
    public synchronized void clear(Console console) {
        this.last = null;
        this.first = null;
        this.size = 0;
        DTDAcceleratorImpl.info(console, Msg.msg("DAI.cacheCleared"));
    }

    private static void info(Console console, String string) {
        if (console != null) {
            console.showMessage(string, Console.MessageType.INFO);
        }
    }

    private static void verbose(Console console, String string) {
        if (console != null) {
            console.showMessage(string, Console.MessageType.VERBOSE);
        }
    }

    private static final class Entry {
        public Entry previous;
        public Entry next;
        public final URL url;
        public final String source;
        public final Decl[] decls;
        private final File file;
        private final long date;

        public Entry(URL uRL, String string, Decl[] declArray) {
            this.url = uRL;
            this.source = string;
            this.decls = declArray;
            this.file = URLUtil.urlToFile(uRL);
            this.date = this.file != null ? this.file.lastModified() : -1L;
        }

        public boolean isObsolete() {
            if (this.file == null || this.date <= 0L) {
                return false;
            }
            return !this.file.isFile() || this.file.lastModified() != this.date;
        }
    }
}

