/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.dtd;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.dtd.DTD;
import com.xmlmind.xml.dtd.Msg;
import com.xmlmind.xml.load.AttributeDecl;
import com.xmlmind.xml.load.DTDLoader;
import com.xmlmind.xml.load.DTDSpec;
import com.xmlmind.xml.load.Decl;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.ElementDecl;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import com.xmlmind.xml.load.NotationDecl;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.ENTITIESType;
import com.xmlmind.xml.wxs.datatype.ENTITYType;
import com.xmlmind.xml.wxs.datatype.IDREFSType;
import com.xmlmind.xml.wxs.datatype.IDREFType;
import com.xmlmind.xml.wxs.datatype.IDType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.NMTOKENSType;
import com.xmlmind.xml.wxs.datatype.NMTOKENType;
import com.xmlmind.xml.wxs.datatype.NOTATIONType;
import com.xmlmind.xml.wxs.datatype.QNameValue;
import com.xmlmind.xml.wxs.datatype.Restriction;
import com.xmlmind.xml.wxs.datatype.StringType;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.AttributeUse;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.Notation;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.ParticleParser;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import com.xmlmind.xml.wxs.validate.Wildcard;
import com.xmlmind.xml.wxs.validate.WildcardParticle;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DTDLoaderImpl
implements DTDLoader,
NamespacePrefixMap {
    private boolean lenientAny = false;
    private URL externalSubsetURL;
    private ArrayList<LoadErrorImpl> errorList;
    private ArrayList<LoadErrorImpl> warningList;
    private Namespace defaultNS;
    private HashMap<String, Namespace> prefixToNS;
    private IdentityHashMap<Namespace, String> nsToPrefix;
    private ParticleParser particleParser;
    private IdentityHashMap<Name, Name> undeclaredElementNames;
    private HashMap<SharedAttribute, SharedAttribute> sharedAttributes;
    private LoadErrorImpl[] errors = LoadErrorImpl.NO_ERRORS;
    private LoadErrorImpl[] warnings = LoadErrorImpl.NO_ERRORS;
    private static final SequenceParticle ANY_SEQUENCE = new SequenceParticle(new Particle[]{new WildcardParticle(Wildcard.ANY_STRICT, 1, 1)}, 0, -1);
    private static final SequenceParticle LENIENT_ANY_SEQUENCE = new SequenceParticle(new Particle[]{new WildcardParticle(Wildcard.ANY_SKIP, 1, 1)}, 0, -1);

    @Override
    public void setLenientAny(boolean bl) {
        this.lenientAny = bl;
    }

    @Override
    public boolean getLenientAny() {
        return this.lenientAny;
    }

    @Override
    public DTD loadSubDocumentType(URL uRL) throws IOException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version='1.0'?>\n");
        stringBuilder.append("<!DOCTYPE dummy SYSTEM ");
        String string = uRL.toExternalForm();
        char c = string.indexOf(34) < 0 ? (char)'\"' : '\'';
        stringBuilder.append(c);
        stringBuilder.append(string);
        stringBuilder.append(c);
        stringBuilder.append(">\n");
        stringBuilder.append("<dummy/>\n");
        InputSource inputSource = new InputSource(new StringReader(stringBuilder.toString()));
        inputSource.setSystemId("(string)");
        DocumentLoader documentLoader = new DocumentLoader();
        try {
            object = documentLoader.load(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new IOException(DocumentLoader.format(sAXParseException));
        }
        catch (SAXException sAXException) {
            throw new IOException(ThrowableUtil.reason(sAXException));
        }
        object = documentLoader.getDTDSpec();
        assert (object != null);
        return this.loadSubDocumentType((DTDSpec)object);
    }

    @Override
    public LoadError[] getLoadErrors() {
        return this.errors;
    }

    @Override
    public LoadError[] getLoadWarnings() {
        return this.warnings;
    }

    @Override
    public DTD loadSubDocumentType(DTDSpec dTDSpec) {
        DTD dTD = new DTD(dTDSpec.publicId, dTDSpec.systemId, dTDSpec.baseURL);
        this.errors = LoadErrorImpl.NO_ERRORS;
        this.warnings = LoadErrorImpl.NO_ERRORS;
        this.errorList = new ArrayList();
        this.warningList = new ArrayList();
        this.externalSubsetURL = dTDSpec.getExternalSubsetURL();
        this.defaultNS = null;
        this.prefixToNS = new HashMap();
        this.nsToPrefix = new IdentityHashMap();
        this.addPrefixes(dTDSpec);
        this.particleParser = new ParticleParser(true, this);
        this.addElementDecls(dTDSpec, dTD);
        if (dTD.getElementDeclarationCount() > 0) {
            this.addNotations(dTDSpec, dTD);
            this.undeclaredElementNames = new IdentityHashMap();
            this.sharedAttributes = new HashMap();
            this.addAttributeDecls(dTDSpec, dTD);
            this.checkElementDecls(dTD);
            if (this.externalSubsetURL != null) {
                dTD.setURLs(new URL[]{this.externalSubsetURL});
            }
            this.setDeclaredPrefixes(dTD);
            this.errors = this.errorList.toArray(LoadErrorImpl.NO_ERRORS);
            this.warnings = this.warningList.toArray(LoadErrorImpl.NO_ERRORS);
        } else {
            dTD = null;
            this.errors = LoadErrorImpl.NO_ERRORS;
            this.warnings = LoadErrorImpl.NO_ERRORS;
        }
        this.sharedAttributes = null;
        this.undeclaredElementNames = null;
        this.particleParser = null;
        this.nsToPrefix = null;
        this.prefixToNS = null;
        this.defaultNS = null;
        this.externalSubsetURL = null;
        this.errorList = null;
        this.warningList = null;
        return this.errors.length > 0 ? null : dTD;
    }

    private void addPrefixes(DTDSpec dTDSpec) {
        this.addPrefixes(dTDSpec.getExternalSubsetDecls());
        this.addPrefixes(dTDSpec.getInternalSubsetDecls());
        if (this.defaultNS == null) {
            this.defaultNS = Namespace.NONE;
        }
    }

    private void addPrefixes(Decl[] declArray) {
        for (int i = 0; i < declArray.length; ++i) {
            Decl decl = declArray[i];
            if (decl.declType != Decl.Type.ATTRIBUTE) continue;
            AttributeDecl attributeDecl = (AttributeDecl)decl;
            if (!attributeDecl.aName.startsWith("xmlns")) continue;
            this.addPrefix(attributeDecl);
        }
    }

    private void addPrefix(AttributeDecl attributeDecl) {
        String string = null;
        Namespace namespace = null;
        if (attributeDecl.aName.equals("xmlns")) {
            string = "";
        } else if (attributeDecl.aName.length() > 6 && attributeDecl.aName.charAt(5) == ':' && !XMLText.isNCName(string = attributeDecl.aName.substring(6))) {
            string = null;
        }
        if (string != null && "CDATA".equals(attributeDecl.type)) {
            if (attributeDecl.value != null && attributeDecl.value.length() > 0) {
                namespace = Namespace.get(attributeDecl.value);
            } else {
                this.addWarning(Msg.msg("noNamespaceBinding", attributeDecl.toString()));
                return;
            }
        }
        if (string == null || namespace == null) {
            this.addError(Msg.msg("unsupportedNamespaceBinding", attributeDecl.toString()));
            return;
        }
        Namespace namespace2 = null;
        if (string.length() == 0) {
            if (this.defaultNS == null) {
                this.defaultNS = namespace;
            } else if (this.defaultNS != namespace) {
                namespace2 = this.defaultNS;
            }
        } else {
            Namespace namespace3 = this.prefixToNS.put(string, namespace);
            if (namespace3 != namespace) {
                namespace2 = namespace3;
            }
            this.nsToPrefix.put(namespace, string);
        }
        if (namespace2 != null) {
            this.addError(Msg.msg("prefixReused", string, namespace2, namespace));
        }
    }

    private void setDeclaredPrefixes(DTD dTD) {
        int n = this.prefixToNS.size();
        if (this.defaultNS != null) {
            ++n;
        }
        if (n > 0) {
            PrefixEntry[] prefixEntryArray = new PrefixEntry[n];
            n = 0;
            if (this.defaultNS != null) {
                prefixEntryArray[n++] = new PrefixEntry("", this.defaultNS);
            }
            for (Map.Entry<String, Namespace> entry : this.prefixToNS.entrySet()) {
                prefixEntryArray[n++] = new PrefixEntry(entry.getKey(), entry.getValue());
            }
            dTD.setDeclaredPrefixes(prefixEntryArray);
        }
    }

    private void addNotations(DTDSpec dTDSpec, DTD dTD) {
        this.addNotations(dTDSpec.getExternalSubsetDecls(), dTD);
        this.addNotations(dTDSpec.getInternalSubsetDecls(), dTD);
    }

    private void addNotations(Decl[] declArray, DTD dTD) {
        for (int i = 0; i < declArray.length; ++i) {
            Decl decl = declArray[i];
            if (decl.declType != Decl.Type.NOTATION) continue;
            NotationDecl notationDecl = (NotationDecl)decl;
            Notation notation = new Notation(this.getName(notationDecl.name, false), notationDecl.publicId, notationDecl.systemId, notationDecl.baseURL);
            Notation notation2 = dTD.addNotation(notation);
            if (notation2 == null) continue;
            this.addError(Msg.msg("notationAlreadyDeclared", notationDecl.name));
        }
    }

    private Name getName(String string, boolean bl) {
        Name name = Name.parse(string, bl, this);
        if (name == null) {
            name = Name.get(Namespace.NONE, string);
        }
        return name;
    }

    private void addElementDecls(DTDSpec dTDSpec, DTD dTD) {
        this.addElementDecls(dTDSpec.getExternalSubsetDecls(), dTD);
        this.addElementDecls(dTDSpec.getInternalSubsetDecls(), dTD);
    }

    private void addElementDecls(Decl[] declArray, DTD dTD) {
        for (int i = 0; i < declArray.length; ++i) {
            Decl decl = declArray[i];
            if (decl.declType != Decl.Type.ELEMENT) continue;
            ElementDecl elementDecl = (ElementDecl)decl;
            this.addElementDecl(elementDecl, dTD);
        }
    }

    private void addElementDecl(ElementDecl elementDecl, DTD dTD) {
        ElementDeclaration elementDeclaration;
        ComplexType complexType = new ComplexType(null, ComplexType.ANY, 1, false, 0, 0);
        String string = elementDecl.model;
        if (!"EMPTY".equals(string)) {
            if ("ANY".equals(string)) {
                complexType.setContentType(this.lenientAny ? LENIENT_ANY_SEQUENCE : ANY_SEQUENCE, true);
            } else {
                boolean bl = string.indexOf("#PCDATA") >= 0;
                try {
                    Particle particle = bl ? this.particleParser.parseMixedContent(string) : this.particleParser.parseElementContent(string);
                    complexType.setContentType(particle, bl);
                }
                catch (ParticleParser.ParseException parseException) {
                    this.addError(Msg.msg("invalidContentSpec", string, elementDecl.name, parseException.getMessage()));
                    complexType.setContentType(ANY_SEQUENCE, true);
                }
            }
        }
        if (dTD.addElementDeclaration(elementDeclaration = new ElementDeclaration(this.getName(elementDecl.name, false), complexType, null, false, false, 0, false)) != null) {
            this.addError(Msg.msg("elementTypeAlreadyDeclared", elementDecl.name));
        }
    }

    private void addAttributeDecls(DTDSpec dTDSpec, DTD dTD) {
        this.addAttributeDecls(dTDSpec.getExternalSubsetDecls(), dTD);
        this.addAttributeDecls(dTDSpec.getInternalSubsetDecls(), dTD);
    }

    private void addAttributeDecls(Decl[] declArray, DTD dTD) {
        for (int i = 0; i < declArray.length; ++i) {
            Decl decl = declArray[i];
            if (decl.declType != Decl.Type.ATTRIBUTE) continue;
            AttributeDecl attributeDecl = (AttributeDecl)decl;
            this.addAttributeDecl(attributeDecl, dTD);
        }
    }

    private void addAttributeDecl(AttributeDecl attributeDecl, DTD dTD) {
        Name name = this.getName(attributeDecl.eName, false);
        ElementDeclaration elementDeclaration = dTD.getElementDeclaration(name);
        if (elementDeclaration == null) {
            if (this.undeclaredElementNames.put(name, name) == null) {
                this.addWarning(Msg.msg("undeclaredElementType", name.format(false, this)));
            }
            return;
        }
        ComplexType complexType = (ComplexType)elementDeclaration.type;
        SharedAttribute sharedAttribute = this.shareAttribute(attributeDecl, elementDeclaration);
        if (complexType.addAttributeDeclaration(sharedAttribute.attributeDeclaration) != null) {
            this.addWarning(Msg.msg("attributeAlreadyDeclared", attributeDecl.aName, attributeDecl.eName));
        }
        boolean bl = true;
        Name name2 = sharedAttribute.attributeDeclaration.name;
        AttributeUse[] attributeUseArray = complexType.getAttributeUses();
        for (int i = 0; i < attributeUseArray.length; ++i) {
            if (attributeUseArray[i].name != name2) continue;
            attributeUseArray[i] = sharedAttribute.attributeUse;
            bl = false;
            break;
        }
        if (bl) {
            complexType.setAttributeUses(ArrayUtil.append(attributeUseArray, sharedAttribute.attributeUse));
        }
    }

    public SharedAttribute shareAttribute(AttributeDecl attributeDecl, ElementDeclaration elementDeclaration) {
        SharedAttribute sharedAttribute = new SharedAttribute(attributeDecl);
        SharedAttribute sharedAttribute2 = this.sharedAttributes.get(sharedAttribute);
        if (sharedAttribute2 == null) {
            sharedAttribute.compile(elementDeclaration);
            this.sharedAttributes.put(sharedAttribute, sharedAttribute);
            sharedAttribute2 = sharedAttribute;
        }
        return sharedAttribute2;
    }

    private void checkElementDecls(DTD dTD) {
        Iterator<ElementDeclaration> iterator = dTD.getElementDeclarations();
        while (iterator.hasNext()) {
            ElementDeclaration elementDeclaration = iterator.next();
            this.checkAttributes(elementDeclaration, dTD);
            Particle particle = ((ComplexType)elementDeclaration.type).getParticle();
            if (particle == null) continue;
            this.traverseParticle(particle, dTD);
        }
    }

    private void checkAttributes(ElementDeclaration elementDeclaration, DTD dTD) {
        ComplexType complexType = (ComplexType)elementDeclaration.type;
        int n = 0;
        int n2 = 0;
        Iterator<AttributeDeclaration> iterator = complexType.getAttributeDeclarations();
        while (iterator.hasNext()) {
            Value[] valueArray;
            AttributeDeclaration attributeDeclaration = iterator.next();
            if (attributeDeclaration.dataType instanceof IDType) {
                ++n;
                continue;
            }
            if (!(attributeDeclaration.dataType instanceof NOTATIONType)) continue;
            ++n2;
            if (complexType.getContentType() == ComplexType.ContentType.EMPTY) {
                this.addError(Msg.msg("emptyContentWithNotationAttribute", elementDeclaration.name.format(false, this), attributeDeclaration.name.format(true, this)));
            }
            if ((valueArray = attributeDeclaration.dataType.getEnumeration()) == null) continue;
            for (int i = 0; i < valueArray.length; ++i) {
                Name name = ((QNameValue)valueArray[i]).getName();
                if (dTD.getNotation(name) != null) continue;
                this.addError(Msg.msg("undeclaredNotationInAttribute", name.format(false, this), attributeDeclaration.name.format(true, this), elementDeclaration.name.format(false, this)));
            }
        }
        if (n > 1) {
            this.addError(Msg.msg("elementTypeWithSeveralIds", elementDeclaration.name.format(false, this)));
        }
        if (n2 > 1) {
            this.addError(Msg.msg("elementTypeWithSeveralNotations", elementDeclaration.name.format(false, this)));
        }
    }

    private void traverseParticle(Particle particle, DTD dTD) {
        switch (particle.getType()) {
            case ELEMENT: {
                Name name = ((ElementParticle)particle).elementName;
                if (dTD.getElementDeclaration(name) != null || this.undeclaredElementNames.put(name, name) != null) break;
                this.addWarning(Msg.msg("undeclaredElementType", name.format(false, this)));
                break;
            }
            case SEQUENCE: {
                this.traverseParticles(((SequenceParticle)particle).getParticles(), dTD);
                break;
            }
            case CHOICE: {
                this.traverseParticles(((ChoiceParticle)particle).getParticles(), dTD);
                break;
            }
            case ALL: {
                this.traverseParticles(((AllParticle)particle).getParticles(), dTD);
            }
        }
    }

    private void traverseParticles(Particle[] particleArray, DTD dTD) {
        for (int i = 0; i < particleArray.length; ++i) {
            this.traverseParticle(particleArray[i], dTD);
        }
    }

    private void addError(String string) {
        this.errorList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, this.externalSubsetURL, -1, -1, string));
    }

    private void addWarning(String string) {
        this.warningList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, this.externalSubsetURL, -1, -1, string));
    }

    @Override
    public Namespace prefixToNamespace(String string) {
        if (string.length() == 0) {
            return this.defaultNS;
        }
        if ("xml".equals(string)) {
            return Namespace.XML;
        }
        return this.prefixToNS.get(string);
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        if (namespace == Namespace.NONE) {
            return EMPTY_PREFIXES;
        }
        if (namespace == Namespace.XML) {
            return XML_PREFIXES;
        }
        String string = this.nsToPrefix.get(namespace);
        if (string == null) {
            if (namespace == this.defaultNS) {
                return EMPTY_PREFIXES;
            }
            return null;
        }
        if (namespace == this.defaultNS) {
            return new String[]{"", string};
        }
        return new String[]{string};
    }

    private final class SharedAttribute {
        private final String aName;
        private final String type;
        private final String mode;
        private final String value;
        public AttributeDeclaration attributeDeclaration;
        public AttributeUse attributeUse;

        public SharedAttribute(AttributeDecl attributeDecl) {
            this.aName = attributeDecl.aName;
            this.type = attributeDecl.type;
            this.mode = attributeDecl.mode;
            this.value = attributeDecl.value;
        }

        public int hashCode() {
            int n = this.aName.hashCode() ^ this.type.hashCode();
            if (this.mode != null) {
                n ^= this.mode.hashCode();
            }
            if (this.value != null) {
                n ^= this.value.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof SharedAttribute)) {
                return false;
            }
            SharedAttribute sharedAttribute = (SharedAttribute)object;
            return this.aName.equals(sharedAttribute.aName) && this.type.equals(sharedAttribute.type) && ObjectUtil.equals(this.mode, sharedAttribute.mode) && ObjectUtil.equals(this.value, sharedAttribute.value);
        }

        public void compile(ElementDeclaration elementDeclaration) {
            DataType dataType;
            Name name = DTDLoaderImpl.this.getName(this.aName, true);
            boolean bl = "#REQUIRED".equals(this.mode);
            if ("CDATA".equals(this.type)) {
                dataType = StringType.BASE;
            } else if ("ID".equals(this.type)) {
                dataType = IDType.BASE;
                if (this.value != null) {
                    DTDLoaderImpl.this.addError(Msg.msg("idAttributeWithDefault", this.aName, elementDeclaration.name.format(false, DTDLoaderImpl.this)));
                }
            } else {
                dataType = "IDREF".equals(this.type) ? IDREFType.BASE : ("IDREFS".equals(this.type) ? IDREFSType.BASE : ("NMTOKEN".equals(this.type) ? NMTOKENType.BASE : ("NMTOKENS".equals(this.type) ? NMTOKENSType.BASE : ("ENTITY".equals(this.type) ? ENTITYType.BASE : ("ENTITIES".equals(this.type) ? ENTITIESType.BASE : (this.type.startsWith("NOTATION") ? this.deriveEnumeration(NOTATIONType.BASE, this.type.substring(9), elementDeclaration) : this.deriveEnumeration(NMTOKENType.BASE, this.type, elementDeclaration)))))));
            }
            Value value = null;
            if (this.value != null && dataType != null) {
                try {
                    value = dataType.valueOf(this.value, DTDLoaderImpl.this);
                }
                catch (InvalidDataException invalidDataException) {
                    DTDLoaderImpl.this.addError(Msg.msg("invalidDefaultValue", this.value, this.aName, elementDeclaration.name.format(false, DTDLoaderImpl.this), invalidDataException.getMessage()));
                }
            }
            if (dataType == null) {
                dataType = StringType.BASE;
            }
            boolean bl2 = value != null && "#FIXED".equals(this.mode);
            this.attributeDeclaration = new AttributeDeclaration(name, dataType, value, bl2);
            this.attributeUse = new AttributeUse(name, bl);
        }

        private DataType deriveEnumeration(DataType dataType, String string, ElementDeclaration elementDeclaration) {
            String[] stringArray = null;
            if (string.startsWith("(") && string.endsWith(")") && (stringArray = StringUtil.split(string.substring(1, string.length() - 1), '|')).length == 0) {
                stringArray = null;
            }
            if (stringArray == null) {
                DTDLoaderImpl.this.addError(Msg.msg("invalidEnumSpec", this.aName, elementDeclaration.name.format(false, DTDLoaderImpl.this), string));
                return null;
            }
            Value[] valueArray = new Value[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    valueArray[i] = dataType.valueOf(stringArray[i], DTDLoaderImpl.this);
                    continue;
                }
                catch (InvalidDataException invalidDataException) {
                    DTDLoaderImpl.this.addError(Msg.msg("invalidEnumValue", stringArray[i], this.aName, elementDeclaration.name.format(false, DTDLoaderImpl.this), invalidDataException.getMessage()));
                    return null;
                }
            }
            Restriction restriction = new Restriction(dataType);
            try {
                restriction.setEnumeration(valueArray);
                return restriction.derive();
            }
            catch (InvalidTypeException invalidTypeException) {
                invalidTypeException.printStackTrace();
                return null;
            }
        }
    }
}

