/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentEvent;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;

public abstract class Tree
extends Node {
    protected Node first;

    protected Tree() {
    }

    public final Node getFirstChild() {
        return this.first;
    }

    public final Node getLastChild() {
        Node node = null;
        Node node2 = this.first;
        while (node2 != null) {
            node = node2;
            node2 = node2.next;
        }
        return node;
    }

    public final int getChildCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            ++n;
            node = node.next;
        }
        return n;
    }

    public final void appendChild(Node node) {
        this.insertChild(null, node);
    }

    public void insertChild(Node node, Node node2) {
        Document document;
        Node node3;
        if (!node2.isDetached()) {
            throw new IllegalArgumentException("added already attached");
        }
        if (node == null) {
            node3 = this.getLastChild();
        } else {
            if (node.getParent() != this) {
                throw new IllegalArgumentException("before not a child");
            }
            node3 = node.previous;
        }
        if (node3 != null) {
            node3.next = node2;
        }
        if (node != null) {
            node.previous = node2;
        }
        node2.setAttached(this, node3, node);
        if (this.first == node) {
            this.first = node2;
        }
        if ((document = this.getDocument()) != null) {
            document.fireTreeChanged(this, DocumentEvent.Type.CHILD_ADDED, node, null, node2);
        }
    }

    public final void removeChild(Node node) {
        this.replaceChild(node, null);
    }

    public final void removeAllChildren() {
        Node node = this.first;
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
    }

    public void replaceChild(Node node, Node node2) {
        Document document;
        Node node3;
        if (node.getParent() != this) {
            throw new IllegalArgumentException("removed not a child");
        }
        Node node4 = node.previous;
        Node node5 = node3 = node.next;
        if (node2 == null) {
            node.setDetached();
            if (node4 != null) {
                node4.next = node3;
            }
            if (node3 != null) {
                node3.previous = node4;
            }
            if (node == this.first) {
                this.first = node3;
            }
        } else {
            if (!node2.isDetached()) {
                throw new IllegalArgumentException("added already attached");
            }
            node.setDetached();
            if (node4 != null) {
                node4.next = node2;
            }
            if (node3 != null) {
                node3.previous = node2;
            }
            node2.setAttached(this, node4, node3);
            if (node == this.first) {
                this.first = node2;
            }
        }
        if ((document = this.getDocument()) != null) {
            DocumentEvent.Type type = node2 == null ? DocumentEvent.Type.CHILD_REMOVED : DocumentEvent.Type.CHILD_REPLACED;
            document.fireTreeChanged(this, type, node5, node, node2);
        }
    }

    public void updateInclusion(Node node, Node node2, Node[] nodeArray) {
        Node node3;
        if (nodeArray == null || nodeArray.length == 0) {
            throw new IllegalArgumentException("no replacement nodes");
        }
        boolean bl = true;
        Inclusion inclusion = (Inclusion)node.getProperty(Constants.INCLUSION_PROPERTY);
        if (inclusion == null) {
            bl = false;
        } else {
            boolean bl2 = false;
            node3 = node;
            while (node3 != null) {
                if (node3.getProperty(Constants.INCLUSION_PROPERTY) != inclusion) {
                    bl = false;
                    break;
                }
                if (node3 == node2) {
                    bl2 = true;
                    break;
                }
                node3 = node3.next;
            }
            if (!bl2) {
                throw new IllegalArgumentException("invalid replaced node range");
            }
            if (bl) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (nodeArray[i].getProperty(Constants.INCLUSION_PROPERTY) == inclusion) continue;
                    bl = false;
                    break;
                }
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("all replaced nodes and all replacement nodes must belong to the same inclusion");
        }
        Node[] nodeArray2 = this.doReplaceChildren(node, node2, nodeArray);
        node3 = this.getDocument();
        if (node3 != null) {
            ((Document)node3).fireInclusionUpdated(this, inclusion, nodeArray2, nodeArray);
        }
    }

    private final Node[] doReplaceChildren(Node node, Node node2, Node[] nodeArray) {
        Node node3;
        int n;
        if (node.parent != this) {
            throw new IllegalArgumentException("firstRemoved not a child");
        }
        if (node2 == node) {
            n = 1;
        } else {
            if (node2.parent != this) {
                throw new IllegalArgumentException("lastRemoved not a child");
            }
            boolean bl = false;
            n = 0;
            node3 = node;
            while (node3 != null) {
                ++n;
                if (node3 == node2) {
                    bl = true;
                    break;
                }
                node3 = node3.next;
            }
            if (!bl) {
                throw new IllegalArgumentException("lastRemoved does not follow firstRemoved");
            }
        }
        Node node4 = node.previous;
        node3 = node2.next;
        Node[] nodeArray2 = new Node[n];
        n = 0;
        Node node5 = node;
        while (node5 != null) {
            Node node6 = node5.next;
            node5.setDetached();
            nodeArray2[n++] = node5;
            if (node5 == node2) break;
            node5 = node6;
        }
        if (node4 != null) {
            node4.next = node3;
        }
        if (node3 != null) {
            node3.previous = node4;
        }
        if (node == this.first) {
            this.first = node3;
        }
        if (nodeArray != null && nodeArray.length > 0) {
            this.doInsertChildren(node3, nodeArray);
        }
        return nodeArray2;
    }

    private final void doInsertChildren(Node node, Node[] nodeArray) {
        Node node2;
        if (node == null) {
            node2 = this.getLastChild();
        } else {
            if (node.parent != this) {
                throw new IllegalArgumentException("before not a child");
            }
            node2 = node.previous;
        }
        if (node2 != null) {
            node2.next = nodeArray[0];
        }
        int n = nodeArray.length - 1;
        if (node != null) {
            node.previous = nodeArray[n];
        }
        for (int i = 0; i <= n; ++i) {
            Node node3 = nodeArray[i];
            if (!node3.isDetached()) {
                throw new IllegalArgumentException("added[" + i + "] already attached");
            }
            Node node4 = i == n ? node : nodeArray[i + 1];
            node3.setAttached(this, node2, node4);
            node2 = node3;
        }
        if (this.first == node) {
            this.first = nodeArray[0];
        }
    }

    public final boolean hasNoChildren() {
        return this.first == null;
    }

    public final Node getChild(int n) {
        int n2 = 0;
        Node node = this.first;
        while (node != null) {
            if (n2 == n) {
                return node;
            }
            ++n2;
            node = node.next;
        }
        return null;
    }

    public final int indexOfChild(Node node) {
        int n = 0;
        Node node2 = this.first;
        while (node2 != null) {
            if (node2 == node) {
                return n;
            }
            ++n;
            node2 = node2.next;
        }
        return -1;
    }

    public final Node[] getChildren() {
        Node[] nodeArray = new Node[this.getChildCount()];
        int n = 0;
        Node node = this.first;
        while (node != null) {
            nodeArray[n++] = node;
            node = node.next;
        }
        return nodeArray;
    }

    public final Object findProperty(Name name) {
        Object object = this.getProperty(name);
        if (object != null) {
            return object;
        }
        Node node = this.first;
        while (node != null) {
            object = node.getType() == Node.Type.ELEMENT ? ((Element)node).findProperty(name) : node.getProperty(name);
            if (object != null) {
                return object;
            }
            node = node.next;
        }
        return null;
    }

    @Override
    public void removeProperties(Name[] nameArray, boolean bl) {
        super.removeProperties(nameArray, false);
        if (bl) {
            Node node = this.first;
            while (node != null) {
                node.removeProperties(nameArray, true);
                node = node.next;
            }
        }
    }

    @Override
    public XNode firstChild() {
        return this.first;
    }

    @Override
    public XNode lastChild() {
        return this.getLastChild();
    }

    @Override
    void setDocument(Document document, boolean bl, int n) {
        super.setDocument(document, bl, n);
        Node node = this.first;
        while (node != null) {
            node.setDocument(document, bl, n);
            node = node.next;
        }
    }
}

