/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentEvent;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.name.Name;
import java.util.ArrayList;

public final class ProcessingInstruction
extends TextNode {
    private static final Object registeredTargetsLock = new Object();
    private static String[] registeredTargets = StringUtil.EMPTY_LIST;
    private String target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTarget(String string) {
        Object object = registeredTargetsLock;
        synchronized (object) {
            if (!StringList.contains(registeredTargets, string)) {
                registeredTargets = StringList.append(registeredTargets, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterTarget(String string) {
        Object object = registeredTargetsLock;
        synchronized (object) {
            registeredTargets = StringList.remove(registeredTargets, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getRegisteredTargets() {
        Object object = registeredTargetsLock;
        synchronized (object) {
            return registeredTargets;
        }
    }

    public static boolean isRegisteredTarget(String string) {
        String[] stringArray;
        for (String string2 : stringArray = ProcessingInstruction.getRegisteredTargets()) {
            if (!(string2.endsWith("*") ? string2.regionMatches(0, string, 0, string2.length() - 1) : string2.equals(string))) continue;
            return true;
        }
        return false;
    }

    public ProcessingInstruction(String string) {
        this(string, "");
    }

    public ProcessingInstruction(String string, String string2) {
        super(string2);
        this.target = string;
    }

    public ProcessingInstruction(String string, char[] cArray, int n, int n2) {
        super(cArray, n, n2);
        this.target = string;
    }

    @Override
    public Node copy() {
        ProcessingInstruction processingInstruction = new ProcessingInstruction(this.target, this.chars, 0, this.chars.length);
        this.copyProperties(processingInstruction);
        return processingInstruction;
    }

    @Override
    public Node.Type getType() {
        return Node.Type.PROCESSING_INSTRUCTION;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        if (string.equals(this.target)) {
            return;
        }
        String string2 = this.target;
        this.target = string;
        Document document = this.getDocument();
        if (document != null) {
            document.fireProcessingInstructionChanged(this, DocumentEvent.Type.TARGET_CHANGED, string2);
            if (ProcessingInstruction.isRegisteredTarget(string)) {
                document.firePITargetDetected(this);
            }
        }
    }

    @Override
    void setDocument(Document document, boolean bl, int n) {
        super.setDocument(document, bl, n);
        if (document != null && !bl && ProcessingInstruction.isRegisteredTarget(this.target)) {
            document.firePITargetDetected(this);
        }
    }

    public String[] getPseudoAttributes() {
        return ProcessingInstruction.parsePseudoAttributes(this.getText());
    }

    public static String[] parsePseudoAttributes(String string) {
        String[] stringArray = ProcessingInstruction.splitPseudoAttributes(string);
        if (stringArray.length % 3 != 0) {
            return null;
        }
        String[] stringArray2 = new String[2 * (stringArray.length / 3)];
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 3) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            String string4 = stringArray[i + 2];
            if (!string3.equals("=")) {
                return null;
            }
            if (string4.length() < 2) {
                return null;
            }
            char c = string4.charAt(0);
            if (c != '\'' && c != '\"') {
                return null;
            }
            int n2 = string4.length() - 1;
            char c2 = string4.charAt(n2);
            if (c2 != c) {
                return null;
            }
            string4 = string4.substring(1, n2);
            stringArray2[n++] = string2;
            if (string4.indexOf(59943) >= 0) {
                string4 = string4.replace('\uea27', '\'');
            }
            stringArray2[n++] = string4;
        }
        return stringArray2;
    }

    private static String[] splitPseudoAttributes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        char c = '\u0000';
        block5: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (c != '\u0000') {
                        stringBuilder.append(c2);
                        continue block5;
                    }
                    if (stringBuilder.length() <= 0) continue block5;
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue block5;
                }
                case '=': {
                    if (c != '\u0000') {
                        stringBuilder.append(c2);
                        continue block5;
                    }
                    if (stringBuilder.length() > 0) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                    }
                    arrayList.add("=");
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    if (c == '\u0000') {
                        stringBuilder.append(c2);
                        c = c2;
                        continue block5;
                    }
                    if (c == c2) {
                        stringBuilder.append(c2);
                        arrayList.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        c = '\u0000';
                        continue block5;
                    }
                    stringBuilder.append(c2);
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void setPseudoAttributes(String[] stringArray) {
        this.setText(ProcessingInstruction.formatPseudoAttributes(stringArray));
    }

    public static String formatPseudoAttributes(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i]);
            stringBuilder.append('=');
            String string = stringArray[i + 1];
            if (string == null) {
                string = "";
            }
            char c = string.indexOf(34) < 0 ? (char)'\"' : '\'';
            stringBuilder.append(c);
            if (c == '\'' && string.indexOf(39) >= 0) {
                string = string.replace('\'', '\uea27');
            }
            stringBuilder.append(string);
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public Name name() {
        return Name.get(this.target);
    }
}

