/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final String[] EMPTY_LIST = new String[0];

    private StringUtil() {
    }

    public static String[] split(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        int n;
        if (string.length() == 0) {
            return EMPTY_LIST;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(c, n3)) >= 0) {
            ++n2;
            ++n3;
        }
        String[] stringArray = new String[++n2];
        n2 = 0;
        n3 = 0;
        while ((n = string.indexOf(c, n3)) >= 0) {
            stringArray[n2++] = n3 == n ? "" : string.substring(n3, n);
            n3 = n + 1;
        }
        stringArray[n2++] = string.substring(n3);
        return stringArray;
    }

    public static String join(char c, String ... stringArray) {
        return StringUtil.join(Character.toString(c), stringArray);
    }

    public static String join(String string, String ... stringArray) {
        int n = stringArray.length;
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return stringArray[0];
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String shortenText(String string, int n) {
        int n2;
        if (n < 3) {
            n = 3;
        }
        if ((n2 = string.length()) <= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n / 2;
        stringBuilder.append(string.substring(0, n3));
        stringBuilder.append('\u2026');
        stringBuilder.append(string.substring(n2 - n3 - 1));
        return stringBuilder.toString();
    }

    public static final String[] wordWrap(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = StringUtil.split(string, '\n');
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ((string2 = string2.trim()).length() == 0) {
                arrayList.add("");
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = stringBuilder.length();
                if (n2 > 0 && n2 + string3.length() > n) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    n2 = 0;
                }
                if (n2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string3);
            }
            if (stringBuilder.length() <= 0) continue;
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public static String[] splitArguments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                if (c != '\u0000') {
                    stringBuilder.append(c2);
                    continue;
                }
                if (stringBuilder == null) continue;
                arrayList.add(stringBuilder.toString());
                stringBuilder = null;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        c = c2;
                        break;
                    }
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                }
                continue;
            }
            if (c2 == c) {
                int n2 = stringBuilder.length() - 1;
                if (n2 >= 0 && stringBuilder.charAt(n2) == '\\') {
                    stringBuilder.setCharAt(n2, c);
                    continue;
                }
                arrayList.add(stringBuilder.toString());
                stringBuilder = null;
                c = '\u0000';
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder != null) {
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static String joinArguments(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(StringUtil.quoteArgument(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String quoteArgument(String string) {
        boolean bl;
        int n = string.length();
        if (n == 0) {
            bl = true;
        } else {
            block0 : switch (string.charAt(0)) {
                case '\"': 
                case '\'': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    for (int i = 0; i < n; ++i) {
                        if (!Character.isWhitespace(string.charAt(i))) continue;
                        bl = true;
                        break block0;
                    }
                }
            }
        }
        if (!bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String substituteVars(String string, char[] cArray, Object[] objectArray) {
        return StringUtil.substituteVars(string, cArray, objectArray, null, null, false);
    }

    public static String substituteVars(String string, char[] cArray, Object[] objectArray, String[] stringArray, String string2) {
        return StringUtil.substituteVars(string, cArray, objectArray, stringArray, string2, false);
    }

    public static String substituteVars(String string, char[] cArray, Object[] objectArray, String[] stringArray, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.length();
        block21: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 1: {
                    switch (c) {
                        case '%': {
                            stringBuilder.append('%');
                            n = 0;
                            continue block21;
                        }
                        case '{': {
                            n = 2;
                            continue block21;
                        }
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (stringArray == null) {
                                stringBuilder.append('%');
                                stringBuilder.append(c);
                            } else if (c == '*') {
                                stringBuilder.append(string2 == null ? StringUtil.joinArguments(stringArray) : string2);
                            } else {
                                char c2;
                                int n3;
                                for (n3 = i + 1; n3 < n2 && (c2 = string.charAt(n3)) >= '0' && c2 <= '9'; ++n3) {
                                }
                                String string3 = string.substring(i, n3);
                                int n4 = -1;
                                try {
                                    n4 = Integer.parseInt(string3);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (n4 >= 0 && n4 < stringArray.length) {
                                    stringBuilder.append(stringArray[n4]);
                                } else {
                                    stringBuilder.append('%');
                                    stringBuilder.append(string3);
                                }
                                i = n3 - 1;
                            }
                            n = 0;
                            continue block21;
                        }
                    }
                    if (cArray == null) {
                        stringBuilder.append('%');
                        stringBuilder.append(c);
                    } else {
                        Object object = null;
                        for (int j = 0; j < cArray.length; ++j) {
                            if (c != cArray[j]) continue;
                            object = objectArray[j];
                            break;
                        }
                        if (object == null) {
                            stringBuilder.append('%');
                            stringBuilder.append(c);
                        } else {
                            stringBuilder.append(object.toString());
                        }
                    }
                    n = 0;
                    continue block21;
                }
                case 2: {
                    String string4;
                    int n5;
                    switch (c) {
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            char c3;
                            int n6;
                            if (stringArray == null) {
                                stringBuilder.append("%{");
                                stringBuilder.append(c);
                                n = 0;
                                continue block21;
                            }
                            if (c == '*') {
                                stringBuilder.append(string2 == null ? StringUtil.joinArguments(stringArray) : string2);
                                n = 3;
                                continue block21;
                            }
                            for (n6 = i + 1; n6 < n2 && (c3 = string.charAt(n6)) >= '0' && c3 <= '9'; ++n6) {
                            }
                            String string5 = string.substring(i, n6);
                            int n7 = -1;
                            try {
                                n7 = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n7 >= 0 && n7 < stringArray.length) {
                                stringBuilder.append(stringArray[n7]);
                                n = 3;
                            } else {
                                stringBuilder.append("%{");
                                stringBuilder.append(string5);
                                n = 0;
                            }
                            i = n6 - 1;
                            continue block21;
                        }
                    }
                    if (cArray == null) {
                        String string6;
                        int n8;
                        if (bl && (n8 = string.indexOf(125, i + 1)) > i + 1 && (string6 = StringUtil.getForeignVar(string, i, n8)) != null) {
                            stringBuilder.append(string6);
                            n = 3;
                            i = n8 - 1;
                        }
                        if (n == 3) continue block21;
                        stringBuilder.append("%{");
                        stringBuilder.append(c);
                        n = 0;
                        continue block21;
                    }
                    Object object = null;
                    for (n5 = 0; n5 < cArray.length; ++n5) {
                        if (c != cArray[n5]) continue;
                        object = objectArray[n5];
                        break;
                    }
                    if (object != null && i + 1 < n2 && string.charAt(i + 1) == '}') {
                        stringBuilder.append(object.toString());
                        n = 3;
                        continue block21;
                    }
                    if (bl && (n5 = string.indexOf(125, i + 1)) > i + 1 && (string4 = StringUtil.getForeignVar(string, i, n5)) != null) {
                        stringBuilder.append(string4);
                        n = 3;
                        i = n5 - 1;
                    }
                    if (n == 3) continue block21;
                    stringBuilder.append("%{");
                    stringBuilder.append(c);
                    n = 0;
                    continue block21;
                }
                case 3: {
                    if (c != '}') {
                        stringBuilder.append(c);
                    }
                    n = 0;
                    continue block21;
                }
                default: {
                    if (c == '%') {
                        n = 1;
                        continue block21;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        switch (n) {
            case 1: {
                stringBuilder.append('%');
                break;
            }
            case 2: {
                stringBuilder.append("%{");
            }
        }
        return stringBuilder.toString();
    }

    private static String getForeignVar(String string, int n, int n2) {
        String string2 = null;
        String string3 = string.substring(n, n2).trim();
        if (string3.length() > 0 && (string2 = System.getProperty(string3)) == null) {
            string2 = System.getenv(string3);
        }
        return string2;
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string2.length();
        int n3 = 0;
        while ((n = string.indexOf(string2, n3)) >= 0) {
            if (n > n3) {
                stringBuilder.append(string.substring(n3, n));
            }
            stringBuilder.append(string3);
            n3 = n + n2;
        }
        if (n3 < string.length()) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        StringUtil.escape(string, stringBuilder);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.escape(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(String string, StringBuilder stringBuilder) {
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        stringBuilder.append(c);
                        continue block10;
                    }
                    StringUtil.escape(c, stringBuilder);
                }
            }
        }
    }

    public static String escape(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.escape(c, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(char c, StringBuilder stringBuilder) {
        stringBuilder.append("\\u");
        String string = Integer.toString(c, 16);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    public static String unquote(String string) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            return StringUtil.unescape(string, 1, n - 2);
        }
        return StringUtil.unescape(string, 0, n);
    }

    public static String unescape(String string) {
        return StringUtil.unescape(string, 0, string.length());
    }

    private static String unescape(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n + n2;
        block16: for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 == n3) {
                        stringBuilder.append(c);
                        continue block16;
                    }
                    switch (string.charAt(i + 1)) {
                        case 'b': {
                            stringBuilder.append('\b');
                            ++i;
                            continue block16;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            ++i;
                            continue block16;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            ++i;
                            continue block16;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            ++i;
                            continue block16;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            ++i;
                            continue block16;
                        }
                        case '\"': {
                            stringBuilder.append('\"');
                            ++i;
                            continue block16;
                        }
                        case '\'': {
                            stringBuilder.append('\'');
                            ++i;
                            continue block16;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            ++i;
                            continue block16;
                        }
                        case 'u': {
                            if (i + 5 >= n3) break;
                            int n4 = -1;
                            try {
                                n4 = Integer.parseInt(string.substring(i + 2, i + 6), 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n4 < 0) break;
                            stringBuilder.append((char)n4);
                            i += 5;
                            continue block16;
                        }
                    }
                    stringBuilder.append(c);
                    continue block16;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

