/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.KeyValuePair;
import com.xmlmind.util.LinearHashtable;
import java.util.Iterator;

public abstract class PropertySet {
    protected LinearHashtable<Object, Object> properties = null;
    private static final PropertyIterator NO_PROPERTY_ITERATOR = new PropertyIterator(new LinearHashtable<Object, Object>());

    protected PropertySet() {
    }

    public void putProperties(PropertySet propertySet) {
        if (propertySet.properties == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinearHashtable();
        }
        Iterator<KeyValuePair<Object, Object>> iterator = propertySet.properties.entries();
        while (iterator.hasNext()) {
            KeyValuePair<Object, Object> keyValuePair = iterator.next();
            this.properties.put(keyValuePair.key, keyValuePair.value);
        }
    }

    public Object putProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new LinearHashtable();
        }
        return this.properties.put(object, object2);
    }

    public Object removeProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        Object object2 = this.properties.remove(object);
        if (this.properties.size() == 0) {
            this.properties = null;
        }
        return object2;
    }

    public void removeAllProperties() {
        this.properties = null;
    }

    public boolean hasProperty(Object object) {
        return this.properties == null ? false : this.properties.get(object) != null;
    }

    public Object getProperty(Object object) {
        return this.properties == null ? null : this.properties.get(object);
    }

    public int getPropertyCount() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public Iterator<Object[]> getProperties() {
        if (this.properties == null) {
            return NO_PROPERTY_ITERATOR;
        }
        return new PropertyIterator(this.properties);
    }

    private static class PropertyIterator
    implements Iterator<Object[]> {
        private Iterator<KeyValuePair<Object, Object>> entries;
        private Object[] keyValuePair = new Object[2];

        public PropertyIterator(LinearHashtable<Object, Object> linearHashtable) {
            this.entries = linearHashtable.entries();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Object[] next() {
            KeyValuePair<Object, Object> keyValuePair = this.entries.next();
            this.keyValuePair[0] = keyValuePair.key;
            this.keyValuePair[1] = keyValuePair.value;
            return this.keyValuePair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

