/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.GlobMatcher;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.SystemUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;

public final class GlobFilter
implements FilenameFilter {
    public final String globPattern;
    public final GlobMatcher globMatcher;

    public GlobFilter(String string) throws PatternSyntaxException {
        this.globPattern = string;
        this.globMatcher = GlobMatcher.containsGlobChar(string, false) ? new GlobMatcher(string) : null;
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.globMatcher == null) {
            return string.equals(this.globPattern);
        }
        return this.globMatcher.matches(string);
    }

    public static GlobFilter create(String string) {
        GlobFilter globFilter = null;
        try {
            globFilter = new GlobFilter(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return globFilter;
    }

    public static File[] glob(String string) {
        File file = GlobFilter.resolve(string, null, true);
        return GlobFilter.glob(file);
    }

    public static File resolve(String string, File file, boolean bl) {
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            int n;
            String string2;
            boolean bl2 = true;
            if (bl && string.startsWith("~")) {
                string2 = System.getProperty("user.name");
                String string3 = System.getProperty("user.home");
                if (string2 != null && string3 != null) {
                    n = string.indexOf(File.separatorChar, 1);
                    if (n < 0) {
                        n = string.length();
                    }
                    if (n == 1) {
                        file2 = new File(string3 + string.substring(1));
                        bl2 = false;
                    } else {
                        int n2 = SystemUtil.IS_WINDOWS ? string3.toLowerCase().indexOf(string2.toLowerCase()) : string3.indexOf(string2);
                        if (n2 >= 0) {
                            String string4 = string.substring(1, n);
                            StringBuilder stringBuilder = new StringBuilder();
                            if (n2 > 0) {
                                stringBuilder.append(string3.substring(0, n2));
                            }
                            stringBuilder.append(string4);
                            if ((n2 += string2.length()) < string3.length()) {
                                stringBuilder.append(string3.substring(n2));
                            }
                            file2 = new File(stringBuilder.toString() + string.substring(n));
                            bl2 = false;
                        }
                    }
                }
            }
            if (bl2) {
                if (file == null && (string2 = System.getProperty("user.dir")) != null) {
                    file = new File(string2);
                }
                if (SystemUtil.IS_WINDOWS) {
                    boolean bl3 = false;
                    int n3 = string.length();
                    if (n3 >= 2 && string.charAt(1) == ':') {
                        n = string.charAt(0);
                        boolean bl4 = bl3 = n >= 97 && n <= 122 || n >= 65 && n <= 90;
                    }
                    file2 = bl3 ? file2.getAbsoluteFile() : new File(file, string);
                } else {
                    file2 = new File(file, string);
                }
            }
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2;
    }

    public static File[] glob(File file) {
        File file2;
        String string = null;
        String string2 = null;
        String string3 = file.getPath();
        if (SystemUtil.IS_WINDOWS) {
            int n = string3.indexOf(92, 2);
            if (n >= 2) {
                string = string3.substring(0, n + 1);
                string2 = string3.substring(n + 1);
            }
        } else if (string3.startsWith("/")) {
            string = "/";
            string2 = string3.substring(1);
        }
        if (string == null || !(file2 = new File(string)).isDirectory()) {
            return new File[0];
        }
        if (string2.length() == 0) {
            return new File[]{file2};
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        GlobFilter.doGlob(file2, StringUtil.split(string2, File.separatorChar), 0, arrayList);
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    private static void doGlob(File file, String[] stringArray, int n, ArrayList<File> arrayList) {
        int n2;
        File[] fileArray;
        final String string = stringArray[n];
        FilenameFilter filenameFilter = GlobFilter.create(string);
        if (filenameFilter == null) {
            filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string2) {
                    return string2.equals(string);
                }
            };
        }
        if ((fileArray = file.listFiles(filenameFilter)) == null || (n2 = fileArray.length) == 0) {
            return;
        }
        if (++n == stringArray.length) {
            for (int i = 0; i < n2; ++i) {
                arrayList.add(fileArray[i]);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory()) continue;
                GlobFilter.doGlob(file2, stringArray, n, arrayList);
            }
        }
    }
}

