/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.Console;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public final class ConsoleCapture {
    public final Console console;
    private static final int[] nesting = new int[1];
    private static PrintStream systemOut;
    private static PrintStream systemErr;

    public ConsoleCapture(Console console) {
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        int[] nArray = nesting;
        synchronized (nesting) {
            if (nesting[0] == 0) {
                systemOut = System.out;
                systemErr = System.err;
                try {
                    System.setOut(new PrintStream((OutputStream)new OutputBuffer(this.console, Console.MessageType.INFO), true, "UTF-8"));
                    System.setErr(new PrintStream((OutputStream)new OutputBuffer(this.console, Console.MessageType.ERROR), true, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            nesting[0] = nesting[0] + 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        int[] nArray = nesting;
        synchronized (nesting) {
            if (nesting[0] > 0) {
                nesting[0] = nesting[0] - 1;
                if (nesting[0] == 0) {
                    System.out.close();
                    System.err.close();
                    System.setOut(systemOut);
                    System.setErr(systemErr);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static final class OutputBuffer
    extends OutputStream {
        private final Console console;
        private final Console.MessageType messageType;
        private final byte[] bytes1;
        private byte[] byteBuffer;
        private int byteCount;

        public OutputBuffer(Console console, Console.MessageType messageType) {
            this.console = console;
            this.messageType = messageType;
            this.bytes1 = new byte[1];
            this.byteBuffer = new byte[6];
            this.byteCount = 0;
        }

        @Override
        public synchronized void write(int n) {
            this.bytes1[1] = (byte)(n & 0xFF);
            this.write(this.bytes1, 0, 1);
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) {
            if (n2 > 0) {
                if (this.byteCount + n2 > this.byteBuffer.length) {
                    byte[] byArray2 = new byte[Math.max(2 * this.byteBuffer.length, this.byteCount + n2)];
                    System.arraycopy(this.byteBuffer, 0, byArray2, 0, this.byteCount);
                    this.byteBuffer = byArray2;
                }
                System.arraycopy(byArray, n, this.byteBuffer, this.byteCount, n2);
                this.byteCount += n2;
                this.flush();
            }
        }

        @Override
        public synchronized void flush() {
            int n;
            int n2 = 0;
            for (n = 0; n < this.byteCount; ++n) {
                int n3;
                byte by = this.byteBuffer[n];
                if (by != 10) continue;
                int n4 = n;
                if (n4 > 0 && this.byteBuffer[n4 - 1] == 13) {
                    --n4;
                }
                if ((n3 = n4 - n2) > 0) {
                    try {
                        String string = new String(this.byteBuffer, n2, n3, "UTF-8");
                        this.console.showMessage(string, this.messageType);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                n2 = n + 1;
            }
            if (n2 <= 0) {
                return;
            }
            n = this.byteCount - n2;
            if (n > 0) {
                System.arraycopy(this.byteBuffer, n2, this.byteBuffer, 0, n);
                this.byteCount = n;
            } else {
                this.byteCount = 0;
            }
        }

        @Override
        public synchronized void close() {
            this.flush();
            if (this.byteCount > 0) {
                try {
                    String string = new String(this.byteBuffer, 0, this.byteCount, "UTF-8");
                    this.console.showMessage(string, this.messageType);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
    }
}

