/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataURLConnection
extends URLConnection {
    public final byte[] bytes;
    public final String contentType;
    private Map<String, List<String>> headerFields;
    private static final String[] FIELD_NAMES = new String[]{"content-length", "content-type"};

    public DataURLConnection(URL uRL, byte[] byArray, String string) {
        super(uRL);
        this.bytes = byArray;
        this.contentType = string;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (this.headerFields == null) {
            this.headerFields = new HashMap<String, List<String>>();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Integer.toString(this.bytes.length));
            this.headerFields.put("content-length", arrayList);
            arrayList = new ArrayList();
            arrayList.add(this.contentType);
            this.headerFields.put("content-type", arrayList);
        }
        return this.headerFields;
    }

    @Override
    public String getHeaderField(String string) {
        List<String> list = this.getHeaderFields().get(string.toLowerCase());
        return list == null ? null : list.get(0);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return n < 0 || n >= FIELD_NAMES.length ? null : FIELD_NAMES[n];
    }

    @Override
    public String getHeaderField(int n) {
        String string = this.getHeaderFieldKey(n);
        if (string == null) {
            return null;
        }
        return this.getHeaderField(string);
    }
}

