/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.LabeledValue;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public final class ShowLog {
    private ShowLog() {
    }

    public static void showLog(Component component) {
        ShowLog.showLog(component, null, null, 1000);
    }

    public static void showLog(Component component, String string, String[] stringArray, final int n) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        String string2 = Msg.msg("category");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string2));
        DialogUtil.setDisplayedMnemonic(jLabel, string2);
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        ++gridBagConstraints.gridx;
        LabeledValue[] labeledValueArray = ShowLog.toLabels(Log.getNames(), stringArray);
        if (labeledValueArray.length > 1) {
            Arrays.sort(labeledValueArray, LabeledValue.compareByLabel);
        }
        final JComboBox<LabeledValue> jComboBox = new JComboBox<LabeledValue>(labeledValueArray);
        gridBagConstraints.insets.left = 5;
        jPanel.add(jComboBox, DialogUtil.px(gridBagConstraints));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jLabel.setLabelFor(jComboBox);
        final JTextPane jTextPane = new JTextPane();
        Font font = jTextPane.getFont();
        font = new Font("SansSerif", 0, AWTUtil.pxFontSize(font, -1));
        jTextPane.setFont(font);
        jTextPane.setBackground(Color.white);
        jTextPane.setForeground(Color.black);
        jTextPane.setEditable(false);
        JScrollPane jScrollPane = DialogUtil.createScrollPane(jTextPane);
        FontMetrics fontMetrics = jTextPane.getFontMetrics(font);
        jScrollPane.setPreferredSize(new Dimension(fontMetrics.charWidth('x') * 85, fontMetrics.getHeight() * 26));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)jScrollPane, DialogUtil.px(gridBagConstraints));
        if (labeledValueArray.length > 0) {
            int n2 = -1;
            if (string != null) {
                if ((string = string.trim()).startsWith("{}")) {
                    string = string.substring(2);
                }
                n2 = LabeledValue.indexOfValue(labeledValueArray, string);
            }
            if (n2 < 0) {
                n2 = 0;
            }
            jComboBox.setSelectedIndex(n2);
            ShowLog.setLog(jTextPane, (String)labeledValueArray[n2].value, n);
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LabeledValue labeledValue = (LabeledValue)jComboBox.getSelectedItem();
                    if (labeledValue != null) {
                        ShowLog.setLog(jTextPane, (String)labeledValue.value, n);
                        ShowLog.scrollToEnd(jTextPane);
                    }
                }
            });
        } else {
            jComboBox.setEnabled(false);
        }
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
        string2 = Msg.msg("messageLog");
        JDialog jDialog = jOptionPane.createDialog(DialogUtil.getDialogAnchor(component), string2);
        ShowLog.scrollToEnd(jTextPane);
        jDialog.setVisible(true);
    }

    private static LabeledValue[] toLabels(String[] stringArray, String[] stringArray2) {
        int n = stringArray2 == null ? 0 : stringArray2.length / 2 * 2;
        LabeledValue[] labeledValueArray = new LabeledValue[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            String string2;
            String string3;
            int n3;
            if (string.startsWith("{") && (n3 = string.lastIndexOf(125)) >= 1) {
                string3 = string.substring(1, n3);
                string2 = string.substring(n3 + 1);
            } else {
                string3 = "";
                string2 = string;
            }
            boolean bl = false;
            if (n == 0) {
                bl = true;
            } else {
                for (int i = 0; i < n; i += 2) {
                    String string4 = stringArray2[i];
                    String string5 = stringArray2[i + 1];
                    if (string4 != null && !string4.equals(string3) || string5 != null && !string5.equals(string2)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            String string6 = string3.length() == 0 ? string2 : string;
            labeledValueArray[n2++] = new LabeledValue(string2, string6);
        }
        if (n2 != labeledValueArray.length) {
            labeledValueArray = ArrayUtil.trimToSize(labeledValueArray, n2);
        }
        return labeledValueArray;
    }

    private static void setLog(JTextPane jTextPane, String string, int n) {
        int n2 = Log.Level.DEBUG.ordinal() + 1;
        SimpleAttributeSet[] simpleAttributeSetArray = new SimpleAttributeSet[n2];
        SimpleAttributeSet[] simpleAttributeSetArray2 = new SimpleAttributeSet[n2];
        for (int i = 0; i < n2; ++i) {
            simpleAttributeSetArray[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSetArray[i], Color.black);
            simpleAttributeSetArray2[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSetArray2[i], Color.black);
        }
        n2 = Log.Level.ERROR.ordinal();
        Color color = new Color(255, 192, 192);
        StyleConstants.setBackground(simpleAttributeSetArray[n2], color);
        color = new Color(255, 224, 224);
        StyleConstants.setBackground(simpleAttributeSetArray2[n2], color);
        n2 = Log.Level.WARNING.ordinal();
        color = new Color(255, 240, 192);
        StyleConstants.setBackground(simpleAttributeSetArray[n2], color);
        color = new Color(255, 240, 224);
        StyleConstants.setBackground(simpleAttributeSetArray2[n2], color);
        n2 = Log.Level.INFO.ordinal();
        color = new Color(255, 255, 240);
        StyleConstants.setBackground(simpleAttributeSetArray[n2], color);
        color = new Color(255, 255, 192);
        StyleConstants.setBackground(simpleAttributeSetArray2[n2], color);
        n2 = Log.Level.VERBOSE.ordinal();
        color = new Color(224, 224, 255);
        StyleConstants.setBackground(simpleAttributeSetArray[n2], color);
        color = new Color(240, 240, 255);
        StyleConstants.setBackground(simpleAttributeSetArray2[n2], color);
        n2 = Log.Level.DEBUG.ordinal();
        color = new Color(224, 224, 224);
        StyleConstants.setBackground(simpleAttributeSetArray[n2], color);
        color = new Color(240, 240, 240);
        StyleConstants.setBackground(simpleAttributeSetArray2[n2], color);
        Document document = jTextPane.getEditorKit().createDefaultDocument();
        Log.Item[] itemArray = Log.getLog(string).get(n);
        int n3 = itemArray.length;
        for (int i = 0; i < n3; ++i) {
            Log.Item item = itemArray[i];
            n2 = item.level.ordinal();
            SimpleAttributeSet simpleAttributeSet = i % 2 == 0 ? simpleAttributeSetArray[n2] : simpleAttributeSetArray2[n2];
            try {
                document.insertString(document.getLength(), item.message + "\n", simpleAttributeSet);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        jTextPane.setDocument(document);
    }

    private static void scrollToEnd(JTextPane jTextPane) {
        Dimension dimension = jTextPane.getPreferredSize();
        Rectangle rectangle = new Rectangle(0, dimension.height, 1, 1);
        jTextPane.scrollRectToVisible(rectangle);
    }
}

