/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SetTimePane
extends JPanel
implements ChangeListener,
ActionListener {
    protected Calendar calendar;
    protected EventListenerList listenerList;
    protected JButton midnightButton;
    protected JButton nowButton;
    protected JSpinner hourField;
    protected JSpinner minuteField;
    protected JSpinner secondField;
    protected boolean refreshing;

    public SetTimePane() {
        this(Calendar.getInstance());
    }

    public SetTimePane(Calendar calendar) {
        this.setLayout(new GridBagLayout());
        this.calendar = calendar;
        this.listenerList = new EventListenerList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 23, 1);
        this.hourField = new JSpinner(spinnerNumberModel);
        this.hourField.setEditor(new JSpinner.NumberEditor(this.hourField, "00"));
        this.hourField.addChangeListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.hourField, DialogUtil.px(gridBagConstraints));
        JLabel jLabel = new JLabel(":");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 8;
        this.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        spinnerNumberModel = new SpinnerNumberModel(0, 0, 59, 1);
        this.minuteField = new JSpinner(spinnerNumberModel);
        this.minuteField.setEditor(new JSpinner.NumberEditor(this.minuteField, "00"));
        this.minuteField.addChangeListener(this);
        ++gridBagConstraints.gridx;
        this.add((Component)this.minuteField, DialogUtil.px(gridBagConstraints));
        jLabel = new JLabel(":");
        ++gridBagConstraints.gridx;
        this.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        spinnerNumberModel = new SpinnerNumberModel(0, 0, 59, 1);
        this.secondField = new JSpinner(spinnerNumberModel);
        this.secondField.setEditor(new JSpinner.NumberEditor(this.secondField, "00"));
        this.secondField.addChangeListener(this);
        ++gridBagConstraints.gridx;
        this.add((Component)this.secondField, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(SetTimePane.class, "midnight.png");
        this.midnightButton = new JButton(iconResource);
        this.midnightButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.midnightButton);
        this.midnightButton.setToolTipText(Msg.msg("STP.midnight"));
        this.midnightButton.addActionListener(this);
        this.midnightButton.setActionCommand("midnight");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 16;
        this.add((Component)this.midnightButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(SetTimePane.class, "now.png");
        this.nowButton = new JButton(iconResource);
        this.nowButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.nowButton);
        this.nowButton.setToolTipText(Msg.msg("STP.now"));
        this.nowButton.addActionListener(this);
        this.nowButton.setActionCommand("now");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        this.add((Component)this.nowButton, DialogUtil.px(gridBagConstraints));
        this.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if ("midnight".equals(string)) {
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
        } else if ("now".equals(string)) {
            this.now();
        }
        this.refresh();
        this.notifyChangeListeners();
    }

    protected void now() {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.set(11, calendar.get(11));
        this.calendar.set(12, calendar.get(12));
        this.calendar.set(13, calendar.get(13));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.refreshing) {
            return;
        }
        Object object = changeEvent.getSource();
        if (object == this.hourField) {
            this.calendar.set(11, (Integer)this.hourField.getValue());
        } else if (object == this.minuteField) {
            this.calendar.set(12, (Integer)this.minuteField.getValue());
        } else if (object == this.secondField) {
            this.calendar.set(13, (Integer)this.secondField.getValue());
        }
        this.notifyChangeListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void notifyChangeListeners() {
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void focusForm() {
        this.hourField.requestFocus();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void refresh() {
        this.refreshing = true;
        int n = this.calendar.get(11);
        this.hourField.setValue(n);
        n = this.calendar.get(12);
        this.minuteField.setValue(n);
        n = this.calendar.get(13);
        this.secondField.setValue(n);
        this.refreshing = false;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.refresh();
    }
}

