/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.util.SystemUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SetDatePane
extends JPanel
implements ActionListener {
    protected Calendar calendar;
    protected DateFormatSymbols dateFormatSymbols;
    protected EventListenerList listenerList;
    protected JButton previousYearButton;
    protected JButton previousMonthButton;
    protected JPopupMenu setMonthMenu;
    protected JButton setMonthButton;
    protected JPopupMenu setYearMenu;
    protected JButton setYearButton;
    protected JButton nextMonthButton;
    protected JButton nextYearButton;
    protected JButton todayButton;
    protected JTable monthTable;
    protected boolean refreshing;
    protected static final int MODIFIER = SystemUtil.IS_MAC_OS ? 256 : 128;

    public SetDatePane() {
        this(Calendar.getInstance(), Locale.getDefault());
    }

    public SetDatePane(Calendar calendar, Locale locale) {
        String string;
        int n;
        this.setLayout(DialogUtil.pxBorderLayout(2, 2));
        this.setBorder(DialogUtil.pxEmptyBorder(2, 2, 2, 2));
        this.calendar = calendar;
        this.dateFormatSymbols = new DateFormatSymbols(locale);
        this.listenerList = new EventListenerList();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder((Border)null));
        this.add((Component)jPanel2, "Center");
        this.monthTable = this.createMonthTable();
        JTableHeader jTableHeader = this.monthTable.getTableHeader();
        Font font = jTableHeader.getFont();
        jTableHeader.setFont(AWTUtil.pxDeriveFont(font, 1, 0));
        jPanel2.add((Component)jTableHeader, "North");
        jPanel2.add((Component)this.monthTable, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.bottom = 2;
        IconResource iconResource = new IconResource(SetDatePane.class, "previousYear.png");
        this.previousYearButton = new JButton(iconResource);
        this.previousYearButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.previousYearButton);
        this.previousYearButton.setToolTipText(SetDatePane.toolTip(Msg.msg("SDP.previousYear"), 37, MODIFIER | 0x40));
        this.previousYearButton.setRolloverEnabled(true);
        this.previousYearButton.addActionListener(this);
        this.previousYearButton.setActionCommand("previousYear");
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.previousYearButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(SetDatePane.class, "previousMonth.png");
        this.previousMonthButton = new JButton(iconResource);
        this.previousMonthButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.previousMonthButton);
        this.previousMonthButton.setToolTipText(SetDatePane.toolTip(Msg.msg("SDP.previousMonth"), 37, MODIFIER));
        this.previousMonthButton.setRolloverEnabled(true);
        this.previousMonthButton.addActionListener(this);
        this.previousMonthButton.setActionCommand("previousMonth");
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.previousMonthButton, DialogUtil.px(gridBagConstraints));
        String[] stringArray = this.dateFormatSymbols.getMonths();
        this.setMonthMenu = new JPopupMenu();
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.length() <= 0) continue;
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("month_" + n);
            this.setMonthMenu.add(jMenuItem);
        }
        n = calendar.get(2);
        string = stringArray[n];
        iconResource = new IconResource(SetDatePane.class, "combo.png");
        this.setMonthButton = new JButton(string, iconResource);
        this.setMonthButton.setDisabledIcon(iconResource);
        this.setMonthButton.setHorizontalTextPosition(10);
        this.setMonthButton.setIconTextGap(AWTUtil.px(2));
        this.setMonthButton.setRolloverEnabled(true);
        SetDatePane.setFixedWidth(this.setMonthButton, stringArray, n);
        this.setMonthButton.addActionListener(this);
        this.setMonthButton.setActionCommand("setMonth");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 8;
        jPanel.add((Component)this.setMonthButton, DialogUtil.px(gridBagConstraints));
        this.addPopupMenu(this.setMonthButton, this.setMonthMenu);
        int n2 = calendar.get(1);
        this.setYearMenu = new JPopupMenu();
        for (int i = n2 - 10; i <= n2 + 10; ++i) {
            JMenuItem jMenuItem = new JMenuItem(Integer.toString(i));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("year_" + i);
            this.setYearMenu.add(jMenuItem);
        }
        iconResource = new IconResource(SetDatePane.class, "combo.png");
        string = Integer.toString(n2);
        this.setYearButton = new JButton(string, iconResource);
        this.setYearButton.setDisabledIcon(iconResource);
        this.setYearButton.setHorizontalTextPosition(10);
        SetDatePane.setFixedWidth(this.setYearButton, new String[]{string, "-99999"}, 0);
        this.setYearButton.setRolloverEnabled(true);
        this.setYearButton.addActionListener(this);
        this.setYearButton.setActionCommand("setYear");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        jPanel.add((Component)this.setYearButton, DialogUtil.px(gridBagConstraints));
        this.addPopupMenu(this.setYearButton, this.setYearMenu);
        iconResource = new IconResource(SetDatePane.class, "nextMonth.png");
        this.nextMonthButton = new JButton(iconResource);
        this.nextMonthButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.nextMonthButton);
        this.nextMonthButton.setToolTipText(SetDatePane.toolTip(Msg.msg("SDP.nextMonth"), 39, MODIFIER));
        this.nextMonthButton.setRolloverEnabled(true);
        this.nextMonthButton.addActionListener(this);
        this.nextMonthButton.setActionCommand("nextMonth");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 8;
        jPanel.add((Component)this.nextMonthButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(SetDatePane.class, "nextYear.png");
        this.nextYearButton = new JButton(iconResource);
        this.nextYearButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.nextYearButton);
        this.nextYearButton.setToolTipText(SetDatePane.toolTip(Msg.msg("SDP.nextYear"), 39, MODIFIER | 0x40));
        this.nextYearButton.setRolloverEnabled(true);
        this.nextYearButton.addActionListener(this);
        this.nextYearButton.setActionCommand("nextYear");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        jPanel.add((Component)this.nextYearButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(SetDatePane.class, "today.png");
        this.todayButton = new JButton(iconResource);
        this.todayButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.todayButton);
        this.todayButton.setToolTipText(SetDatePane.toolTip(Msg.msg("SDP.today"), 36, 0));
        this.todayButton.setRolloverEnabled(true);
        this.todayButton.addActionListener(this);
        this.todayButton.setActionCommand("today");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 8;
        gridBagConstraints.insets.right = 2;
        jPanel.add((Component)this.todayButton, DialogUtil.px(gridBagConstraints));
        this.refresh();
    }

    protected static final String toolTip(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" [");
        if (n2 != 0) {
            stringBuilder.append(KeyEvent.getModifiersExText(n2));
            stringBuilder.append('-');
        }
        stringBuilder.append(KeyEvent.getKeyText(n));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected static final void setFixedWidth(JButton jButton, String[] stringArray, int n) {
        Dimension dimension = jButton.getPreferredSize();
        FontMetrics fontMetrics = jButton.getFontMetrics(jButton.getFont());
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n4 = fontMetrics.stringWidth(stringArray[i]);
            if (i == n) {
                n2 = n4;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        dimension.width += n3 - n2;
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
    }

    protected void addPopupMenu(final JButton jButton, final JPopupMenu jPopupMenu) {
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showMenu(mouseEvent);
            }

            private void showMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    DialogUtil.showMenu(jPopupMenu, jButton);
                }
            }
        });
    }

    protected JTable createMonthTable() {
        Serializable serializable;
        int n;
        MonthTableModel monthTableModel = new MonthTableModel();
        JTable jTable = new JTable(monthTableModel);
        jTable.setSelectionMode(0);
        jTable.setCellSelectionEnabled(true);
        jTable.setDragEnabled(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setShowGrid(false);
        jTable.setAutoResizeMode(0);
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        int n2 = AWTUtil.px(4);
        jTable.setRowHeight(fontMetrics.getHeight() + n2);
        int n3 = AWTUtil.px(8);
        int n4 = 2 * fontMetrics.charWidth('9');
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        String[] stringArray = monthTableModel.columnNames;
        int n5 = monthTableModel.columnCount;
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n = Math.max(fontMetrics.stringWidth(stringArray[i]) + n3, n4);
            if (n <= n6) continue;
            n6 = n;
        }
        n6 += n2;
        DayRenderer dayRenderer = new DayRenderer(jTable);
        for (n = 0; n < n5; ++n) {
            serializable = tableColumnModel.getColumn(n);
            ((TableColumn)serializable).setHeaderValue(stringArray[n]);
            ((TableColumn)serializable).setPreferredWidth(n6);
            ((TableColumn)serializable).setResizable(false);
            ((TableColumn)serializable).setCellRenderer(dayRenderer);
        }
        InputMap inputMap = jTable.getInputMap(1);
        serializable = jTable.getActionMap();
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(27, 0), KeyStroke.getKeyStroke(10, 0), KeyStroke.getKeyStroke(113, 0)};
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            inputMap.put(keyStrokeArray[i], "no-op");
        }
        KeyStroke[] keyStrokeArray2 = new KeyStroke[]{KeyStroke.getKeyStroke(32, 0), KeyStroke.getKeyStroke(37, MODIFIER | 0x40), KeyStroke.getKeyStroke(37, MODIFIER), KeyStroke.getKeyStroke(39, MODIFIER), KeyStroke.getKeyStroke(39, MODIFIER | 0x40), KeyStroke.getKeyStroke(36, 0)};
        String[] stringArray2 = new String[]{"setDay", "previousYear", "previousMonth", "nextMonth", "nextYear", "today"};
        for (int i = 0; i < keyStrokeArray2.length; ++i) {
            String string = stringArray2[i];
            inputMap.put(keyStrokeArray2[i], string);
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SetDatePane.this.actionPerformed(actionEvent);
                }
            };
            abstractAction.putValue("ActionCommandKey", string);
            ((ActionMap)serializable).put(string, abstractAction);
        }
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    SetDatePane.this.setDay();
                }
            }
        });
        return jTable;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if ("setDay".equals(string)) {
            this.setDay();
            return;
        }
        if ("setMonth".equals(string)) {
            DialogUtil.showMenu(this.setMonthMenu, this.setMonthButton);
            return;
        }
        if ("setYear".equals(string)) {
            DialogUtil.showMenu(this.setYearMenu, this.setYearButton);
            return;
        }
        if ("previousYear".equals(string)) {
            this.calendar.set(1, this.calendar.get(1) - 1);
        } else if ("previousMonth".equals(string)) {
            this.calendar.set(2, this.calendar.get(2) - 1);
        } else if (string.startsWith("month_")) {
            int n = Integer.parseInt(string.substring(6));
            this.calendar.set(2, n);
        } else if (string.startsWith("year_")) {
            int n = Integer.parseInt(string.substring(5));
            this.calendar.set(1, n);
        } else if ("nextMonth".equals(string)) {
            this.calendar.set(2, this.calendar.get(2) + 1);
        } else if ("nextYear".equals(string)) {
            this.calendar.set(1, this.calendar.get(1) + 1);
        } else if ("today".equals(string)) {
            this.today();
        }
        this.refresh();
        this.monthTable.requestFocus();
        this.notifyChangeListeners();
    }

    protected void setDay() {
        int n = this.monthTable.getSelectedRow();
        int n2 = this.monthTable.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        MonthTableModel monthTableModel = (MonthTableModel)this.monthTable.getModel();
        calendar.setTimeInMillis(monthTableModel.getDate(n, n2));
        this.calendar.set(1, calendar.get(1));
        this.calendar.set(2, calendar.get(2));
        this.calendar.set(5, calendar.get(5));
        this.refresh();
        this.monthTable.requestFocus();
        this.notifyChangeListeners();
    }

    protected void today() {
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.calendar.set(1, calendar.get(1));
        this.calendar.set(2, calendar.get(2));
        this.calendar.set(5, calendar.get(5));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void notifyChangeListeners() {
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void focusForm() {
        this.monthTable.requestFocus();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void refresh() {
        this.refreshing = true;
        int n = this.calendar.get(2);
        String[] stringArray = this.dateFormatSymbols.getMonths();
        this.setMonthButton.setText(stringArray[n]);
        int n2 = this.calendar.get(1);
        this.setYearButton.setText(Integer.toString(n2));
        MonthTableModel monthTableModel = (MonthTableModel)this.monthTable.getModel();
        monthTableModel.refresh();
        this.monthTable.setRowSelectionInterval(monthTableModel.rowOfCurrentDay, monthTableModel.rowOfCurrentDay);
        this.monthTable.setColumnSelectionInterval(monthTableModel.columnOfCurrentDay, monthTableModel.columnOfCurrentDay);
        this.refreshing = false;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.refresh();
    }

    protected class DayRenderer
    extends DefaultTableCellRenderer {
        private MonthTableModel tableModel;
        private Border normalBorder;
        private Border focusBorder;
        private Border currentDayBorder;

        public DayRenderer(JTable jTable) {
            this.tableModel = (MonthTableModel)jTable.getModel();
            this.normalBorder = DialogUtil.pxEmptyBorder(1, 1, 1, 1);
            this.focusBorder = DialogUtil.pxLineBorder(jTable.getSelectionBackground().darker(), 1);
            this.currentDayBorder = DialogUtil.pxLineBorder(Color.red, 1);
            this.setBorder(this.normalBorder);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = n < this.tableModel.rowOfFirstDay || n == this.tableModel.rowOfFirstDay && n2 < this.tableModel.columnOfFirstDay || n > this.tableModel.rowOfLastDay || n == this.tableModel.rowOfLastDay && n2 > this.tableModel.columnOfLastDay;
            this.setEnabled(!bl3);
            if (n == this.tableModel.rowOfCurrentDay && n2 == this.tableModel.columnOfCurrentDay) {
                this.setBorder(this.currentDayBorder);
            } else if (bl2) {
                this.setBorder(this.focusBorder);
            } else {
                this.setBorder(this.normalBorder);
            }
            return this;
        }
    }

    protected class MonthTableModel
    extends AbstractTableModel {
        public int firstDayOfWeek;
        public String[] columnNames;
        public int rowCount;
        public int columnCount;
        public Integer[][] values;
        public long[][] dates;
        public int rowOfFirstDay;
        public int columnOfFirstDay;
        public int rowOfLastDay;
        public int columnOfLastDay;
        public int rowOfCurrentDay;
        public int columnOfCurrentDay;

        public MonthTableModel() {
            int n;
            String[] stringArray = SetDatePane.this.dateFormatSymbols.getShortWeekdays();
            this.firstDayOfWeek = SetDatePane.this.calendar.getFirstDayOfWeek();
            this.columnCount = SetDatePane.this.calendar.getMaximum(7) - SetDatePane.this.calendar.getMinimum(7) + 1;
            this.columnNames = new String[this.columnCount];
            int n2 = this.firstDayOfWeek;
            for (n = 0; n < this.columnCount; ++n) {
                if (n2 == stringArray.length) {
                    n2 = 1;
                }
                this.columnNames[n] = stringArray[n2++];
            }
            this.rowCount = SetDatePane.this.calendar.getMaximum(5) - SetDatePane.this.calendar.getMinimum(5) + 1;
            this.rowCount = (this.rowCount + (this.columnCount - 1)) / this.columnCount;
            ++this.rowCount;
            this.values = new Integer[this.rowCount][];
            for (n = 0; n < this.rowCount; ++n) {
                this.values[n] = new Integer[this.columnCount];
            }
            this.dates = new long[this.rowCount][];
            for (n = 0; n < this.rowCount; ++n) {
                this.dates[n] = new long[this.columnCount];
            }
            this.doRefresh();
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void refresh() {
            this.doRefresh();
            this.fireTableDataChanged();
        }

        private void doRefresh() {
            Calendar calendar = (Calendar)SetDatePane.this.calendar.clone();
            int n = calendar.getActualMinimum(5);
            int n2 = calendar.getActualMaximum(5);
            int n3 = calendar.get(2);
            int n4 = calendar.get(5);
            calendar.set(5, n);
            int n5 = this.dayToCol(calendar.get(7));
            if (n5 > 0) {
                calendar.add(5, -n5);
            } else {
                calendar.add(5, -this.columnCount);
            }
            this.columnOfFirstDay = -1;
            this.rowOfFirstDay = -1;
            this.columnOfLastDay = -1;
            this.rowOfLastDay = -1;
            this.columnOfCurrentDay = -1;
            this.rowOfCurrentDay = -1;
            for (int i = 0; i < this.rowCount; ++i) {
                Integer[] integerArray = this.values[i];
                long[] lArray = this.dates[i];
                for (int j = 0; j < this.columnCount; ++j) {
                    int n6 = calendar.get(5);
                    int n7 = calendar.get(2);
                    integerArray[j] = n6;
                    lArray[j] = calendar.getTimeInMillis();
                    if (n7 == n3) {
                        if (n6 == n) {
                            this.rowOfFirstDay = i;
                            this.columnOfFirstDay = j;
                        }
                        if (n6 == n2) {
                            this.rowOfLastDay = i;
                            this.columnOfLastDay = j;
                        }
                        if (n6 == n4) {
                            this.rowOfCurrentDay = i;
                            this.columnOfCurrentDay = j;
                        }
                    }
                    calendar.add(5, 1);
                }
            }
        }

        private int dayToCol(int n) {
            int n2 = n - this.firstDayOfWeek;
            if (n2 < 0) {
                n2 += this.columnCount;
            }
            return n2;
        }

        public long getDate(int n, int n2) {
            return this.dates[n][n2];
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.values[n][n2];
        }

        @Override
        public String getColumnName(int n) {
            return n >= 0 && n < this.columnNames.length ? this.columnNames[n] : "";
        }
    }
}

