/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class Separator
extends Component {
    private boolean isHorizontal;
    private int separation;
    private boolean drawLine;
    private int fixedSize;
    private static int THICKNESS;
    private static int GAP;

    public Separator() {
        this(false, 0, false, 0);
    }

    public Separator(boolean bl, int n, boolean bl2, int n2) {
        if (THICKNESS == 0) {
            THICKNESS = AWTUtil.px(1);
            GAP = AWTUtil.px(2);
        }
        this.isHorizontal = bl;
        if (n <= 0) {
            n = 1;
        }
        this.separation = n;
        this.drawLine = bl2;
        this.fixedSize = n2;
    }

    public void setHorizontal(boolean bl) {
        if (bl != this.isHorizontal) {
            this.isHorizontal = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public void setSeparation(int n) {
        if (n <= 0) {
            n = 1;
        }
        if (n != this.separation) {
            this.separation = n;
            this.invalidate();
            this.repaint();
        }
    }

    public int getSeparation() {
        return this.separation;
    }

    public void setDrawLine(boolean bl) {
        if (bl != this.drawLine) {
            this.drawLine = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean getDrawLine() {
        return this.drawLine;
    }

    public void setFixedSize(int n) {
        if (n != this.fixedSize) {
            this.fixedSize = n;
            this.invalidate();
            this.repaint();
        }
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.preferredSize(this.fixedSize > 0 ? this.fixedSize : 4 * GAP);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize(this.fixedSize > 0 ? this.fixedSize : 6 * GAP);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.preferredSize(this.fixedSize > 0 ? this.fixedSize : Integer.MAX_VALUE);
    }

    private Dimension preferredSize(int n) {
        int n2 = this.separation;
        if (this.drawLine && n2 < THICKNESS) {
            n2 = THICKNESS;
        }
        if (this.isHorizontal) {
            return new Dimension(n, n2);
        }
        return new Dimension(n2, n);
    }

    @Override
    public void paint(Graphics graphics) {
        block5: {
            int n;
            block4: {
                if (!this.drawLine) {
                    return;
                }
                Color color = AWTUtil.toSeparatorColor(this.getBackground());
                graphics.setColor(color);
                if (!this.isHorizontal) break block4;
                int n2 = (this.separation - THICKNESS) / 2;
                int n3 = this.getWidth() - GAP - 1;
                if (n3 <= GAP) break block5;
                for (n = THICKNESS; n > 0; --n) {
                    graphics.drawLine(GAP, n2, n3, n2);
                    ++n2;
                }
                break block5;
            }
            int n4 = (this.separation - THICKNESS) / 2;
            int n5 = this.getHeight() - GAP - 1;
            if (n5 > GAP) {
                while (n > 0) {
                    graphics.drawLine(n4, GAP, n4, n5);
                    ++n4;
                    --n;
                }
            }
        }
    }
}

