/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.ImageResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class IconResource
implements Icon {
    public final Image image;
    public final boolean isDoubleSizeImage;
    public final int width;
    public final int height;
    protected String description;
    protected Image disabledImage;

    public IconResource(Class<?> clazz, String string) {
        this(ImageResource.get(clazz, string));
    }

    public IconResource(URL uRL) {
        this(ImageResource.get(uRL));
    }

    public IconResource(Image image) {
        this.image = image;
        if (image == null) {
            this.isDoubleSizeImage = false;
            this.height = 0;
            this.width = 0;
        } else {
            this.isDoubleSizeImage = ImageResource.isDoubleSizeImage(image);
            if (this.isDoubleSizeImage) {
                this.width = image.getWidth(null) / 2;
                this.height = image.getHeight(null) / 2;
            } else {
                this.width = image.getWidth(null);
                this.height = image.getHeight(null);
            }
        }
    }

    public IconResource(Class<?> clazz, String string, Color color, Color color2) {
        this(ImageResource.get(clazz, string, color, color2));
    }

    public IconResource(URL uRL, Color color, Color color2) {
        this(ImageResource.get(uRL, color, color2));
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Image image = this.image;
        if (component != null && !component.isEnabled()) {
            if (this.disabledImage == null) {
                this.disabledImage = ImageResource.createDisabledImage(this.image);
            }
            image = this.disabledImage;
        }
        if (this.isDoubleSizeImage) {
            ImageResource.drawDoubleSizeImage(graphics, image, n, n2);
        } else {
            graphics.drawImage(image, n, n2, null);
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public static void setDisabledIcon(AbstractButton abstractButton, Icon icon) {
        if (icon == null || !(icon instanceof ImageIcon)) {
            abstractButton.setDisabledIcon(icon);
        }
    }

    public static void setDisabledIcon(JLabel jLabel, Icon icon) {
        if (icon == null || !(icon instanceof ImageIcon)) {
            jLabel.setDisabledIcon(icon);
        }
    }

    public static void setDisabledSelectedIcon(AbstractButton abstractButton, Icon icon) {
        if (icon == null || !(icon instanceof ImageIcon)) {
            abstractButton.setDisabledSelectedIcon(icon);
        }
    }

    public static Icon createDisabledIcon(Icon icon, JComponent jComponent) {
        Icon icon2;
        if (jComponent == null) {
            jComponent = new JButton();
        }
        if ((icon2 = UIManager.getLookAndFeel().getDisabledIcon(jComponent, icon)) == null) {
            icon2 = icon;
        }
        return icon2;
    }
}

