/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.MultiLineJLabel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class EditText {
    private static IconResource editIcon;

    private EditText() {
    }

    public static String editText(Component component, String string, String string2, boolean bl, int n, int n2) {
        return EditText.editText(component, string, string, string2, bl, n, n2, null);
    }

    public static String editText(Component component, String string, String string2, String string3, boolean bl, int n, int n2, Icon icon) {
        DialogBox dialogBox = new DialogBox(component, string, string2, bl, n, n2, icon);
        return dialogBox.editText(string3);
    }

    public static final class DialogBox
    extends DialogBase {
        private Icon icon;
        private String message;
        private JTextArea textArea;
        private String result;

        public DialogBox(Component component, String string, String string2, boolean bl, int n, int n2, Icon icon) {
            super(component, string, true);
            this.initialize(component, string2, bl, n, n2, icon);
        }

        protected void initialize(Component component, String string, boolean bl, int n, int n2, Icon icon) {
            if (icon == null) {
                if (editIcon == null) {
                    editIcon = new IconResource(EditText.class, "edit.png");
                }
                icon = editIcon;
            }
            this.icon = icon;
            this.message = string;
            this.textArea = new JTextArea("", n, n2);
            Font font = this.textArea.getFont();
            this.textArea.setFont(new Font(bl ? "SansSerif" : "Monospaced", 0, font.getSize()));
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(bl);
            super.initialize(component, 26);
        }

        @Override
        protected Component createForm() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.left = 5;
            jPanel.add((Component)new JLabel(this.icon), DialogUtil.px(gridBagConstraints));
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)new MultiLineJLabel(this.message), DialogUtil.px(gridBagConstraints));
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)DialogUtil.createScrollPane(this.textArea), DialogUtil.px(gridBagConstraints));
            return jPanel;
        }

        @Override
        public void ok() {
            this.result = this.textArea.getText();
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void cancel() {
            this.result = null;
            this.setVisible(false);
            this.dispose();
        }

        public String editText(String string) {
            if (string == null) {
                string = "";
            }
            this.textArea.setText(string);
            this.textArea.setCaretPosition(0);
            this.getRootPane().setDefaultButton(this.dialogButtons[0]);
            this.pack();
            this.setLocationRelativeTo(this.dialogAnchor);
            this.textArea.requestFocus();
            this.result = null;
            this.setVisible(true);
            return this.result;
        }
    }
}

