/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.Alert;
import com.xmlmind.guiutil.AsyncImagePreview;
import com.xmlmind.guiutil.ChooseFileOptions;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.FilterByExtension;
import com.xmlmind.guiutil.ImagePreview;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.util.SystemUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class ChooseFile {
    public static FileChooserImpl DEFAULT_CHOOSER = new FileChooserImpl();
    private static FileChooser fileChooser = DEFAULT_CHOOSER;
    private static final ChooseFileOptions DEFAULT_OPTIONS = new ChooseFileOptions();

    public static void setFileChooser(FileChooser fileChooser) {
        if (fileChooser == null) {
            fileChooser = DEFAULT_CHOOSER;
        }
        ChooseFile.fileChooser = fileChooser;
    }

    public static FileChooser getFileChooser() {
        return fileChooser;
    }

    public static File chooseOpenFile(Component component, File file, ChooseFileOptions chooseFileOptions) {
        return fileChooser.chooseOpenFile(component, file, chooseFileOptions);
    }

    public static File chooseSaveFile(Component component, File file, ChooseFileOptions chooseFileOptions) {
        return fileChooser.chooseSaveFile(component, file, chooseFileOptions);
    }

    public static File chooseOpenDirectory(Component component, File file, ChooseFileOptions chooseFileOptions) {
        return fileChooser.chooseOpenDirectory(component, file, chooseFileOptions);
    }

    public static File chooseSaveDirectory(Component component, File file, ChooseFileOptions chooseFileOptions) {
        return fileChooser.chooseSaveDirectory(component, file, chooseFileOptions);
    }

    public static File chooseFile(Component component, File file, boolean bl, boolean bl2, ChooseFileOptions chooseFileOptions) {
        boolean bl3;
        if (chooseFileOptions == null) {
            chooseFileOptions = DEFAULT_OPTIONS;
        }
        switch (SystemUtil.PLATFORM) {
            case WINDOWS: 
            case MAC_OS: {
                bl3 = chooseFileOptions.nativeDialog != null && chooseFileOptions.nativeDialog != false;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        Window window = DialogUtil.getDialogOwner(component);
        if (!bl3 || bl || window == null) {
            return ChooseFile.chooseFileJ(component, file, bl, bl2, chooseFileOptions);
        }
        return ChooseFile.chooseFileN(window, file, bl2, chooseFileOptions);
    }

    public static String getChooserTitle(boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                return Msg.msg("saveDir");
            }
            return Msg.msg("saveFile");
        }
        if (bl) {
            return Msg.msg("openDir");
        }
        return Msg.msg("openFile");
    }

    private static File chooseFileN(Window window, File file, boolean bl, ChooseFileOptions chooseFileOptions) {
        Object object;
        if (chooseFileOptions == null) {
            chooseFileOptions = DEFAULT_OPTIONS;
        }
        FileDialog fileDialog = window instanceof Dialog ? new FileDialog((Dialog)window) : new FileDialog((Frame)window);
        fileDialog.setMode(bl ? 1 : 0);
        String string = chooseFileOptions.title;
        if (string == null) {
            string = ChooseFile.getChooserTitle(false, bl);
        }
        fileDialog.setTitle(string);
        String string2 = null;
        String string3 = null;
        if (file == null) {
            string2 = System.getProperty("user.home");
        } else {
            file = file.getAbsoluteFile();
            string3 = bl && object != null && ((File)object).isDirectory() ? file.getName() : null;
            for (object = file.getParentFile(); object != null; object = ((File)object).getParentFile()) {
                if (!((File)object).isDirectory()) continue;
                string2 = ((File)object).getPath();
                break;
            }
        }
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        if (string3 != null) {
            fileDialog.setFile(string3);
        }
        fileDialog.setVisible(true);
        object = fileDialog.getFile();
        if (object == null) {
            return null;
        }
        return new File(fileDialog.getDirectory(), (String)object);
    }

    private static File chooseFileJ(Component component, File file, boolean bl, boolean bl2, ChooseFileOptions chooseFileOptions) {
        Object object;
        Object object2;
        if (chooseFileOptions == null) {
            chooseFileOptions = DEFAULT_OPTIONS;
        }
        File file2 = null;
        File file3 = null;
        if (file == null) {
            object2 = System.getProperty("user.home");
            if (object2 != null) {
                file2 = new File((String)object2);
            }
        } else {
            file2 = file.getParentFile();
            if (bl2 && file2 != null && file2.isDirectory()) {
                file3 = file;
            }
        }
        object2 = new JFileChooser(file2);
        ((JFileChooser)object2).setFileSelectionMode(bl ? 1 : 0);
        ((JFileChooser)object2).setFileHidingEnabled(!chooseFileOptions.showHiddenFiles);
        String string = chooseFileOptions.title;
        if (string == null) {
            string = ChooseFile.getChooserTitle(bl, bl2);
        }
        ((JFileChooser)object2).setDialogTitle(string);
        if (!bl) {
            ArrayList<Object> arrayList;
            if (chooseFileOptions.previewImages) {
                arrayList = new AsyncImagePreview();
                ((ImagePreview)((Object)arrayList)).setFileChooser((Component)object2);
                ((JFileChooser)object2).setAccessory((JComponent)((Object)arrayList));
            }
            arrayList = chooseFileOptions.filterList;
            object = chooseFileOptions.activeFilter;
            if (arrayList == null && file != null && (object = FilterByExtension.create(file)) != null) {
                arrayList = new ArrayList<Object>();
                arrayList.add(object);
                if (!bl2) {
                    object = null;
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                ChooseFile.addFileFilters((JFileChooser)object2, (List<FileFilter>)arrayList, (FileFilter)object);
            }
        }
        if (file3 != null) {
            ((JFileChooser)object2).setSelectedFile(file3);
        }
        if (chooseFileOptions.size != null && chooseFileOptions.size.width > 0 && chooseFileOptions.size.height > 0) {
            ((JComponent)object2).setPreferredSize(chooseFileOptions.size);
        }
        component = DialogUtil.getDialogAnchor(component);
        int n = bl2 ? ((JFileChooser)object2).showSaveDialog(component) : ((JFileChooser)object2).showOpenDialog(component);
        if (chooseFileOptions.size != null) {
            object = ((Component)object2).getSize();
            if (object == null || ((Dimension)object).width <= 0 || ((Dimension)object).height <= 0) {
                chooseFileOptions.size.height = -1;
                chooseFileOptions.size.width = -1;
            } else {
                chooseFileOptions.size.width = ((Dimension)object).width;
                chooseFileOptions.size.height = ((Dimension)object).height;
            }
        }
        if (n != 0) {
            return null;
        }
        object = ((JFileChooser)object2).getSelectedFile();
        if (bl2 && !bl && object != null && ((File)object).exists() && !chooseFileOptions.allowOverwrite && !Alert.confirm(component, Msg.msg("CF.overwriteFile", object))) {
            return null;
        }
        return object;
    }

    private static void addFileFilters(JFileChooser jFileChooser, List<FileFilter> list, FileFilter fileFilter) {
        int n;
        int n2 = list.size();
        if (fileFilter != null) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) != fileFilter) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                fileFilter = null;
            }
        }
        if (fileFilter == null) {
            jFileChooser.setAcceptAllFileFilterUsed(true);
        }
        for (n = 0; n < n2; ++n) {
            jFileChooser.addChoosableFileFilter(list.get(n));
        }
        if (fileFilter != null) {
            jFileChooser.setFileFilter(fileFilter);
        } else {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
    }

    public static final class FileChooserImpl
    implements FileChooser {
        @Override
        public File chooseOpenFile(Component component, File file, ChooseFileOptions chooseFileOptions) {
            return ChooseFile.chooseFile(component, file, false, false, chooseFileOptions);
        }

        @Override
        public File chooseSaveFile(Component component, File file, ChooseFileOptions chooseFileOptions) {
            return ChooseFile.chooseFile(component, file, false, true, chooseFileOptions);
        }

        @Override
        public File chooseOpenDirectory(Component component, File file, ChooseFileOptions chooseFileOptions) {
            return ChooseFile.chooseFile(component, file, true, false, chooseFileOptions);
        }

        @Override
        public File chooseSaveDirectory(Component component, File file, ChooseFileOptions chooseFileOptions) {
            return ChooseFile.chooseFile(component, file, true, true, chooseFileOptions);
        }
    }

    public static interface FileChooser {
        public File chooseOpenFile(Component var1, File var2, ChooseFileOptions var3);

        public File chooseSaveFile(Component var1, File var2, ChooseFileOptions var3);

        public File chooseOpenDirectory(Component var1, File var2, ChooseFileOptions var3);

        public File chooseSaveDirectory(Component var1, File var2, ChooseFileOptions var3);
    }
}

