/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.CSSProperties;
import com.xmlmind.w2x.processor.CSSRule;
import com.xmlmind.w2x.processor.CSSRules;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.ParseStylesCmd;
import com.xmlmind.w2x.processor.Util;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.xed.NodeUtil;
import com.xmlmind.xml.xpath.BooleanVariant;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.ExtensionFunctions;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NumberVariant;
import com.xmlmind.xml.xpath.SimpleFunction;
import com.xmlmind.xml.xpath.SimpleFunctionImpl;
import com.xmlmind.xml.xpath.SimpleFunctionTable;
import com.xmlmind.xml.xpath.StringVariant;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantExpr;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XPathFunctions
implements SimpleFunctionTable {
    private HashMap<String, Object> functionMap = new HashMap();
    private static final String[] MONOSPACED_FONT_FAMILIES = new String[]{"courier new", "courier", "monospace", "andale mono", "monaco", "lucida console", "lucida sans typewriter", "lucida typewriter", "anonymous", "anonymous pro", "arial monospaced", "bitstream vera", "vera sans mono", "consolas", "courierhp", "courierps", "fontcraft courier", "dejavu sans mono", "droid sans mono", "everson mono", "everson mono unicode", "fedra mono", "fixed", "fixedsys", "fixedsys excelsior", "inconsolata", "hyperfont", "letter gothic", "liberation mono", "micr", "menlo", "miriam fixed", "monofur", "ms gothic", "ms mincho", "nimbus mono l", "ocr-a", "ocr-b", "orator", "ormaxx", "pragmatapro", "prestige elite", "prestige", "sydnie", "terminal", "terminus", "tex gyre cursor", "um typewriter", "ubuntu mono", "vera sans mono", "william monospace"};
    private static final double MEDIUM_FONT_SIZE = 12.0;
    private static final double FONT_SIZE_SCALE = 1.2;

    @Override
    public synchronized SimpleFunction getSimpleFunction(String string) {
        SimpleFunction simpleFunction;
        Object object = this.functionMap.get(string = ExtensionFunctions.camelCase(string));
        if (object == null) {
            Method method = null;
            try {
                method = XPathFunctions.class.getMethod(string, SimpleFunction.METHOD_PARAMETER_TYPES);
            }
            catch (Exception exception) {
                // empty catch block
            }
            simpleFunction = method == null ? null : new SimpleFunctionImpl(null, method);
            this.functionMap.put(string, simpleFunction == null ? Boolean.FALSE : simpleFunction);
        } else {
            simpleFunction = object == Boolean.FALSE ? null : (SimpleFunction)object;
        }
        return simpleFunction;
    }

    public static Variant uniqueKeyValue(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("unique-key-value", variantExprArray, 2, 2);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string2 = variantExprArray[1].eval(xNode, exprContext).convertToString();
        Name name = Name.parse(string, true, xNode.namespacePrefixMap());
        if (name == null) {
            throw new EvalException(Msg.msg("notAQName", string));
        }
        NodeIterator nodeIterator = exprContext.getKeyedNodes(name, string2, xNode);
        if (nodeIterator.next() == null) {
            return new StringVariant(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append('-');
        int n = stringBuilder.length();
        for (int i = 2; i < 1000; ++i) {
            stringBuilder.setLength(n);
            stringBuilder.append(Integer.toString(i));
            String string3 = stringBuilder.toString();
            nodeIterator = exprContext.getKeyedNodes(name, string3, xNode);
            if (nodeIterator.next() != null) continue;
            return new StringVariant(string3);
        }
        throw new EvalException(Msg.msg("uniqueKeyValueFailure", string, string2));
    }

    public static Variant stringToId(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("string-to-id", variantExprArray, 1, 2);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        int n = -1;
        if (variantExprArray.length > 1) {
            n = (int)Math.rint(variantExprArray[1].eval(xNode, exprContext).convertToNumber());
        }
        if (n <= 0) {
            n = 40;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = cArray[i];
            if (i == 0 && XMLText.isNCNameStartChar((char)n5) || i > 0 && XMLText.isNCNameChar((char)n5)) {
                stringBuilder.append((char)n5);
                ++n4;
                n3 = n5;
            } else if (n3 != 95) {
                stringBuilder.append('_');
                ++n4;
                n3 = 95;
            }
            if (n4 >= n) break;
        }
        if (n4 == 0) {
            stringBuilder.append('_');
        }
        return new StringVariant(stringBuilder.toString());
    }

    public static Variant contentType(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("content-type", variantExprArray, 0, 1);
        int n = -1;
        Element element = XPathFunctions.getElement(variantExprArray, 0, xNode, exprContext);
        if (element != null) {
            n = NodeUtil.getContentType(element);
        }
        return new NumberVariant(n);
    }

    public static Variant orRegex(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        int n;
        Object object;
        XPathFunctions.checkArgCount("or-regex", variantExprArray, 1, Integer.MAX_VALUE);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < variantExprArray.length; ++i) {
            String string = variantExprArray[i].eval(xNode, exprContext).convertToString();
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        String[] stringArray = StringUtil.split(stringBuilder.toString());
        int n2 = stringArray.length;
        if (n2 > 1) {
            object = new String[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                String string = stringArray[i];
                boolean bl = false;
                for (int j = 0; j < i; ++j) {
                    if (!stringArray[j].equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object[n++] = string;
            }
            if (n != n2) {
                stringArray = ArrayUtil.trimToSize(object, n);
            }
        }
        if ((n2 = stringArray.length) == 1) {
            object = stringArray[0];
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append("^(");
            for (n = 0; n < n2; ++n) {
                String string = stringArray[n];
                if (n > 0) {
                    stringBuilder.append('|');
                }
                stringBuilder.append('(');
                stringBuilder.append(Pattern.quote(string));
                stringBuilder.append(')');
            }
            stringBuilder.append(")$");
            object = stringBuilder.toString();
        }
        return new StringVariant((String)object);
    }

    public static Variant getClass(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("get-class", variantExprArray, 0, 2);
        String string = "";
        if (variantExprArray.length > 0) {
            string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        }
        String string2 = null;
        Element element = XPathFunctions.getElement(variantExprArray, 1, xNode, exprContext);
        if (element != null) {
            string2 = XPathFunctions.getClass(element, string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return new StringVariant(string2);
    }

    public static String getClass(Element element, String string) {
        String string2;
        block3: {
            Matcher matcher;
            List<String> list;
            block6: {
                block4: {
                    int n;
                    block5: {
                        string2 = null;
                        list = ParseStylesCmd.getClassProperty(element);
                        if (list == null) break block3;
                        if (string.length() != 0) break block4;
                        n = list.size();
                        if (n != 1) break block5;
                        string2 = list.get(0);
                        break block3;
                    }
                    if (n <= 0) break block3;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(list.get(i));
                    }
                    string2 = stringBuilder.toString();
                    break block3;
                }
                matcher = Util.toMatcher(string);
                if (matcher != null) break block6;
                if (!list.contains(string)) break block3;
                string2 = string;
                break block3;
            }
            for (String string3 : list) {
                matcher.reset(string3);
                if (!matcher.find()) continue;
                string2 = string3;
                break;
            }
        }
        return string2;
    }

    public static Variant styleCount(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        LinearHashtable<String, String> linearHashtable;
        XPathFunctions.checkArgCount("style-count", variantExprArray, 0, 1);
        int n = 0;
        Element element = XPathFunctions.getElement(variantExprArray, 0, xNode, exprContext);
        if (element != null && (linearHashtable = ParseStylesCmd.getStyleProperty(element)) != null) {
            n = linearHashtable.size();
        }
        return new NumberVariant(n);
    }

    private static Element getElement(VariantExpr[] variantExprArray, int n, XNode xNode, ExprContext exprContext) throws EvalException {
        if (n < variantExprArray.length) {
            NodeIterator nodeIterator = variantExprArray[n].eval(xNode, exprContext).convertToNodeSet();
            XNode xNode2 = nodeIterator.next();
            if (xNode2 == null) {
                return null;
            }
            xNode = xNode2;
        }
        return XPathFunctions.toElement(xNode);
    }

    private static Element toElement(XNode xNode) {
        return xNode.type() == XNode.Type.ELEMENT ? (Element)xNode : null;
    }

    public static Variant getStyle(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        LinearHashtable<String, String> linearHashtable;
        XPathFunctions.checkArgCount("get-style", variantExprArray, 1, 2);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string2 = null;
        Element element = XPathFunctions.getElement(variantExprArray, 1, xNode, exprContext);
        if (element != null && (linearHashtable = ParseStylesCmd.getStyleProperty(element)) != null) {
            string2 = linearHashtable.get(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return new StringVariant(string2);
    }

    public static Variant lookupStyle(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("lookup-style", variantExprArray, 1, 2);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string2 = null;
        Element element = XPathFunctions.getElement(variantExprArray, 1, xNode, exprContext);
        if (element != null) {
            string2 = XPathFunctions.lookupStyle(element, string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return new StringVariant(string2);
    }

    public static String lookupStyle(Element element, String string) {
        String string2;
        block1: {
            CSSRules cSSRules = ParseStylesCmd.getRulesProperty(element);
            string2 = XPathFunctions.doLookupStyle(element, string, cSSRules);
            if (string2 != null || !CSSProperties.isInherited(string)) break block1;
            while ((element = element.getParentElement()) != null && (string2 = XPathFunctions.doLookupStyle(element, string, cSSRules)) == null) {
            }
        }
        return string2;
    }

    private static String doLookupStyle(Element element, String string, CSSRules cSSRules) {
        List<String> list;
        LinearHashtable<String, String> linearHashtable = ParseStylesCmd.getStyleProperty(element);
        if (linearHashtable != null && (list = linearHashtable.get(string)) != null) {
            return list;
        }
        if (cSSRules != null) {
            CSSRule cSSRule;
            String string2;
            list = ParseStylesCmd.getClassProperty(element);
            if (list != null) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    String string3;
                    string2 = (String)list.get(i);
                    CSSRule cSSRule2 = cSSRules.get("." + string2);
                    if (cSSRule2 == null || (string3 = cSSRule2.getProperty(string)) == null) continue;
                    return string3;
                }
            }
            if ((cSSRule = cSSRules.get(element.getLocalName())) != null && (string2 = cSSRule.getProperty(string)) != null) {
                return string2;
            }
        }
        return null;
    }

    public static Variant findRule(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("find-rule", variantExprArray, 1, 1);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        int n = -1;
        CSSRules cSSRules = ParseStylesCmd.getRulesProperty(xNode);
        if (cSSRules != null) {
            n = cSSRules.findFirst(string);
        }
        return new NumberVariant(n);
    }

    public static Variant getRule(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        String string;
        XPathFunctions.checkArgCount("get-rule", variantExprArray, 1, 2);
        String string2 = variantExprArray[0].eval(xNode, exprContext).convertToString();
        String string3 = null;
        if (variantExprArray.length >= 2 && (string3 = variantExprArray[1].eval(xNode, exprContext).convertToString()).length() == 0) {
            string3 = null;
        }
        if ((string = XPathFunctions.getRule(xNode, string2, string3)) == null) {
            string = "";
        }
        return new StringVariant(string);
    }

    public static String getRule(XNode xNode, String string, String string2) {
        CSSRule cSSRule;
        String string3 = null;
        CSSRules cSSRules = ParseStylesCmd.getRulesProperty(xNode);
        if (cSSRules != null && (cSSRule = cSSRules.get(cSSRules.findFirst(string))) != null) {
            if (string2 == null) {
                StringBuilder stringBuilder = new StringBuilder();
                CSSRule.toString(cSSRule.properties, ' ', stringBuilder);
                string3 = stringBuilder.toString();
            } else {
                string3 = cSSRule.getProperty(string2);
            }
        }
        return string3;
    }

    public static Variant length(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("length", variantExprArray, 1, 2);
        double d = Double.NaN;
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        Element element = XPathFunctions.getElement(variantExprArray, 1, xNode, exprContext);
        if (element != null) {
            d = XPathFunctions.parseLength(string, element);
        }
        return new NumberVariant(d);
    }

    public static Variant lookupLength(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        String string;
        XPathFunctions.checkArgCount("lookup-length", variantExprArray, 1, 2);
        double d = Double.NaN;
        String string2 = variantExprArray[0].eval(xNode, exprContext).convertToString();
        Element element = XPathFunctions.getElement(variantExprArray, 1, xNode, exprContext);
        if (element != null && (string = XPathFunctions.lookupStyle(element, string2)) != null) {
            d = XPathFunctions.parseLength(string, element);
        }
        return new NumberVariant(d);
    }

    public static Variant fontSize(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("font-size", variantExprArray, 0, 1);
        double d = Double.NaN;
        Element element = XPathFunctions.getElement(variantExprArray, 0, xNode, exprContext);
        if (element != null) {
            d = XPathFunctions.fontSize(element);
        }
        return new NumberVariant(d);
    }

    public static Variant isMonospaced(VariantExpr[] variantExprArray, XNode xNode, ExprContext exprContext) throws EvalException {
        XPathFunctions.checkArgCount("is-monospaced", variantExprArray, 1, 1);
        String string = variantExprArray[0].eval(xNode, exprContext).convertToString();
        return new BooleanVariant(XPathFunctions.isMonospacedFontFamily(string));
    }

    public static boolean isMonospacedFontFamily(String string) {
        boolean bl = false;
        if (string != null) {
            for (String string2 : MONOSPACED_FONT_FAMILIES) {
                if (!XPathFunctions.containsFontFamily(string, string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static double parseLength(String string, Element element) {
        LengthUnit lengthUnit;
        if ((string = string.trim().toLowerCase()).endsWith("pt")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.PT;
        } else if (string.endsWith("in")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.IN;
        } else if (string.endsWith("cm")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.CM;
        } else if (string.endsWith("mm")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.MM;
        } else if (string.endsWith("pc")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.PC;
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.PX;
        } else if (string.endsWith("em")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.EM;
        } else if (string.endsWith("ex")) {
            string = string.substring(0, string.length() - 2);
            lengthUnit = LengthUnit.EX;
        } else {
            lengthUnit = LengthUnit.PX;
        }
        return XPathFunctions.lengthToPt(string, lengthUnit, element);
    }

    private static double lengthToPt(String string, LengthUnit lengthUnit, Element element) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(string);
            switch (lengthUnit) {
                case PT: {
                    break;
                }
                case IN: {
                    d *= 72.0;
                    break;
                }
                case CM: {
                    d = d / 2.54 * 72.0;
                    break;
                }
                case MM: {
                    d = d / 25.4 * 72.0;
                    break;
                }
                case PC: {
                    d *= 12.0;
                    break;
                }
                case PX: {
                    d *= 0.75;
                    break;
                }
                case EM: {
                    double d2 = XPathFunctions.fontSize(element);
                    if (Double.isNaN(d2)) break;
                    d *= d2;
                    break;
                }
                case EX: {
                    double d3 = XPathFunctions.fontSize(element);
                    if (Double.isNaN(d3)) break;
                    d *= d3 / 2.0;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static double fontSize(Element element) {
        String string;
        double d = Double.NaN;
        if (element != null && (string = XPathFunctions.lookupStyle(element, "font-size")) != null) {
            d = XPathFunctions.parseFontSize(string, element);
        }
        return d;
    }

    public static double parseFontSize(String string, Element element) {
        double d = Double.NaN;
        if ((string = string.trim().toLowerCase()).endsWith("em") || string.endsWith("ex") || string.endsWith("%")) {
            double d2 = XPathFunctions.fontSize(XPathFunctions.getParentElement(element));
            if (!Double.isNaN(d2)) {
                if (string.endsWith("em")) {
                    string = string.substring(0, string.length() - 2);
                    try {
                        d = Double.parseDouble(string);
                        d *= d2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.endsWith("ex")) {
                    string = string.substring(0, string.length() - 2);
                    try {
                        d = Double.parseDouble(string);
                        d *= d2 / 2.0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.endsWith("%")) {
                    string = string.substring(0, string.length() - 1);
                    try {
                        d = Double.parseDouble(string);
                        d = d / 100.0 * d2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else if ("larger".equals(string)) {
            double d3 = XPathFunctions.fontSize(XPathFunctions.getParentElement(element));
            if (!Double.isNaN(d3)) {
                d = d3 * 1.2;
            }
        } else if ("smaller".equals(string)) {
            double d4 = XPathFunctions.fontSize(XPathFunctions.getParentElement(element));
            if (!Double.isNaN(d4)) {
                d = d4 / 1.2;
            }
        } else {
            d = "medium".equals(string) ? 12.0 : ("large".equals(string) ? 14.399999999999999 : ("x-large".equals(string) ? 17.279999999999998 : ("xx-large".equals(string) ? 20.735999999999997 : ("small".equals(string) ? 10.0 : ("x-small".equals(string) ? 8.333333333333334 : ("xx-small".equals(string) ? 6.9444444444444455 : XPathFunctions.parseLength(string, element)))))));
        }
        return d;
    }

    private static Element getParentElement(Element element) {
        return element == null ? null : element.getParentElement();
    }

    private static boolean containsFontFamily(String string, String string2) {
        int n = (string = string.trim().toLowerCase()).length();
        if (n == 0) {
            return false;
        }
        if ((string2 = string2.trim().toLowerCase()).length() == 0) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        block4: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case ',': {
                    if (c != '\u0000') {
                        stringBuilder.append(c2);
                        continue block4;
                    }
                    if (stringBuilder.length() <= 0) continue block4;
                    if (stringBuilder.toString().trim().equals(string2)) {
                        return true;
                    }
                    stringBuilder.setLength(0);
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (c == '\u0000') {
                        c = c2;
                        continue block4;
                    }
                    if (c == c2) {
                        c = '\u0000';
                        continue block4;
                    }
                    stringBuilder.append(c2);
                    continue block4;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.length() > 0 && stringBuilder.toString().trim().equals(string2);
    }

    private static void checkArgCount(String string, VariantExpr[] variantExprArray, int n, int n2) throws EvalException {
        int n3 = variantExprArray.length;
        if (n3 < n || n3 > n2) {
            String string2 = n == n2 ? Msg.msg("badArgCount1", n, string, n3) : (n2 == Integer.MAX_VALUE ? Msg.msg("badArgCount2", n, string, n3) : Msg.msg("badArgCount3", n, n2, string, n3));
            throw new EvalException(string2);
        }
    }

    private static enum LengthUnit {
        PT,
        IN,
        CM,
        MM,
        PC,
        PX,
        EM,
        EX;

    }
}

