/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.ProgressMonitorConsole;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.SaveXHTML;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.docx.toxhtml.XHTMLVersion;
import com.xmlmind.w2x.processor.CanceledException;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.ParseStylesCmd;
import com.xmlmind.w2x.processor.ProcessStep;
import com.xmlmind.w2x.processor.UnparseStylesCmd;
import com.xmlmind.w2x.processor.XPathFunctions;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SplitStep
extends ProcessStep {
    protected static final Name FRAMESET_ELEM = Name.get(Namespace.XHTML, "frameset");
    protected static final Name FRAME_ELEM = Name.get(Namespace.XHTML, "frame");
    protected static final Name COLS_ATTR = Name.get(Namespace.NONE, "cols");
    protected static final Name SCROLLING_ATTR = Name.get(Namespace.NONE, "scrolling");
    protected static final String TOC_CSS = ".toc-entry-0,\n.toc-entry-1,\n.toc-entry-2,\n.toc-entry-3,\n.toc-entry-4,\n.toc-entry-5,\n.toc-entry-6,\n.toc-entry-7,\n.toc-entry-8,\n.toc-entry-9 {\n    margin: 0.25em 0px;\n}\n\n.toc-entry-1 { margin-left: 4ex; }\n.toc-entry-2 { margin-left: 8ex; }\n.toc-entry-3 { margin-left: 12ex; }\n.toc-entry-4 { margin-left: 16ex; }\n.toc-entry-5 { margin-left: 20ex; }\n.toc-entry-6 { margin-left: 24ex; }\n.toc-entry-7 { margin-left: 28ex; }\n.toc-entry-8 { margin-left: 32ex; }\n.toc-entry-9 { margin-left: 36ex; }\n";

    public SplitStep(String string) {
        super(string);
    }

    @Override
    public void process(Object[] objectArray, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        if (!(objectArray[0] instanceof Document)) {
            this.illegalState(Document.class);
        }
        Document document = (Document)objectArray[0];
        File file = this.getFileParameter(map, "out-file", null);
        if (file == null) {
            this.missingParameter("out-file");
        }
        this.progress(Msg.msg("splitStep", file), nArray, progressMonitor);
        this.debugParameters(map, progressMonitor);
        int n = this.getIntParameter(map, "split-before-level", 0, 8, 0);
        boolean bl = this.getBooleanParameter(map, "use-id-as-filename", false);
        boolean bl2 = this.getBooleanParameter(map, "allow-lonely-heading", false);
        boolean bl3 = this.getBooleanParameter(map, "indent", false);
        ArrayList<Part> arrayList = new ArrayList<Part>();
        HashSet<String> hashSet = null;
        if (bl) {
            hashSet = new HashSet<String>();
            hashSet.add(FileUtil.setExtension(file.getName(), null));
        }
        this.splitDocument(document, n, hashSet, bl2, file, arrayList, progressMonitor);
        this.processParts(arrayList, document);
        String string = SplitStep.findCharset(document);
        String string2 = string == null ? "UTF-8" : string;
        Document document2 = this.toTOC(arrayList, string);
        File file2 = SplitStep.newOutFile(file, "-TOC");
        this.saveDocument(document2, bl3, string2, file2, progressMonitor);
        this.saveParts(arrayList, bl3, string2, file, progressMonitor);
        String string3 = URIComponent.quotePath(file2.getName());
        String string4 = "???";
        if (arrayList.size() > 0) {
            string4 = arrayList.get((int)0).href;
        }
        Document document3 = this.createFrameset(document, string, string3, string4);
        this.saveDocument(document3, bl3, string2, file, progressMonitor);
        objectArray[0] = file;
    }

    protected static final String findCharset(Document document) {
        String[] stringArray;
        Element element;
        Element element2 = document.getRootElement().getChildElement(0);
        if (element2 != null && (element = SplitStep.findCharsetMeta(element2, stringArray = new String[1])) != null) {
            return stringArray[0];
        }
        return null;
    }

    protected static final Element findCharsetMeta(Element element, String[] stringArray) {
        if (stringArray != null) {
            stringArray[0] = null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != Constants.META_ELEM) continue;
            String string = element2.getAttribute(Constants.CHARSET_ATTR);
            if (string == null && "content-type".equalsIgnoreCase(element2.getAttribute(Constants.HTTP_EQUIV_ATTR)) && (string = element2.getAttribute(Constants.CONTENT_ATTR)) != null) {
                int n = string.indexOf("charset=");
                string = n < 0 ? null : string.substring(n + 8);
            }
            if (string == null || (string = string.trim()).length() <= 0) continue;
            if (stringArray != null) {
                stringArray[0] = string;
            }
            return element2;
        }
        return null;
    }

    protected File newOutFile(File file, int n) {
        return SplitStep.newOutFile(file, "-" + n);
    }

    protected static final File newOutFile(File file, String object) {
        File file2 = null;
        String string = file.getName();
        int n = string.lastIndexOf(46);
        for (int i = 0; i < 100; ++i) {
            if (i > 0) {
                if (object == null) {
                    object = "";
                }
                object = (String)object + "-" + Integer.toString(1 + i);
            }
            Object object2 = string;
            if (object != null) {
                object2 = n <= 0 ? (String)object2 + (String)object : string.substring(0, n) + (String)object + string.substring(n);
            }
            if (!(file2 = new File(file.getParentFile(), (String)object2)).exists()) break;
        }
        return file2;
    }

    protected void splitDocument(Document document, int n, Set<String> set, boolean bl, File file, List<Part> list, ProgressMonitor progressMonitor) throws Exception {
        ParseStylesCmd parseStylesCmd = new ParseStylesCmd();
        ProgressMonitorConsole progressMonitorConsole = new ProgressMonitorConsole(progressMonitor);
        parseStylesCmd.execute(document, progressMonitorConsole);
        Document document2 = this.createPartTemplate(document);
        if (document2 == null) {
            return;
        }
        Part part = this.addPart(-1, n, set, bl, null, null, file, document2, list);
        Element element = part.document.getRootElement().getChildElement(1);
        Element element2 = document.getRootElement().getChildElement(1);
        for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            int n2;
            if (node.getType() == Node.Type.ELEMENT && (n2 = SplitStep.getOutlineLevel(element3 = (Element)node)) >= 0) {
                part = this.addPart(n2, n, set, bl, element3, element, file, document2, list);
                if (part.document != null) {
                    element = part.document.getRootElement().getChildElement(1);
                }
            }
            element.appendChild(node.copy());
        }
    }

    protected static final int getOutlineLevel(Element element) {
        Name name;
        int n = -1;
        Element element2 = SplitStep.getBoxFirstChildElement(element);
        if (element2 != null) {
            element = element2;
        }
        if ((name = element.getName()) == Constants.P_ELEM) {
            String string = XPathFunctions.lookupStyle(element, "-ms-outlineLvl");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 0 || n > 8) {
                        n = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (name == Constants.H1_ELEM) {
            n = 0;
        } else if (name == Constants.H2_ELEM) {
            n = 1;
        } else if (name == Constants.H3_ELEM) {
            n = 2;
        } else if (name == Constants.H4_ELEM) {
            n = 3;
        } else if (name == Constants.H5_ELEM) {
            n = 4;
        } else if (name == Constants.H6_ELEM) {
            n = 5;
        }
        if (n >= 0 && (SplitStep.getAllText(element, true) == null || XPathFunctions.getClass(element, "/^role-bridgehead/") != null)) {
            n = -1;
        }
        return n;
    }

    protected static final Element getBoxFirstChildElement(Element element) {
        Element element2 = null;
        if (element.getName() == Constants.DIV_ELEM && XPathFunctions.getClass(element, "role-box") != null) {
            element2 = element.getChildElement(0);
        }
        return element2;
    }

    protected Document createPartTemplate(Document document) throws Exception {
        Document document2 = (Document)document.copy();
        Element element = document2.getRootElement().getChildElement(0);
        Element element2 = document2.getRootElement().getChildElement(1);
        if (element == null || element2 == null) {
            document2 = null;
        } else {
            Element element3 = SplitStep.findCharsetMeta(element, null);
            Element element4 = Util.findDescendant(element, Constants.TITLE_ELEM);
            Element element5 = Util.findDescendant(element, Constants.SCRIPT_ELEM);
            element.removeAllChildren();
            if (element3 != null) {
                element.appendChild(element3);
            }
            if (element4 != null) {
                element.appendChild(element4);
            }
            if (element5 != null) {
                element.appendChild(element5);
            }
            element2.removeAllChildren();
        }
        return document2;
    }

    protected Part addPart(int n, int n2, Set<String> set, boolean bl, Element element, Element element2, File file, Document document, List<Part> list) {
        Object object;
        Object object2;
        Object object3;
        Part part = new Part();
        part.level = n;
        boolean bl2 = false;
        if (element != null) {
            object3 = null;
            object2 = SplitStep.getBoxFirstChildElement(element);
            if (object2 != null) {
                object3 = element;
                element = object2;
            }
            part.title = object3 != null ? SplitStep.getAllText((Element)object3, true) : SplitStep.getAllText(element, true);
            if (part.title == null) {
                part.title = "???";
            }
            part.id = element.getAttribute(Constants.ID_ATTR);
            if (part.id == null) {
                object = new StringBuilder("__PAGE");
                ((StringBuilder)object).append(Integer.toString(list.size()));
                ((StringBuilder)object).append("__");
                part.id = ((StringBuilder)object).toString();
                element.putAttribute(Constants.ID_ATTR, part.id);
                bl2 = true;
            }
            if ((object = SplitStep.parseCounterPI(element, null)) != null && object[0] != null) {
                StringBuilder stringBuilder = new StringBuilder((String)object[0]);
                stringBuilder.append(' ');
                stringBuilder.append(part.title);
                part.title = stringBuilder.toString();
            }
            part.lang = element.lookupAttribute(Name.LANG);
        } else {
            part.title = null;
            object3 = SplitStep.findTitle(document);
            if (object3 != null) {
                part.title = SplitStep.getAllText((Element)object3, true);
            }
            if (part.title == null) {
                part.title = "???";
            }
            part.id = null;
            part.lang = document.getRootElement().getAttribute(Name.LANG);
        }
        if (n <= n2 && !this.useSameChunk(bl, element2)) {
            part.document = (Document)document.copy();
            object3 = SplitStep.findTitle(part.document);
            if (object3 != null) {
                ((Element)object3).forceText(part.title);
            }
            if (set != null && part.id != null && !bl2 && !set.contains(part.id)) {
                set.add(part.id);
                object2 = part.id;
                object = FileUtil.getExtension(file);
                if (object != null) {
                    object2 = (String)object2 + "." + (String)object;
                }
                part.file = new File(file.getParentFile(), (String)object2);
                part.file = SplitStep.newOutFile(part.file, null);
            } else {
                part.file = this.newOutFile(file, list.size());
            }
            part.href = URIComponent.quotePath(part.file.getName());
        } else {
            part.document = null;
            part.file = null;
            part.href = "#" + URIComponent.quoteFragment(part.id);
            object3 = SplitStep.findParentPart(list);
            if (object3 != null) {
                part.href = ((Part)object3).href + part.href;
            }
        }
        list.add(part);
        return part;
    }

    protected static final Object[] parseCounterPI(Element element, ProcessingInstruction[] processingInstructionArray) {
        if (processingInstructionArray != null) {
            processingInstructionArray[0] = null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            ProcessingInstruction processingInstruction;
            if (node.getType() != Node.Type.PROCESSING_INSTRUCTION || !"counter".equals((processingInstruction = (ProcessingInstruction)node).getTarget())) continue;
            if (processingInstructionArray != null) {
                processingInstructionArray[0] = processingInstruction;
            }
            Object[] objectArray = new Object[3];
            String[] stringArray = ProcessingInstruction.parsePseudoAttributes(processingInstruction.getText());
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; i += 2) {
                    String string = stringArray[i];
                    String string2 = stringArray[i + 1];
                    if ("label".equals(string)) {
                        objectArray[0] = string2;
                        continue;
                    }
                    if ("name".equals(string)) {
                        objectArray[1] = string2;
                        continue;
                    }
                    if (!"value".equals(string)) continue;
                    try {
                        objectArray[2] = Integer.valueOf(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (objectArray[1] == null || objectArray[2] == null) {
                objectArray = null;
            }
            return objectArray;
        }
        return null;
    }

    protected static final Element findTitle(Document document) {
        Element element = null;
        Element element2 = document.getRootElement().getChildElement(0);
        if (element2 != null) {
            element = Util.findDescendant(element2, Constants.TITLE_ELEM);
        }
        return element;
    }

    protected static final Part findParentPart(List<Part> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Part part = list.get(i);
            if (part.document == null) continue;
            return part;
        }
        return null;
    }

    protected boolean useSameChunk(boolean bl, Element element) {
        if (element == null) {
            return false;
        }
        Node node = element.getLastChild();
        if (node == null) {
            return true;
        }
        if (!bl) {
            while (node != null && node.getType() == Node.Type.ELEMENT && ((Element)node).getName() == Constants.P_ELEM && SplitStep.getAllText((Element)node, true) == null) {
                node = node.getPreviousSibling();
            }
            if (node == null) {
                return true;
            }
            if (node.getType() == Node.Type.ELEMENT) {
                int n = SplitStep.getOutlineLevel((Element)node);
                return n >= 0;
            }
        }
        return false;
    }

    protected void processParts(List<Part> list, Document document) {
        this.processCounters(list);
        this.processNotes(list, document);
        this.processLinks(list);
    }

    protected void processCounters(List<Part> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Part part = list.get(i);
            if (part.document == null) continue;
            Element element = part.document.getRootElement().getChildElement(1);
            if (i == 0) {
                String string = XPathFunctions.getRule(part.document, "body", "counter-reset");
                if (string != null) {
                    SplitStep.parseCounterReset(string, hashMap);
                }
                if (hashMap.size() == 0) {
                    return;
                }
                SplitStep.collectCounters(element, hashMap, hashMap2);
                continue;
            }
            hashMap2.clear();
            SplitStep.collectCounters(element, hashMap, hashMap2);
            part.resetCounters = SplitStep.resetCounters(hashMap, hashMap2);
        }
    }

    protected static final void parseCounterReset(String string, Map<String, Integer> map) {
        String[] stringArray = StringUtil.split(string);
        int n = stringArray.length / 2 * 2;
        for (int i = 0; i < n; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            try {
                map.put(string2, Integer.valueOf(string3));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected static final void collectCounters(Element element, Map<String, Integer> map, Map<String, Integer> map2) {
        if (element.getName() == Constants.P_ELEM) {
            ProcessingInstruction[] processingInstructionArray = new ProcessingInstruction[1];
            Object[] objectArray = SplitStep.parseCounterPI(element, processingInstructionArray);
            if (processingInstructionArray[0] != null) {
                element.removeChild(processingInstructionArray[0]);
            }
            if (objectArray != null) {
                String string = (String)objectArray[1];
                Integer n = (Integer)objectArray[2];
                map.put(string, n);
                if (!map2.containsKey(string)) {
                    map2.put(string, n - 1);
                }
            }
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            SplitStep.collectCounters((Element)node, map, map2);
        }
    }

    protected static final String resetCounters(Map<String, Integer> map, Map<String, Integer> map2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey();
            Integer n = map2.get(string);
            if (n == null) {
                n = entry.getValue();
            }
            stringBuilder.setLength(0);
            stringBuilder.append(string);
            stringBuilder.append(' ');
            stringBuilder.append(Integer.toString(n));
            arrayList.add(stringBuilder.toString());
        }
        int n = arrayList.size();
        if (n > 1) {
            Collections.sort(arrayList);
        }
        stringBuilder.setLength(0);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append((String)arrayList.get(i));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        stringBuilder.insert(0, "\nbody {\n    counter-reset: ");
        stringBuilder.append(";\n}\n");
        return stringBuilder.toString();
    }

    protected void processNotes(List<Part> list, Document document) {
        Element element = document.getRootElement().getChildElement(1);
        String[] stringArray = new String[]{"role-footnotes", "role-footnote-ref", "role-endnotes", "role-endnote-ref"};
        int n = 0;
        for (int i = 0; i < 4; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            Element element2 = SplitStep.findNotes(string, element);
            if (element2 == null) continue;
            ++n;
            for (Part part : list) {
                if (part.document == null) continue;
                Element element3 = (Element)element2.copy();
                Element element4 = element3.getChildElement(0);
                if (element4 != null && element4.getName() != Constants.HR_ELEM) {
                    element4 = null;
                }
                element3.removeAllChildren();
                if (element4 != null) {
                    element3.appendChild(element4);
                }
                Element element5 = part.document.getRootElement().getChildElement(1);
                this.copyNotes(string2, element5, element2, element3);
                if (element3.getLastChild() == element4) {
                    element3 = null;
                }
                SplitStep.setNotes(string, element3, element5);
            }
        }
        if (n == 0) {
            this.processNotes2(element, list, document);
        }
    }

    protected static final Element findNotes(String string, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != Constants.DIV_ELEM || XPathFunctions.getClass(element2, string) == null) continue;
            return element2;
        }
        return null;
    }

    protected void copyNotes(String string, Element element, Element element2, Element element3) {
        if (element.getName() == Constants.A_ELEM && XPathFunctions.getClass(element, string) != null) {
            String string2;
            Element element4;
            String string3 = element.getAttribute(Constants.HREF_ATTR);
            if (string3 != null && string3.startsWith("#") && (element4 = SplitStep.findById(element2, string2 = string3.substring(1))) != null) {
                element3.appendChild((Element)element4.copy());
            }
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            this.copyNotes(string, (Element)node, element2, element3);
        }
    }

    protected static final Element findById(Element element, String string) {
        String string2 = element.getAttribute(Constants.ID_ATTR);
        if (string.equals(string2)) {
            return element;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = SplitStep.findById((Element)node, string)) == null) continue;
            return element2;
        }
        return null;
    }

    protected static final void setNotes(String string, Element element, Element element2) {
        Element element3 = SplitStep.findNotes(string, element2);
        if (element != null) {
            if (element3 != null) {
                element2.replaceChild(element3, element);
            } else {
                element2.appendChild(element);
            }
        } else if (element3 != null) {
            element2.removeChild(element3);
        }
    }

    protected void processNotes2(Element element, List<Part> list, Document document) {
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        this.collectNotes(element, hashMap);
        if (hashMap.size() == 0) {
            return;
        }
        for (Part part : list) {
            if (part.document == null) continue;
            Element element2 = part.document.getRootElement().getChildElement(1);
            this.deleteNotes(element2);
            int[] nArray = new int[1];
            this.copyNotes2(element2, hashMap, nArray, element2);
        }
    }

    protected void deleteNotes(Element element) {
        Name name = element.getName();
        if (name == Constants.DIV_ELEM && SplitStep.isNote(element) || name == Constants.HR_ELEM && SplitStep.isNoteSeparator(element)) {
            element.getParent().removeChild(element);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                this.deleteNotes((Element)node);
            }
            node = node2;
        }
    }

    protected static final boolean isNote(Element element) {
        return XPathFunctions.getClass(element, "role-footnote") != null || XPathFunctions.getClass(element, "role-endnote") != null;
    }

    protected static final boolean isNoteSeparator(Element element) {
        return XPathFunctions.getClass(element, "role-footnote-separator") != null;
    }

    protected void collectNotes(Element element, Map<String, Element> map) {
        if (element.getName() == Constants.DIV_ELEM && SplitStep.isNote(element)) {
            String string = element.getAttribute(Constants.ID_ATTR);
            if (string != null) {
                map.put(string, element);
            }
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            this.collectNotes((Element)node, map);
        }
    }

    protected void copyNotes2(Element element, Map<String, Element> map, int[] nArray, Element element2) {
        if (element.getName() == Constants.A_ELEM && SplitStep.isNoteRef(element)) {
            String string;
            Element element3;
            String string2 = element.getAttribute(Constants.HREF_ATTR);
            if (string2 != null && string2.startsWith("#") && (element3 = map.get(string = string2.substring(1))) != null) {
                if (nArray[0] == 0) {
                    Element element4 = new Element(Constants.HR_ELEM);
                    element4.putAttribute(Constants.CLASS_ATTR, "role-footnote-separator");
                    element2.appendChild(element4);
                }
                element2.appendChild((Element)element3.copy());
                nArray[0] = nArray[0] + 1;
            }
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            this.copyNotes2((Element)node, map, nArray, element2);
        }
    }

    protected static final boolean isNoteRef(Element element) {
        return XPathFunctions.getClass(element, "role-footnote-ref") != null || XPathFunctions.getClass(element, "role-endnote-ref") != null;
    }

    protected void processLinks(List<Part> list) {
        Element element;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (Part part : list) {
            if (part.document == null) continue;
            element = part.document.getRootElement().getChildElement(1);
            SplitStep.collectIds(element, part.href, hashMap);
        }
        for (Part part : list) {
            if (part.document == null) continue;
            element = part.document.getRootElement().getChildElement(1);
            SplitStep.fixLinks(element, part.href, hashMap);
        }
    }

    protected static final void collectIds(Element element, String string, Map<String, String[]> map) {
        Object object;
        String string2 = element.getAttribute(Constants.ID_ATTR);
        if (string2 != null) {
            object = map.get(string2);
            if (object == null) {
                object = new String[]{string};
            } else if (!StringList.contains(object, string)) {
                object = StringList.append(object, string);
            }
            map.put(string2, (String[])object);
        }
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getType() != Node.Type.ELEMENT) continue;
            SplitStep.collectIds((Element)object, string, map);
        }
    }

    protected static final void fixLinks(Element element, String string, Map<String, String[]> map) {
        String string2;
        if (element.getName() == Constants.A_ELEM && (string2 = element.getAttribute(Constants.HREF_ATTR)) != null && string2.startsWith("#")) {
            String string3 = string2.substring(1);
            String[] stringArray = map.get(string3);
            if (stringArray != null && !StringList.contains(stringArray, string)) {
                element.putAttribute(Constants.HREF_ATTR, stringArray[0] + string2);
            }
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            SplitStep.fixLinks((Element)node, string, map);
        }
    }

    protected void saveParts(List<Part> list, boolean bl, String string, File file, ProgressMonitor progressMonitor) throws Exception {
        UnparseStylesCmd unparseStylesCmd = new UnparseStylesCmd();
        File file2 = FileUtil.setExtension(file, "css");
        String string2 = URIComponent.quotePath(file2.getName());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            Part part = list.get(i);
            if (part.document == null) continue;
            String string3 = unparseStylesCmd.execute(part.document, string2, null, i == 0);
            if (string3 != null && (element = part.document.getRootElement().getChildElement(0)) != null) {
                Element element2 = new Element(Constants.LINK_ELEM);
                element2.putAttribute(Constants.HREF_ATTR, string2);
                element2.putAttribute(Constants.REL_ATTR, "stylesheet");
                element2.putAttribute(Constants.TYPE_ATTR, "text/css");
                element.appendChild(element2);
                if (part.resetCounters != null) {
                    Element element3 = new Element(Constants.STYLE_ELEM);
                    element3.putAttribute(Constants.TYPE_ATTR, "text/css");
                    element3.appendChild(new Text(part.resetCounters));
                    element.appendChild(element3);
                }
            }
            this.saveDocument(part.document, bl, string, part.file, progressMonitor);
        }
    }

    protected void saveDocument(Document document, boolean bl, String string, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        SplitStep.creatingFile(file, progressMonitor);
        SaveXHTML.save(document, bl, string, file);
    }

    protected static final void creatingFile(File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        if (!progressMonitor.message(Msg.msg("creatingFile", file), Console.MessageType.VERBOSE)) {
            throw new CanceledException();
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory()) {
            FileUtil.checkedMkdirs(file2);
        }
    }

    protected Document toTOC(List<Part> list, String string) {
        Document document = new Document();
        document.appendChild(new DocumentTypeDeclaration("html", XHTMLVersion.V1_0_Transitional.getPublicId(), XHTMLVersion.V1_0_Transitional.getSystemId(), null));
        Element element = new Element(Constants.HTML_ELEM);
        document.appendChild(element);
        Element element2 = new Element(Constants.HEAD_ELEM);
        element.appendChild(element2);
        String string2 = null;
        if (list.size() > 0) {
            string2 = list.get((int)0).lang;
        }
        if (string2 != null) {
            element.putAttribute(Name.LANG, string2);
        }
        if (string != null) {
            element2.appendChild(SplitStep.createCharsetMeta(string));
        }
        Element element3 = new Element(Constants.TITLE_ELEM);
        element2.appendChild(element3);
        element3.appendChild(new Text("Contents"));
        element2.appendChild(this.createTOCStyle(list));
        Element element4 = new Element(Constants.BODY_ELEM);
        element.appendChild(element4);
        for (Part part : list) {
            Element element5 = new Element(Constants.P_ELEM);
            element4.appendChild(element5);
            String string3 = part.lang;
            if (string3 != null && !string3.equals(string2)) {
                element5.putAttribute(Name.LANG, string3);
            }
            element5.putAttribute(Constants.CLASS_ATTR, "toc-entry-" + (1 + part.level));
            Element element6 = new Element(Constants.A_ELEM);
            element5.appendChild(element6);
            element6.putAttribute(Constants.HREF_ATTR, part.href);
            element6.putAttribute(Constants.TARGET_ATTR, "contentFrame");
            element6.appendChild(new Text(part.title));
        }
        return document;
    }

    protected Element createTOCStyle(List<Part> list) {
        int n;
        Element element = new Element(Constants.STYLE_ELEM);
        element.putAttribute(Constants.TYPE_ATTR, "text/css");
        String string = TOC_CSS;
        String string2 = null;
        String string3 = null;
        if (list.size() > 0) {
            Document document = list.get((int)0).document;
            string2 = XPathFunctions.getRule(document, "p", "font-family");
            if (string2 == null) {
                string2 = XPathFunctions.getRule(document, "body", "font-family");
            }
            if ((string3 = XPathFunctions.getRule(document, "p", "font-size")) == null) {
                string3 = XPathFunctions.getRule(document, "body", "font-size");
            }
        }
        if ((string2 != null || string3 != null) && (n = string.indexOf("margin:")) >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (string3 != null) {
                stringBuilder.insert(n, ";\n    ");
                stringBuilder.insert(n, string3);
                stringBuilder.insert(n, "font-size: ");
            }
            if (string2 != null) {
                stringBuilder.insert(n, ";\n    ");
                stringBuilder.insert(n, string2);
                stringBuilder.insert(n, "font-family: ");
            }
            string = stringBuilder.toString();
        }
        element.appendChild(new Text(string));
        return element;
    }

    protected static final Element createCharsetMeta(String string) {
        Element element = new Element(Constants.META_ELEM);
        element.putAttribute(Constants.HTTP_EQUIV_ATTR, "content-type");
        element.putAttribute(Constants.CONTENT_ATTR, "text/html;charset=" + string);
        return element;
    }

    protected Document createFrameset(Document document, String string, String string2, String string3) {
        Element element;
        Comparable<Name> comparable;
        Node node;
        Document document2 = new Document();
        document2.appendChild(new DocumentTypeDeclaration("html", XHTMLVersion.V1_0_Frameset.getPublicId(), XHTMLVersion.V1_0_Frameset.getSystemId(), null));
        Element element2 = new Element(Constants.HTML_ELEM);
        document2.appendChild(element2);
        Element element3 = document.getRootElement();
        String string4 = element3.getAttribute(Name.LANG);
        if (string4 != null) {
            element2.putAttribute(Name.LANG, string4);
        }
        Element element4 = element3.getChildElement(0);
        element4 = (Element)element4.copy();
        element2.appendChild(element4);
        Node node2 = element4.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            if (node2.getType() == Node.Type.ELEMENT && (comparable = (element = (Element)node2).getName()) != Constants.TITLE_ELEM && comparable != Constants.META_ELEM) {
                element4.removeChild(element);
            }
            node2 = node;
        }
        if (string != null) {
            node = SplitStep.findCharsetMeta(element4, null);
            if (node != null) {
                element4.removeChild(node);
            }
            element4.insertChild(element4.getFirstChild(), SplitStep.createCharsetMeta(string));
        }
        node = new Element(FRAMESET_ELEM);
        element2.appendChild(node);
        ((Element)node).putAttribute(COLS_ATTR, "30%,70%");
        element = new Element(FRAME_ELEM);
        ((Tree)node).appendChild(element);
        element.putAttribute(Constants.NAME_ATTR, "tocFrame");
        element.putAttribute(Constants.ID_ATTR, "tocFrame");
        element.putAttribute(Constants.SRC_ATTR, string2);
        element.putAttribute(SCROLLING_ATTR, "yes");
        comparable = new Element(FRAME_ELEM);
        ((Tree)node).appendChild((Node)comparable);
        ((Element)comparable).putAttribute(Constants.NAME_ATTR, "contentFrame");
        ((Element)comparable).putAttribute(Constants.ID_ATTR, "contentFrame");
        ((Element)comparable).putAttribute(Constants.SRC_ATTR, string3);
        return document2;
    }

    protected static final String getAllText(Element element, boolean bl) {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        SplitStep.getAllText(element, stringBuilder);
        if (stringBuilder.length() > 0) {
            string = stringBuilder.toString();
            if (bl && (string = XMLText.collapseWhiteSpace(string)).length() == 0) {
                string = null;
            }
        }
        return string;
    }

    private static final void getAllText(Element element, StringBuilder stringBuilder) {
        if (element.getName() == Constants.SPAN_ELEM && XPathFunctions.getClass(element, "/role-index-term(-start)?/") != null) {
            return;
        }
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case TEXT: {
                    stringBuilder.append(((Text)node).getTextChars());
                    continue block4;
                }
                case ELEMENT: {
                    SplitStep.getAllText((Element)node, stringBuilder);
                }
            }
        }
    }

    protected static final class Part {
        public int level;
        public String id;
        public String title;
        public String lang;
        public Document document;
        public File file;
        public String href;
        public String resetCounters;
        public Object clientData;

        protected Part() {
        }
    }
}

