/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.SimpleProgressMonitor;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.w2x.docx.image.ImageConverterFactories;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.Plugin;
import com.xmlmind.w2x.processor.Processor;
import com.xmlmind.w2x.processor.Start;
import com.xmlmind.w2x.processor.UsageException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class Main {
    private File installDirectory;
    private String[] searchPluginErrors;
    private URL[] pluginURLs;
    private static final String USAGE1 = "Usage: w2x [-version] [-v|-vv|-vvv] [Options]\n    in_docx_file out_file\n    | -batch out_spec in_docx_file1 ... in_docx_fileN\n    | -printenv\n    | -liststeps\n\n";
    private static final String USAGE2 = "-version\n    Print version number and exit.\n-v|-vv|-vvv\n    Verbose.\n-batch out_spec in_docx_file1 ... in_docx_fileN\n    Convert all specified input DOCX files.\n    out_spec specifies the absolute or relative path\n    of the output files. It may contain the following variables:\n    @{name}, basename of the input file without any extension,\n    @{parent}, abs. path of the directory containing the input file.\n-printenv\n    Print supported environment variables/system properties and exit.\n-liststeps\n    List the conversion steps to be executed and exit.";
    private static final String USAGE3 = "Use '-?' to list options.";

    public static void main(String[] stringArray) {
        new Main().run(stringArray);
    }

    public Main() {
        this(null);
    }

    public Main(Map<String, Object> map) {
        if (map != null) {
            this.installDirectory = (File)map.get("installDirectory");
            this.searchPluginErrors = (String[])map.get("searchPluginErrors");
            this.pluginURLs = (URL[])map.get("pluginURLs");
        } else {
            this.installDirectory = Start.findInstallDir();
            this.searchPluginErrors = StringUtil.EMPTY_LIST;
            this.pluginURLs = URLUtil.EMPTY_LIST;
        }
    }

    public static final boolean initResolver(File file) {
        if (file != null && new File(file, "xed").isDirectory() && new File(file, "xslt").isDirectory()) {
            Processor.initResolver(FileUtil.fileToURL(file));
            return true;
        }
        return false;
    }

    public static final void initPlugins(String[] stringArray, URL[] uRLArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                System.err.println("WARNING: " + string);
            }
        }
        if (uRLArray != null && uRLArray.length > 0) {
            ArrayList arrayList = new ArrayList();
            Plugin[] pluginArray = Plugin.loadAll(uRLArray, arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                string = (String)iterator.next();
                System.err.println("WARNING: " + string);
            }
            if (pluginArray.length > 0) {
                Processor.registerPlugins(pluginArray);
            }
        }
    }

    public void run(String[] stringArray) {
        String string;
        Thread.currentThread().setContextClassLoader(Main.class.getClassLoader());
        Main.initResolver(this.installDirectory);
        Main.initPlugins(this.searchPluginErrors, this.pluginURLs);
        Console.MessageType messageType = Console.MessageType.INFO;
        if (stringArray.length > 0 && (string = stringArray[0]).startsWith("-v")) {
            if ("-version".equals(string)) {
                System.out.println("XMLmind Word To XML Evaluation Edition 1.14.0");
                System.exit(0);
            }
            if ("-vv".equals(string) || "-vvv".equals(string)) {
                messageType = Console.MessageType.DEBUG;
            } else if ("-v".equals(string)) {
                messageType = Console.MessageType.VERBOSE;
            }
            stringArray = StringList.removeAt(stringArray, 0);
        }
        int n = stringArray.length;
        Processor processor = new Processor();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        try {
            String string3;
            int n2 = processor.configure(stringArray, stringBuilder);
            if (n2 >= n) {
                Main.usage(null);
            }
            if ("-liststeps".equals(string3 = stringArray[n2])) {
                System.out.println(stringBuilder);
                System.exit(0);
            } else if ("-printenv".equals(string3)) {
                Main.printEnv();
                System.exit(0);
            } else if ("-batch".equals(string3)) {
                if (n2 + 2 >= n || (string2 = stringArray[n2 + 1].trim()).length() == 0) {
                    Main.usage(null);
                }
            } else if (n2 + 2 != n) {
                Main.usage(null);
            }
            if (string2 == null) {
                Main.processFile(processor, new File(stringArray[n2]), new File(stringArray[n2 + 1]), new SimpleProgressMonitor(messageType));
            } else {
                for (int i = n2 + 2; i < n; ++i) {
                    File file = new File(stringArray[i]);
                    File file2 = Main.batchOutputFile(string2, file);
                    Main.processFile(processor, file, file2, new SimpleProgressMonitor(messageType));
                    if (i + 1 >= n) continue;
                    processor = new Processor();
                    processor.configure(stringArray, null);
                }
            }
        }
        catch (UsageException usageException) {
            Main.usage(usageException);
        }
        catch (Exception exception) {
            System.err.println(Main.errorReason(exception));
            System.exit(2);
        }
    }

    private static void processFile(Processor processor, File file, File file2, ProgressMonitor progressMonitor) throws Exception {
        if (file2.exists() && file.exists() && file2.getCanonicalFile().equals(file.getCanonicalFile())) {
            throw new RuntimeException(Msg.msg("willNotOverwriteInputFile", file));
        }
        processor.process(file, file2, progressMonitor);
    }

    private static File batchOutputFile(String string, File file) {
        String string2 = string;
        if (string2.indexOf("@{name}") >= 0) {
            string2 = StringUtil.replaceAll(string2, "@{name}", FileUtil.setExtension(file, null).getName());
        }
        if (string2.indexOf("@{parent}") >= 0) {
            string2 = StringUtil.replaceAll(string2, "@{parent}", file.getAbsoluteFile().getParent());
        }
        return new File(string2).getAbsoluteFile();
    }

    private static void printEnv() {
        System.out.print("W2X_TRACE=");
        String string = System.getProperty("W2X_TRACE");
        if (string != null) {
            System.out.print(string);
        }
        System.out.println("\n(Supported values are: \"image\", \"math\" or \"all\".)");
        System.out.print("\nW2X_IMAGE_CONVERSIONS=");
        System.out.println(ImageConverterFactories.toSpecString());
    }

    private static void usage(UsageException usageException) {
        String string;
        if (usageException != null) {
            String string2 = USAGE1 + usageException.optionsDoc + "\n\n-version\n    Print version number and exit.\n-v|-vv|-vvv\n    Verbose.\n-batch out_spec in_docx_file1 ... in_docx_fileN\n    Convert all specified input DOCX files.\n    out_spec specifies the absolute or relative path\n    of the output files. It may contain the following variables:\n    @{name}, basename of the input file without any extension,\n    @{parent}, abs. path of the directory containing the input file.\n-printenv\n    Print supported environment variables/system properties and exit.\n-liststeps\n    List the conversion steps to be executed and exit.";
            string = UsageException.joinMessage(string2, usageException.error, usageException.errorURL);
        } else {
            string = "Usage: w2x [-version] [-v|-vv|-vvv] [Options]\n    in_docx_file out_file\n    | -batch out_spec in_docx_file1 ... in_docx_fileN\n    | -printenv\n    | -liststeps\n\n-version\n    Print version number and exit.\n-v|-vv|-vvv\n    Verbose.\n-batch out_spec in_docx_file1 ... in_docx_fileN\n    Convert all specified input DOCX files.\n    out_spec specifies the absolute or relative path\n    of the output files. It may contain the following variables:\n    @{name}, basename of the input file without any extension,\n    @{parent}, abs. path of the directory containing the input file.\n-printenv\n    Print supported environment variables/system properties and exit.\n-liststeps\n    List the conversion steps to be executed and exit.\n\nUse '-?' to list options.";
        }
        System.err.println(string);
        System.exit(1);
    }

    private static String errorReason(Exception exception) {
        String string = exception instanceof NullPointerException || exception instanceof IndexOutOfBoundsException ? ThrowableUtil.detailedReason(exception) : ThrowableUtil.reason(exception);
        return string;
    }
}

