/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.ProgressMonitorConsole;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.docx.toxhtml.ResourceDirectory;
import com.xmlmind.w2x.docx.toxhtml.Translator;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.ProcessStep;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.name.Name;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

public class ConvertStep
extends ProcessStep {
    public static final Name RESOURCE_DIRECTORY_PROP = Name.get("convert.resource-directory");

    public ConvertStep(String string) {
        super(string);
    }

    @Override
    public void process(Object[] objectArray, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        if (!(objectArray[0] instanceof File)) {
            this.illegalState(File.class);
        }
        File file = (File)objectArray[0];
        File file2 = this.getFileParameter(map, "xhtml-file", null);
        this.progress(Msg.msg("convertStep", file), nArray, progressMonitor);
        this.debugParameters(map, progressMonitor);
        map.remove(this.parameterName("xhtml-file"));
        Translator translator = new Translator();
        translator.setConsole(new ProgressMonitorConsole(progressMonitor));
        try {
            translator.parseParameters(this.getAllParameters(map));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("step \"" + this.stepName + "\": " + ThrowableUtil.reason(illegalArgumentException));
        }
        Pattern pattern = translator.getAutomaticIdsPattern();
        if (pattern != null) {
            map.put("edit.ids.automaticIdsRegex", pattern.pattern());
        }
        ResourceDirectory resourceDirectory = new ResourceDirectory();
        Document document = translator.translate(file, file2, resourceDirectory);
        document.putProperty(RESOURCE_DIRECTORY_PROP, resourceDirectory);
        if (file2 != null) {
            document.putProperty(Constants.SOURCE_URL_PROPERTY, FileUtil.fileToURL(file2));
        }
        objectArray[0] = document;
    }
}

