/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.w2x.processor.CSSRule;
import com.xmlmind.w2x.processor.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;

final class CSSRules {
    private final ArrayList<CSSRule> ruleList = new ArrayList();
    private final HashMap<String, CSSRule> selectorToRule = new HashMap();

    public int size() {
        return this.ruleList.size();
    }

    public CSSRule[] getAll() {
        return this.ruleList.toArray(CSSRule.EMPTY_LIST);
    }

    public int findFirst(String string) {
        int[] nArray = this.find(string, true);
        return nArray == null ? -1 : nArray[0];
    }

    public int[] findAll(String string) {
        return this.find(string, false);
    }

    private int[] find(String string, boolean bl) {
        int[] nArray = null;
        int n = this.ruleList.size();
        int n2 = -1;
        string = string.trim();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 >= 0 && n2 < n) {
            nArray = new int[]{n2};
        } else {
            Matcher matcher = Util.toMatcher(string);
            if (matcher == null) {
                for (int i = 0; i < n; ++i) {
                    if (!this.ruleList.get((int)i).selector.equals(string)) continue;
                    if (nArray == null) {
                        nArray = new int[]{i};
                        if (!bl) continue;
                        break;
                    }
                    int n3 = nArray.length;
                    int[] nArray2 = new int[n3 + 1];
                    System.arraycopy(nArray, 0, nArray2, 0, n3);
                    nArray2[n3] = i;
                    nArray = nArray2;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    matcher.reset(this.ruleList.get((int)i).selector);
                    if (!matcher.find()) continue;
                    if (nArray == null) {
                        nArray = new int[]{i};
                        if (!bl) continue;
                        break;
                    }
                    int n4 = nArray.length;
                    int[] nArray3 = new int[n4 + 1];
                    System.arraycopy(nArray, 0, nArray3, 0, n4);
                    nArray3[n4] = i;
                    nArray = nArray3;
                }
            }
        }
        return nArray;
    }

    public CSSRule get(int n) {
        CSSRule cSSRule = null;
        if (n >= 0 && n < this.ruleList.size()) {
            cSSRule = this.ruleList.get(n);
        }
        return cSSRule;
    }

    public CSSRule get(String string) {
        return this.selectorToRule.get(string);
    }

    public boolean add(CSSRule cSSRule) {
        return this.add(cSSRule, this.ruleList.size());
    }

    public boolean add(CSSRule cSSRule, int n) {
        if (this.selectorToRule.containsKey(cSSRule.selector)) {
            return false;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this.ruleList.size()) {
            n = this.ruleList.size();
        }
        this.ruleList.add(n, cSSRule);
        this.selectorToRule.put(cSSRule.selector, cSSRule);
        return true;
    }

    public void put(CSSRule cSSRule) {
        CSSRule cSSRule2 = this.selectorToRule.get(cSSRule.selector);
        if (cSSRule2 == null) {
            this.add(cSSRule);
            return;
        }
        cSSRule2.merge(cSSRule);
    }

    public CSSRule remove(int n) {
        CSSRule cSSRule = null;
        if (n >= 0 && n < this.ruleList.size()) {
            cSSRule = this.ruleList.remove(n);
            this.selectorToRule.remove(cSSRule.selector);
        }
        return cSSRule;
    }

    public void clear() {
        this.ruleList.clear();
        this.selectorToRule.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CSSRule cSSRule : this.ruleList) {
            stringBuilder.append('\n');
            cSSRule.toString(stringBuilder);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

