/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

public enum XHTMLVersion {
    V1_0_Transitional,
    V1_0_Strict,
    V1_0_Frameset,
    V1_1,
    V5_0;


    public static XHTMLVersion fromString(String string) {
        if ("1.0_transitional".equalsIgnoreCase(string) || "1.0_loose".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string)) {
            return V1_0_Transitional;
        }
        if ("1.0_strict".equalsIgnoreCase(string)) {
            return V1_0_Strict;
        }
        if ("1.0_frameset".equalsIgnoreCase(string)) {
            return V1_0_Frameset;
        }
        if ("1.1".equalsIgnoreCase(string)) {
            return V1_1;
        }
        if ("5.0".equalsIgnoreCase(string) || "5".equalsIgnoreCase(string)) {
            return V5_0;
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case V1_0_Transitional: {
                return "1.0_Transitional";
            }
            case V1_0_Strict: {
                return "1.0_Strict";
            }
            case V1_0_Frameset: {
                return "1.0_Frameset";
            }
            case V1_1: {
                return "1.1";
            }
            case V5_0: {
                return "5.0";
            }
        }
        return "???";
    }

    public String getPublicId() {
        switch (this) {
            case V1_0_Transitional: {
                return "-//W3C//DTD XHTML 1.0 Transitional//EN";
            }
            case V1_0_Strict: {
                return "-//W3C//DTD XHTML 1.0 Strict//EN";
            }
            case V1_0_Frameset: {
                return "-//W3C//DTD XHTML 1.0 Frameset//EN";
            }
            case V1_1: {
                return "-//W3C//DTD XHTML 1.1//EN";
            }
        }
        return null;
    }

    public String getSystemId() {
        switch (this) {
            case V1_0_Transitional: {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
            }
            case V1_0_Strict: {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
            }
            case V1_0_Frameset: {
                return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
            }
            case V1_1: {
                return "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
            }
        }
        return null;
    }
}

