/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.image.ImageConverterFactories;
import com.xmlmind.w2x.docx.image.ImageConverterFactoryImpl;
import com.xmlmind.w2x.docx.math.MathConverterFactories;
import com.xmlmind.w2x.docx.packaging.Package;
import com.xmlmind.w2x.docx.packaging.PackageException;
import com.xmlmind.w2x.docx.packaging.Part;
import com.xmlmind.w2x.docx.packaging.Related;
import com.xmlmind.w2x.docx.toxhtml.BasicPattern;
import com.xmlmind.w2x.docx.toxhtml.Binding;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.ImgTranslator;
import com.xmlmind.w2x.docx.toxhtml.JoinParagraphs;
import com.xmlmind.w2x.docx.toxhtml.LegacyFontMappings;
import com.xmlmind.w2x.docx.toxhtml.Msg;
import com.xmlmind.w2x.docx.toxhtml.Numbering;
import com.xmlmind.w2x.docx.toxhtml.PrepareTabs;
import com.xmlmind.w2x.docx.toxhtml.Product;
import com.xmlmind.w2x.docx.toxhtml.Range;
import com.xmlmind.w2x.docx.toxhtml.RemoveAnnotations;
import com.xmlmind.w2x.docx.toxhtml.ResourceDirectory;
import com.xmlmind.w2x.docx.toxhtml.RowColumn;
import com.xmlmind.w2x.docx.toxhtml.SaveXHTML;
import com.xmlmind.w2x.docx.toxhtml.SimplifyAnchors;
import com.xmlmind.w2x.docx.toxhtml.SimplifyFields;
import com.xmlmind.w2x.docx.toxhtml.SimplifyLang;
import com.xmlmind.w2x.docx.toxhtml.SimplifyParagraphs;
import com.xmlmind.w2x.docx.toxhtml.SimplifyReferences;
import com.xmlmind.w2x.docx.toxhtml.SimplifySpans;
import com.xmlmind.w2x.docx.toxhtml.SimplifyTables;
import com.xmlmind.w2x.docx.toxhtml.SpanHelper;
import com.xmlmind.w2x.docx.toxhtml.Style;
import com.xmlmind.w2x.docx.toxhtml.Styles;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.docx.toxhtml.XHTMLVersion;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.sxpath.ElementMatcher;
import com.xmlmind.xml.sxpath.XPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Translator
implements ImgTranslator {
    public static final String AUTOMATIC_IDS_REGEX = "(^_?[a-zA-Z]{1,3}\\d+$)|(^(OLE_LINK|_ENREF_))|(^_GoBack$)";
    private Console console;
    private boolean columnNumberPI;
    private XHTMLVersion xhtmlVersion = XHTMLVersion.V1_0_Transitional;
    private String charset = null;
    private String forceLang = null;
    private String defaultLang = null;
    private boolean lowerCaseResourceNames;
    private Boolean createMathMLObject = null;
    private boolean markCustomStyles;
    private boolean simplify = true;
    private boolean keepAllRanges;
    private String[] convertedImageExtensions;
    private String resourceDirectoryPath;
    private String resourcePrefix;
    private Pattern automaticIdsPattern = Pattern.compile("(^_?[a-zA-Z]{1,3}\\d+$)|(^(OLE_LINK|_ENREF_))|(^_GoBack$)");
    private File docxFile;
    private Package docx;
    private int docxVersion;
    private HashMap<String, String> imgPartNameToSrc;
    private File imgDir;
    private String imgDirPath;
    private int mathCounter;
    private Document mainDoc;
    private Styles styles;
    private Document footnotesDoc;
    private int firstFootnoteId;
    private Document endnotesDoc;
    private int firstEndnoteId;
    private HashMap<String, String> styleProps;
    private String[] classes;
    private HashMap<Integer, Range> idToRange;
    private static final int MAX_IMG_WIDTH = 5120;
    private static final int MAX_IMG_HEIGHT = 3200;
    private static final Name LAST_HMERGED_CELL_PROP = Name.get(Constants.WORDPROCESSINGML_NS[0], "LAST_HMERGED_CELL");
    private static final Name LAST_VMERGED_CELL_PROP = Name.get(Constants.WORDPROCESSINGML_NS[0], "LAST_VMERGED_CELL");
    private static final Name PARSED_STYLES_PROP = Name.get(Constants.WORDPROCESSINGML_NS[0], "PARSED_STYLES");
    private static final Name ROW_COLUMN_PROP = Name.get(Constants.WORDPROCESSINGML_NS[0], "ROW_COLUMN");
    private static final Name PHANTOM_CELL_PROP = Name.get(Constants.WORDPROCESSINGML_NS[0], "PHANTOM_CELL");
    private static final Name[] TABLE_PROPS = new Name[]{LAST_HMERGED_CELL_PROP, LAST_VMERGED_CELL_PROP, PARSED_STYLES_PROP, ROW_COLUMN_PROP, PHANTOM_CELL_PROP};
    private static final HashMap<String, String> EMPTY_PARSED_STYLES = new HashMap();
    private static final String[] QNAMES = new String[]{"a:blip", "a:ext", "a:srcRect", "a:xfrm", "asvg:svgBlip", "cp:keywords", "m:oMath", "m:oMathPara", "o:hr", "o:href", "o:title", "pic:cNvPr", "pic:pic", "r:embed", "r:href", "r:id", "r:link", "v:imagedata", "v:rect", "v:textbox", "v:shape", "w:anchor", "w:bookmarkEnd", "w:bookmarkStart", "w:char", "w:drawing", "w:fldCharType", "w:font", "w:gridAfter", "w:gridBefore", "w:gridCol", "w:gridSpan", "w:header", "w:headers", "w:hMerge", "w:id", "w:instr", "w:name", "w:pPr", "w:pStyle", "w:pict", "w:rPr", "w:rStyle", "w:sectPr", "w:tblCaption", "w:tblDescription", "w:tblHeader", "w:tblPr", "w:tblStyle", "w:tc", "w:tcPr", "w:tgtFrame", "w:tooltip", "w:tr", "w:trPr", "w:txbxContent", "w:type", "w:vMerge", "w:val", "w:w", "w:wAfter", "w:wBefore"};
    private Name name_a_blip;
    private Name name_a_ext;
    private Name name_a_srcRect;
    private Name name_a_xfrm;
    private Name name_asvg_svgBlip;
    private Name name_cp_keywords;
    private Name name_m_oMath;
    private Name name_m_oMathPara;
    private Name name_o_hr;
    private Name name_o_href;
    private Name name_o_title;
    private Name name_pic_cNvPr;
    private Name name_pic_pic;
    private Name name_r_embed;
    private Name name_r_href;
    private Name name_r_id;
    private Name name_r_link;
    private Name name_v_imagedata;
    private Name name_v_rect;
    private Name name_v_textbox;
    private Name name_v_shape;
    private Name name_w_anchor;
    private Name name_w_bookmarkEnd;
    private Name name_w_bookmarkStart;
    private Name name_w_char;
    private Name name_w_drawing;
    private Name name_w_fldCharType;
    private Name name_w_font;
    private Name name_w_gridAfter;
    private Name name_w_gridBefore;
    private Name name_w_gridCol;
    private Name name_w_gridSpan;
    private Name name_w_header;
    private Name name_w_headers;
    private Name name_w_hMerge;
    private Name name_w_id;
    private Name name_w_instr;
    private Name name_w_name;
    private Name name_w_pPr;
    private Name name_w_pStyle;
    private Name name_w_pict;
    private Name name_w_rPr;
    private Name name_w_rStyle;
    private Name name_w_sectPr;
    private Name name_w_tblCaption;
    private Name name_w_tblDescription;
    private Name name_w_tblHeader;
    private Name name_w_tblPr;
    private Name name_w_tblStyle;
    private Name name_w_tc;
    private Name name_w_tcPr;
    private Name name_w_tgtFrame;
    private Name name_w_tooltip;
    private Name name_w_tr;
    private Name name_w_trPr;
    private Name name_w_txbxContent;
    private Name name_w_type;
    private Name name_w_vMerge;
    private Name name_w_val;
    private Name name_w_w;
    private Name name_w_wAfter;
    private Name name_w_wBefore;
    private static final String[] TRANSLATION_SPEC = new String[]{"w:document", "translate_w_document", "w:background", "translate_w_background", "w:body", "translate_w_body", "w:sectPr", "translate_w_sectPr", "w:p", "translate_w_p", "w:pPr", "translate_w_pPr", "w:bookmarkEnd", "translate_w_bookmarkEnd", "w:bookmarkStart", "translate_w_bookmarkStart", "w:fldSimple", "translate_w_fldSimple", "w:hyperlink", "translate_w_hyperlink", "m:oMathPara", "translate_m_oMath", "m:oMath", "translate_m_oMath", "w:bdo", "traverse", "w:dir", "traverse", "w:r", "translate_w_r", "w:rPr", "translate_w_rPr", "w:br", "translateBreak", "w:cr", "translateBreak", "w:dayLong", "translateLegacyField", "w:dayShort", "translateLegacyField", "w:drawing", "translate_w_drawing", "w:endnoteReference", "translateNoteReference", "w:fldChar", "translateComplexField", "w:footnoteReference", "translateNoteReference", "w:instrText", "translateComplexField", "w:monthLong", "translateLegacyField", "w:monthShort", "translateLegacyField", "w:noBreakHyphen", "translate_w_noBreakHyphen", "w:object", "translate_w_object", "w:pgNum", "translateLegacyField", "w:pict", "translate_w_pict", "w:sym", "translate_w_sym", "w:t", "translate_w_t", "w:tab", "translateTab", "w:yearLong", "translateLegacyField", "w:yearShort", "translateLegacyField", "w:tbl", "translate_w_tbl", "w:tblPr", "translate_w_tblPr", "w:tblGrid", "traverse", "w:gridCol", "translate_w_gridCol", "w:tr", "translate_w_tr", "w:trPr", "translate_w_trPr", "w:tc", "translate_w_tc", "w:tcPr", "translate_w_tcPr", "w:footnotes", "translateNotes", "w:footnote", "translateNote", "w:endnotes", "translateNotes", "w:endnote", "translateNote"};
    private IdentityHashMap<Name, Binding[]> bindingMap;

    public void setConsole(Console console) {
        this.console = console;
    }

    public Console getConsole() {
        return this.console;
    }

    public void parseParameters(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length / 2 * 2;
        for (int i = 0; i < n; i += 2) {
            Object object;
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            boolean bl = false;
            if ("version".equals(string)) {
                if (string2.length() == 0) {
                    this.setXHTMLVersion(null);
                } else {
                    object = XHTMLVersion.fromString(string2);
                    if (object == null) {
                        bl = true;
                    } else {
                        this.setXHTMLVersion((XHTMLVersion)((Object)object));
                    }
                }
            } else if ("charset".equals(string)) {
                this.setCharset(string2.length() == 0 ? null : string2);
            } else if ("set-column-number".equals(string)) {
                this.setAddColumnNumberPI(Translator.parseBooleanParam(string2, false));
            } else if ("set-lang".equals(string)) {
                this.setForceLang(string2.length() == 0 ? null : string2);
            } else if ("default-lang".equals(string)) {
                this.setDefaultLang(string2.length() == 0 ? null : string2);
            } else if ("converted-image-extensions".equals(string)) {
                this.setConvertedImageExtensions(StringUtil.split(string2));
            } else if ("resource-directory".equals(string)) {
                this.setResourceDirectoryPath(string2);
            } else if ("resource-prefix".equals(string)) {
                this.setResourcePrefix(string2);
            } else if ("lower-case-resource-names".equals(string)) {
                this.setLowerCaseResourceNames(Translator.parseBooleanParam(string2, false));
            } else if ("create-mathml-object".equals(string)) {
                object = null;
                if ("yes".equals(string2)) {
                    object = Boolean.TRUE;
                } else if ("no".equals(string2)) {
                    object = Boolean.FALSE;
                } else if (!"auto".equals(string2)) {
                    bl = true;
                }
                this.setCreateMathMLObject((Boolean)object);
            } else if ("automatic-ids".equals(string)) {
                try {
                    this.setAutomaticIds(string2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    bl = true;
                }
            } else if ("mark-custom-styles".equals(string)) {
                this.setMarkCustomStyles(Translator.parseBooleanParam(string2, false));
            } else if ("simplify".equals(string)) {
                this.setSimplify(Translator.parseBooleanParam(string2, true));
            } else if ("keep-all-ranges".equals(string)) {
                this.setKeepAllRanges(Translator.parseBooleanParam(string2, false));
            } else {
                throw new IllegalArgumentException(Msg.msg("unknownParam", string));
            }
            if (!bl) continue;
            throw new IllegalArgumentException(Msg.msg("invalidParamValue", string2, string));
        }
    }

    private static boolean parseBooleanParam(String string, boolean bl) {
        if (string != null) {
            if ("true".equals(string) || "yes".equals(string) || "on".equals(string) || "1".equals(string)) {
                return true;
            }
            if ("false".equals(string) || "no".equals(string) || "off".equals(string) || "0".equals(string)) {
                return false;
            }
        }
        return bl;
    }

    public void setAddColumnNumberPI(boolean bl) {
        this.columnNumberPI = bl;
    }

    public boolean getAddColumnNumberPI() {
        return this.columnNumberPI;
    }

    public void setXHTMLVersion(XHTMLVersion xHTMLVersion) {
        this.xhtmlVersion = xHTMLVersion;
    }

    public XHTMLVersion getXHTMLVersion() {
        return this.xhtmlVersion;
    }

    private XHTMLVersion xhtmlVersion() {
        return this.xhtmlVersion == null ? XHTMLVersion.V1_0_Transitional : this.xhtmlVersion;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setForceLang(String string) {
        this.forceLang = string;
    }

    public String getForceLang() {
        return this.forceLang;
    }

    public void setDefaultLang(String string) {
        this.defaultLang = string;
    }

    public String getDefaultLang() {
        return this.defaultLang;
    }

    public void setConvertedImageExtensions(String[] stringArray) {
        this.convertedImageExtensions = stringArray;
    }

    public String[] getConvertedImageExtensions() {
        return this.convertedImageExtensions;
    }

    public void setResourceDirectoryPath(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string != null && string.indexOf(47) >= 0 && File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        this.resourceDirectoryPath = string;
    }

    public String getResourceDirectoryPath() {
        return this.resourceDirectoryPath;
    }

    public void setResourcePrefix(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string != null) {
            if (string.indexOf(47) >= 0) {
                string = string.replace('/', '_');
            }
            if (string.indexOf(File.separatorChar) >= 0) {
                string = string.replace(File.separatorChar, '_');
            }
        }
        this.resourcePrefix = string;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public void setLowerCaseResourceNames(boolean bl) {
        this.lowerCaseResourceNames = bl;
    }

    public boolean getLowerCaseResourceNames() {
        return this.lowerCaseResourceNames;
    }

    public void setCreateMathMLObject(Boolean bl) {
        this.createMathMLObject = bl;
    }

    public Boolean getCreateMathMLObject() {
        return this.createMathMLObject;
    }

    public void setMarkCustomStyles(boolean bl) {
        this.markCustomStyles = bl;
    }

    public boolean getMarkCustomStyles() {
        return this.markCustomStyles;
    }

    public void setSimplify(boolean bl) {
        this.simplify = bl;
    }

    public boolean getSimplify() {
        return this.simplify;
    }

    public void setKeepAllRanges(boolean bl) {
        this.keepAllRanges = bl;
    }

    public boolean getKeepAllRanges() {
        return this.keepAllRanges;
    }

    public void setAutomaticIds(String object) throws PatternSyntaxException {
        Pattern pattern = null;
        if (((String)(object = ((String)object).trim())).length() > 0) {
            if (((String)object).startsWith("|")) {
                object = AUTOMATIC_IDS_REGEX + (String)object;
            } else if (((String)object).endsWith("|")) {
                object = (String)object + AUTOMATIC_IDS_REGEX;
            }
            pattern = Pattern.compile((String)object);
        }
        this.setAutomaticIdsPattern(pattern);
    }

    public void setAutomaticIdsPattern(Pattern pattern) {
        this.automaticIdsPattern = pattern;
    }

    public Pattern getAutomaticIdsPattern() {
        return this.automaticIdsPattern;
    }

    public Document translate(File file, File file2, ResourceDirectory resourceDirectory) throws IOException {
        Object object;
        this.docxFile = file;
        Document document = null;
        try {
            Element element;
            this.initTranslation();
            if (resourceDirectory == null) {
                resourceDirectory = new ResourceDirectory();
            }
            this.initResources(file2, resourceDirectory);
            this.initPackage();
            this.styleProps = new HashMap();
            this.classes = new String[3];
            this.idToRange = new HashMap();
            document = new Document();
            object = new PrefixPreferences();
            ((PrefixPreferences)object).add(Namespace.XHTML, "html");
            ((PrefixPreferences)object).setDefaultNamespace(Namespace.XHTML);
            document.putProperty(com.xmlmind.xml.doc.Constants.NAMESPACE_PREFIX_MAP_PROPERTY, object);
            XPath[] xPathArray = new XPath[]{XPath.fromString("html:style", (PrefixToNamespace)object), XPath.fromString("html:script", (PrefixToNamespace)object), XPath.fromString("html:pre", (PrefixToNamespace)object)};
            document.putProperty(com.xmlmind.xml.doc.Constants.PRESERVE_SPACE_ELEMENTS_PROPERTY, new ElementMatcher(xPathArray));
            Element element2 = new Element(Constants.HTML_ELEM);
            document.appendChild(element2);
            this.translate(this.mainDoc.getRootElement(), element2);
            Element element3 = element2.getChildElement(1);
            if (element3 != null) {
                if (this.footnotesDoc != null) {
                    this.translate(this.footnotesDoc.getRootElement(), element3);
                }
                if (this.endnotesDoc != null) {
                    this.translate(this.endnotesDoc.getRootElement(), element3);
                }
            }
            if ((element = element2.getChildElement(0)) != null) {
                this.styles.declareStyles(element);
            }
        }
        catch (Throwable throwable) {
            String string = throwable instanceof IOException || throwable instanceof PackageException ? ThrowableUtil.reason(throwable) : ThrowableUtil.detailedReason(throwable, 10);
            throw new IOException(Msg.msg("cannotTranslate", file, string), throwable);
        }
        if (this.xhtmlVersion != null) {
            Util.setDocumentType(document, this.xhtmlVersion);
        }
        this.fixLineHeight(document.getRootElement());
        this.numberItems(document);
        if (this.simplify) {
            SimplifyLang.process(document, this.forceLang, this.defaultLang);
            SimplifyFields.process(document);
            SimplifyAnchors.process(document, this.automaticIdsPattern);
            Range.simplifyAll(document, this.idToRange, this.keepAllRanges);
            this.idToRange = null;
            SimplifyReferences.process(document, this.xhtmlVersion());
            SimplifyTables.process(document, this.styles);
            SimplifySpans.process(document);
            SimplifyParagraphs.process(document);
            JoinParagraphs.process(document, this.styles);
            PrepareTabs.process(document, this.styles);
            if (Product.IS_MANGLED) {
                object = new int[1];
                Translator.mangle(document.getRootElement(), (int[])object);
            }
        }
        return document;
    }

    private static void mangle(Element element, int[] nArray) {
        if (element.getName() == Constants.P_ELEM) {
            nArray[0] = nArray[0] + 1;
            if (nArray[0] % 5 == 4) {
                Translator.mangle(element);
            }
        } else {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                Translator.mangle((Element)node, nArray);
            }
        }
    }

    private static boolean mangle(Element element) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case TEXT: {
                    if (!Translator.mangle((Text)node)) continue block4;
                    return true;
                }
                case ELEMENT: {
                    Element element2 = (Element)node;
                    if (element2.getName() != Constants.SPAN_ELEM || !Translator.mangle(element2)) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean mangle(Text text) {
        char[] cArray = text.getTextChars();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(cArray[i])) continue;
            int n2 = i + 1;
            int n3 = n2;
            if (n3 < n && Character.isLetter(cArray[n3])) {
                ++n3;
                while (n3 < n && Character.isLetterOrDigit(cArray[n3])) {
                    ++n3;
                }
            }
            if (n3 - n2 < 3) continue;
            text.replaceText(n2, n3 - n2, "[XMLmind]");
            return true;
        }
        return false;
    }

    private void initTranslation() throws IOException, PackageException {
        Object[] objectArray;
        this.docx = new Package(this.docxFile);
        this.docxVersion = -1;
        for (int i = 0; i < Constants.OFFICE_DOCUMENT_REL.length; ++i) {
            objectArray = this.docx.getRelatedPartByRelation(Constants.OFFICE_DOCUMENT_REL[i]);
            if (objectArray == null || objectArray.length != 1) continue;
            this.docxVersion = i;
            break;
        }
        if (this.docxVersion < 0) {
            throw new PackageException(Msg.msg("notWML", this.docxFile));
        }
        PrefixPreferences prefixPreferences = Util.createPrefixPreferences(this.docxVersion);
        this.bindingMap = new IdentityHashMap();
        try {
            Object object;
            Object object2;
            Object object3;
            objectArray = QNAMES;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                object3 = objectArray[i];
                object2 = Name.parse((String)object3, true, prefixPreferences);
                if (object2 == null) {
                    throw new RuntimeException("'" + (String)object3 + "', not a Name");
                }
                object = "name_" + ((String)object3).replace(':', '_');
                Field field = Translator.class.getDeclaredField((String)object);
                field.set(this, object2);
            }
            int n2 = TRANSLATION_SPEC.length;
            for (n = 0; n < n2; n += 2) {
                String string = TRANSLATION_SPEC[n];
                object3 = TRANSLATION_SPEC[n + 1];
                object2 = BasicPattern.parse(string, prefixPreferences);
                object = Translator.class.getDeclaredMethod((String)object3, Element.class, Element.class);
                Binding.bind((BasicPattern)object2, (Method)object, this.bindingMap);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initResources(File file, ResourceDirectory resourceDirectory) throws IOException {
        this.imgPartNameToSrc = new HashMap();
        if (resourceDirectory.directory != null) {
            resourceDirectory.directory = resourceDirectory.directory.getAbsoluteFile();
            if (resourceDirectory.directory.getParentFile() == null) {
                resourceDirectory.directory = null;
            }
        }
        if (resourceDirectory.directory == null && this.resourceDirectoryPath != null) {
            File file2 = new File(this.resourceDirectoryPath);
            if (!file2.isAbsolute()) {
                file2 = file != null ? new File(file.getAbsoluteFile().getParentFile(), this.resourceDirectoryPath) : null;
            }
            resourceDirectory.directory = file2;
        }
        boolean bl = false;
        if (resourceDirectory.directory != null) {
            this.imgDir = resourceDirectory.directory;
            if (file != null) {
                File file3 = new File(this.imgDir, "XXX");
                this.imgDirPath = URLUtil.getRawRelativePath(FileUtil.fileToURL(file3), FileUtil.fileToURL(file));
                this.imgDirPath = this.imgDirPath.substring(0, this.imgDirPath.length() - 3);
            } else {
                this.imgDirPath = FileUtil.fileToURL(this.imgDir).toExternalForm();
            }
        } else if (file != null) {
            this.imgDir = Translator.saveFileToResourceDir(file);
            bl = true;
            this.imgDirPath = URIComponent.quotePath(this.imgDir.getName()) + "/";
        } else {
            this.imgDir = FileUtil.createTempDirectory("w2x_", null);
            this.imgDirPath = FileUtil.fileToURL(this.imgDir).toExternalForm();
        }
        if (this.imgDirPath.length() > 0 && !this.imgDirPath.endsWith("/")) {
            this.imgDirPath = this.imgDirPath + "/";
        }
        resourceDirectory.directory = this.imgDir;
        resourceDirectory.location = this.imgDirPath;
        if (this.imgDir.isDirectory() && bl) {
            this.emptyDir(this.imgDir);
        }
    }

    private static File saveFileToResourceDir(File file) {
        String string = FileUtil.setExtension(file.getName(), null) + "_files";
        return new File(file.getAbsoluteFile().getParentFile(), string);
    }

    private void emptyDir(File file) {
        if (!FileUtil.doEmptyDir(file) && this.console != null) {
            this.console.showMessage(Msg.msg("cannotEmptyDir", file), Console.MessageType.WARNING);
        }
    }

    private void initPackage() throws IOException, PackageException {
        Part part;
        Part part2 = null;
        Part[] partArray = this.docx.getRelatedPartByRelation(Constants.OFFICE_DOCUMENT_REL[this.docxVersion]);
        if (partArray != null && partArray.length == 1) {
            part2 = partArray[0];
        }
        if (part2 == null) {
            throw new PackageException(Msg.msg("notWML", this.docxFile));
        }
        this.mainDoc = part2.getDocument();
        Util.setPartProperty(this.mainDoc, part2);
        RemoveAnnotations removeAnnotations = new RemoveAnnotations(this.docxVersion, this.console);
        removeAnnotations.process(this.mainDoc);
        Part part3 = null;
        Part[] partArray2 = part2.getRelatedPartByRelation(Constants.STYLES_REL[this.docxVersion]);
        if (partArray2 != null && partArray2.length > 0) {
            part3 = partArray2[0];
        }
        Part part4 = null;
        partArray2 = part2.getRelatedPartByRelation(Constants.NUMBERING_REL[this.docxVersion]);
        if (partArray2 != null && partArray2.length > 0) {
            part4 = partArray2[0];
        }
        Part part5 = null;
        partArray2 = part2.getRelatedPartByRelation(Constants.THEME_REL[this.docxVersion]);
        if (partArray2 != null && partArray2.length > 0) {
            part5 = partArray2[0];
        }
        Part part6 = null;
        partArray2 = part2.getRelatedPartByRelation(Constants.SETTINGS_REL[this.docxVersion]);
        if (partArray2 != null && partArray2.length > 0) {
            part6 = partArray2[0];
        }
        this.styles = new Styles(part3, part4, part5, part6, this.markCustomStyles, this.docxVersion, this.forceLang != null ? this.forceLang : this.defaultLang, this, this.console);
        this.footnotesDoc = null;
        this.firstFootnoteId = -1;
        partArray2 = part2.getRelatedPartByRelation(Constants.FOOTNOTES_REL[this.docxVersion]);
        if (partArray2 != null && partArray2.length > 0) {
            part = partArray2[0];
            this.footnotesDoc = part.getDocument();
            Util.setPartProperty(this.footnotesDoc, part);
            removeAnnotations.process(this.footnotesDoc);
            this.firstFootnoteId = this.getFirstNoteId(this.footnotesDoc);
        }
        this.endnotesDoc = null;
        this.firstEndnoteId = -1;
        partArray2 = part2.getRelatedPartByRelation(Constants.ENDNOTES_REL[this.docxVersion]);
        if (partArray2 != null && partArray2.length > 0) {
            part = partArray2[0];
            this.endnotesDoc = part.getDocument();
            Util.setPartProperty(this.endnotesDoc, part);
            removeAnnotations.process(this.endnotesDoc);
            this.firstEndnoteId = this.getFirstNoteId(this.endnotesDoc);
        }
    }

    private int getFirstNoteId(Document document) {
        int n = -1;
        for (Node node = document.getRootElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            String string;
            if (node.getType() != Node.Type.ELEMENT || (string = (element = (Element)node).getAttribute(this.name_w_type)) != null && !"normal".equals(string)) continue;
            n = element.getIntAttribute(this.name_w_id, 0, Integer.MAX_VALUE, -1);
            break;
        }
        return n;
    }

    private void translate(Element element, Element element2) {
        Method method = Binding.getMethod(this.bindingMap, element);
        if (method != null) {
            try {
                method.invoke((Object)this, element, element2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void traverse(Element element, Element element2) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case PROCESSING_INSTRUCTION: {
                    element2.appendChild(node.copy());
                    continue block4;
                }
                case ELEMENT: {
                    this.translate((Element)node, element2);
                }
            }
        }
    }

    private void translate_w_document(Element element, Element element2) throws IOException {
        Element element3 = new Element(Constants.HEAD_ELEM);
        element2.appendChild(element3);
        this.addMetas(element3);
        this.traverse(element, element2);
    }

    private void addMetas(Element element) throws IOException {
        boolean bl;
        boolean bl2 = true;
        Part[] partArray = this.docx.getRelatedPartByRelation(Constants.CORE_PROPERTIES_REL[this.docxVersion]);
        if (partArray != null && partArray.length > 0 && (bl = this.addMetas(partArray[0].getDocument(), element))) {
            bl2 = false;
        }
        if ((partArray = this.docx.getRelatedPartByRelation(Constants.EXTENDED_PROPERTIES_REL[this.docxVersion])) != null && partArray.length > 0 && (bl = this.addMetas(partArray[0].getDocument(), element))) {
            bl2 = false;
        }
        if ((partArray = this.docx.getRelatedPartByRelation(Constants.CUSTOM_PROPERTIES_REL[this.docxVersion])) != null && partArray.length > 0 && (bl = this.addMetas(partArray[0].getDocument(), element))) {
            bl2 = false;
        }
        if (bl2) {
            Translator.addTitle("???", element);
        }
        if (this.charset != null) {
            Element element2 = new Element(Constants.META_ELEM);
            if (this.xhtmlVersion() == XHTMLVersion.V5_0) {
                element2.putAttribute(Constants.CHARSET_ATTR, this.charset);
            } else {
                element2.putAttribute(Constants.HTTP_EQUIV_ATTR, "content-type");
                element2.putAttribute(Constants.CONTENT_ATTR, "text/html;charset=" + this.charset);
            }
            element.insertChild(element.getFirstChild(), element2);
        }
        Element element3 = new Element(Constants.META_ELEM);
        element3.putAttribute(Constants.NAME_ATTR, "generator");
        element3.putAttribute(Constants.CONTENT_ATTR, "XMLmind Word To XML Evaluation Edition 1.14.0");
        element.appendChild(element3);
    }

    private boolean addMetas(Document document, Element element) throws IOException {
        boolean bl = false;
        for (Node node = document.getRootElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl2;
            if (node.getType() != Node.Type.ELEMENT || !(bl2 = this.addMeta((Element)node, element))) continue;
            bl = true;
        }
        return bl;
    }

    private boolean addMeta(Element element, Element element2) {
        Comparable<XNode> comparable;
        String string = Translator.getMetaText(element);
        if (string == null) {
            return false;
        }
        Name name = element.getName();
        if (name == Constants.DC_TITLE_ELEM) {
            Translator.addTitle(string, element2);
            return true;
        }
        Object object = null;
        if (name == Constants.DC_CREATOR_ELEM) {
            object = "author";
        } else if (name == Constants.DC_DESCRIPTION_ELEM) {
            object = "description";
        } else if (name == this.name_cp_keywords) {
            object = "keywords";
        } else {
            comparable = name.namespace;
            String string2 = name.localPart;
            if (comparable == Constants.CORE_PROPERTIES_NS[this.docxVersion]) {
                object = "ms-cp-" + string2;
            } else if (comparable == Constants.EXTENDED_PROPERTIES_NS[this.docxVersion]) {
                object = "ms-ep-" + string2;
            } else if (comparable == Constants.CUSTOM_PROPERTIES_NS[this.docxVersion]) {
                object = element.getAttribute(Constants.NAME_ATTR);
                if (object != null) {
                    object = "ms-up-" + XMLText.checkId((String)object);
                }
            } else {
                object = comparable == Constants.DC_NS ? "dc." + string2 : (comparable == Constants.DCTERMS_NS ? "dcterms." + string2 : "-x-" + string2);
            }
        }
        if (object == null) {
            return false;
        }
        comparable = new Element(Constants.META_ELEM);
        element2.appendChild((Node)comparable);
        ((Element)comparable).putAttribute(Constants.NAME_ATTR, (String)object);
        ((Element)comparable).putAttribute(Constants.CONTENT_ATTR, string);
        return false;
    }

    private static String getMetaText(Element element) {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        Translator.getMetaText(element, stringBuilder);
        if (stringBuilder.length() > 0) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private static void getMetaText(Element element, StringBuilder stringBuilder) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case TEXT: {
                    String string = ((Text)node).getText();
                    string = XMLText.collapseWhiteSpace(string);
                    if (string.length() <= 0) continue block4;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(';');
                    }
                    stringBuilder.append(string);
                    continue block4;
                }
                case ELEMENT: {
                    Translator.getMetaText((Element)node, stringBuilder);
                }
            }
        }
    }

    private static void addTitle(String string, Element element) {
        Element element2 = new Element(Constants.TITLE_ELEM);
        element2.appendChild(new Text(string));
        element.insertChild(element.getFirstChild(), element2);
    }

    private void translate_w_background(Element element, Element element2) {
        this.styles.setBodyBackground(element);
    }

    private void translate_w_body(Element element, Element element2) {
        Element element3 = new Element(Constants.BODY_ELEM);
        element2.appendChild(element3);
        this.styles.setDefaultLang(element3);
        this.traverse(element, element3);
    }

    private void translate_w_sectPr(Element element, Element element2) {
        element2.appendChild(new ProcessingInstruction("end-of-section"));
    }

    private void translate_w_p(Element element, Element element2) {
        Element element3;
        Element element4 = Util.findDescendant(element, this.name_w_pPr, false);
        if (element4 != null && (element3 = Util.findDescendant(element4, this.name_w_sectPr, false)) != null && element.getChildElementCount() == 1) {
            this.translate_w_sectPr(element3, element2);
            return;
        }
        element3 = new Element(Constants.P_ELEM);
        element2.appendChild(element3);
        String string = this.styles.getImplicitParagraphStyleId();
        if (string != null) {
            this.addImplicitStyle(element, this.name_w_pPr, this.name_w_pStyle, string);
        }
        this.traverse(element, element3);
    }

    private void addImplicitStyle(Element element, Name name, Name name2, String string) {
        Element element2 = Util.findDescendant(element, name, false);
        if (element2 == null) {
            element2 = new Element(name);
            element.insertChild(element.getFirstChild(), element2);
        }
        if (Util.findDescendant(element2, name2, false) == null) {
            Element element3 = new Element(name2);
            element2.insertChild(element2.getFirstChild(), element3);
            element3.putAttribute(this.name_w_val, string);
        }
    }

    private void translate_w_pPr(Element element, Element element2) {
        String string;
        Element element3 = Util.findDescendant(element, this.name_w_rPr, false);
        if (element3 != null) {
            element.removeChild(element3);
        }
        if ((string = this.styles.getLang(element)) != null) {
            element2.putAttribute(Name.LANG, string);
        }
        this.styles.parseStyleProps(element, this.styleProps, this.classes);
        this.putStyles(element2, this.styleProps, this.classes);
        Element element4 = element.getParentElement();
        if (element4 != null) {
            element4 = element4.getParentElement();
        }
        if (element4 != null && element4.getName() == this.name_w_tc) {
            element2.putProperty(PARSED_STYLES_PROP, this.styleProps.clone());
        }
    }

    private void putStyles(Element element, Map<String, String> map, String[] stringArray) {
        String string;
        if (map.size() > 0 && (string = Styles.toCSS(map, ' ')).length() > 0) {
            element.putAttribute(Constants.STYLE_ATTR, string);
        }
        if (stringArray[0] != null) {
            Util.addClass(element, stringArray[0]);
        }
        if (stringArray[1] != null) {
            Util.addClass(element, stringArray[1]);
        }
        if (stringArray[2] != null) {
            Util.addClass(element, stringArray[2]);
        }
    }

    private void translate_w_bookmarkStart(Element element, Element element2) {
        int n = element.getIntAttribute(this.name_w_id, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            return;
        }
        String string = element.getAttribute(this.name_w_name);
        if (string == null) {
            return;
        }
        string = XMLText.checkId(string);
        Element element3 = new Element(Constants.A_ELEM);
        element2.appendChild(element3);
        element3.putAttribute(Constants.CLASS_ATTR, "role-bookmark");
        element3.putAttribute(Constants.ID_ATTR, string);
        Range range = Range.create(n, string);
        this.idToRange.put(n, range);
        element2.appendChild(range.startPI);
    }

    private void translate_w_bookmarkEnd(Element element, Element element2) {
        int n = element.getIntAttribute(this.name_w_id, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            return;
        }
        Range range = this.idToRange.get(n);
        if (range == null) {
            return;
        }
        if (!this.followsBookmarkStart(element, n)) {
            element2.appendChild(range.endPI);
        }
    }

    private boolean followsBookmarkStart(Element element, int n) {
        block4: for (Node node = element.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            switch (node.getType()) {
                case TEXT: {
                    if (((Text)node).isXMLSpace()) continue block4;
                    return false;
                }
                case ELEMENT: {
                    Element element2 = (Element)node;
                    Name name = element2.getName();
                    if (name == this.name_w_bookmarkStart) {
                        if (element2.getIntAttribute(this.name_w_id, Integer.MIN_VALUE) != n) continue block4;
                        return true;
                    }
                    if (name == this.name_w_bookmarkEnd) continue block4;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private void translate_w_fldSimple(Element element, Element element2) {
        String string = Util.getNonEmptyAttribute(element, this.name_w_instr);
        if (string == null || (string = Util.normalizeFieldCode(string)).length() == 0) {
            return;
        }
        Element element3 = new Element(Constants.SPAN_ELEM);
        element2.appendChild(element3);
        element3.putAttribute(Constants.CLASS_ATTR, "role-field");
        string = Util.processFieldCodeIdref(string, null);
        element3.appendChild(new ProcessingInstruction("field", string));
        this.traverse(element, element3);
    }

    private void translate_w_hyperlink(Element element, Element element2) {
        String string;
        Object object;
        Object object2 = null;
        String string2 = element.getAttribute(this.name_r_id);
        if (string2 != null && (object = Util.getPartProperty(element).getRelated(string2)) != null && ((Related)object).external) {
            object2 = ((Related)object).target;
        }
        if ((object = element.getAttribute(this.name_w_anchor)) != null) {
            object2 = object2 != null ? object2 + "#" + (String)object : "#" + XMLText.checkId((String)object);
        }
        if (object2 == null) {
            return;
        }
        Element element3 = new Element(Constants.A_ELEM);
        element2.appendChild(element3);
        element3.putAttribute(Constants.HREF_ATTR, (String)object2);
        XHTMLVersion xHTMLVersion = this.xhtmlVersion();
        if (xHTMLVersion != XHTMLVersion.V1_0_Strict && xHTMLVersion != XHTMLVersion.V1_1 && (string = element.getAttribute(this.name_w_tgtFrame)) != null) {
            element3.putAttribute(Constants.TARGET_ATTR, string);
        }
        if ((string = Util.getNonEmptyTokenAttribute(element, this.name_w_tooltip)) != null) {
            element3.putAttribute(Constants.TITLE_ATTR, string);
        }
        this.traverse(element, element3);
    }

    private void translate_w_r(Element element, Element element2) {
        Element element3 = new Element(Constants.SPAN_ELEM);
        element2.appendChild(element3);
        this.traverse(element, element3);
    }

    private void translate_w_rPr(Element element, Element element2) {
        String string = this.styles.getLang(element);
        if (string != null) {
            element2.putAttribute(Name.LANG, string);
        }
        this.styles.parseStyleProps(element, this.styleProps, this.classes);
        this.putStyles(element2, this.styleProps, this.classes);
    }

    private void translate_w_t(Element element, Element element2) {
        String string = element.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        Util.appendText(string, element2);
    }

    private void translateBreak(Element element, Element element2) {
        String string = element.getAttribute(this.name_w_type);
        Node node = "page".equals(string) ? new ProcessingInstruction("break-page") : ("column".equals(string) ? new ProcessingInstruction("break-column") : new Element(Constants.BR_ELEM));
        element2.appendChild(node);
    }

    private void translateLegacyField(Element element, Element element2) {
        String string = "";
        String string2 = element.getName().localPart;
        if ("dayLong".equals(string2)) {
            string = "DATE \\@ \"DDDD\"";
        } else if ("dayShort".equals(string2)) {
            string = "DATE \\@ \"DD\"";
        } else if ("monthLong".equals(string2)) {
            string = "DATE \\@ \"MMMM\"";
        } else if ("monthShort".equals(string2)) {
            string = "DATE \\@ \"MM\"";
        } else if ("yearLong".equals(string2)) {
            string = "DATE \\@ \"YYYY\"";
        } else if ("yearShort".equals(string2)) {
            string = "DATE \\@ \"YY\"";
        } else if ("pgNum".equals(string2)) {
            string = "PAGE";
        }
        Element element3 = new Element(Constants.SPAN_ELEM);
        element2.appendChild(element3);
        element3.putAttribute(Constants.CLASS_ATTR, "role-field");
        element3.appendChild(new ProcessingInstruction("field", string));
    }

    private void translate_w_noBreakHyphen(Element element, Element element2) {
        Util.appendText("-", element2);
    }

    private void translateTab(Element element, Element element2) {
        Element element3 = new Element(Constants.SPAN_ELEM);
        element2.appendChild(element3);
        element3.putAttribute(Constants.CLASS_ATTR, "role-tab");
        element3.appendChild(new Text(" "));
    }

    private void translate_w_sym(Element element, Element element2) {
        int n;
        int n2 = -1;
        String string = element.getAttribute(this.name_w_char);
        if (string != null) {
            try {
                n2 = Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean bl = false;
        if (n2 >= 61440) {
            n2 -= 61440;
            bl = true;
        }
        if (n2 <= 0 || n2 > 65535) {
            return;
        }
        String string2 = element.getAttribute(this.name_w_font);
        if (string2 != null && bl && (n = LegacyFontMappings.map(string2, n2)) > 0) {
            n2 = n;
            string2 = null;
        }
        if (string2 != null) {
            boolean bl2;
            Element element3 = new Element(Constants.SPAN_ELEM);
            element2.appendChild(element3);
            StringBuilder stringBuilder = new StringBuilder("font-family: ");
            boolean bl3 = bl2 = string2.indexOf(32) >= 0;
            if (bl2) {
                stringBuilder.append('\'');
            }
            stringBuilder.append(string2);
            if (bl2) {
                stringBuilder.append('\'');
            }
            stringBuilder.append(';');
            element3.putAttribute(Constants.STYLE_ATTR, stringBuilder.toString());
            element2 = element3;
        }
        Util.appendText(Character.toString((char)n2), element2);
    }

    private void translate_w_drawing(Element element, Element element2) throws IOException {
        Element element3 = this.drawingToImg(element);
        if (element3 != null) {
            element2.appendChild(element3);
        }
    }

    private Element drawingToImg(Element element) throws IOException {
        Element element2;
        Related related;
        Element element3;
        Element element4 = Util.findDescendant(element, this.name_pic_pic, true);
        if (element4 == null) {
            return null;
        }
        Element element5 = Util.findDescendant(element4, this.name_a_blip, true);
        if (element5 == null) {
            return null;
        }
        double[] dArray = null;
        Element element6 = Util.findDescendant(element4, this.name_a_srcRect, true);
        if (element6 != null) {
            double d = Util.getPercentageAttribute(element6, Constants.T_ATTR, 0.0);
            double d2 = Util.getPercentageAttribute(element6, Constants.R_ATTR, 0.0);
            double d3 = Util.getPercentageAttribute(element6, Constants.B_ATTR, 0.0);
            double d4 = Util.getPercentageAttribute(element6, Constants.L_ATTR, 0.0);
            if (d != 0.0 || d2 != 0.0 || d3 != 0.0 || d4 != 0.0) {
                dArray = new double[]{d, d2, d3, d4};
            }
        }
        if ((element3 = Util.findDescendant(element5, this.name_asvg_svgBlip, true)) != null && dArray == null) {
            element5 = element3;
        }
        String string = null;
        Part part = null;
        String string2 = element5.getAttribute(this.name_r_embed);
        if (string2 == null) {
            string2 = element5.getAttribute(this.name_r_link);
        }
        if (string2 != null && (related = Util.getPartProperty(element).getRelated(string2)) != null) {
            if (related.external) {
                string = related.target;
            } else {
                part = this.docx.getPart(related.target);
            }
        }
        String string3 = null;
        String string4 = null;
        Element element7 = Util.findDescendant(element4, this.name_pic_cNvPr, true);
        if (element7 != null) {
            string3 = Util.getNonEmptyTokenAttribute(element7, Constants.NAME_ATTR);
            string4 = Util.getNonEmptyTokenAttribute(element7, Constants.DESCR_ATTR);
        }
        long l = -1L;
        long l2 = -1L;
        Element element8 = Util.findDescendant(element4, this.name_a_xfrm, true);
        if (element8 != null && (element2 = Util.findDescendant(element8, this.name_a_ext, false)) != null) {
            l = Util.getLengthAttribute(element2, Constants.CX_ATTR, -1L);
            l2 = Util.getLengthAttribute(element2, Constants.CY_ATTR, -1L);
        }
        return this.toImg(string, part, string3, string4, dArray, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element toImg(String string, Part part, String object, String string2, double[] dArray, long l, long l2) throws IOException {
        Object object2;
        if (string != null) {
            object = string;
            if (dArray != null) {
                Translator.notCroppedWarning(string, dArray, "linked image file");
            }
        } else if (part != null) {
            Object object3;
            Object object4;
            object2 = this.imgPartNameToSrc.get(part.name);
            if (object2 != null) {
                object = object2;
            } else {
                Object object5;
                if (!this.imgDir.isDirectory()) {
                    FileUtil.checkedMkdirs(this.imgDir);
                }
                object4 = URIComponent.getBaseName(part.name);
                object3 = URIComponent.getExtension((String)object4);
                if (object != null) {
                    object = ((String)object).replace('\\', '/');
                    if ((object = URIComponent.getBaseName((String)object)) != null && ((String)object).length() == 0) {
                        object = null;
                    }
                    if (object != null) {
                        object5 = URIComponent.getExtension((String)object);
                        if (object5 == null) {
                            object = null;
                        } else if (!Translator.sameImageExtension((String)object5, (String)object3)) {
                            object = URIComponent.setExtension((String)object, (String)object3);
                        }
                    }
                }
                if (object == null) {
                    object = object4;
                }
                if (this.resourcePrefix != null) {
                    object = this.resourcePrefix + (String)object;
                }
                if (this.lowerCaseResourceNames) {
                    object = ((String)object).toLowerCase();
                }
                if (((File)(object5 = new File(this.imgDir, (String)object))).exists()) {
                    object5 = Translator.alternateFile((File)object5);
                    object = ((File)object5).getName();
                }
                try (InputStream inputStream = part.getInputStream();){
                    FileUtil.copyFile(inputStream, (File)object5);
                }
                File file = ImageConverterFactories.convertImage((File)object5, this.convertedImageExtensions);
                if (file != null) {
                    this.checkedDelete((File)object5);
                    object = file.getName();
                }
                object = this.imgDirPath + URIComponent.quotePath((String)object);
                this.imgPartNameToSrc.put(part.name, (String)object);
            }
            if (dArray != null && (object3 = Translator.cropFile((File)(object4 = new File(this.imgDir, URIComponent.getBaseName((String)object))), dArray)) != null) {
                object = this.imgDirPath + URIComponent.quotePath(((File)object3).getName());
            }
        } else {
            return null;
        }
        object2 = new Element(Constants.IMG_ELEM);
        ((Element)object2).putAttribute(Constants.SRC_ATTR, (String)object);
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            string2 = "???";
        }
        ((Element)object2).putAttribute(Constants.ALT_ATTR, string2);
        if (l > 5120L || l2 > 3200L) {
            l2 = -1L;
            l = -1L;
        }
        if (l > 0L) {
            ((Element)object2).putAttribute(Constants.WIDTH_ATTR, Long.toString(l));
        }
        if (l2 > 0L) {
            ((Element)object2).putAttribute(Constants.HEIGHT_ATTR, Long.toString(l2));
        }
        return object2;
    }

    private void checkedDelete(File file) throws IOException {
        if (!file.delete() && this.console != null) {
            this.console.showMessage(Msg.msg("cannotDelete", file), Console.MessageType.WARNING);
        }
    }

    private static File alternateFile(File file) {
        File file2 = file.getParentFile();
        String string = file.getName();
        String string2 = FileUtil.setExtension(string, null);
        String string3 = FileUtil.getExtension(string);
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n = string2.length();
        for (int i = 2; i < 1000; ++i) {
            String string4;
            File file3;
            stringBuilder.setLength(n);
            stringBuilder.append('-');
            stringBuilder.append(Integer.toString(i));
            if (string3 != null) {
                stringBuilder.append('.');
                stringBuilder.append(string3);
            }
            if ((file3 = new File(file2, string4 = stringBuilder.toString())).exists()) continue;
            return file3;
        }
        return file;
    }

    private static boolean sameImageExtension(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        string = Translator.normalizeImageExtension(string);
        string2 = Translator.normalizeImageExtension(string2);
        return string.equalsIgnoreCase(string2);
    }

    private static String normalizeImageExtension(String string) {
        String[] stringArray = new String[]{"tif", "tiff", "jpg", "jpeg"};
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return stringArray[i + 1];
        }
        return string;
    }

    private static File cropFile(File file, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = file.getName();
        int n = FileUtil.indexOfDot(string, File.separatorChar);
        stringBuilder.append(n < 0 ? string : string.substring(0, n));
        for (double iOException : dArray) {
            int n2 = (int)Math.rint(iOException * 1000.0);
            if (n2 >= 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(Integer.toString(n2));
        }
        stringBuilder.append(n < 0 ? ".png" : string.substring(n));
        String string2 = stringBuilder.toString();
        File file2 = new File(file.getParentFile(), string2);
        if (file2.isFile()) {
            return file2;
        }
        String string3 = null;
        try {
            if (ImageConverterFactoryImpl.cropImage(file, dArray[0], dArray[1], dArray[2], dArray[3], file2)) {
                return file2;
            }
        }
        catch (IOException iOException) {
            string3 = ThrowableUtil.reason(iOException);
        }
        Translator.notCroppedWarning(file.getPath(), dArray, string3);
        return null;
    }

    private static void notCroppedWarning(String string, double[] dArray, String string2) {
        if (ImageConverterFactories.trace) {
            String string3 = "Translator>>> WARNING: image \"" + string + "\" not cropped (top=" + dArray[0] + "%, right=" + dArray[1] + "%, bottom=" + dArray[2] + "%, left=" + dArray[3] + "%)";
            if (string2 != null) {
                string3 = string3 + ": " + string2;
            }
            System.err.println(string3);
        }
    }

    private void translate_w_pict(Element element, Element element2) throws IOException {
        Element element3 = this.pictToImg(element);
        if (element3 != null) {
            element2.appendChild(element3);
            return;
        }
        Element element4 = Util.findAncestor(element2, Constants.P_ELEM);
        if (element4 != null) {
            this.insertPictText(element, element4);
        }
    }

    private void insertPictText(Element element, Element element2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getNamespace() != Constants.VML_NS) continue;
            Name name = element3.getName();
            if (name == this.name_v_rect && "t".equals(element3.getAttribute(this.name_o_hr))) {
                element2.getParent().insertChild(element2, new Element(Constants.HR_ELEM));
                continue;
            }
            if (name == this.name_v_textbox) {
                Element element4 = Util.findDescendant(element3, this.name_w_txbxContent, false);
                if (element4 == null) continue;
                Element element5 = new Element(Constants.DIV_ELEM);
                element5.putAttribute(Constants.CLASS_ATTR, "role-text-box");
                element2.getParent().insertChild(element2, element5);
                this.traverse(element4, element5);
                continue;
            }
            this.insertPictText(element3, element2);
        }
    }

    private Element pictToImg(Element element) throws IOException {
        Element element2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Util.findAllDescendants(element, this.name_v_shape, true, arrayList);
        Element element3 = null;
        Iterator<Element> iterator = arrayList.iterator();
        while (iterator.hasNext() && (element3 = this.pictShapeToImg(element2 = iterator.next())) == null) {
        }
        return element3;
    }

    private Element pictShapeToImg(Element element) throws IOException {
        Object object;
        Element element2 = Util.findDescendant(element, this.name_v_imagedata, true);
        if (element2 == null) {
            return null;
        }
        String string = null;
        Part part = null;
        String string2 = element2.getAttribute(this.name_r_id);
        if (string2 == null) {
            string2 = element2.getAttribute(this.name_r_href);
        }
        if (string2 != null && (object = Util.getPartProperty(element).getRelated(string2)) != null) {
            if (((Related)object).external) {
                string = ((Related)object).target;
            } else {
                part = this.docx.getPart(((Related)object).target);
            }
        }
        object = element2.getAttribute(this.name_o_href);
        String string3 = element.getAttribute(Constants.ALT_ATTR);
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            string3 = element2.getAttribute(this.name_o_title);
        }
        long l = -1L;
        long l2 = -1L;
        String string4 = element.getAttribute(Constants.STYLE_ATTR);
        if (string4 != null) {
            String string5 = Util.getStyleProperty(string4, "width");
            if (string5 != null) {
                l = Util.lengthToPx(string5);
            }
            if ((string5 = Util.getStyleProperty(string4, "height")) != null) {
                l2 = Util.lengthToPx(string5);
            }
        }
        return this.toImg(string, part, (String)object, string3, null, l, l2);
    }

    private void translate_w_object(Element element, Element element2) throws IOException {
        Element element3 = this.pictToImg(element);
        if (element3 != null) {
            element2.appendChild(element3);
            return;
        }
        Element element4 = Util.findDescendant(element, this.name_w_drawing, false);
        if (element4 != null && (element3 = this.drawingToImg(element4)) != null) {
            element2.appendChild(element3);
        }
    }

    @Override
    public Element translateToImg(Element element) throws IOException {
        Name name = element.getName();
        if (name == this.name_w_drawing) {
            return this.drawingToImg(element);
        }
        if (name == this.name_w_pict) {
            return this.pictToImg(element);
        }
        return null;
    }

    private void translate_m_oMath(Element element, Element element2) throws IOException {
        Element element3 = MathConverterFactories.convertMath(element);
        if (element3 != null) {
            if (this.createMathMLObject == Boolean.TRUE || this.createMathMLObject == null && this.xhtmlVersion != XHTMLVersion.V5_0) {
                File file;
                Object object = String.format("math-%03d.mml", this.mathCounter++);
                if (this.resourcePrefix != null) {
                    object = this.resourcePrefix + (String)object;
                }
                if (!this.imgDir.isDirectory()) {
                    FileUtil.checkedMkdirs(this.imgDir);
                }
                if ((file = new File(this.imgDir, (String)object)).exists()) {
                    file = Translator.alternateFile(file);
                    object = file.getName();
                }
                SaveXHTML.saveMathML(element3, true, "UTF-8", file);
                object = this.imgDirPath + URIComponent.quotePath((String)object);
                Element element4 = new Element(Constants.OBJECT_ELEM);
                element2.appendChild(element4);
                element4.putAttribute(Constants.DATA_ATTR, (String)object);
                element4.putAttribute(Constants.TYPE_ATTR, "application/mathml+xml");
            } else {
                element2.appendChild(element3);
            }
        } else {
            Element element5 = new Element(Constants.SPAN_ELEM);
            element2.appendChild(element5);
            element5.putAttribute(Constants.CLASS_ATTR, "role-math");
            element5.appendChild(new Text(element.getAllText(true, new Name[0])));
        }
    }

    private void translateComplexField(Element element, Element element2) {
        Object object = null;
        String string = null;
        if ("fldChar".equals(element.getLocalName())) {
            String string2 = element.getAttribute(this.name_w_fldCharType);
            if (string2 != null) {
                object = "field-" + string2;
            }
            string = "";
        } else {
            object = "field-code";
            string = element.getText();
            if (string != null) {
                if (!"preserve".equals(element.getAttribute(Name.XML_SPACE))) {
                    string = string.trim();
                }
                if (string.length() == 0) {
                    string = null;
                }
            }
        }
        if (object != null && string != null) {
            element2.appendChild(new ProcessingInstruction((String)object, string));
        }
    }

    private void translateNoteReference(Element element, Element element2) {
        String string;
        String string2;
        int n = element.getIntAttribute(this.name_w_id, 0, Integer.MAX_VALUE, -1);
        if (n < 0) {
            return;
        }
        boolean bl = "endnoteReference".equals(element.getLocalName());
        if (bl) {
            if (this.firstEndnoteId >= 0) {
                n = n - this.firstEndnoteId + 1;
            }
        } else if (this.firstFootnoteId >= 0) {
            n = n - this.firstFootnoteId + 1;
        }
        String string3 = Integer.toString(n);
        Element element3 = new Element(Constants.A_ELEM);
        element2.appendChild(element3);
        if (bl) {
            string2 = "role-endnote-ref";
            string = "#__EN" + string3 + "__";
        } else {
            string2 = "role-footnote-ref";
            string = "#__FN" + string3 + "__";
        }
        element3.putAttribute(Constants.CLASS_ATTR, string2);
        element3.putAttribute(Constants.HREF_ATTR, string);
        element3.appendChild(new Text(string3));
    }

    private void translateNotes(Element element, Element element2) {
        Element element3 = new Element(Constants.DIV_ELEM);
        element2.appendChild(element3);
        String string = "endnotes".equals(element.getLocalName()) ? "role-endnotes" : "role-footnotes";
        element3.putAttribute(Constants.CLASS_ATTR, string);
        this.traverse(element, element3);
        if (element3.getChildElementCount() == 0) {
            element2.removeChild(element3);
        }
    }

    private void translateNote(Element element, Element element2) {
        String string;
        String string2 = element.getAttribute(this.name_w_type);
        if (string2 != null && !"normal".equals(string2)) {
            return;
        }
        int n = element.getIntAttribute(this.name_w_id, 0, Integer.MAX_VALUE, -1);
        if (n < 0) {
            return;
        }
        boolean bl = "endnote".equals(element.getLocalName());
        if (bl) {
            if (this.firstEndnoteId >= 0) {
                n = n - this.firstEndnoteId + 1;
            }
        } else if (this.firstFootnoteId >= 0) {
            n = n - this.firstFootnoteId + 1;
        }
        Object object = Integer.toString(n);
        Element element3 = new Element(Constants.DIV_ELEM);
        element2.appendChild(element3);
        if (bl) {
            string = "role-endnote";
            object = "__EN" + (String)object + "__";
        } else {
            string = "role-footnote";
            object = "__FN" + (String)object + "__";
        }
        element3.putAttribute(Constants.CLASS_ATTR, string);
        element3.putAttribute(Constants.ID_ATTR, (String)object);
        this.traverse(element, element3);
    }

    private void translate_w_tbl(Element element, Element element2) {
        Element element3 = new Element(Constants.TABLE_ELEM);
        element2.appendChild(element3);
        String string = this.styles.getImplicitTableStyleId();
        if (string != null) {
            this.addImplicitStyle(element, this.name_w_tblPr, this.name_w_tblStyle, string);
        }
        this.traverse(element, element3);
        RowColumn rowColumn = new RowColumn();
        this.indexCells(element3, this.columnNumberPI, rowColumn);
        String string2 = element3.getAttribute(Constants.CLASS_ATTR);
        Map<String, String> map = Translator.getParsedStyles(element3);
        this.addInsideBorders(element3, string2, map, rowColumn);
        if (string2 != null) {
            this.decorateTable2(element3, string2, map, rowColumn);
        }
        this.addTableBody(element3);
        this.addCols(element3, rowColumn.column + 1);
        element3.removeProperties(TABLE_PROPS, true);
    }

    private static Map<String, String> getParsedStyles(Element element) {
        HashMap<String, String> hashMap = (HashMap<String, String>)element.getProperty(PARSED_STYLES_PROP);
        if (hashMap == null) {
            hashMap = EMPTY_PARSED_STYLES;
        }
        return hashMap;
    }

    private void translate_w_tblPr(Element element, Element element2) {
        String string;
        Element element3 = Util.findDescendant(element, this.name_w_tblCaption, false);
        if (element3 != null && (string = Util.getNonEmptyTokenAttribute(element3, this.name_w_val)) != null) {
            element2.putAttribute(Constants.TITLE_ATTR, string);
        }
        if ((element3 = Util.findDescendant(element, this.name_w_tblDescription, false)) != null && (string = Util.getNonEmptyTokenAttribute(element3, this.name_w_val)) != null) {
            element2.putAttribute(Constants.SUMMARY_ATTR, string);
        }
        this.styles.parseStyleProps(element, this.styleProps, this.classes);
        this.putStyles(element2, this.styleProps, this.classes);
        element2.putProperty(PARSED_STYLES_PROP, this.styleProps.clone());
    }

    private void translate_w_gridCol(Element element, Element element2) {
        Element element3 = new Element(Constants.COLGROUP_ELEM);
        element3.putAttribute(Constants.SPAN_ATTR, "1");
        element2.appendChild(element3);
        String string = element.getAttribute(this.name_w_w);
        if (string != null) {
            string = Util.parsePt(string, 20);
        }
        if (string != null) {
            Util.addStyleProp(element3, "width", string);
        }
    }

    private void translate_w_tr(Element element, Element element2) {
        Element element3 = new Element(Constants.TR_ELEM);
        element2.appendChild(element3);
        Element element4 = Util.findDescendant(element, this.name_w_trPr, false);
        if (element4 != null) {
            this.addEmptyCells(element4, this.name_w_gridBefore, this.name_w_wBefore, element3);
        }
        this.traverse(element, element3);
        if (element4 != null) {
            this.addEmptyCells(element4, this.name_w_gridAfter, this.name_w_wAfter, element3);
        }
    }

    private void addEmptyCells(Element element, Name name, Name name2, Element element2) {
        Object object;
        int n = 0;
        Element element3 = Util.findDescendant(element, name, false);
        if (element3 != null) {
            n = element3.getIntAttribute(this.name_w_val, 1, Integer.MAX_VALUE, -1);
        }
        if (n <= 0) {
            return;
        }
        String string = null;
        Element element4 = Util.findDescendant(element, name2, false);
        if (element4 != null) {
            String string2;
            object = element4.getAttribute(this.name_w_type);
            if (object == null) {
                object = "dxa";
            }
            if (!"nil".equals(object) && !"auto".equals(object) && (string2 = element4.getAttribute(this.name_w_w)) != null) {
                if ("pct".equals(object)) {
                    if (string2.endsWith("%")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    try {
                        double d = Double.parseDouble(string2);
                        d /= (double)n;
                        if (d > 0.0) {
                            string = Util.formatDouble(d) + "%";
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    double d = Util.doParsePt(string2, 20, false);
                    if (!Double.isNaN(d) && (d /= (double)n) > 0.0) {
                        string = Util.formatDouble(d) + "pt";
                    }
                }
            }
        }
        while (n > 0) {
            object = new Element(Constants.TD_ELEM);
            element2.appendChild((Node)object);
            ((Node)object).putProperty(PHANTOM_CELL_PROP, Boolean.TRUE);
            if (string != null) {
                ((Element)object).putAttribute(Constants.STYLE_ATTR, "width: " + string + ";");
            }
            --n;
        }
    }

    private static boolean isPhantomCell(Element element) {
        return element.hasProperty(PHANTOM_CELL_PROP);
    }

    private void translate_w_trPr(Element element, Element element2) {
        this.styles.parseStyleProps(element, this.styleProps, this.classes);
        this.putStyles(element2, this.styleProps, this.classes);
        element2.putProperty(PARSED_STYLES_PROP, this.styleProps.clone());
    }

    private static boolean isHeaderRow(Element element) {
        Map<String, String> map = Translator.getParsedStyles(element);
        return "true".equals(map.get("-ms-tblHeader"));
    }

    private void translate_w_tc(Element element, Element element2) {
        Object object;
        int n;
        Boolean bl = this.isVMerged(element);
        if (bl == Boolean.TRUE) {
            return;
        }
        Boolean bl2 = this.isHMerged(element);
        if (bl2 == Boolean.TRUE) {
            return;
        }
        Element element3 = new Element(Constants.TD_ELEM);
        element2.appendChild(element3);
        if (bl2 == Boolean.FALSE) {
            Element[] elementArray = new Element[1];
            n = this.countHMergedCells(element, elementArray);
            if (n > 1 && elementArray[0] != null) {
                element3.putProperty(LAST_HMERGED_CELL_PROP, elementArray[0]);
            }
        } else {
            n = this.getGridSpan(element);
        }
        if (n > 1) {
            element3.putAttribute(Constants.COLSPAN_ATTR, Integer.toString(n));
        }
        int n2 = 1;
        if (bl == Boolean.FALSE && (n2 = this.countVMergedCells(element, (Element[])(object = new Element[1]))) > 1 && object[0] != null) {
            element3.putProperty(LAST_VMERGED_CELL_PROP, object[0]);
        }
        if (n2 > 1) {
            element3.putAttribute(Constants.ROWSPAN_ATTR, Integer.toString(n2));
        }
        if ((object = element.getAttribute(this.name_w_id)) != null) {
            element3.putAttribute(Constants.ID_ATTR, XMLText.checkId((String)object));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Element element4 = Util.findDescendant(element, this.name_w_tcPr, this.name_w_headers);
        if (element4 != null) {
            for (Node node = element4.getFirstChild(); node != null; node = node.getNextSibling()) {
                String string;
                Element element5;
                if (node.getType() != Node.Type.ELEMENT || (element5 = (Element)node).getName() != this.name_w_header || (string = element5.getAttribute(this.name_w_val)) == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(XMLText.checkId(string));
            }
        }
        if (stringBuilder.length() > 0) {
            element3.putAttribute(Constants.HEADERS_ATTR, stringBuilder.toString());
        }
        this.traverse(element, element3);
    }

    private void translate_w_tcPr(Element element, Element element2) {
        String[] stringArray;
        this.styles.parseStyleProps(element, this.styleProps, this.classes);
        Element element3 = (Element)element2.removeProperty(LAST_VMERGED_CELL_PROP);
        if (element3 != null) {
            stringArray = new String[]{"border-bottom-style", "border-bottom-width", "border-bottom-color", "padding-bottom"};
            this.copyPropsFromMergedCell(element3, stringArray);
        }
        if ((element3 = (Element)element2.removeProperty(LAST_HMERGED_CELL_PROP)) != null) {
            stringArray = new String[]{"border-right-style", "border-right-width", "border-right-color", "padding-right"};
            this.copyPropsFromMergedCell(element3, stringArray);
        }
        this.putStyles(element2, this.styleProps, this.classes);
        element2.putProperty(PARSED_STYLES_PROP, this.styleProps.clone());
    }

    private void copyPropsFromMergedCell(Element element, String[] stringArray) {
        Element element2 = Util.findDescendant(element, this.name_w_tcPr);
        if (element2 != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = new String[3];
            this.styles.parseStyleProps(element2, hashMap, stringArray2);
            for (String string : stringArray) {
                String string2 = hashMap.get(string);
                if (string2 == null) continue;
                this.styleProps.put(string, string2);
            }
        }
    }

    private Boolean isVMerged(Element element) {
        Boolean bl = null;
        Element element2 = Util.findDescendant(element, this.name_w_tcPr, this.name_w_vMerge);
        if (element2 != null) {
            bl = "restart".equals(element2.getAttribute(this.name_w_val)) ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl;
    }

    private Boolean isHMerged(Element element) {
        Boolean bl = null;
        Element element2 = Util.findDescendant(element, this.name_w_tcPr, this.name_w_hMerge);
        if (element2 != null) {
            bl = "restart".equals(element2.getAttribute(this.name_w_val)) ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl;
    }

    private int getGridSpan(Element element) {
        int n = 1;
        Element element2 = Util.findDescendant(element, this.name_w_tcPr, this.name_w_gridSpan);
        if (element2 != null) {
            n = element2.getIntAttribute(this.name_w_val, 1, Integer.MAX_VALUE, 1);
        }
        return n;
    }

    private int countHMergedCells(Element element, Element[] elementArray) {
        elementArray[0] = null;
        Element element2 = element.getParentElement();
        if (element2 == null || element2.getName() != this.name_w_tr) {
            return 1;
        }
        int n = 1;
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != this.name_w_tc) continue;
            if (this.isHMerged(element3) != Boolean.TRUE) break;
            ++n;
            elementArray[0] = element3;
        }
        return n;
    }

    private int countVMergedCells(Element element, Element[] elementArray) {
        elementArray[0] = null;
        Element element2 = element.getParentElement();
        if (element2 == null || element2.getName() != this.name_w_tr) {
            return 1;
        }
        int n = 1;
        int n2 = this.cellColumn(element2, element);
        for (Node node = element2.getNextSibling(); node != null; node = node.getNextSibling()) {
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != this.name_w_tr) continue;
            Element element4 = this.cellAtColumn(element3, n2);
            if (element4 == null || this.isVMerged(element4) != Boolean.TRUE) break;
            ++n;
            elementArray[0] = element4;
        }
        return n;
    }

    private int cellColumn(Element element, Element element2) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != this.name_w_tc) continue;
            if (element3 == element2) break;
            n += this.getGridSpan(element3);
        }
        return n;
    }

    private Element cellAtColumn(Element element, int n) {
        Element element2 = null;
        int n2 = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != this.name_w_tc) continue;
            if (n2 == n) {
                element2 = element3;
                break;
            }
            n2 += this.getGridSpan(element3);
        }
        return element2;
    }

    private void indexCells(Element element, boolean bl, RowColumn rowColumn) {
        SpanHelper spanHelper = new SpanHelper();
        int n = 0;
        int n2 = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != Constants.TR_ELEM) continue;
            Element element2 = (Element)node;
            spanHelper.addRow();
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getType() != Node.Type.ELEMENT || ((Element)node2).getName() != Constants.TD_ELEM) continue;
                Element element3 = (Element)node2;
                int n3 = spanHelper.getNextColumn();
                int n4 = element3.getIntAttribute(Constants.ROWSPAN_ATTR, 1, Integer.MAX_VALUE, 1);
                int n5 = element3.getIntAttribute(Constants.COLSPAN_ATTR, 1, Integer.MAX_VALUE, 1);
                RowColumn rowColumn2 = new RowColumn(n, n3, n4, n5);
                element3.putProperty(ROW_COLUMN_PROP, rowColumn2);
                if (bl) {
                    ProcessingInstruction processingInstruction = new ProcessingInstruction("column-number", Integer.toString(1 + n3));
                    element3.insertChild(element3.getFirstChild(), processingInstruction);
                }
                spanHelper.addCell(n4, n5);
                n3 = spanHelper.getNextColumn();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            ++n;
        }
        rowColumn.row = n - 1;
        rowColumn.column = n2 - 1;
    }

    private void addInsideBorders(Element element, String string, Map<String, String> map, RowColumn rowColumn) {
        boolean bl = this.getPtStyleProperty(map, string, "border-spacing", 0.0) > 0.0;
        String string2 = map.get("-ms-border-insideH");
        String string3 = map.get("-ms-border-insideH-sz");
        String string4 = map.get("-ms-border-insideH-color");
        if ("auto".equals(string4)) {
            string4 = "#000000";
        }
        String string5 = map.get("-ms-border-insideV");
        String string6 = map.get("-ms-border-insideV-sz");
        String string7 = map.get("-ms-border-insideV-color");
        if ("auto".equals(string7)) {
            string7 = "#000000";
        }
        String string8 = map.get("-ms-tblCellMar-top");
        String string9 = map.get("-ms-tblCellMar-bottom");
        String string10 = map.get("-ms-tblCellMar-left");
        String string11 = map.get("-ms-tblCellMar-right");
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != Constants.TR_ELEM) continue;
            Element element2 = (Element)node;
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string12;
                String string13;
                String string14;
                String string15;
                String string16;
                Element element3;
                if (node2.getType() != Node.Type.ELEMENT || ((Element)node2).getName() != Constants.TD_ELEM || Translator.isPhantomCell(element3 = (Element)node2)) continue;
                RowColumn rowColumn2 = Translator.getRowColumn(element3);
                boolean bl2 = rowColumn2.row + rowColumn2.rowSpan - 1 < rowColumn.row;
                boolean bl3 = rowColumn2.column + rowColumn2.columnSpan - 1 < rowColumn.column;
                Map<String, String> map2 = Translator.getParsedStyles(element3);
                String string17 = map2.get("-ms-border-insideH");
                if (string17 != null) {
                    string16 = map2.get("-ms-border-insideH-sz");
                    string15 = map2.get("-ms-border-insideH-color");
                    if ("auto".equals(string15)) {
                        string15 = "#000000";
                    }
                } else {
                    string17 = string2;
                    string16 = string3;
                    string15 = string4;
                }
                if ((string14 = map2.get("-ms-border-insideV")) != null) {
                    string13 = map2.get("-ms-border-insideV-sz");
                    string12 = map2.get("-ms-border-insideV-color");
                    if ("auto".equals(string12)) {
                        string12 = "#000000";
                    }
                } else {
                    string14 = string5;
                    string13 = string6;
                    string12 = string7;
                }
                if (bl && string17 != null && !map2.containsKey("border-top-style")) {
                    Util.addStyleProp(element3, "border-top-style", string17);
                    if (string16 != null) {
                        Util.addStyleProp(element3, "border-top-width", Util.checkBorderWidth(string16));
                    }
                    if (string15 != null) {
                        Util.addStyleProp(element3, "border-top-color", string15);
                    }
                }
                if ((bl || bl2) && string17 != null && !map2.containsKey("border-bottom-style")) {
                    Util.addStyleProp(element3, "border-bottom-style", string17);
                    if (string16 != null) {
                        Util.addStyleProp(element3, "border-bottom-width", Util.checkBorderWidth(string16));
                    }
                    if (string15 != null) {
                        Util.addStyleProp(element3, "border-bottom-color", string15);
                    }
                }
                if (bl && string14 != null && !map2.containsKey("border-left-style")) {
                    Util.addStyleProp(element3, "border-left-style", string14);
                    if (string13 != null) {
                        Util.addStyleProp(element3, "border-left-width", Util.checkBorderWidth(string13));
                    }
                    if (string12 != null) {
                        Util.addStyleProp(element3, "border-left-color", string12);
                    }
                }
                if ((bl || bl3) && string14 != null && !map2.containsKey("border-right-style")) {
                    Util.addStyleProp(element3, "border-right-style", string14);
                    if (string13 != null) {
                        Util.addStyleProp(element3, "border-right-width", Util.checkBorderWidth(string13));
                    }
                    if (string12 != null) {
                        Util.addStyleProp(element3, "border-right-color", string12);
                    }
                }
                if (string8 != null && !map2.containsKey("padding-top")) {
                    Util.addStyleProp(element3, "padding-top", string8);
                }
                if (string9 != null && !map2.containsKey("padding-bottom")) {
                    Util.addStyleProp(element3, "padding-bottom", string9);
                }
                if (string10 != null && !map2.containsKey("padding-left")) {
                    Util.addStyleProp(element3, "padding-left", string10);
                }
                if (string11 == null || map2.containsKey("padding-right")) continue;
                Util.addStyleProp(element3, "padding-right", string11);
            }
        }
    }

    private static RowColumn getRowColumn(Element element) {
        return (RowColumn)element.getProperty(ROW_COLUMN_PROP);
    }

    private void decorateTable(Element element, String string, Map<String, String> map, RowColumn rowColumn) {
        boolean bl = this.getPtStyleProperty(map, string, "border-spacing", 0.0) > 0.0;
        Map<String, String> map2 = this.styles.getTableStyleNames(string);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Map<String, String> map3;
            boolean bl5;
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != Constants.TR_ELEM) continue;
            Element element2 = (Element)node;
            String string2 = map2.get("tr");
            if (string2 != null) {
                Util.addClass(element2, string2);
            }
            if ((string2 = map2.get("tr-wholeTable")) != null) {
                Util.addClass(element2, string2);
            }
            if ((bl5 = "true".equals((map3 = Translator.getParsedStyles(element2)).get("-ms-cnfStyle-band1Horz"))) && (string2 = map2.get("tr-band1Horz")) != null) {
                Util.addClass(element2, string2);
            }
            if ((bl4 = "true".equals(map3.get("-ms-cnfStyle-band2Horz"))) && (string2 = map2.get("tr-band2Horz")) != null) {
                Util.addClass(element2, string2);
            }
            if ((bl3 = "true".equals(map3.get("-ms-cnfStyle-firstRow"))) && (string2 = map2.get("tr-firstRow")) != null) {
                Util.addClass(element2, string2);
            }
            if ((bl2 = "true".equals(map3.get("-ms-cnfStyle-lastRow"))) && (string2 = map2.get("tr-lastRow")) != null) {
                Util.addClass(element2, string2);
            }
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                boolean bl6;
                boolean bl7;
                boolean bl8;
                boolean bl9;
                boolean bl10;
                boolean bl11;
                boolean bl12;
                boolean bl13;
                boolean bl14;
                boolean bl15;
                boolean bl16;
                boolean bl17;
                Element element3;
                if (node2.getType() != Node.Type.ELEMENT || ((Element)node2).getName() != Constants.TD_ELEM || Translator.isPhantomCell(element3 = (Element)node2)) continue;
                RowColumn rowColumn2 = Translator.getRowColumn(element3);
                boolean bl18 = rowColumn2.row + rowColumn2.rowSpan - 1 < rowColumn.row;
                boolean bl19 = rowColumn2.column + rowColumn2.columnSpan - 1 < rowColumn.column;
                string2 = map2.get("tc");
                if (string2 != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((string2 = map2.get("tc-wholeTable")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl17 = "true".equals((map3 = Translator.getParsedStyles(element3)).get("-ms-cnfStyle-band1Vert"))) && (string2 = map2.get("tc-band1Vert")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl16 = "true".equals(map3.get("-ms-cnfStyle-band2Vert"))) && (string2 = map2.get("tc-band2Vert")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                boolean bl20 = bl15 = bl5 || "true".equals(map3.get("-ms-cnfStyle-band1Horz"));
                if (bl15 && (string2 = map2.get("tc-band1Horz")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                boolean bl21 = bl14 = bl4 || "true".equals(map3.get("-ms-cnfStyle-band2Horz"));
                if (bl14 && (string2 = map2.get("tc-band2Horz")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl13 = "true".equals(map3.get("-ms-cnfStyle-firstCol"))) && (string2 = map2.get("tc-firstCol")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl12 = "true".equals(map3.get("-ms-cnfStyle-lastCol"))) && (string2 = map2.get("tc-lastCol")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                boolean bl22 = bl11 = bl3 || "true".equals(map3.get("-ms-cnfStyle-firstRow"));
                if (bl11 && (string2 = map2.get("tc-firstRow")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                boolean bl23 = bl10 = bl2 || "true".equals(map3.get("-ms-cnfStyle-lastRow"));
                if (bl10 && (string2 = map2.get("tc-lastRow")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl9 = "true".equals(map3.get("-ms-cnfStyle-neCell"))) && (string2 = map2.get("tc-neCell")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl8 = "true".equals(map3.get("-ms-cnfStyle-nwCell"))) && (string2 = map2.get("tc-nwCell")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl7 = "true".equals(map3.get("-ms-cnfStyle-seCell"))) && (string2 = map2.get("tc-seCell")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                if ((bl6 = "true".equals(map3.get("-ms-cnfStyle-swCell"))) && (string2 = map2.get("tc-swCell")) != null) {
                    this.addCellClass(element3, string2, bl18, bl19, bl);
                }
                for (Node node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getType() != Node.Type.ELEMENT || ((Element)node3).getName() != Constants.P_ELEM) continue;
                    Element element4 = (Element)node3;
                    string2 = map2.get("tp");
                    if (string2 != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((string2 = map2.get("tp-wholeTable")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    map3 = Translator.getParsedStyles(element4);
                    if ((bl17 || "true".equals(map3.get("-ms-cnfStyle-band1Vert"))) && (string2 = map2.get("tp-band1Vert")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl16 || "true".equals(map3.get("-ms-cnfStyle-band2Vert"))) && (string2 = map2.get("tp-band2Vert")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl15 || "true".equals(map3.get("-ms-cnfStyle-band1Horz"))) && (string2 = map2.get("tp-band1Horz")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl14 || "true".equals(map3.get("-ms-cnfStyle-band2Horz"))) && (string2 = map2.get("tp-band2Horz")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl13 || "true".equals(map3.get("-ms-cnfStyle-firstCol"))) && (string2 = map2.get("tp-firstCol")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl12 || "true".equals(map3.get("-ms-cnfStyle-lastCol"))) && (string2 = map2.get("tp-lastCol")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl11 || "true".equals(map3.get("-ms-cnfStyle-firstRow"))) && (string2 = map2.get("tp-firstRow")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl10 || "true".equals(map3.get("-ms-cnfStyle-lastRow"))) && (string2 = map2.get("tp-lastRow")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl9 || "true".equals(map3.get("-ms-cnfStyle-neCell"))) && (string2 = map2.get("tp-neCell")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl8 || "true".equals(map3.get("-ms-cnfStyle-nwCell"))) && (string2 = map2.get("tp-nwCell")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((bl7 || "true".equals(map3.get("-ms-cnfStyle-seCell"))) && (string2 = map2.get("tp-seCell")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (!bl6 && !"true".equals(map3.get("-ms-cnfStyle-swCell")) || (string2 = map2.get("tp-swCell")) == null) continue;
                    this.addParaClass(element4, string2);
                }
            }
        }
    }

    private void addCellClass(Element element, String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = string + "--bt";
        if (bl3 && this.styles.getStyle(string2) != null) {
            Util.addClass(element, string2);
        }
        string2 = string + "--bb";
        if ((bl3 || bl) && this.styles.getStyle(string2) != null) {
            Util.addClass(element, string2);
        }
        string2 = string + "--bl";
        if (bl3 && this.styles.getStyle(string2) != null) {
            Util.addClass(element, string2);
        }
        string2 = string + "--br";
        if ((bl3 || bl2) && this.styles.getStyle(string2) != null) {
            Util.addClass(element, string2);
        }
        Util.addClass(element, string);
    }

    private void addParaClass(Element element, String string) {
        String string2 = element.getAttribute(Constants.CLASS_ATTR);
        if (string2 == null) {
            string2 = string;
        } else {
            int n;
            String[] stringArray = XMLText.splitList(string2);
            int n2 = n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i];
                if (!string3.startsWith("p-") && !string3.startsWith("n-")) continue;
                n2 = i;
                break;
            }
            stringArray = ArrayUtil.insert(stringArray, n2, string);
            string2 = StringUtil.join(' ', stringArray);
        }
        element.putAttribute(Constants.CLASS_ATTR, string2);
    }

    private double getPtStyleProperty(Map<String, String> map, String string, String string2, double d) {
        double d2 = d;
        String string3 = this.getStyleProperty(map, string, string2);
        if (string3 != null) {
            try {
                if (string3.endsWith("pt")) {
                    d2 = Double.parseDouble(string3.substring(0, string3.length() - 2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    private int getIntStyleProperty(Map<String, String> map, String string, String string2, int n) {
        int n2 = n;
        String string3 = this.getStyleProperty(map, string, string2);
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private boolean getBooleanStyleProperty(Map<String, String> map, String string, String string2, boolean bl) {
        String string3 = this.getStyleProperty(map, string, string2);
        if (string3 == null) {
            return bl;
        }
        return "true".equals(string3);
    }

    private String getStyleProperty(Map<String, String> map, String string, String string2) {
        String string3 = null;
        if (map != null) {
            string3 = map.get(string2);
        }
        if (string3 == null && string != null) {
            string3 = this.styles.getStyleProperty(string, string2);
        }
        return string3;
    }

    private void decorateTable2(Element element, String string, Map<String, String> map, RowColumn rowColumn) {
        boolean bl = this.getPtStyleProperty(map, string, "border-spacing", 0.0) > 0.0;
        boolean bl2 = this.getBooleanStyleProperty(map, string, "-ms-tblLook-firstRow", false);
        boolean bl3 = this.getBooleanStyleProperty(map, string, "-ms-tblLook-firstColumn", false);
        boolean bl4 = this.getBooleanStyleProperty(map, string, "-ms-tblLook-lastColumn", false);
        boolean bl5 = this.getBooleanStyleProperty(map, string, "-ms-tblLook-lastRow", false);
        boolean bl6 = this.getBooleanStyleProperty(map, string, "-ms-tblLook-noHBand", false);
        boolean bl7 = this.getBooleanStyleProperty(map, string, "-ms-tblLook-noVBand", false);
        int n = this.getIntStyleProperty(map, string, "-ms-tblStyleRowBandSize", 1);
        int n2 = this.getIntStyleProperty(map, string, "-ms-tblStyleColBandSize", 1);
        Map<String, String> map2 = this.styles.getTableStyleNames(string);
        boolean bl8 = true;
        int n3 = 0;
        int n4 = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != Constants.TR_ELEM) continue;
            Element element2 = (Element)node;
            String string2 = map2.get("tr");
            if (string2 != null) {
                Util.addClass(element2, string2);
            }
            if ((string2 = map2.get("tr-wholeTable")) != null) {
                Util.addClass(element2, string2);
            }
            bl8 = bl8 && this.headerRow(element2);
            boolean bl9 = n3 == 0 || bl8;
            boolean bl10 = n3 == rowColumn.row;
            boolean bl11 = bl9 && bl2;
            boolean bl12 = bl10 && bl5;
            boolean bl13 = !bl6 && !bl11 && !bl12;
            boolean bl14 = false;
            if (bl13) {
                bl14 = n4 % (2 * n) < n;
                ++n4;
                string2 = map2.get(bl14 ? "tr-band1Horz" : "tr-band2Horz");
                if (string2 != null) {
                    Util.addClass(element2, string2);
                }
            }
            if (bl11 && (string2 = map2.get("tr-firstRow")) != null) {
                Util.addClass(element2, string2);
            }
            if (bl12 && (string2 = map2.get("tr-lastRow")) != null) {
                Util.addClass(element2, string2);
            }
            int n5 = 0;
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                boolean bl15;
                boolean bl16;
                boolean bl17;
                boolean bl18;
                Element element3;
                if (node2.getType() != Node.Type.ELEMENT || ((Element)node2).getName() != Constants.TD_ELEM || Translator.isPhantomCell(element3 = (Element)node2)) continue;
                RowColumn rowColumn2 = Translator.getRowColumn(element3);
                boolean bl19 = rowColumn2.row + rowColumn2.rowSpan - 1 < rowColumn.row;
                boolean bl20 = rowColumn2.column + rowColumn2.columnSpan - 1 < rowColumn.column;
                string2 = map2.get("tc");
                if (string2 != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                if ((string2 = map2.get("tc-wholeTable")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                boolean bl21 = rowColumn2.column == 0;
                boolean bl22 = rowColumn2.column == rowColumn.column;
                boolean bl23 = bl21 && bl3;
                boolean bl24 = bl22 && bl4;
                boolean bl25 = !bl7 && !bl23 && !bl24;
                boolean bl26 = false;
                if (bl25) {
                    bl26 = n5 % (2 * n2) < n2;
                    ++n5;
                    string2 = map2.get(bl26 ? "tc-band1Vert" : "tc-band2Vert");
                    if (string2 != null) {
                        this.addCellClass(element3, string2, bl19, bl20, bl);
                    }
                }
                if (bl13 && (string2 = map2.get(bl14 ? "tc-band1Horz" : "tc-band2Horz")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                if (bl23 && (string2 = map2.get("tc-firstCol")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                if (bl24 && (string2 = map2.get("tc-lastCol")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                if (bl11 && (string2 = map2.get("tc-firstRow")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                if (bl12 && (string2 = map2.get("tc-lastRow")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                boolean bl27 = bl18 = rowColumn2.row == 0 && rowColumn2.column == rowColumn.column;
                if (bl18 && (string2 = map2.get("tc-neCell")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                boolean bl28 = bl17 = rowColumn2.row == 0 && rowColumn2.column == 0;
                if (bl17 && (string2 = map2.get("tc-nwCell")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                boolean bl29 = bl16 = rowColumn2.row == rowColumn.row && rowColumn2.column == rowColumn.column;
                if (bl16 && (string2 = map2.get("tc-seCell")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                boolean bl30 = bl15 = rowColumn2.row == rowColumn.row && rowColumn2.column == 0;
                if (bl15 && (string2 = map2.get("tc-swCell")) != null) {
                    this.addCellClass(element3, string2, bl19, bl20, bl);
                }
                for (Node node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getType() != Node.Type.ELEMENT || ((Element)node3).getName() != Constants.P_ELEM) continue;
                    Element element4 = (Element)node3;
                    string2 = map2.get("tp");
                    if (string2 != null) {
                        this.addParaClass(element4, string2);
                    }
                    if ((string2 = map2.get("tp-wholeTable")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl25 && (string2 = map2.get(bl26 ? "tp-band1Vert" : "tp-band2Vert")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl13 && (string2 = map2.get(bl14 ? "tp-band1Horz" : "tp-band2Horz")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl23 && (string2 = map2.get("tp-firstCol")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl24 && (string2 = map2.get("tp-lastCol")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl11 && (string2 = map2.get("tp-firstRow")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl12 && (string2 = map2.get("tp-lastRow")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl18 && (string2 = map2.get("tp-neCell")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl17 && (string2 = map2.get("tp-nwCell")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (bl16 && (string2 = map2.get("tp-seCell")) != null) {
                        this.addParaClass(element4, string2);
                    }
                    if (!bl15 || (string2 = map2.get("tp-swCell")) == null) continue;
                    this.addParaClass(element4, string2);
                }
            }
            ++n3;
        }
    }

    private void addTableBody(Element element) {
        Element element2 = new Element(Constants.THEAD_ELEM);
        Element element3 = new Element(Constants.TBODY_ELEM);
        boolean bl = true;
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT && ((Element)node).getName() == Constants.TR_ELEM) {
                Element element4 = (Element)node;
                element.removeChild(element4);
                if (bl && this.headerRow(element4)) {
                    element2.appendChild(element4);
                } else {
                    bl = false;
                    element3.appendChild(element4);
                }
            } else if (bl) {
                if (element2.getFirstChild() != null) {
                    element.removeChild(node);
                    element2.appendChild(node);
                }
            } else {
                element.removeChild(node);
                element3.appendChild(node);
            }
            node = node2;
        }
        if (element2.getFirstChild() != null) {
            element.appendChild(element2);
        }
        element.appendChild(element3);
    }

    private boolean headerRow(Element element) {
        return Translator.isHeaderRow(element) || "true".equals(this.styles.getStyleProperty(element, "-ms-tblHeader"));
    }

    private void addCols(Element element, int n) {
        Element element2 = Util.findDescendant(element, Constants.COLGROUP_ELEM, false);
        if (element2 == null) {
            Node node = element.getFirstChild();
            for (int i = 0; i < n; ++i) {
                element2 = new Element(Constants.COLGROUP_ELEM);
                element2.putAttribute(Constants.SPAN_ATTR, "1");
                element.insertChild(node, element2);
            }
        }
    }

    private void fixLineHeight(Element element) {
        Object object;
        if (element.getName() == Constants.P_ELEM && (object = Util.getStyleProperty(element, "line-height")) != null && ((String)object).endsWith("pt")) {
            String string = Util.getStyleProperty(element, "font-size");
            if (string == null) {
                string = this.styles.getStyleProperty(element, "font-size");
            }
            object = this.styles.fixedLineHeight((String)object, string);
            Util.putStyleProperty(element, "line-height", (String)object);
        }
        for (object = element.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
            if (((Node)object).getType() != Node.Type.ELEMENT) continue;
            this.fixLineHeight((Element)object);
        }
    }

    private void numberItems(Document document) {
        Object object;
        Object object2;
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        Style style = this.styles.getDefaultStyle("body");
        if (style != null && (object2 = style.get("counter-reset")) != null) {
            object = StringUtil.split((String)object2);
            int n = ((String[])object).length / 2 * 2;
            for (int i = 0; i < n; i += 2) {
                String string = object[i];
                String string2 = object[i + 1];
                try {
                    int n2 = Integer.parseInt(string2);
                    hashMap.put(string, new int[]{n2, n2});
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (hashMap.size() == 0) {
            return;
        }
        object2 = document.getRootElement();
        object = this.styles.getStyles();
        Translator.numberItems((Element)object2, (Map<String, Style>)object, hashMap, 1);
        Translator.numberItems((Element)object2, (Map<String, Style>)object, hashMap, 0);
    }

    private static void numberItems(Element element, Map<String, Style> map, Map<String, int[]> map2, int n) {
        Object object;
        if (element.getName() == Constants.P_ELEM && (object = element.getAttribute(Constants.CLASS_ATTR)) != null && ((String)object).indexOf("n-") >= 0) {
            String[] stringArray;
            Numbering numbering = null;
            for (String string : stringArray = XMLText.splitList((String)object)) {
                if (!string.startsWith("n-")) continue;
                numbering = (Numbering)map.get(string);
                break;
            }
            if (numbering != null && numbering.hasCounter()) {
                Translator.numberItem(element, numbering, map, map2, n);
            }
        }
        for (object = element.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
            if (((Node)object).getType() != Node.Type.ELEMENT) continue;
            Translator.numberItems((Element)object, map, map2, n);
        }
    }

    private static void numberItem(Element element, Numbering numbering, Map<String, Style> map, Map<String, int[]> map2, int n) {
        int[] nArray;
        String string;
        String string2 = (String)numbering.props.get("counter-reset");
        if (string2 != null) {
            Translator.updateCounters(true, string2, map2, n);
        }
        if ((string2 = Util.getStyleProp(element, "counter-reset")) != null) {
            Translator.updateCounters(true, string2, map2, n);
        }
        if ((string = numbering.propsBefore.get("counter-increment")) != null) {
            Translator.updateCounters(false, string, map2, n);
        }
        if (n == 0 && (nArray = map2.get(numbering.name)) != null) {
            String string3 = null;
            String string4 = numbering.propsBefore.get("content");
            if (string4 != null) {
                string3 = Translator.numberingLabel(string4, map2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (string3 != null) {
                stringBuilder.append("label=");
                char c = string3.indexOf(34) < 0 ? (char)'\"' : '\'';
                stringBuilder.append(c);
                stringBuilder.append(string3);
                stringBuilder.append(c);
                stringBuilder.append(' ');
            }
            stringBuilder.append("name=\"");
            stringBuilder.append(numbering.name);
            stringBuilder.append("\" value=\"");
            stringBuilder.append(Integer.toString(nArray[0]));
            stringBuilder.append('\"');
            ProcessingInstruction processingInstruction = new ProcessingInstruction("counter", stringBuilder.toString());
            element.insertChild(element.getFirstChild(), processingInstruction);
        }
    }

    private static void updateCounters(boolean bl, String string, Map<String, int[]> map, int n) {
        String string2 = null;
        for (String string3 : StringUtil.split(string)) {
            int n2 = Integer.MIN_VALUE;
            boolean bl2 = false;
            try {
                n2 = Integer.parseInt(string3);
                bl2 = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bl2) {
                if (string2 == null) continue;
                Translator.updateCounter(bl, string2, n2, map, n);
                string2 = null;
                continue;
            }
            if (string2 != null) {
                Translator.updateCounter(bl, string2, bl ? 0 : 1, map, n);
            }
            string2 = string3;
        }
        if (string2 != null) {
            Translator.updateCounter(bl, string2, bl ? 0 : 1, map, n);
        }
    }

    private static void updateCounter(boolean bl, String string, int n, Map<String, int[]> map, int n2) {
        int[] nArray = map.get(string);
        if (nArray != null) {
            if (bl) {
                nArray[n2] = n;
            } else {
                int n3 = n2;
                nArray[n3] = nArray[n3] + n;
            }
        }
    }

    private static String numberingLabel(String string, Map<String, int[]> map) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = Translator.splitNumberingLabel(string)) {
            if (string2.startsWith("counter(") && string2.endsWith(")")) {
                int[] nArray;
                String string3 = null;
                String string4 = string2.substring(8, string2.length() - 1).trim();
                int n = string4.lastIndexOf(44);
                if (n > 0) {
                    string3 = string4.substring(n + 1).trim();
                    string4 = string4.substring(0, n).trim();
                }
                if ((nArray = map.get(string4)) == null) {
                    stringBuilder.append(string2);
                    continue;
                }
                if (string3 == null) {
                    string3 = "decimal";
                }
                if ("lower-alpha".equals(string3)) {
                    Util.numberToAlpha(nArray[0], true, stringBuilder);
                    continue;
                }
                if ("upper-alpha".equals(string3)) {
                    Util.numberToAlpha(nArray[0], false, stringBuilder);
                    continue;
                }
                if ("lower-roman".equals(string3)) {
                    Util.numberToRoman(nArray[0], true, stringBuilder);
                    continue;
                }
                if ("upper-roman".equals(string3)) {
                    Util.numberToRoman(nArray[0], false, stringBuilder);
                    continue;
                }
                if ("decimal-leading-zero".equals(string3)) {
                    String string5 = Integer.toString(nArray[0]);
                    int n2 = Integer.toString(nArray[1]).length() - string5.length();
                    if (n2 <= 0) {
                        n2 = 1;
                    }
                    while (n2 > 0) {
                        stringBuilder.append(0);
                        --n2;
                    }
                    stringBuilder.append(string5);
                    continue;
                }
                stringBuilder.append(Integer.toString(nArray[0]));
                continue;
            }
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static String[] splitNumberingLabel(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        block4: for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (Character.isWhitespace((char)n3)) {
                if (n != 0) {
                    stringBuilder.append((char)n3);
                    continue;
                }
                if (stringBuilder == null) continue;
                arrayList.add(stringBuilder.toString());
                stringBuilder = null;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                switch (n3) {
                    case 34: 
                    case 39: {
                        n = n3;
                        break;
                    }
                    case 99: {
                        if (!string.regionMatches(i, "counter(", 0, 8)) continue block4;
                        stringBuilder.append('c');
                        n = 41;
                        break;
                    }
                    default: {
                        stringBuilder.append((char)n3);
                        break;
                    }
                }
                continue;
            }
            if (n3 == n) {
                if (n == 41) {
                    stringBuilder.append(')');
                }
                arrayList.add(stringBuilder.toString());
                stringBuilder = null;
                n = 0;
                continue;
            }
            stringBuilder.append((char)n3);
        }
        if (stringBuilder != null) {
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

