/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import java.util.Iterator;

final class SimplifySpans {
    SimplifySpans() {
    }

    public static void process(Document document) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        SimplifySpans.mergeSimilarSpans(element2);
        SimplifySpans.unwrapUselessSpans(element2);
    }

    private static void mergeSimilarSpans(Element element) {
        Node node;
        Element element2 = null;
        Element element3 = null;
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            switch (node2.getType()) {
                case PROCESSING_INSTRUCTION: {
                    if (element2 != null && element3 != element2) {
                        SimplifySpans.mergeSpans(element2, element3);
                    }
                    element3 = null;
                    element2 = null;
                    break;
                }
                case ELEMENT: {
                    Element element4 = (Element)node2;
                    if (element4.getName() == Constants.SPAN_ELEM) {
                        boolean bl = SimplifySpans.isMergeableSpan(element4);
                        if (element2 == null) {
                            if (!bl) break;
                            element2 = element3 = element4;
                            break;
                        }
                        if (bl && SimplifySpans.canMergeSpans(element2, element4)) {
                            element3 = element4;
                            break;
                        }
                        if (element3 != element2) {
                            SimplifySpans.mergeSpans(element2, element3);
                        }
                        if (bl) {
                            element2 = element3 = element4;
                            break;
                        }
                        element3 = null;
                        element2 = null;
                        break;
                    }
                    if (element2 != null && element3 != element2) {
                        SimplifySpans.mergeSpans(element2, element3);
                    }
                    element3 = null;
                    element2 = null;
                }
            }
            node2 = node;
        }
        if (element2 != null && element3 != element2) {
            SimplifySpans.mergeSpans(element2, element3);
        }
        for (node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getType() != Node.Type.ELEMENT || ((Element)(node = (Element)node2)).getName() == Constants.SPAN_ELEM && SimplifySpans.isMergeableSpan((Element)node)) continue;
            SimplifySpans.mergeSimilarSpans((Element)node);
        }
    }

    private static boolean isMergeableSpan(Element element) {
        String string = element.getAttribute(Constants.CLASS_ATTR);
        return string == null || !string.startsWith("role-");
    }

    private static boolean canMergeSpans(Element element, Element element2) {
        int n = element.getAttributeCount();
        if (n != element2.getAttributeCount()) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        Iterator<Attribute> iterator = element.getAttributes(false);
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (attribute.value.equals(element2.getAttribute(attribute.name))) continue;
            return false;
        }
        return true;
    }

    private static void mergeSpans(Element element, Element element2) {
        Tree tree = element.getParent();
        Node node = element.getNextSibling();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                Element element3 = (Element)node;
                tree.removeChild(element3);
                SimplifySpans.doMergeSpans(element, element3);
                if (element3 == element2) break;
            }
            node = node2;
        }
    }

    private static void doMergeSpans(Element element, Element element2) {
        Node node = element2.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            element2.removeChild(node);
            SimplifySpans.appendChild(element, node);
            node = node2;
        }
    }

    private static void appendChild(Element element, Node node) {
        Node node2;
        boolean bl = true;
        if (node.getType() == Node.Type.TEXT && (node2 = element.getLastChild()) != null && node2.getType() == Node.Type.TEXT) {
            ((Text)node2).appendText(((Text)node).getText());
            bl = false;
        }
        if (bl) {
            element.appendChild(node);
        }
    }

    private static void unwrapUselessSpans(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                Element element2 = (Element)node;
                SimplifySpans.unwrapUselessSpans(element2);
                if (element2.getName() == Constants.SPAN_ELEM && element2.getAttributeCount() == 0) {
                    node2 = Util.unwrapElement(element2);
                }
            }
            node = node2;
        }
    }
}

