/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Styles;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;

final class JoinParagraphs {
    JoinParagraphs() {
    }

    public static void process(Document document, Styles styles) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        JoinParagraphs.processParagraphs(element2, styles);
    }

    private static void processParagraphs(Element element, Styles styles) {
        if (element.getName() == Constants.P_ELEM) {
            Element element2 = null;
            Node node = element.getNextSibling();
            if (node != null && node.getType() == Node.Type.ELEMENT && ((Element)node).getName() == Constants.P_ELEM) {
                element2 = (Element)node;
            }
            if (element2 != null) {
                JoinParagraphs.applyContextualSpacing(element, element2, styles);
            }
        } else {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                JoinParagraphs.processParagraphs((Element)node, styles);
            }
        }
    }

    private static void applyContextualSpacing(Element element, Element element2, Styles styles) {
        String string = JoinParagraphs.getStyleName(element);
        String string2 = JoinParagraphs.getStyleName(element2);
        if (string != null && string.equals(string2) && "true".equals(styles.lookupStyle(element, "-ms-contextualSpacing"))) {
            double d = JoinParagraphs.lookupPt(styles, element, "margin-bottom", "0");
            double d2 = JoinParagraphs.lookupPt(styles, element2, "margin-top", "0");
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                double d3 = Math.max(d, d2) - Math.abs(d - d2);
                if (d2 == 0.0) {
                    if (d != d3) {
                        JoinParagraphs.putStyleProp(element, "margin-bottom", Util.formatDouble(d3) + "pt");
                    }
                } else {
                    if (d != 0.0) {
                        JoinParagraphs.putStyleProp(element, "margin-bottom", "0pt");
                    }
                    if (d2 != d3) {
                        JoinParagraphs.putStyleProp(element2, "margin-top", Util.formatDouble(d3) + "pt");
                    }
                }
            }
        }
    }

    private static String getStyleName(Element element) {
        String string = null;
        String string2 = element.getAttribute(Constants.CLASS_ATTR);
        if (string2 != null) {
            for (String string3 : XMLText.splitList(string2)) {
                if (!string3.startsWith("p-")) continue;
                string = string3;
                break;
            }
        }
        return string;
    }

    private static double lookupPt(Styles styles, Element element, String string, String string2) {
        double d = Double.NaN;
        String string3 = styles.lookupStyle(element, string);
        if (string3 == null) {
            string3 = string2;
        }
        if (string3 != null) {
            boolean bl = false;
            if (string3.endsWith("pt")) {
                string3 = string3.substring(0, string3.length() - 2);
            } else {
                bl = true;
            }
            try {
                d = Double.parseDouble(string3);
                if (bl && d != 0.0) {
                    d = Double.NaN;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    private static void putStyleProp(Element element, String string, String string2) {
        Util.removeStyleProp(element, string);
        Util.addStyleProp(element, string, string2);
    }
}

