/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.toxhtml.Util;
import java.util.Map;

final class Border {
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int BETWEEN = 16;
    public static final int BAR = 32;
    public static final int INSIDE_H = 64;
    public static final int INSIDE_V = 128;
    public static final int TL2BR = 256;
    public static final int TR2BL = 512;
    public static final int ALL_SIDES = 15;
    public final String style;
    public final String styleExt;
    public final String width;
    public final String color;
    public final String padding;

    public Border(String string, String string2, String string3, String string4, String string5) {
        this.style = string;
        this.styleExt = string2;
        this.width = string3;
        this.color = string4;
        this.padding = string5;
    }

    public void toCSS(int n, Map<String, String> map) {
        if ((n & 1) != 0) {
            map.put("border-top-style", this.style);
        }
        if ((n & 2) != 0) {
            map.put("border-right-style", this.style);
        }
        if ((n & 4) != 0) {
            map.put("border-bottom-style", this.style);
        }
        if ((n & 8) != 0) {
            map.put("border-left-style", this.style);
        }
        if (this.styleExt != null) {
            if ((n & 1) != 0) {
                map.put("-ms-border-top", this.styleExt);
            }
            if ((n & 2) != 0) {
                map.put("-ms-border-right", this.styleExt);
            }
            if ((n & 4) != 0) {
                map.put("-ms-border-bottom", this.styleExt);
            }
            if ((n & 8) != 0) {
                map.put("-ms-border-left", this.styleExt);
            }
        }
        if (this.width != null) {
            String string = Util.checkBorderWidth(this.width);
            if ((n & 1) != 0) {
                map.put("border-top-width", string);
            }
            if ((n & 2) != 0) {
                map.put("border-right-width", string);
            }
            if ((n & 4) != 0) {
                map.put("border-bottom-width", string);
            }
            if ((n & 8) != 0) {
                map.put("border-left-width", string);
            }
        }
        if (this.color != null) {
            if ((n & 1) != 0) {
                map.put("border-top-color", this.color);
            }
            if ((n & 2) != 0) {
                map.put("border-right-color", this.color);
            }
            if ((n & 4) != 0) {
                map.put("border-bottom-color", this.color);
            }
            if ((n & 8) != 0) {
                map.put("border-left-color", this.color);
            }
        }
        if (this.padding != null) {
            if ((n & 1) != 0) {
                map.put("padding-top", this.padding);
            }
            if ((n & 2) != 0) {
                map.put("padding-right", this.padding);
            }
            if ((n & 4) != 0) {
                map.put("padding-bottom", this.padding);
            }
            if ((n & 8) != 0) {
                map.put("padding-left", this.padding);
            }
        }
        if ((n & 0x10) != 0) {
            this.toCSS("between", this.styleExt(), map);
        }
        if ((n & 0x20) != 0) {
            this.toCSS("bar", this.styleExt(), map);
        }
        if ((n & 0x40) != 0) {
            this.toCSS("insideH", this.style, map);
        }
        if ((n & 0x80) != 0) {
            this.toCSS("insideV", this.style, map);
        }
        if ((n & 0x100) != 0) {
            this.toCSS("tl2br", this.styleExt(), map);
        }
        if ((n & 0x200) != 0) {
            this.toCSS("tr2bl", this.styleExt(), map);
        }
    }

    private String styleExt() {
        if (this.styleExt != null) {
            return this.styleExt;
        }
        return "solid".equals(this.style) ? "single" : this.style;
    }

    private void toCSS(String string, String string2, Map<String, String> map) {
        map.put("-ms-border-" + string, string2);
        if (this.width != null) {
            map.put("-ms-border-" + string + "-sz", this.width);
        }
        if (this.color != null) {
            map.put("-ms-border-" + string + "-color", this.color == "#000000" ? "auto" : this.color);
        }
        if (this.padding != null) {
            map.put("-ms-border-" + string + "-space", this.padding);
        }
    }
}

