/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.packaging;

import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.packaging.Msg;
import com.xmlmind.w2x.docx.packaging.ParseException;
import com.xmlmind.w2x.docx.packaging.PartNameUtil;
import com.xmlmind.w2x.docx.packaging.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import java.util.Map;
import java.util.TreeMap;

final class ContentTypeMap {
    private final TreeMap<String, String> defaultMap = new TreeMap();
    private final TreeMap<String, String> overrideMap = new TreeMap();
    private static final Namespace CONTENT_TYPES_NS = Namespace.get("http://schemas.openxmlformats.org/package/2006/content-types");
    private static final Name TYPES_ELEM = Name.get(CONTENT_TYPES_NS, "Types");
    private static final Name DEFAULT_ELEM = Name.get(CONTENT_TYPES_NS, "Default");
    private static final Name OVERRIDE_ELEM = Name.get(CONTENT_TYPES_NS, "Override");
    private static final Name EXTENSION_ATTR = Name.get(Namespace.NONE, "Extension");
    private static final Name CONTENT_TYPE_ATTR = Name.get(Namespace.NONE, "ContentType");
    private static final Name PART_NAME_ATTR = Name.get(Namespace.NONE, "PartName");

    public void loadFrom(Document document) throws ParseException {
        Element element = document.getRootElement();
        if (element.getName() != TYPES_ELEM) {
            throw new ParseException(element, Msg.msg("unknownElement", element.getName().format(false, element)));
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            String string2;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == DEFAULT_ELEM) {
                string2 = Util.getRequiredAttribute(element2, EXTENSION_ATTR);
                string = Util.getRequiredAttribute(element2, CONTENT_TYPE_ATTR);
                this.defaultMap.put(string2, string);
                continue;
            }
            if (name != OVERRIDE_ELEM) continue;
            string2 = Util.getRequiredAttribute(element2, PART_NAME_ATTR);
            string = Util.getRequiredAttribute(element2, CONTENT_TYPE_ATTR);
            this.overrideMap.put(string2, string);
        }
    }

    public String getContentType(String string) {
        String string2;
        String string3 = this.overrideMap.get(string);
        if (string3 == null && (string2 = PartNameUtil.extension(string)) != null) {
            string3 = this.defaultMap.get(string2);
        }
        return string3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<Types>\n");
        for (Map.Entry<String, String> entry : this.defaultMap.entrySet()) {
            stringBuilder.append("  <Default Extension=");
            XMLText.quoteXML(entry.getKey(), stringBuilder);
            stringBuilder.append(" ContentType=");
            XMLText.quoteXML(entry.getValue(), stringBuilder);
            stringBuilder.append("/>\n");
        }
        for (Map.Entry<String, String> entry : this.overrideMap.entrySet()) {
            stringBuilder.append("  <Override PartName=");
            XMLText.quoteXML(entry.getKey(), stringBuilder);
            stringBuilder.append(" ContentType=");
            XMLText.quoteXML(entry.getValue(), stringBuilder);
            stringBuilder.append("/>\n");
        }
        stringBuilder.append("</Types>");
        return stringBuilder.toString();
    }
}

