/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.math;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.docx.math.AutoRegisterFactories;
import com.xmlmind.w2x.docx.math.MathConverter;
import com.xmlmind.w2x.docx.math.MathConverterFactory;
import com.xmlmind.xml.doc.Element;

public final class MathConverterFactories {
    private static final boolean trace;
    private static final Object LOCK;
    private static MathConverterFactory[] factories;

    private MathConverterFactories() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(MathConverterFactory mathConverterFactory) {
        Object object = LOCK;
        synchronized (object) {
            MathConverterFactories.trace("registering MathConverterFactory \"" + mathConverterFactory.getClass().getName() + "\"...");
            int n = factories.length;
            MathConverterFactory[] mathConverterFactoryArray = new MathConverterFactory[n + 1];
            System.arraycopy(factories, 0, mathConverterFactoryArray, 0, n);
            mathConverterFactoryArray[n] = mathConverterFactory;
            factories = mathConverterFactoryArray;
        }
    }

    private static void trace(String string) {
        if (trace) {
            System.err.println("MathConverterFactories>>> " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MathConverter createMathConverter(Element element) {
        Object object = LOCK;
        synchronized (object) {
            for (int i = factories.length - 1; i >= 0; --i) {
                MathConverterFactory mathConverterFactory = factories[i];
                MathConverter mathConverter = null;
                try {
                    mathConverter = mathConverterFactory.createMathConverter(element);
                }
                catch (Exception exception) {
                    MathConverterFactories.trace("could not create math converter using \"" + mathConverterFactory.getClass().getName() + "\": " + ThrowableUtil.reason(exception));
                }
                if (mathConverter == null) continue;
                return mathConverter;
            }
            return null;
        }
    }

    public static Element convertMath(Element element) {
        Element element2 = null;
        MathConverter mathConverter = MathConverterFactories.createMathConverter(element);
        if (mathConverter != null) {
            MathConverterFactories.trace("converting " + element.getName().format(false, element) + " to mml:math using " + String.valueOf(mathConverter) + "...");
            try {
                element2 = mathConverter.convertMath(element);
            }
            catch (Exception exception) {
                MathConverterFactories.trace("could not convert math using " + String.valueOf(mathConverter) + ": " + ThrowableUtil.reason(exception));
            }
        }
        return element2;
    }

    static {
        LOCK = new Object();
        factories = new MathConverterFactory[0];
        String string = System.getProperty("W2X_TRACE");
        trace = string != null && (string.indexOf("math") >= 0 || string.indexOf("all") >= 0);
        AutoRegisterFactories.registerAll();
    }
}

