/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.image;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.docx.image.AutoRegisterFactories;
import com.xmlmind.w2x.docx.image.ExternalImageConverter;
import com.xmlmind.w2x.docx.image.ImageConverter;
import com.xmlmind.w2x.docx.image.ImageConverterFactory;
import java.io.File;

public final class ImageConverterFactories {
    public static final boolean trace;
    private static final Object LOCK;
    private static ImageConverterFactory[] factories;
    private static final String[] DEFAULT_PREFERRED_EXTENSIONS;

    private ImageConverterFactories() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ImageConverterFactory imageConverterFactory) {
        Object object = LOCK;
        synchronized (object) {
            ImageConverterFactories.trace("registering ImageConverterFactory \"" + ImageConverterFactories.toSpecString(imageConverterFactory) + "\"...");
            int n = factories.length;
            ImageConverterFactory[] imageConverterFactoryArray = new ImageConverterFactory[n + 1];
            System.arraycopy(factories, 0, imageConverterFactoryArray, 0, n);
            imageConverterFactoryArray[n] = imageConverterFactory;
            factories = imageConverterFactoryArray;
        }
    }

    private static void trace(String string) {
        if (trace) {
            System.err.println("ImageConverterFactories>>> " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toSpecString() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = LOCK;
        synchronized (object) {
            for (int i = factories.length - 1; i >= 0; --i) {
                ImageConverterFactories.toSpecString(factories[i], stringBuilder);
                if (i <= 0) continue;
                stringBuilder.append(';');
            }
        }
        return stringBuilder.toString();
    }

    private static String toSpecString(ImageConverterFactory imageConverterFactory) {
        StringBuilder stringBuilder = new StringBuilder();
        ImageConverterFactories.toSpecString(imageConverterFactory, stringBuilder);
        return stringBuilder.toString();
    }

    private static void toSpecString(ImageConverterFactory imageConverterFactory, StringBuilder stringBuilder) {
        String[] stringArray = imageConverterFactory.getImageConversions();
        for (int i = 0; i < stringArray.length; i += 2) {
            stringBuilder.append('.');
            stringBuilder.append(stringArray[i]);
            stringBuilder.append('.');
            stringBuilder.append(stringArray[i + 1]);
        }
        stringBuilder.append(' ');
        if (imageConverterFactory instanceof ExternalImageConverter) {
            stringBuilder.append(((ExternalImageConverter)imageConverterFactory).conversionCommand);
        } else {
            stringBuilder.append("java:");
            stringBuilder.append(imageConverterFactory.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageConverterFactory get(String string, String string2) {
        Object object = LOCK;
        synchronized (object) {
            for (int i = factories.length - 1; i >= 0; --i) {
                ImageConverterFactory imageConverterFactory = factories[i];
                String[] stringArray = imageConverterFactory.getImageConversions();
                int n = stringArray.length;
                for (int j = 0; j < n; j += 2) {
                    String string3 = stringArray[j];
                    String string4 = stringArray[j + 1];
                    if (!string3.equalsIgnoreCase(string) || !string4.equalsIgnoreCase(string2)) continue;
                    return imageConverterFactory;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File convertImage(File file, String[] stringArray) {
        void var5_8;
        String string = FileUtil.getExtension(file);
        if (string == null || string.length() == 0) {
            return null;
        }
        if ("gif".equalsIgnoreCase(string) || "png".equalsIgnoreCase(string) || "jpg".equalsIgnoreCase(string) || "jpeg".equalsIgnoreCase(string) || "svg".equalsIgnoreCase(string)) {
            return null;
        }
        ImageConverterFactory imageConverterFactory = null;
        String string2 = null;
        if (stringArray == null) {
            stringArray = DEFAULT_PREFERRED_EXTENSIONS;
        }
        for (String string3 : stringArray) {
            imageConverterFactory = ImageConverterFactories.get(string, string3);
            if (imageConverterFactory == null) continue;
            string2 = string3;
            break;
        }
        if (imageConverterFactory == null) {
            return null;
        }
        File file2 = FileUtil.setExtension(file, string2);
        ImageConverterFactories.trace("converting \"" + String.valueOf(file) + "\" to \"" + String.valueOf(file2) + "\"...");
        try {
            ImageConverter imageConverter = imageConverterFactory.createImageConverter(string, string2);
            imageConverter.convertImage(file, file2);
        }
        catch (Exception exception) {
            ImageConverterFactories.trace("cannot convert \"" + String.valueOf(file) + "\" to \"" + String.valueOf(file2) + "\": " + ThrowableUtil.detailedReason(exception));
            Object var5_7 = null;
        }
        return var5_8;
    }

    static {
        LOCK = new Object();
        factories = new ImageConverterFactory[0];
        String string = System.getProperty("W2X_TRACE");
        trace = string != null && (string.indexOf("image") >= 0 || string.indexOf("all") >= 0);
        AutoRegisterFactories.registerAll(trace);
        DEFAULT_PREFERRED_EXTENSIONS = new String[]{"svg", "png", "jpeg"};
    }
}

