/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.image;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.docx.image.ImageConverter;
import com.xmlmind.w2x.docx.image.ImageConverterFactories;
import com.xmlmind.w2x.docx.image.ImageConverterFactory;
import java.io.File;

public final class ExternalImageConverter
implements ImageConverterFactory {
    public final String[] supportedConversions;
    public final String conversionCommand;

    public ExternalImageConverter(String[] stringArray, String string) throws IllegalArgumentException {
        int n;
        if (stringArray == null || (n = stringArray.length / 2 * 2) == 0) {
            throw new IllegalArgumentException("no conversions");
        }
        for (int i = 0; i < n; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            if (string2 == null || (string2 = string2.trim()).length() == 0) {
                throw new IllegalArgumentException("no input extension");
            }
            stringArray[i] = string2 = string2.toLowerCase();
            if (string3 == null || (string3 = string3.trim()).length() == 0) {
                throw new IllegalArgumentException("no output extension");
            }
            stringArray[i + 1] = string3 = string3.toLowerCase();
            if (!string3.equals(string2)) continue;
            throw new IllegalArgumentException("input extension '" + string2 + "' same as output extension '" + string3 + "'");
        }
        if (string == null || (string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("no command");
        }
        this.supportedConversions = stringArray;
        this.conversionCommand = string;
    }

    @Override
    public void setParameter(String string, String string2) {
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public String[] getImageConversions() {
        return this.supportedConversions;
    }

    @Override
    public ImageConverter createImageConverter(String string, String string2) {
        return new ImageConverterImpl(this.conversionCommand);
    }

    private static final class ImageConverterImpl
    implements ImageConverter {
        public final String conversionCommand;
        private static final int QUOTE_VALUE = 1;
        private static final int IN_FILE = 16;
        private static final int OUT_FILE = 32;
        private static final int MOD_PARENT = 65536;
        private static final int MOD_NAME = 131072;
        private static final int MOD_ROOT_NAME = 262144;
        private static final int MOD_EXTENSION = 524288;

        public ImageConverterImpl(String string) {
            this.conversionCommand = string;
        }

        @Override
        public void convertImage(File file, File file2) throws RuntimeException {
            file = file.getAbsoluteFile();
            file2 = file2.getAbsoluteFile();
            String string = ImageConverterImpl.substituteVars(this.conversionCommand, file, file2);
            int n = 0;
            String[] stringArray = new String[2];
            try {
                n = SystemUtil.shellExec(string, stringArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("cannot execute command \"" + string + "\": " + ThrowableUtil.reason(exception));
            }
            if (ImageConverterFactories.trace) {
                if (stringArray[0] != null && stringArray[0].length() > 0) {
                    System.out.println(stringArray[0]);
                }
                if (stringArray[1] != null && stringArray[1].length() > 0) {
                    System.err.println(stringArray[1]);
                }
            }
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("command \"");
                stringBuilder.append(string);
                stringBuilder.append("\" exited abnormally (status = ");
                stringBuilder.append(n);
                stringBuilder.append(')');
                if (stringArray[0] != null && stringArray[0].length() > 0) {
                    stringBuilder.append('\n');
                    stringBuilder.append(stringArray[0]);
                }
                if (stringArray[1] != null && stringArray[1].length() > 0) {
                    stringBuilder.append('\n');
                    stringBuilder.append(stringArray[1]);
                }
                throw new RuntimeException(stringBuilder.toString());
            }
        }

        private static String substituteVars(String string, File file, File file2) {
            if (string.indexOf(37) < 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            block4: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '%') {
                    switch (ImageConverterImpl.charAt(string, n, i + 1)) {
                        case '%': {
                            stringBuilder.append('%');
                            ++i;
                            break;
                        }
                        case 'S': {
                            stringBuilder.append(File.separatorChar);
                            ++i;
                            break;
                        }
                        default: {
                            int n2 = ImageConverterImpl.parseVar(string, n, i + 1);
                            if ((n2 & 0x10) != 0 && file != null || (n2 & 0x20) != 0 && file2 != null) {
                                String string2 = (n2 & 0x10) != 0 ? ImageConverterImpl.varValue(file, n2) : ImageConverterImpl.varValue(file2, n2);
                                int n3 = i++;
                                if (ImageConverterImpl.hasModifier(n2)) {
                                    i += 3;
                                }
                                boolean bl = false;
                                if ((n2 & 1) != 0 && !ImageConverterImpl.hasQuotes(string, n, n3 - 1, i + 1)) {
                                    bl = true;
                                }
                                if (bl) {
                                    stringBuilder.append('\"');
                                }
                                stringBuilder.append(string2);
                                if (!bl) continue block4;
                                stringBuilder.append('\"');
                                break;
                            }
                            stringBuilder.append(c);
                            break;
                        }
                    }
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        private static boolean hasQuotes(String string, int n, int n2, int n3) {
            char c = ImageConverterImpl.charAt(string, n, n2);
            char c2 = ImageConverterImpl.charAt(string, n, n3);
            return c == '\"' && c2 == '\"' || c == '\'' && c2 == '\'';
        }

        private static char charAt(String string, int n, int n2) {
            return n2 >= 0 && n2 < n ? string.charAt(n2) : (char)'\u0000';
        }

        private static int parseVar(String string, int n, int n2) {
            switch (ImageConverterImpl.charAt(string, n, n2)) {
                case '~': {
                    int n3;
                    switch (ImageConverterImpl.charAt(string, n, n2 + 1)) {
                        case 'p': {
                            n3 = 65536;
                            break;
                        }
                        case 'n': {
                            n3 = 131072;
                            break;
                        }
                        case 'r': {
                            n3 = 262144;
                            break;
                        }
                        case 'e': {
                            n3 = 524288;
                            break;
                        }
                        default: {
                            return 0;
                        }
                    }
                    switch (ImageConverterImpl.charAt(string, n, n2 + 2)) {
                        case 'I': {
                            return n3 | 0x10;
                        }
                        case 'O': {
                            return n3 | 0x20;
                        }
                        case 'i': {
                            return n3 | 1 | 0x10;
                        }
                        case 'o': {
                            return n3 | 1 | 0x20;
                        }
                    }
                    return 0;
                }
                case 'I': {
                    return 16;
                }
                case 'O': {
                    return 32;
                }
                case 'i': {
                    return 17;
                }
                case 'o': {
                    return 33;
                }
            }
            return 0;
        }

        private static String varValue(File file, int n) {
            String string = null;
            string = (n & 0x10000) != 0 ? file.getParent() : ((n & 0x20000) != 0 ? file.getName() : ((n & 0x40000) != 0 ? FileUtil.setExtension(file.getName(), null) : ((n & 0x80000) != 0 ? FileUtil.getExtension(file.getName()) : file.getPath())));
            return string == null ? "" : string;
        }

        private static boolean hasModifier(int n) {
            return (n & 0xF0000) != 0;
        }
    }
}

