/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Alert;
import com.xmlmind.guiutil.ChooseFile;
import com.xmlmind.guiutil.ChooseFileOptions;
import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.HintLabel;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.LabeledValue;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.processor.HTMLElements;
import com.xmlmind.w2x_app.ConvertPane;
import com.xmlmind.w2x_app.CustomStyles;
import com.xmlmind.w2x_app.Msg;
import com.xmlmind.w2x_app.OptionsWizardState;
import com.xmlmind.w2x_app.StyleMappingType;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;

public class StyleMappingEditor
extends DialogBase {
    private JRadioButton charStylesToggle;
    private JRadioButton paraStylesToggle;
    private ButtonGroup styleTypeGroup;
    private JButton addStylesButton;
    private boolean selectingStyle;
    private JComboBox<CustomStyles.Entry> styleCombo;
    private JTextArea cssRuleText;
    private static LabeledValue[] paraMappingValues;
    private static String[] paraMappingTooltips;
    private JComboBox<LabeledValue> paraMappingCombo;
    private JTextField elementQNameField;
    private JTextField[] attributeFields;
    private CustomStyles customStyles;
    private boolean checkElement;
    private OptionsWizardState.StyleMapping result;

    public StyleMappingEditor(Component component, String string) {
        super(component, string, 91);
        this.setHelpId("style_mapping_editor");
    }

    @Override
    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(Msg.msg("SME.style"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.charStylesToggle = new JRadioButton(Msg.msg("SME.character"));
        this.charStylesToggle.setSelected(true);
        this.charStylesToggle.setActionCommand("styleTypeChanged");
        this.charStylesToggle.addActionListener(this);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.charStylesToggle, DialogUtil.px(gridBagConstraints));
        this.styleTypeGroup = new ButtonGroup();
        this.paraStylesToggle = new JRadioButton(Msg.msg("SME.paragraph"));
        this.charStylesToggle.setSelected(false);
        this.paraStylesToggle.setActionCommand("styleTypeChanged");
        this.paraStylesToggle.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.paraStylesToggle, DialogUtil.px(gridBagConstraints));
        this.styleTypeGroup.add(this.charStylesToggle);
        this.styleTypeGroup.add(this.paraStylesToggle);
        IconResource iconResource = new IconResource(StyleMappingEditor.class, "add_styles.png");
        this.addStylesButton = new JButton(iconResource);
        this.addStylesButton.setDisabledIcon(iconResource);
        this.addStylesButton.setToolTipText(Msg.msg("SME.addStylesTip"));
        DialogUtil.setIconic(this.addStylesButton);
        this.addStylesButton.setActionCommand("addStyles");
        this.addStylesButton.addActionListener(this);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.addStylesButton, DialogUtil.px(gridBagConstraints));
        this.styleCombo = new JComboBox();
        this.styleCombo.setRenderer(new StyleRenderer());
        this.styleCombo.setActionCommand("styleChanged");
        this.styleCombo.addActionListener(this);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        jPanel.add(this.styleCombo, DialogUtil.px(gridBagConstraints));
        this.cssRuleText = new JTextArea(8, 40);
        this.cssRuleText.setEditable(false);
        Font font = this.cssRuleText.getFont();
        this.cssRuleText.setFont(new Font("Monospaced", 0, Math.max(8, font.getSize() - 1)));
        JScrollPane jScrollPane = DialogUtil.createScrollPane(this.cssRuleText);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, DialogUtil.px(gridBagConstraints));
        jLabel = new JLabel(Msg.msg("SME.paraMapping"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        if (paraMappingValues == null) {
            paraMappingValues = StyleMappingEditor.paraMappingValues();
            paraMappingTooltips = StyleMappingEditor.paraMappingTooltips();
        }
        this.paraMappingCombo = new JComboBox<LabeledValue>(paraMappingValues){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.getSelectedIndex();
                if (n < 0) {
                    return null;
                }
                return paraMappingTooltips[n];
            }
        };
        this.paraMappingCombo.setToolTipText("");
        this.paraMappingCombo.setEnabled(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add(this.paraMappingCombo, DialogUtil.px(gridBagConstraints));
        jLabel = new JLabel(Msg.msg("OW.styleMapping.targetElement"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 20;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.elementQNameField = new JTextField(50);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)this.elementQNameField, DialogUtil.px(gridBagConstraints));
        HintLabel hintLabel = new HintLabel(Msg.msg("SME.localNamesHint"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 2;
        jPanel.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
        jLabel = new JLabel(Msg.msg("SME.optionalAttributes"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 20;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.attributeFields = new JTextField[6];
        for (int i = 0; i < this.attributeFields.length; ++i) {
            boolean bl;
            boolean bl2 = bl = i % 2 == 1;
            if (bl) {
                this.attributeFields[i] = new JTextField();
                gridBagConstraints.gridx += 2;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets.right = 5;
            } else {
                this.attributeFields[i] = new JTextField(20);
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.insets.right = 0;
            }
            gridBagConstraints.insets.top = 5;
            jPanel.add((Component)this.attributeFields[i], DialogUtil.px(gridBagConstraints));
        }
        hintLabel = new HintLabel(Msg.msg("SME.attributeFieldsHint"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    private static LabeledValue[] paraMappingValues() {
        StyleMappingType[] styleMappingTypeArray = StyleMappingType.values();
        LabeledValue[] labeledValueArray = new LabeledValue[styleMappingTypeArray.length];
        labeledValueArray[0] = new LabeledValue("-", null);
        for (int i = 1; i < styleMappingTypeArray.length; ++i) {
            StyleMappingType styleMappingType = styleMappingTypeArray[i];
            labeledValueArray[i] = new LabeledValue(styleMappingType.getLabel(), (Object)styleMappingType);
        }
        return labeledValueArray;
    }

    private static String[] paraMappingTooltips() {
        StyleMappingType[] styleMappingTypeArray = StyleMappingType.values();
        String[] stringArray = new String[styleMappingTypeArray.length];
        stringArray[0] = null;
        for (int i = 1; i < styleMappingTypeArray.length; ++i) {
            StyleMappingType styleMappingType = styleMappingTypeArray[i];
            StringBuilder stringBuilder = new StringBuilder("<html>");
            DialogUtil.appendHTML(Msg.msg("SME." + styleMappingType.toString()), stringBuilder);
            String string = stringBuilder.toString();
            string = Alert.checkMessage(string, 80, 20);
            stringArray[i] = string = StringUtil.replaceAll(string, "\n", "<br>\n");
        }
        return stringArray;
    }

    public void styleTypeChanged() {
        this.updateStyleCombo(this.charStylesToggle.isSelected());
        this.setStyle(null);
    }

    private void updateStyleCombo(boolean bl) {
        CustomStyles.Entry[] entryArray = this.customStyles.getAll(bl);
        DefaultComboBoxModel<CustomStyles.Entry> defaultComboBoxModel = new DefaultComboBoxModel<CustomStyles.Entry>(entryArray);
        this.styleCombo.setModel(defaultComboBoxModel);
    }

    private void setStyle(String string) {
        CustomStyles.Entry entry = this.selectStyle(string);
        this.doSetStyle(entry);
    }

    private CustomStyles.Entry selectStyle(String string) {
        CustomStyles.Entry entry = null;
        int n = -1;
        ComboBoxModel<CustomStyles.Entry> comboBoxModel = this.styleCombo.getModel();
        int n2 = comboBoxModel.getSize();
        if (string != null) {
            for (int i = 0; i < n2; ++i) {
                CustomStyles.Entry entry2 = (CustomStyles.Entry)comboBoxModel.getElementAt(i);
                if (!entry2.styleName.equals(string)) continue;
                entry = entry2;
                n = i;
                break;
            }
        } else if (n2 > 0) {
            entry = (CustomStyles.Entry)comboBoxModel.getElementAt(0);
            n = 0;
        }
        if (n >= 0) {
            this.selectingStyle = true;
            this.styleCombo.setSelectedIndex(n);
            this.selectingStyle = false;
        }
        return entry;
    }

    public void addStyles() {
        File file = null;
        File file2 = this.customStyles.lastLoadedFile();
        if (file2 != null) {
            file = new File(file2.getParentFile(), "any.docx");
        }
        ChooseFileOptions chooseFileOptions = ConvertPane.getChooseFileOptions();
        chooseFileOptions.setActiveFilter("docx");
        File file3 = ChooseFile.chooseOpenFile(this, file, chooseFileOptions);
        ConvertPane.saveFileChooserSize(chooseFileOptions);
        if (file3 == null) {
            return;
        }
        final File file4 = file3.getAbsoluteFile();
        StyleMappingEditor.runLater(100, new Runnable(){

            @Override
            public void run() {
                if (StyleMappingEditor.this.customStyles.load(file4, StyleMappingEditor.this)) {
                    StyleMappingEditor.this.updateStyleCombo(StyleMappingEditor.this.charStylesToggle.isSelected());
                    StyleMappingEditor.this.setStyle(null);
                }
            }
        });
    }

    private static void runLater(int n, final Runnable runnable) {
        Timer timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void styleChanged() {
        CustomStyles.Entry entry = this.selectedStyle();
        if (entry == null) {
            return;
        }
        this.doSetStyle(entry);
    }

    private CustomStyles.Entry selectedStyle() {
        return (CustomStyles.Entry)this.styleCombo.getSelectedItem();
    }

    private void doSetStyle(CustomStyles.Entry entry) {
        if (entry == null) {
            this.setCSSRuleText(null);
            this.setParaMapping(null);
        } else {
            this.setCSSRuleText(entry.cssRule);
            this.setParaMapping(entry.styleMappingType);
        }
    }

    private void setCSSRuleText(String string) {
        this.cssRuleText.setText(string == null ? "" : string);
        this.cssRuleText.setCaretPosition(0);
    }

    private void setParaMapping(StyleMappingType styleMappingType) {
        this.selectParaMapping(styleMappingType);
        this.paraMappingCombo.setEnabled(styleMappingType != null && styleMappingType != StyleMappingType.CHARACTER_STYLE);
    }

    private void selectParaMapping(StyleMappingType styleMappingType) {
        int n = -1;
        if (styleMappingType != null) {
            n = LabeledValue.indexOfValue(paraMappingValues, (Object)styleMappingType);
        }
        this.paraMappingCombo.setSelectedIndex(n < 0 ? 0 : n);
    }

    @Override
    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void ok() {
        String string;
        String[] stringArray;
        StyleMappingType styleMappingType;
        if (this.charStylesToggle.isSelected()) {
            styleMappingType = StyleMappingType.CHARACTER_STYLE;
        } else {
            styleMappingType = this.selectedParaMapping();
            if (styleMappingType == null) {
                StyleMappingEditor.badComboBox(this.paraMappingCombo);
                return;
            }
        }
        CustomStyles.Entry entry = this.selectedStyle();
        if (entry == null) {
            StyleMappingEditor.badComboBox(this.styleCombo);
            return;
        }
        String string2 = entry.styleName;
        String string3 = this.elementQNameField.getText().trim();
        if (!XMLText.isNCName(string3)) {
            if (string3.length() > 0) {
                Alert.showError(this, Msg.msg("SME.notAnNCName", string3));
            }
            DialogUtil.badField(this.elementQNameField);
            return;
        }
        if (this.checkElement) {
            stringArray = Name.get(Namespace.XHTML, string3);
            if (!HTMLElements.has((Name)stringArray)) {
                Alert.showError(this, Msg.msg("SME.notAnXHTMLElement", string3));
                DialogUtil.badField(this.elementQNameField);
                return;
            }
            Name name = null;
            string = null;
            switch (styleMappingType) {
                case PARAGRAPH_STYLE_N_TO_1: {
                    name = Name.get(Namespace.XHTML, "p");
                    string = "div";
                    break;
                }
                case PARAGRAPH_STYLE_N_TO_PRE: {
                    name = Name.get(Namespace.XHTML, "span");
                    string = "pre";
                }
            }
            if (name != null && !HTMLElements.mayContain((Name)stringArray, name)) {
                Alert.showError(this, Msg.msg("SME.invalidGroupContainer", string2, name.localPart, string, string3));
                DialogUtil.badField(this.elementQNameField);
                return;
            }
        }
        stringArray = null;
        for (int i = 0; i < 6; i += 2) {
            string = this.attributeFields[i].getText().trim();
            if (string.length() == 0) continue;
            if (!XMLText.isName(string)) {
                Alert.showError(this, Msg.msg("SME.notAName", string));
                DialogUtil.badField(this.attributeFields[i]);
                return;
            }
            String string4 = this.attributeFields[i + 1].getText().trim();
            if (string4.length() == 0) {
                DialogUtil.badField(this.attributeFields[i + 1]);
                return;
            }
            if (stringArray == null) {
                stringArray = new String[]{string, string4};
                continue;
            }
            stringArray = StringList.append(stringArray, string);
            stringArray = StringList.append(stringArray, string4);
        }
        this.customStyles.put(string2, styleMappingType);
        this.result = new OptionsWizardState.StyleMapping(styleMappingType, string2, string3, stringArray);
        this.setVisible(false);
        this.dispose();
    }

    private StyleMappingType selectedParaMapping() {
        LabeledValue labeledValue = (LabeledValue)this.paraMappingCombo.getSelectedItem();
        return labeledValue == null ? null : (StyleMappingType)((Object)labeledValue.value);
    }

    private static void badComboBox(JComboBox<?> jComboBox) {
        jComboBox.getToolkit().beep();
        jComboBox.requestFocus();
    }

    public OptionsWizardState.StyleMapping edit(final OptionsWizardState.StyleMapping styleMapping, final CustomStyles customStyles, final File file, boolean bl) {
        assert (customStyles != null);
        this.customStyles = customStyles;
        this.checkElement = bl;
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.charStylesToggle.requestFocus();
        this.result = null;
        StyleMappingEditor.runLater(250, new Runnable(){

            @Override
            public void run() {
                StyleMappingEditor.this.fillForm(styleMapping, customStyles, file);
            }
        });
        this.setVisible(true);
        return this.result;
    }

    private void fillForm(OptionsWizardState.StyleMapping styleMapping, CustomStyles customStyles, File file) {
        if (file != null && !customStyles.getLoadedFiles().contains(file)) {
            customStyles.load(file, this);
        }
        boolean bl = true;
        String string = null;
        if (styleMapping != null && styleMapping.type != null) {
            bl = styleMapping.type == StyleMappingType.CHARACTER_STYLE;
            string = styleMapping.styleName;
            if (string != null) {
                customStyles.put(string, styleMapping.type);
            }
        }
        if (bl) {
            this.charStylesToggle.setSelected(true);
        } else {
            this.paraStylesToggle.setSelected(true);
        }
        this.updateStyleCombo(bl);
        this.setStyle(string);
        if (styleMapping != null) {
            if (styleMapping.elementQName != null) {
                this.elementQNameField.setText(styleMapping.elementQName);
            }
            if (styleMapping.attributes != null) {
                int n = Math.min(6, styleMapping.attributes.length);
                for (int i = 0; i < n; i += 2) {
                    this.attributeFields[i].setText(styleMapping.attributes[i]);
                    this.attributeFields[i + 1].setText(styleMapping.attributes[i + 1]);
                }
            }
        }
    }

    private static final class StyleRenderer
    extends DefaultListCellRenderer {
        private String localNameColor;

        private StyleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof CustomStyles.Entry) {
                CustomStyles.Entry entry = (CustomStyles.Entry)object;
                StringBuilder stringBuilder = new StringBuilder("<html><span>");
                String string = entry.styleName;
                if (string.length() > 100) {
                    string = StringUtil.shortenText(string, 100);
                }
                XMLText.escapeXML(string, stringBuilder);
                String string2 = entry.localStyleName;
                if (string2 != null && string.length() <= 50) {
                    if (string2.length() > 50) {
                        string2 = StringUtil.shortenText(string2, 50);
                    }
                    stringBuilder.append("</span>&#xA0;&#xA0;&#xA0;&#xA0;");
                    stringBuilder.append("<b style='font-size: 90%; color: ");
                    if (this.localNameColor == null) {
                        Color color = jList.getBackground();
                        color = AWTUtil.editHSB(color, 240, 0.3f, -0.5f, true);
                        this.localNameColor = AWTUtil.toHexString(color);
                    }
                    stringBuilder.append(this.localNameColor);
                    stringBuilder.append(";'>");
                    XMLText.quoteXML(string2, stringBuilder);
                    stringBuilder.append("</b>");
                }
                object = stringBuilder.toString();
            }
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

