/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.processor.HTMLElements;
import com.xmlmind.w2x_app.CustomStyles;
import com.xmlmind.w2x_app.OutputFormat;
import com.xmlmind.w2x_app.StyleMappingType;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

final class OptionsWizardState {
    public CustomStyles customStyles;
    public File inputFile;
    public OutputFormat outputFormat;
    public Option[] options;
    public StyleMapping[] styleMappings;
    public String[] otherParameters;
    public File saveFile;

    public Option getOption(String string) {
        if (this.options != null) {
            for (Option option : this.options) {
                if (!option.name.equals(string)) continue;
                return option;
            }
        }
        return null;
    }

    public File getSuggestedSaveFile() {
        File file = this.saveFile;
        if (file == null && this.outputFormat != null) {
            File file2 = null;
            if (this.inputFile != null) {
                file2 = this.inputFile.getParentFile();
            }
            if (file2 == null) {
                file2 = SystemUtil.homeDir();
            }
            file = new File(file2, this.outputFormat.name + "_options.txt").getAbsoluteFile();
        }
        return file;
    }

    public static OptionsWizardState load(File file) throws IOException {
        String[] stringArray;
        String string = FileUtil.loadString(file, "UTF-8");
        OutputFormat outputFormat = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        String[] stringArray2 = StringUtil.EMPTY_LIST;
        for (String string2 : stringArray = StringUtil.split(string, '\n')) {
            Object object;
            if ((string2 = string2.trim()).startsWith("###outputFormat")) {
                if (outputFormat != null) {
                    System.err.println("'" + string2 + "', duplicate outputFormat");
                    return null;
                }
                object = string2.substring(15).trim();
                outputFormat = OutputFormat.get((String)object);
                if (outputFormat != null) continue;
                System.err.println("'" + string2 + "', unknown outputFormat");
                return null;
            }
            if (string2.startsWith("###option")) {
                object = Option.fromString(string2.substring(3));
                if (object == null) {
                    System.err.println("'" + string2 + "', invalid option");
                    return null;
                }
                if (outputFormat == null) {
                    System.err.println("'" + string2 + "', missing outputFormat");
                    return null;
                }
                if (object.value != null && outputFormat.getOption(object.name) != null) {
                    arrayList.add((String[])object);
                    continue;
                }
                System.err.println("ignoring option '" + string2 + "'");
                continue;
            }
            if (string2.startsWith("###styleMapping")) {
                object = StyleMapping.fromString(string2.substring(3));
                if (object == null) {
                    System.err.println("'" + string2 + "', invalid styleMapping");
                    return null;
                }
                if (outputFormat == null) {
                    System.err.println("'" + string2 + "', missing outputFormat");
                    return null;
                }
                if (outputFormat.hasStyleMapping) {
                    arrayList2.add((String[])object);
                    continue;
                }
                System.err.println("ignoring styleMapping '" + string2 + "'");
                continue;
            }
            if (!string2.startsWith("###otherParameter")) continue;
            object = OptionsWizardState.splitOtherParameters(string2.substring(17));
            if (object == null) {
                System.err.println("'" + string2 + "', invalid otherParameter");
                continue;
            }
            stringArray2 = ArrayUtil.insert(stringArray2, stringArray2.length, object);
        }
        if (outputFormat == null) {
            return null;
        }
        OptionsWizardState optionsWizardState = new OptionsWizardState();
        optionsWizardState.outputFormat = outputFormat;
        if (arrayList.size() > 0) {
            optionsWizardState.options = new Option[arrayList.size()];
            arrayList.toArray(optionsWizardState.options);
        }
        if (arrayList2.size() > 0) {
            optionsWizardState.styleMappings = new StyleMapping[arrayList2.size()];
            arrayList2.toArray(optionsWizardState.styleMappings);
        }
        if (stringArray2.length > 0) {
            optionsWizardState.otherParameters = stringArray2;
        }
        optionsWizardState.saveFile = file;
        return optionsWizardState;
    }

    public static String[] splitOtherParameters(String string) {
        String[] stringArray;
        String[] stringArray2 = null;
        if (string != null && (string = string.trim()).length() > 0 && (stringArray = StringUtil.splitArguments(string)).length > 0 && stringArray.length % 3 == 0) {
            stringArray2 = stringArray;
            for (int i = 0; i < stringArray.length; i += 3) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                if (("-p".equals(string2) || "-pu".equals(string2)) && string3.equals(string3.trim()) && string3.length() != 0) continue;
                stringArray2 = null;
                break;
            }
        }
        return stringArray2;
    }

    public void save() throws IllegalStateException, RuntimeException, IOException {
        File file;
        Object object;
        CharSequence charSequence;
        Object object2;
        if (this.outputFormat == null || this.saveFile == null) {
            throw new IllegalStateException();
        }
        String string = System.getProperty("line.separator");
        if (string == null) {
            string = "\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# AUTOMATICALLY CREATED BY w2x-app SETUP ASSISTANT.");
        stringBuilder.append(" PLEASE DO NOT EDIT BY HAND!");
        stringBuilder.append(string);
        stringBuilder.append("###outputFormat ");
        stringBuilder.append(this.outputFormat.name);
        stringBuilder.append(string);
        if (this.options != null) {
            for (Option object32 : this.options) {
                stringBuilder.append("###");
                stringBuilder.append(object32);
                stringBuilder.append(string);
            }
        }
        if (this.styleMappings != null) {
            for (StyleMapping styleMapping : this.styleMappings) {
                stringBuilder.append("###");
                stringBuilder.append(styleMapping);
                stringBuilder.append(string);
            }
        }
        if (this.otherParameters != null) {
            OptionsWizardState.joinOtherParameters("###otherParameter ", this.otherParameters, string, stringBuilder);
            stringBuilder.append(string);
        }
        stringBuilder.append(string);
        stringBuilder.append("-o ");
        stringBuilder.append(this.outputFormat.name);
        stringBuilder.append(string);
        if (this.otherParameters != null) {
            OptionsWizardState.joinOtherParameters(null, this.otherParameters, string, stringBuilder);
            stringBuilder.append(string);
        }
        if (this.options != null) {
            for (Option option : this.options) {
                object2 = this.outputFormat.getOption(option.name);
                if (object2 == null) {
                    throw new RuntimeException("internal error: '" + option.name + "', unknown output format option");
                }
                if (option.value == null || option.value.equals(((OutputFormat.Option)object2).defaultValue)) continue;
                charSequence = ((OutputFormat.Option)object2).parameterTemplate;
                if (((String)charSequence).startsWith("if(%V=")) {
                    int n = ((String)charSequence).indexOf(41, 6);
                    if (n < 0) {
                        throw new RuntimeException("internal error: {" + String.valueOf(object2) + "} invalid output format option");
                    }
                    object = ((String)charSequence).substring(6, n).trim();
                    charSequence = option.value.equals(object) ? ((String)charSequence).substring(n + 1).trim() : null;
                }
                if (charSequence == null) continue;
                charSequence = StringUtil.replaceAll((String)charSequence, "%V", StringUtil.quoteArgument(option.value));
                stringBuilder.append((String)charSequence);
                stringBuilder.append(string);
            }
        }
        boolean bl = false;
        File file2 = OptionsWizardState.getTransformFile(this.saveFile);
        File file22 = file2.getParentFile();
        if (this.styleMappings != null) {
            for (StyleMapping styleMapping : this.styleMappings) {
                if (!styleMapping.needsTransform(this.outputFormat.stylesheetTemplate, this.outputFormat.targetNamespace)) continue;
                bl = true;
                break;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            object2 = new StringBuilder();
            charSequence = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            block10: for (StyleMapping styleMapping : this.styleMappings) {
                String string2 = styleMapping.getXEDParameterValue(this.outputFormat.stylesheetTemplate, this.outputFormat.targetNamespace);
                switch (styleMapping.type) {
                    case CHARACTER_STYLE: {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(" ! ");
                        }
                        stringBuilder2.append(styleMapping.styleName);
                        stringBuilder2.append(' ');
                        stringBuilder2.append(string2);
                        continue block10;
                    }
                    case PARAGRAPH_STYLE_N_TO_PRE: {
                        if (((StringBuilder)charSequence).length() > 0) {
                            ((StringBuilder)charSequence).append(' ');
                        }
                        ((StringBuilder)charSequence).append(styleMapping.styleName);
                    }
                    case PARAGRAPH_STYLE: 
                    case PARAGRAPH_STYLE_N_TO_1: {
                        if (((StringBuilder)object2).length() > 0) {
                            ((StringBuilder)object2).append(" ! ");
                        }
                        ((StringBuilder)object2).append(styleMapping.styleName);
                        ((StringBuilder)object2).append(' ');
                        ((StringBuilder)object2).append(string2);
                        continue block10;
                    }
                    case PARAGRAPH_STYLE_1_TO_PRE: {
                        if (stringBuilder3.length() > 0) {
                            stringBuilder3.append(" ! ");
                        }
                        stringBuilder3.append(styleMapping.styleName);
                        stringBuilder3.append(' ');
                        stringBuilder3.append(string2);
                    }
                }
            }
            if (((StringBuilder)charSequence).length() > 0) {
                stringBuilder.append("-p edit.prune.preserve \"");
                stringBuilder.append(((StringBuilder)charSequence).toString());
                stringBuilder.append('\"');
                stringBuilder.append(string);
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder.append("-p edit.inlines.convert \"");
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder.append('\"');
                stringBuilder.append(string);
            }
            if (((StringBuilder)object2).length() > 0) {
                stringBuilder.append("-p edit.blocks.convert \"");
                stringBuilder.append(((StringBuilder)object2).toString());
                stringBuilder.append('\"');
                stringBuilder.append(string);
            }
            if (stringBuilder3.length() > 0) {
                stringBuilder.append("-p edit.blocks.convert-to-pre \"");
                stringBuilder.append(stringBuilder3.toString());
                stringBuilder.append('\"');
                stringBuilder.append(string);
            }
            if (bl) {
                stringBuilder.append("-t ");
                stringBuilder.append(URIComponent.quotePath(file22.getName()));
                stringBuilder.append('/');
                stringBuilder.append(URIComponent.quotePath(file2.getName()));
                stringBuilder.append(string);
            }
        }
        if (!(file = this.saveFile.getParentFile()).isDirectory()) {
            FileUtil.checkedMkdirs(file);
        }
        FileUtil.saveString(stringBuilder.toString(), this.saveFile, "UTF-8");
        if (file22.exists()) {
            FileUtil.deleteFileOrDir(file22);
        }
        if (bl) {
            if (!file22.isDirectory()) {
                FileUtil.checkedMkdir(file22);
            }
            stringBuilder = new StringBuilder(this.outputFormat.stylesheetTemplate);
            int n = this.outputFormat.stylesheetTemplate.indexOf("</xsl:stylesheet>");
            if (n <= 0) {
                throw new RuntimeException("internal error: {" + String.valueOf(this.outputFormat) + "} invalid output format");
            }
            for (int i = this.styleMappings.length - 1; i >= 0; --i) {
                StyleMapping styleMapping = this.styleMappings[i];
                if (!styleMapping.needsTransform(this.outputFormat.stylesheetTemplate, this.outputFormat.targetNamespace)) continue;
                object = this.outputFormat.ruleTemplate;
                if (((String)(object = StringUtil.replaceAll((String)object, "%{MATCHED_XHTML_ELEMENT}", styleMapping.getXSLTPattern()))).indexOf("%{TARGET_START_TAG}") >= 0) {
                    object = StringUtil.replaceAll((String)object, "%{TARGET_START_TAG}", styleMapping.getXSLTStartTag());
                    object = StringUtil.replaceAll((String)object, "%{TARGET_END_TAG}", styleMapping.elementQName);
                } else {
                    object = StringUtil.replaceAll((String)object, "%{DYNAMIC_TARGET_ELEMENT}", styleMapping.getXSLTDynamicElement());
                }
                stringBuilder.insert(n, "\n\n");
                stringBuilder.insert(n, (String)object);
            }
            String string3 = stringBuilder.toString();
            if (!"\n".equals(string)) {
                string3 = StringUtil.replaceAll(string3, "\n", string);
            }
            FileUtil.saveString(string3, file2, "UTF-8");
        }
    }

    public static void joinOtherParameters(String string, String[] stringArray, String string2, StringBuilder stringBuilder) {
        int n = stringArray.length / 3 * 3;
        for (int i = 0; i < n; i += 3) {
            if (i > 0) {
                stringBuilder.append(string2);
            }
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(StringUtil.quoteArgument(stringArray[i]));
            stringBuilder.append(' ');
            stringBuilder.append(StringUtil.quoteArgument(stringArray[i + 1]));
            stringBuilder.append(' ');
            stringBuilder.append(StringUtil.quoteArgument(stringArray[i + 2]));
        }
    }

    private static File getTransformFile(File file) {
        Object object = file.getName();
        int n = ((String)object).lastIndexOf(46);
        object = n > 0 ? ((String)object).substring(0, n) + "_scripts" : (String)object + "_scripts";
        File file2 = new File(file.getParentFile(), (String)object);
        return new File(file2, "custom_transform.xslt");
    }

    public static final class StyleMapping {
        public final StyleMappingType type;
        public final String styleName;
        public final String elementQName;
        public final String[] attributes;

        public StyleMapping(StyleMappingType styleMappingType, String string, String string2, String[] stringArray) {
            this.type = styleMappingType;
            this.styleName = string;
            this.elementQName = string2;
            this.attributes = stringArray;
        }

        public static StyleMapping fromString(String string) {
            String string2;
            if (!string.startsWith("styleMapping ")) {
                System.err.println("'" + string + "', not a styleMapping");
                return null;
            }
            int n = 13;
            int n2 = string.indexOf(32, n);
            if (n2 < 0) {
                System.err.println("'" + string + "', missing mapping type");
                return null;
            }
            StyleMappingType styleMappingType = StyleMappingType.fromString(string.substring(n, n2));
            if (styleMappingType == null) {
                System.err.println("'" + string + "', invalid mapping type");
                return null;
            }
            n = n2 + 1;
            if ((n2 = string.indexOf(32, n)) < 0) {
                System.err.println("'" + string + "', missing style name");
                return null;
            }
            String string3 = string.substring(n, n2);
            if (!CustomStyles.checkEntry(string3, styleMappingType)) {
                System.err.println("'" + string3 + "', invalid style name");
                return null;
            }
            n = n2 + 1;
            if ((n2 = string.indexOf(32, n)) < 0) {
                n2 = string.length();
            }
            if (!XMLText.isNCName(string2 = string.substring(n, n2))) {
                System.err.println("'" + string + "', invalid element name");
                return null;
            }
            String[] stringArray = null;
            if (n2 < string.length() && (string = string.substring(n = n2 + 1).trim()).length() > 0) {
                stringArray = ProcessingInstruction.parsePseudoAttributes(string);
                if (stringArray == null) {
                    System.err.println("'" + string + "', invalid attributes");
                    return null;
                }
                int n3 = stringArray.length;
                if (n3 == 0) {
                    stringArray = null;
                } else {
                    for (int i = 0; i < n3; i += 2) {
                        stringArray[i + 1] = XMLText.unescapeXML(stringArray[i + 1]);
                    }
                }
            }
            return new StyleMapping(styleMappingType, string3, string2, stringArray);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append("styleMapping ");
            stringBuilder.append((Object)this.type);
            stringBuilder.append(' ');
            stringBuilder.append(this.styleName);
            stringBuilder.append(' ');
            stringBuilder.append(this.getStartTag("\""));
        }

        public String getXEDParameterValue(String string, Namespace namespace) {
            boolean bl = this.needsTransform(string, namespace);
            Object object = null;
            switch (this.type) {
                case CHARACTER_STYLE: {
                    if (bl) {
                        object = "span class='" + this.styleName + "'";
                        break;
                    }
                    object = this.getStartTag("'");
                    break;
                }
                case PARAGRAPH_STYLE: {
                    if (bl) {
                        object = "p class='" + this.styleName + "'";
                        break;
                    }
                    object = this.getStartTag("'");
                    break;
                }
                case PARAGRAPH_STYLE_N_TO_1: {
                    if (bl) {
                        object = "p g:id='" + this.styleName + "' g:container='div class=\\\"" + this.styleName + "\\\"'";
                        break;
                    }
                    object = "p g:id='" + this.styleName + "' g:container='" + this.getStartTag("\\\"") + "'";
                    break;
                }
                case PARAGRAPH_STYLE_N_TO_PRE: {
                    if (bl) {
                        object = "span g:id='" + this.styleName + "' g:container='pre class=\\\"" + this.styleName + "\\\"'";
                        break;
                    }
                    object = "span g:id='" + this.styleName + "' g:container='" + this.getStartTag("\\\"") + "'";
                    break;
                }
                case PARAGRAPH_STYLE_1_TO_PRE: {
                    object = bl ? "pre class='" + this.styleName + "'" : this.getStartTag("'");
                }
            }
            return object;
        }

        public boolean needsTransform(String string, Namespace namespace) {
            return string != null && (namespace != Namespace.XHTML || !HTMLElements.has(Name.get(Namespace.XHTML, this.elementQName)));
        }

        private String getStartTag(String string) {
            if (this.attributes == null) {
                return this.elementQName;
            }
            StringBuilder stringBuilder = new StringBuilder(this.elementQName);
            int n = this.attributes.length;
            for (int i = 0; i < n; i += 2) {
                String string2 = this.attributes[i];
                String string3 = this.attributes[i + 1];
                stringBuilder.append(' ');
                stringBuilder.append(string2);
                stringBuilder.append('=');
                stringBuilder.append(string);
                XMLText.escapeXML(string3, stringBuilder);
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        public String getXSLTPattern() {
            String string = null;
            switch (this.type) {
                case CHARACTER_STYLE: {
                    string = "h:span[@class='" + this.styleName + "']";
                    break;
                }
                case PARAGRAPH_STYLE: {
                    string = "h:p[@class='" + this.styleName + "']";
                    break;
                }
                case PARAGRAPH_STYLE_N_TO_1: {
                    string = "h:div[@class='" + this.styleName + "']";
                    break;
                }
                case PARAGRAPH_STYLE_N_TO_PRE: 
                case PARAGRAPH_STYLE_1_TO_PRE: {
                    string = "h:pre[@class='" + this.styleName + "']";
                }
            }
            return string;
        }

        public String getXSLTStartTag() {
            return this.getStartTag("\"");
        }

        public String getXSLTDynamicElement() {
            StringBuilder stringBuilder = new StringBuilder("<xsl:element name=\"");
            stringBuilder.append(this.elementQName);
            stringBuilder.append("\">");
            if (this.attributes != null) {
                int n = this.attributes.length;
                for (int i = 0; i < n; i += 2) {
                    String string = this.attributes[i];
                    String string2 = this.attributes[i + 1];
                    stringBuilder.append("\n    <xsl:attribute name=\"");
                    stringBuilder.append(string);
                    stringBuilder.append("\">");
                    XMLText.escapeXML(string2, stringBuilder);
                    stringBuilder.append("</xsl:attribute>");
                }
            }
            return stringBuilder.toString();
        }
    }

    public static final class Option {
        public final String name;
        public final String value;

        public Option(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public static Option fromString(String string) {
            if (!string.startsWith("option ")) {
                return null;
            }
            int n = 7;
            int n2 = string.indexOf(32, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            String string3 = null;
            if (n2 < string.length() && (string3 = string.substring(n = n2 + 1).trim()).length() == 0) {
                string3 = null;
            }
            return new Option(string2, string3);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append("option ");
            stringBuilder.append(this.name);
            if (this.value != null) {
                stringBuilder.append(' ');
                stringBuilder.append(this.value);
            }
        }
    }
}

