/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Alert;
import com.xmlmind.guiutil.ChooseFile;
import com.xmlmind.guiutil.ChooseFileOptions;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.HintLabel;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Wizard;
import com.xmlmind.guiutil.ZebraCellRenderer;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x_app.ConvertPane;
import com.xmlmind.w2x_app.Msg;
import com.xmlmind.w2x_app.OptionsWizardState;
import com.xmlmind.w2x_app.OutputFormat;
import com.xmlmind.w2x_app.StyleMappingEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;

public class OptionsWizard
extends Wizard
implements ListSelectionListener {
    public final OptionsWizardState state;
    private Font normalFont;
    private JComboBox<String> categoryCombo;
    private JComboBox<String> subCategoryCombo;
    private JPanel optionsForm;
    private JComponent[] optionFields;
    private String optionFieldsFor;
    private StyleMappingModel styleMappingModel;
    private JTable styleMappingTable;
    private JButton addStyleMappingButton;
    private JButton editStyleMappingButton;
    private JButton removeStyleMappingButton;
    private JTextArea otherParametersText;
    private JTextField saveFileField;
    private JEditorPane reviewHTML;
    private JTextArea savingText;
    private JTextArea finishText;
    private String saveError;
    private static final int SCREEN_OUTPUT_FORMAT = 0;
    private static final int SCREEN_OPTIONS = 1;
    private static final int SCREEN_STYLE_MAPPING = 2;
    private static final int SCREEN_USER_PARAMETERS = 3;
    private static final int SCREEN_SAVE_FILE = 4;
    private static final int SCREEN_REVIEW = 5;
    private static final int SCREEN_SAVING_FILE = 6;
    private static final int SCREEN_FINISH = 7;

    public OptionsWizard(Component component, OptionsWizardState optionsWizardState) {
        super(component);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.state = optionsWizardState;
        this.setTitle(Msg.msg("OW.title"));
        this.initialize(3);
    }

    @Override
    protected void addAllScreens() {
        this.setHeaderDefaultIcon(new IconResource(OptionsWizard.class, "options_wizard_icon.png"));
        this.normalFont = UIManager.getFont("TextField.font");
        Wizard.Screen screen = new Wizard.Screen(this, this.outputFormatForm(), Msg.msg("OW.outputFormatScreen.title"), null);
        screen.setHelpId("options_wizard_format_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.optionsForm(), Msg.msg("OW.optionsScreen.title"), null);
        screen.setHelpId("options_wizard_options_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.styleMappingForm(), Msg.msg("OW.styleMappingScreen.title"), null);
        screen.setHelpId("options_wizard_style_mapping_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.otherParametersForm(), Msg.msg("OW.otherParametersScreen.title"), null);
        screen.setHelpId("options_wizard_other_parameters_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.saveFileForm(), Msg.msg("OW.saveFileScreen.title"), null);
        screen.setHelpId("options_wizard_save_file_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.reviewForm(), Msg.msg("OW.reviewScreen.title"), null);
        screen.setHelpId("options_wizard_review_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.savingFileForm(), Msg.msg("OW.savingFileScreen.title"), null);
        screen.setHelpId("options_wizard_saving_file_screen");
        this.addScreen(screen);
        screen = new Wizard.Screen(this, this.finishForm(), Msg.msg("OW.finishScreen.title"), null);
        screen.setHelpId("options_wizard_finish_screen");
        this.addScreen(screen);
    }

    private JPanel outputFormatForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        String[] stringArray = OutputFormat.getCategories();
        this.categoryCombo = new JComboBox<String>(stringArray);
        this.categoryCombo.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add(this.categoryCombo, DialogUtil.px(gridBagConstraints));
        String[] stringArray2 = OutputFormat.getSubCategories(stringArray[0]);
        this.subCategoryCombo = new JComboBox<String>(stringArray2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 5;
        jPanel.add(this.subCategoryCombo, DialogUtil.px(gridBagConstraints));
        this.categoryCombo.setActionCommand("categorySelected");
        return jPanel;
    }

    public void categorySelected() {
        String string = (String)this.categoryCombo.getSelectedItem();
        if (string != null) {
            String[] stringArray = OutputFormat.getSubCategories(string);
            this.subCategoryCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        }
    }

    private JPanel optionsForm() {
        this.optionsForm = new JPanel(new GridBagLayout());
        OutputFormat outputFormat = this.state.outputFormat;
        if (outputFormat == null) {
            String[] stringArray = OutputFormat.getCategories();
            String[] stringArray2 = OutputFormat.getSubCategories(stringArray[0]);
            outputFormat = OutputFormat.get(stringArray[0], stringArray2[0]);
        }
        this.populateOptionsForm(outputFormat);
        return this.optionsForm;
    }

    private void populateOptionsForm(OutputFormat outputFormat) {
        this.optionsForm.removeAll();
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        OutputFormat.Option[] optionArray = outputFormat.options;
        for (int i = 0; i < optionArray.length; ++i) {
            Component component;
            JComponent jComponent;
            OutputFormat.Option option = optionArray[i];
            JComponent jComponent2 = null;
            if (option.type == OutputFormat.OptionType.YES_NO) {
                jComponent2 = jComponent = new JCheckBox(option.label);
            } else {
                jComponent = new JLabel(option.label);
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            if (i > 0) {
                gridBagConstraints.insets.top = 20;
            }
            this.optionsForm.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
            gridBagConstraints.insets.top = 2;
            switch (option.type) {
                case STRING: 
                case ID: 
                case SAVE_FILE_URI: 
                case SAVE_DIRECTORY_URI: {
                    jComponent2 = new JTextField(40);
                    ++gridBagConstraints.gridy;
                    this.optionsForm.add((Component)jComponent2, DialogUtil.px(gridBagConstraints));
                    break;
                }
                case ENUMERATED_VALUES: {
                    jComponent2 = new JComboBox<String>(option.enumeratedValues);
                    ++gridBagConstraints.gridy;
                    this.optionsForm.add((Component)jComponent2, DialogUtil.px(gridBagConstraints));
                    break;
                }
                case OPEN_FILE_PATH: {
                    component = new JTextField(40);
                    jComponent2 = component;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridwidth = 1;
                    this.optionsForm.add((Component)jComponent2, DialogUtil.px(gridBagConstraints));
                    IconResource iconResource = new IconResource(OptionsWizard.class, "browse.png");
                    JButton jButton = new JButton(iconResource);
                    jButton.setDisabledIcon(iconResource);
                    DialogUtil.setIconic(jButton);
                    jButton.setToolTipText(Msg.msg("OW.chooseOpenFile"));
                    jButton.addActionListener(new ActionListener((JTextField)component){
                        final /* synthetic */ JTextField val$openFileField;
                        {
                            this.val$openFileField = jTextField;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            OptionsWizard.this.chooseOpenFile(this.val$openFileField);
                        }
                    });
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.insets.left = 2;
                    this.optionsForm.add((Component)jButton, DialogUtil.px(gridBagConstraints));
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridwidth = 2;
                    gridBagConstraints.insets.left = 0;
                }
            }
            arrayList.add((JCheckBox)jComponent2);
            if (option.hint == null) continue;
            component = new HintLabel(Alert.checkMessage(option.hint, 80, 50));
            ++gridBagConstraints.gridy;
            this.optionsForm.add(component, DialogUtil.px(gridBagConstraints));
        }
        this.optionFields = new JComponent[arrayList.size()];
        arrayList.toArray(this.optionFields);
        this.optionFieldsFor = outputFormat.name;
    }

    private void chooseOpenFile(JTextField jTextField) {
        String string;
        File file = null;
        String string2 = jTextField.getText().trim();
        if (string2.length() == 0 && this.state.inputFile != null) {
            file = new File(this.state.inputFile.getParentFile(), "any");
        }
        if (file == null && string2.length() > 0) {
            file = new File(string2);
        }
        ChooseFileOptions chooseFileOptions = ConvertPane.getChooseFileOptions();
        chooseFileOptions.addFilter("css");
        chooseFileOptions.addFilter("png");
        chooseFileOptions.addFilter(new String[]{"jpg", "jpeg"});
        if (file != null && (string = FileUtil.getExtension(file)) != null) {
            chooseFileOptions.setActiveFilter(string.toLowerCase());
        }
        File file2 = ChooseFile.chooseOpenFile(this, file, chooseFileOptions);
        ConvertPane.saveFileChooserSize(chooseFileOptions);
        if (file2 == null) {
            return;
        }
        file2 = file2.getAbsoluteFile();
        jTextField.setText(file2.getPath());
    }

    private JPanel styleMappingForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.styleMappingModel = new StyleMappingModel();
        this.styleMappingTable = new JTable(this.styleMappingModel);
        this.styleMappingTable.setRowSelectionAllowed(true);
        this.styleMappingTable.setColumnSelectionAllowed(false);
        this.styleMappingTable.setSelectionMode(0);
        this.styleMappingTable.setShowGrid(true);
        DialogUtil.adjustRowHeight(this.styleMappingTable, 0);
        this.styleMappingTable.getSelectionModel().addListSelectionListener(this);
        this.styleMappingTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    OptionsWizard.this.editStyleMapping();
                }
            }
        });
        TableColumnModel tableColumnModel = this.styleMappingTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        String string = Msg.msg("OW.styleMapping.type");
        tableColumn.setHeaderValue(string);
        FontMetrics fontMetrics = this.styleMappingTable.getFontMetrics(this.styleMappingTable.getFont());
        int n = AWTUtil.px(5);
        int n2 = Math.max(fontMetrics.stringWidth(string) + n, 20 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n2);
        tableColumn.setResizable(true);
        ZebraCellRenderer zebraCellRenderer = new ZebraCellRenderer();
        tableColumn.setCellRenderer(zebraCellRenderer);
        tableColumn = tableColumnModel.getColumn(1);
        string = Msg.msg("OW.styleMapping.styleName");
        tableColumn.setHeaderValue(string);
        int n3 = Math.max(fontMetrics.stringWidth(string) + n, 25 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n3);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(zebraCellRenderer);
        tableColumn = tableColumnModel.getColumn(2);
        string = Msg.msg("OW.styleMapping.targetElement");
        tableColumn.setHeaderValue(string);
        int n4 = Math.max(fontMetrics.stringWidth(string) + n, 40 * fontMetrics.charWidth('x'));
        tableColumn.setPreferredWidth(n4);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(zebraCellRenderer);
        JScrollPane jScrollPane = DialogUtil.createScrollPane(this.styleMappingTable);
        n = AWTUtil.px(2);
        jScrollPane.setPreferredSize(new Dimension(n + n2 + n + n3 + n + n4 + n, n + 10 * (fontMetrics.getHeight() + n)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(OptionsWizard.class, "add.png");
        this.addStyleMappingButton = new JButton(Msg.msg("OW.add"), iconResource);
        this.addStyleMappingButton.setDisabledIcon(iconResource);
        this.addStyleMappingButton.addActionListener(this);
        this.addStyleMappingButton.setActionCommand("addStyleMapping");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.addStyleMappingButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(OptionsWizard.class, "edit.png");
        this.editStyleMappingButton = new JButton(Msg.msg("OW.edit"), iconResource);
        this.editStyleMappingButton.setDisabledIcon(iconResource);
        this.editStyleMappingButton.addActionListener(this);
        this.editStyleMappingButton.setActionCommand("editStyleMapping");
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.editStyleMappingButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(OptionsWizard.class, "remove.png");
        this.removeStyleMappingButton = new JButton(Msg.msg("OW.remove"), iconResource);
        this.removeStyleMappingButton.setDisabledIcon(iconResource);
        this.removeStyleMappingButton.addActionListener(this);
        this.removeStyleMappingButton.setActionCommand("removeStyleMapping");
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.removeStyleMappingButton, DialogUtil.px(gridBagConstraints));
        this.valueChanged(null);
        return jPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.styleMappingTable.getSelectedRow() >= 0;
        this.editStyleMappingButton.setEnabled(bl);
        this.removeStyleMappingButton.setEnabled(bl);
    }

    public void addStyleMapping() {
        OptionsWizardState.StyleMapping styleMapping = this.styleMappingModel.get(this.styleMappingTable.getSelectedRow());
        if (styleMapping != null) {
            styleMapping = new OptionsWizardState.StyleMapping(styleMapping.type, null, null, null);
        }
        this.addOrEditStyleMapping(styleMapping);
    }

    public void editStyleMapping() {
        OptionsWizardState.StyleMapping styleMapping = this.styleMappingModel.get(this.styleMappingTable.getSelectedRow());
        if (styleMapping == null) {
            return;
        }
        this.addOrEditStyleMapping(styleMapping);
    }

    private void addOrEditStyleMapping(OptionsWizardState.StyleMapping styleMapping) {
        StyleMappingEditor styleMappingEditor = new StyleMappingEditor((Component)this, DialogUtil.dialogTitle(styleMapping == null || styleMapping.elementQName == null ? Msg.msg("OW.add") : Msg.msg("OW.edit")));
        if ((styleMapping = styleMappingEditor.edit(styleMapping, this.state.customStyles, this.state.inputFile, this.state.outputFormat.stylesheetTemplate == null)) == null) {
            return;
        }
        int n = -1;
        OptionsWizardState.StyleMapping[] styleMappingArray = this.styleMappingModel.getList();
        for (int i = 0; i < styleMappingArray.length; ++i) {
            if (!styleMappingArray[i].styleName.equals(styleMapping.styleName)) continue;
            n = i;
        }
        if (n < 0) {
            n = styleMappingArray.length;
            styleMappingArray = ArrayUtil.append(styleMappingArray, styleMapping);
        } else {
            styleMappingArray[n] = styleMapping;
        }
        this.styleMappingModel.setList(styleMappingArray);
        OptionsWizard.ensureRowIsVisible(this.styleMappingTable, n);
    }

    public void removeStyleMapping() {
        int n = this.styleMappingTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        OptionsWizardState.StyleMapping[] styleMappingArray = this.styleMappingModel.getList();
        styleMappingArray = ArrayUtil.removeAt(styleMappingArray, n);
        this.styleMappingModel.setList(styleMappingArray);
        OptionsWizard.ensureRowIsVisible(this.styleMappingTable, 0);
    }

    private static final void ensureRowIsVisible(JTable jTable, int n) {
        Rectangle rectangle = jTable.getCellRect(n, 0, true);
        if (rectangle.width <= 0) {
            rectangle.width = 1;
        }
        if (rectangle.height <= 0) {
            rectangle.height = 1;
        }
        jTable.scrollRectToVisible(rectangle);
    }

    private JPanel otherParametersForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(Msg.msg("OW.otherParameters"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.otherParametersText = new JTextArea(15, 60);
        Font font = this.otherParametersText.getFont();
        this.otherParametersText.setFont(new Font("Monospaced", 0, Math.max(8, font.getSize() - 1)));
        this.otherParametersText.setLineWrap(false);
        JScrollPane jScrollPane = DialogUtil.createScrollPane(this.otherParametersText);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, DialogUtil.px(gridBagConstraints));
        HintLabel hintLabel = new HintLabel(Msg.msg("OW.otherParametersHint"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    private JPanel saveFileForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(Msg.msg("OW.whichSaveFile"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.saveFileField = new JTextField(50);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 2;
        jPanel.add((Component)this.saveFileField, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(OptionsWizard.class, "browse.png");
        JButton jButton = new JButton(iconResource);
        jButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(Msg.msg("OW.chooseSaveFile"));
        jButton.addActionListener(this);
        jButton.setActionCommand("chooseSaveFile");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        jPanel.add((Component)jButton, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    public void chooseSaveFile() {
        Object object;
        File file = null;
        String string = this.saveFileField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        ChooseFileOptions chooseFileOptions = ConvertPane.getChooseFileOptions();
        chooseFileOptions.addFilter("w2x");
        chooseFileOptions.addFilter("txt");
        String string2 = "txt";
        if (file != null && (object = FileUtil.getExtension(file)) != null) {
            string2 = ((String)object).toLowerCase();
        }
        chooseFileOptions.setActiveFilter(string2);
        object = ChooseFile.chooseSaveFile(this, file, chooseFileOptions);
        ConvertPane.saveFileChooserSize(chooseFileOptions);
        if (object == null) {
            return;
        }
        object = ((File)object).getAbsoluteFile();
        this.saveFileField.setText(((File)object).getPath());
    }

    private JPanel reviewForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        StringBuilder stringBuilder = new StringBuilder("<html>");
        DialogUtil.appendHTML(Msg.msg("OW.clickToSaveToFile"), stringBuilder);
        JLabel jLabel = new JLabel(stringBuilder.toString());
        jLabel.setFont(this.normalFont);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, DialogUtil.px(gridBagConstraints));
        this.reviewHTML = new JEditorPane();
        this.reviewHTML.setEditable(false);
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.reviewHTML.getEditorKitForContentType("text/html");
        this.reviewHTML.setEditorKit(hTMLEditorKit);
        this.reviewHTML.setFont(this.normalFont);
        this.reviewHTML.setBackground(Color.white);
        this.reviewHTML.setForeground(Color.black);
        JScrollPane jScrollPane = DialogUtil.createScrollPane(this.reviewHTML);
        FontMetrics fontMetrics = this.reviewHTML.getFontMetrics(this.normalFont);
        jScrollPane.setPreferredSize(new Dimension(fontMetrics.charWidth('x') * 90, fontMetrics.getHeight() * 25));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    private JPanel savingFileForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.savingText = new JTextArea(10, 50);
        this.savingText.setEditable(false);
        this.savingText.setFont(this.normalFont);
        this.savingText.setBorder(DialogUtil.pxEmptyBorder(1, 1, 1, 1));
        this.savingText.setBackground(this.getBackground());
        this.savingText.setLineWrap(true);
        this.savingText.setWrapStyleWord(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.savingText, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    private JPanel finishForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.finishText = new JTextArea(10, 50);
        this.finishText.setEditable(false);
        this.finishText.setFont(this.normalFont);
        this.finishText.setBorder(DialogUtil.pxEmptyBorder(1, 1, 1, 1));
        this.finishText.setBackground(this.getBackground());
        this.finishText.setLineWrap(true);
        this.finishText.setWrapStyleWord(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.finishText, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    @Override
    protected int whichNextScreen(int n) {
        int n2 = n + 1;
        switch (n) {
            case 0: {
                this.state.outputFormat = OutputFormat.get((String)this.categoryCombo.getSelectedItem(), (String)this.subCategoryCombo.getSelectedItem());
                if (this.state.outputFormat.options.length != 0) break;
                this.state.options = null;
                if (this.state.outputFormat.hasStyleMapping) {
                    n2 = 2;
                    break;
                }
                this.state.styleMappings = null;
                n2 = 3;
                break;
            }
            case 1: {
                ArrayList<OptionsWizardState.Option> arrayList = new ArrayList<OptionsWizardState.Option>();
                OutputFormat.Option[] optionArray = this.state.outputFormat.options;
                for (int i = 0; i < optionArray.length; ++i) {
                    OutputFormat.Option option = optionArray[i];
                    String string = null;
                    switch (option.type) {
                        case YES_NO: {
                            JComponent jComponent = (JCheckBox)this.optionFields[i];
                            string = ((AbstractButton)jComponent).isSelected() ? "yes" : "no";
                            break;
                        }
                        case STRING: {
                            JComponent jComponent = (JTextField)this.optionFields[i];
                            string = ((JTextComponent)jComponent).getText().trim();
                            if (string.length() != 0) break;
                            string = null;
                            break;
                        }
                        case ID: {
                            JComponent jComponent = (JTextField)this.optionFields[i];
                            string = ((JTextComponent)jComponent).getText().trim();
                            if (string.length() == 0) {
                                string = null;
                                break;
                            }
                            if (XMLText.isName(string)) break;
                            Alert.showError(this, Msg.msg("OW.notAnID", string));
                            DialogUtil.badField((JTextComponent)jComponent);
                            n2 = n;
                            return n2;
                        }
                        case SAVE_FILE_URI: {
                            JComponent jComponent = (JTextField)this.optionFields[i];
                            string = ((JTextComponent)jComponent).getText().trim();
                            if (string.length() > 0) {
                                string = OptionsWizard.checkURI(string, false);
                            }
                            if (string.length() != 0) break;
                            string = null;
                            break;
                        }
                        case SAVE_DIRECTORY_URI: {
                            JComponent jComponent = (JTextField)this.optionFields[i];
                            string = ((JTextComponent)jComponent).getText().trim();
                            if (string.length() > 0) {
                                string = OptionsWizard.checkURI(string, true);
                            }
                            if (string.length() != 0) break;
                            string = null;
                            break;
                        }
                        case OPEN_FILE_PATH: {
                            JComponent jComponent = (JTextField)this.optionFields[i];
                            string = ((JTextComponent)jComponent).getText().trim();
                            if (string.length() == 0) {
                                string = null;
                                break;
                            }
                            File file = new File(string);
                            if (!file.isFile()) {
                                DialogUtil.badField((JTextComponent)jComponent);
                                n2 = n;
                                return n2;
                            }
                            string = file.getAbsolutePath();
                            break;
                        }
                        case ENUMERATED_VALUES: {
                            JComponent jComponent = (JComboBox)this.optionFields[i];
                            string = (String)((JComboBox)jComponent).getSelectedItem();
                        }
                    }
                    if (ObjectUtil.equals(string, option.defaultValue)) {
                        string = null;
                    }
                    if (string == null) continue;
                    arrayList.add(new OptionsWizardState.Option(option.name, string));
                }
                if (arrayList.size() > 0) {
                    this.state.options = new OptionsWizardState.Option[arrayList.size()];
                    arrayList.toArray(this.state.options);
                } else {
                    this.state.options = null;
                }
                if (this.state.outputFormat.hasStyleMapping) break;
                this.state.styleMappings = null;
                n2 = 3;
                break;
            }
            case 2: {
                this.state.styleMappings = this.styleMappingModel.getList();
                if (this.state.styleMappings.length != 0) break;
                this.state.styleMappings = null;
                break;
            }
            case 3: {
                this.state.otherParameters = null;
                String string = this.otherParametersText.getText().trim();
                if (string.length() <= 0) break;
                this.state.otherParameters = OptionsWizardState.splitOtherParameters(string);
                if (this.state.otherParameters != null) break;
                DialogUtil.badField(this.otherParametersText);
                n2 = n;
                break;
            }
            case 4: {
                String string = this.saveFileField.getText().trim();
                if (string.length() == 0) {
                    DialogUtil.badField(this.saveFileField);
                    n2 = n;
                    break;
                }
                this.state.saveFile = new File(string).getAbsoluteFile();
            }
        }
        return n2;
    }

    private static final String checkURI(String object, boolean bl) {
        if (((String)object).indexOf(92) >= 0) {
            object = StringUtil.replaceAll((String)object, "\\", "/");
        }
        object = URIComponent.encode((String)object);
        if (bl) {
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
        } else if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    @Override
    protected void showingScreen(int n, int n2) {
        switch (n) {
            case 0: {
                if (this.state.outputFormat == null) break;
                this.categoryCombo.setSelectedItem(this.state.outputFormat.category);
                this.subCategoryCombo.setSelectedItem(this.state.outputFormat.subCategory);
                break;
            }
            case 1: {
                if (!this.state.outputFormat.name.equals(this.optionFieldsFor)) {
                    this.populateOptionsForm(this.state.outputFormat);
                    this.state.options = null;
                    this.state.styleMappings = null;
                    this.state.saveFile = null;
                }
                OutputFormat.Option[] optionArray = this.state.outputFormat.options;
                block17: for (int i = 0; i < optionArray.length; ++i) {
                    OutputFormat.Option option = optionArray[i];
                    String string = option.defaultValue;
                    OptionsWizardState.Option option2 = this.state.getOption(option.name);
                    if (option2 != null) {
                        string = option2.value;
                    }
                    switch (option.type) {
                        case YES_NO: {
                            JComponent jComponent = (JCheckBox)this.optionFields[i];
                            ((AbstractButton)jComponent).setSelected("yes".equals(string));
                            continue block17;
                        }
                        case STRING: 
                        case ID: 
                        case SAVE_FILE_URI: 
                        case SAVE_DIRECTORY_URI: 
                        case OPEN_FILE_PATH: {
                            JComponent jComponent = (JTextField)this.optionFields[i];
                            ((JTextComponent)jComponent).setText(string == null ? "" : string);
                            continue block17;
                        }
                        case ENUMERATED_VALUES: {
                            JComponent jComponent = (JComboBox)this.optionFields[i];
                            if (string == null) {
                                ((JComboBox)jComponent).setSelectedIndex(0);
                                continue block17;
                            }
                            ((JComboBox)jComponent).setSelectedItem(string);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.styleMappingModel.setList(this.state.styleMappings);
                OptionsWizard.ensureRowIsVisible(this.styleMappingTable, 0);
                break;
            }
            case 3: {
                if (this.state.otherParameters == null) break;
                StringBuilder stringBuilder = new StringBuilder();
                OptionsWizardState.joinOtherParameters(null, this.state.otherParameters, "\n", stringBuilder);
                this.otherParametersText.setText(stringBuilder.toString());
                break;
            }
            case 4: {
                File file = this.state.saveFile;
                boolean bl = false;
                if (file == null) {
                    file = this.state.getSuggestedSaveFile();
                    bl = true;
                }
                if (file == null) break;
                this.saveFileField.setText(file.getPath());
                if (!bl) break;
                this.saveFileField.selectAll();
                break;
            }
            case 5: {
                try {
                    this.reviewHTML.read(new StringReader(this.summary()), null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reviewHTML.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                break;
            }
            case 6: {
                this.savingText.append(Msg.msg("OW.savingOptions", this.state.saveFile));
                this.savingText.append("\n");
                break;
            }
            case 7: {
                if (this.saveError != null) {
                    this.finishText.append(Msg.msg("OW.cannotSaveOptions", this.state.saveFile, this.saveError));
                } else {
                    this.finishText.append(Msg.msg("OW.savedOptions", this.state.saveFile));
                }
                this.finishText.append("\n\n");
                this.finishText.append(Msg.msg("OW.finish"));
                this.finishText.append("\n");
            }
        }
    }

    private String summary() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>\n");
        stringBuilder.append("<head>\n");
        OptionsWizard.appendHTML("title", Msg.msg("OW.reviewScreen.title"), stringBuilder);
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body text='black' bgcolor='white'>\n");
        OptionsWizard.appendHTML("h4", Msg.msg("OW.outputFormatScreen.title"), stringBuilder);
        OptionsWizard.appendHTML("p", this.state.outputFormat.category + " - " + this.state.outputFormat.subCategory, stringBuilder);
        OptionsWizard.appendHTML("h4", Msg.msg("OW.optionsScreen.title"), stringBuilder);
        if (this.state.options != null) {
            stringBuilder.append("<ul>");
            for (OptionsWizardState.Option object : this.state.options) {
                OutputFormat.Option option = this.state.outputFormat.getOption(object.name);
                OptionsWizard.appendHTML("li", option.label + "\n" + object.value, stringBuilder);
            }
            stringBuilder.append("</ul>");
        } else {
            OptionsWizard.appendHTML("p", Msg.msg("OW.defaultOptions"), stringBuilder);
        }
        if (this.state.outputFormat.hasStyleMapping) {
            OptionsWizard.appendHTML("h4", Msg.msg("OW.styleMappingScreen.title"), stringBuilder);
            if (this.state.styleMappings != null) {
                stringBuilder.append("<table border=\"1\">\n");
                stringBuilder.append("<tr>\n");
                OptionsWizard.appendHTML("th", Msg.msg("OW.styleMapping.type"), stringBuilder);
                OptionsWizard.appendHTML("th", Msg.msg("OW.styleMapping.styleName"), stringBuilder);
                OptionsWizard.appendHTML("th", Msg.msg("OW.styleMapping.targetElement"), stringBuilder);
                stringBuilder.append("</tr>\n");
                for (OptionsWizardState.StyleMapping styleMapping : this.state.styleMappings) {
                    stringBuilder.append("<tr>\n");
                    OptionsWizard.appendHTML("td", styleMapping.type.getLabel(), stringBuilder);
                    OptionsWizard.appendHTML("td", styleMapping.styleName, stringBuilder);
                    OptionsWizard.appendHTML("td", styleMapping.getXSLTStartTag(), stringBuilder);
                    stringBuilder.append("</tr>\n");
                }
                stringBuilder.append("</table>\n");
            } else {
                OptionsWizard.appendHTML("p", Msg.msg("OW.noStyleMappings"), stringBuilder);
            }
        }
        if (this.state.otherParameters != null) {
            OptionsWizard.appendHTML("h4", Msg.msg("OW.otherParametersScreen.title"), stringBuilder);
            stringBuilder.append("<pre>");
            StringBuilder stringBuilder2 = new StringBuilder();
            OptionsWizardState.joinOtherParameters(null, this.state.otherParameters, "\n", stringBuilder2);
            XMLText.escapeXML(stringBuilder2.toString(), stringBuilder);
            stringBuilder.append("</pre>\n");
        }
        OptionsWizard.appendHTML("h4", Msg.msg("OW.saveFileScreen.title"), stringBuilder);
        OptionsWizard.appendHTML("p", this.state.saveFile.getPath(), stringBuilder);
        stringBuilder.append("</body>\n");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static void appendHTML(String string, String string2, StringBuilder stringBuilder) {
        stringBuilder.append('<');
        stringBuilder.append(string);
        stringBuilder.append('>');
        string2 = XMLText.escapeXML(string2);
        if (string2.indexOf(10) >= 0) {
            string2 = StringUtil.replaceAll(string2, "\n", "<br>\n");
        }
        stringBuilder.append(string2);
        stringBuilder.append("</");
        stringBuilder.append(string);
        stringBuilder.append(">\n");
    }

    @Override
    protected String performButtonText() {
        return Msg.msg("OW.saveOptions");
    }

    @Override
    protected Wizard.Status performTask() {
        try {
            Thread.sleep(250L);
            this.state.save();
            return Wizard.Status.DONE;
        }
        catch (Exception exception) {
            this.saveError = ThrowableUtil.reason(exception);
            return Wizard.Status.FAILED;
        }
    }

    @Override
    protected void abortTask() {
    }

    @Override
    protected void closingWizard(Wizard.Status status) {
    }

    private static final class StyleMappingModel
    extends AbstractTableModel {
        private OptionsWizardState.StyleMapping[] list;

        public StyleMappingModel() {
            this.setList(null);
        }

        public void setList(OptionsWizardState.StyleMapping[] styleMappingArray) {
            this.list = styleMappingArray == null ? new OptionsWizardState.StyleMapping[0] : (OptionsWizardState.StyleMapping[])styleMappingArray.clone();
            this.fireTableDataChanged();
        }

        public OptionsWizardState.StyleMapping[] getList() {
            return this.list;
        }

        public OptionsWizardState.StyleMapping get(int n) {
            return n >= 0 && n < this.list.length ? this.list[n] : null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            OptionsWizardState.StyleMapping styleMapping = this.list[n];
            if (n2 == 0) {
                return styleMapping.type.getLabel();
            }
            if (n2 == 1) {
                return styleMapping.styleName;
            }
            return styleMapping.getXSLTStartTag();
        }
    }
}

