/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.guiutil.Alert;
import com.xmlmind.guiutil.ThreadMonitorDialog;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StoppableThread;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.ResourceDirectory;
import com.xmlmind.w2x.docx.toxhtml.Translator;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.processor.XPathFunctions;
import com.xmlmind.w2x_app.Msg;
import com.xmlmind.w2x_app.StyleMappingType;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CustomStyles {
    private static final int TRAIT_HAS_BOX = 1;
    private static final int TRAIT_HAS_MONOSPACED_FONT = 2;
    private static final int TRAIT_CONTAINS_LINE_BREAKS = 4;
    private static final Entry[] NO_ENTRIES = new Entry[0];
    private HashMap<String, Entry> styleMap = new HashMap();
    private Entry[] charStyleEntries = null;
    private Entry[] paraStyleEntries = null;
    private ArrayList<File> loadedFiles = new ArrayList();

    public static boolean checkEntry(String string, StyleMappingType styleMappingType) {
        return !(string == null || styleMappingType == null || styleMappingType == StyleMappingType.CHARACTER_STYLE && !string.startsWith("c-") || styleMappingType != StyleMappingType.CHARACTER_STYLE && !string.startsWith("p-") && !string.startsWith("tp-")) && string.indexOf(32) < 0;
    }

    public Entry get(String string) {
        return this.styleMap.get(string);
    }

    public void put(Entry entry) {
        this.styleMap.put(entry.styleName, entry);
        this.paraStyleEntries = null;
        this.charStyleEntries = null;
    }

    public void put(String string, StyleMappingType styleMappingType) {
        Entry entry = this.styleMap.get(string);
        if (entry == null || entry.styleMappingType != styleMappingType) {
            Entry entry2 = entry == null ? new Entry(string, null, null, styleMappingType) : new Entry(string, entry.localStyleName, entry.cssRule, styleMappingType);
            this.put(entry2);
        }
    }

    public Entry[] getAll(boolean bl) {
        if (this.charStyleEntries == null) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            ArrayList<Entry> arrayList2 = new ArrayList<Entry>();
            for (Entry entry : this.styleMap.values()) {
                if (entry.styleName.startsWith("c-")) {
                    arrayList.add(entry);
                    continue;
                }
                arrayList2.add(entry);
            }
            this.charStyleEntries = arrayList.toArray(NO_ENTRIES);
            if (this.charStyleEntries.length > 1) {
                Arrays.sort(this.charStyleEntries);
            }
            this.paraStyleEntries = arrayList2.toArray(NO_ENTRIES);
            if (this.paraStyleEntries.length > 1) {
                Arrays.sort(this.paraStyleEntries);
            }
        }
        return bl ? this.charStyleEntries : this.paraStyleEntries;
    }

    public boolean load(File file, Component component) {
        HashMap<String, Entry> hashMap = new HashMap<String, Entry>();
        String string = CustomStyles.load(file, hashMap, component);
        if (string != null) {
            Alert.showError(component, Msg.msg("CS.cannotTranslateDOCX", file, string));
            return false;
        }
        for (Entry entry : hashMap.values()) {
            this.styleMap.put(entry.styleName, entry);
        }
        this.paraStyleEntries = null;
        this.charStyleEntries = null;
        this.addLoadedFile(file);
        return true;
    }

    private void addLoadedFile(File file) {
        int n = this.loadedFiles.indexOf(file);
        if (n >= 0) {
            this.loadedFiles.remove(n);
        }
        this.loadedFiles.add(file);
    }

    public List<File> getLoadedFiles() {
        return this.loadedFiles;
    }

    public File lastLoadedFile() {
        int n = this.loadedFiles.size();
        return n == 0 ? null : this.loadedFiles.get(0);
    }

    private static String load(final File file, final Map<String, Entry> map, Component component) {
        final String[] stringArray = new String[1];
        StoppableThread stoppableThread = new StoppableThread("CustomStyles.getThread"){

            @Override
            public void run() {
                try {
                    CustomStyles.load(file, map);
                }
                catch (Exception exception) {
                    stringArray[0] = ThrowableUtil.reason(exception);
                }
            }
        };
        stoppableThread.start();
        try {
            stoppableThread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!stoppableThread.isAlive()) {
            return stringArray[0];
        }
        ThreadMonitorDialog threadMonitorDialog = new ThreadMonitorDialog(component, Msg.msg("CS.pleaseWait"), Msg.msg("CS.translatingDOCX", file) + " " + Msg.msg("CS.pleaseWait"), 0, 0, true);
        threadMonitorDialog.setIndeterminateProgressBar(true);
        boolean bl = threadMonitorDialog.attachThread(stoppableThread);
        if (!bl && stringArray == null) {
            stringArray[0] = Msg.msg("CS.canceledByUser");
        }
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(File file, Map<String, Entry> map) throws IOException {
        Object object;
        Translator translator = new Translator();
        translator.setMarkCustomStyles(true);
        File file2 = File.createTempFile("w2x-app_", ".xhtml");
        ResourceDirectory resourceDirectory = new ResourceDirectory();
        Document document = null;
        try {
            document = translator.translate(file, file2, resourceDirectory);
        }
        finally {
            if (file2.exists()) {
                FileUtil.deleteFileOrDir(file2);
            }
            if (resourceDirectory.directory != null && resourceDirectory.directory.exists()) {
                FileUtil.deleteFileOrDir(resourceDirectory.directory);
            }
        }
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.STYLE_ELEM, true);
        if (element2 != null && (object = element2.getText()) != null) {
            CustomStyles.parseRules((String)object, map);
        }
        if (map.size() == 0 || (object = Util.findDescendant(element, Constants.BODY_ELEM, false)) == null) {
            return;
        }
        CustomStyles.suggestParaMapping((Element)object, map);
    }

    private static void parseRules(String string, Map<String, Entry> map) {
        String[] stringArray;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        StringBuilder stringBuilder = null;
        for (String string4 : stringArray = StringUtil.split(string, '\n')) {
            Object object;
            if ((string4 = string4.trim()).endsWith("{") && CustomStyles.startsWith(string4, ".c-", ".p-", ".tp-")) {
                string2 = string4.substring(1, string4.length() - 1).trim();
                if (CustomStyles.endsWith(string2, "-firstRow", "-lastRow", "-firstCol", "-lastCol")) {
                    string2 = null;
                    bl = false;
                    stringBuilder = null;
                    continue;
                }
                bl = false;
                stringBuilder = new StringBuilder();
                stringBuilder.append(string4);
                stringBuilder.append('\n');
                continue;
            }
            if ("-ms-customStyle: true;".equals(string4)) {
                if (stringBuilder == null) continue;
                bl = true;
                continue;
            }
            if (string4.startsWith("-ms-name:")) {
                if (stringBuilder == null) continue;
                object = string4.substring(9).trim();
                if (object.endsWith(";")) {
                    object = object.substring(0, object.length() - 1);
                }
                if ((string3 = CustomStyles.fromCSSString(object)).length() != 0) continue;
                string3 = null;
                continue;
            }
            if ("}".equals(string4)) {
                if (stringBuilder == null) continue;
                if (bl) {
                    stringBuilder.append('}');
                    object = string2.startsWith("c-") ? StyleMappingType.CHARACTER_STYLE : StyleMappingType.PARAGRAPH_STYLE;
                    map.put(string2, new Entry(string2, string3, stringBuilder.toString(), (StyleMappingType)((Object)object)));
                }
                string2 = null;
                bl = false;
                stringBuilder = null;
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append("    ");
            stringBuilder.append(string4);
            stringBuilder.append('\n');
        }
    }

    private static String fromCSSString(String string) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            string = string.substring(1, n - 1);
        }
        if (string.indexOf("\\\"") >= 0) {
            string = StringUtil.replaceAll(string, "\\\"", "\"");
        }
        return string;
    }

    private static boolean startsWith(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean endsWith(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static void suggestParaMapping(Element element, Map<String, Entry> map) {
        Object[] objectArray = map.values().toArray(NO_ENTRIES);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if (((Entry)object).styleMappingType == StyleMappingType.CHARACTER_STYLE) continue;
            ((Entry)object).initParaMappingInfo();
        }
        CustomStyles.setParaMappingInfo(element, map);
        for (Object object : objectArray) {
            if (((Entry)object).styleMappingType == StyleMappingType.CHARACTER_STYLE) continue;
            ((Entry)object).applyParaMappingInfo();
        }
    }

    private static void setParaMappingInfo(Element element, Map<String, Entry> map) {
        ArrayList<Element> arrayList = null;
        if (element.getName() == Constants.BODY_ELEM) {
            arrayList = new ArrayList<Element>();
        }
        Entry object = null;
        boolean bl = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            Entry object2 = object;
            object = null;
            if (name == Constants.P_ELEM) {
                boolean bl2;
                Entry entry = CustomStyles.getParaMappingEntry(element2, map);
                if (entry == null) continue;
                ParaMappingInfo paraMappingInfo = entry.paraMappingInfo;
                if (object2 != null && entry.styleName.equals(object2.styleName)) {
                    object = object2;
                } else if (CustomStyles.startsParaSequence(element2, entry.styleName)) {
                    object = entry;
                    ++paraMappingInfo.sequenceCount;
                } else {
                    ++paraMappingInfo.singleCount;
                }
                boolean bl3 = bl2 = paraMappingInfo.sequenceCount == 1 && paraMappingInfo.singleCount == 0 || paraMappingInfo.sequenceCount == 0 && paraMappingInfo.singleCount == 1;
                if (!bl2 || Util.findDescendant(element2, Constants.BR_ELEM, true) == null) continue;
                paraMappingInfo.traits |= 4;
                continue;
            }
            if (arrayList == null || name != Constants.TABLE_ELEM) continue;
            Util.findAllDescendants(element2, Constants.TD_ELEM, true, arrayList);
            for (Element element3 : arrayList) {
                CustomStyles.setParaMappingInfo(element3, map);
            }
        }
    }

    private static Entry getParaMappingEntry(Element element, Map<String, Entry> map) {
        String[] stringArray;
        String string = element.getAttribute(Constants.CLASS_ATTR);
        if (string == null) {
            return null;
        }
        Entry entry = null;
        for (String string2 : stringArray = XMLText.splitList(string)) {
            if (!string2.startsWith("p-")) continue;
            entry = map.get(string2);
            break;
        }
        return entry;
    }

    private static boolean startsParaSequence(Element element, String string) {
        boolean bl = false;
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            if (element2.getName() != Constants.P_ELEM || !CustomStyles.hasClass(element2, string)) break;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean hasClass(Element element, String string) {
        String string2 = element.getAttribute(Constants.CLASS_ATTR);
        if (string2 == null) {
            return false;
        }
        String[] stringArray = XMLText.splitList(string2);
        return StringList.indexOf(stringArray, string) >= 0;
    }

    public static final class Entry
    implements Comparable<Entry> {
        public final String styleName;
        public final String localStyleName;
        public final String cssRule;
        public StyleMappingType styleMappingType;
        private ParaMappingInfo paraMappingInfo;

        public Entry(String string, String string2, String string3, StyleMappingType styleMappingType) {
            assert (CustomStyles.checkEntry(string, styleMappingType));
            this.styleName = string;
            if (string2 != null && (string2 = string2.trim()).length() == 0) {
                string2 = null;
            }
            this.localStyleName = string2;
            if (string3 != null && (string3 = string3.trim()).length() == 0) {
                string3 = null;
            }
            this.cssRule = string3;
            this.styleMappingType = styleMappingType;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.styleName.compareTo(entry.styleName);
        }

        public String toString() {
            return this.styleName;
        }

        private void initParaMappingInfo() {
            this.paraMappingInfo = new ParaMappingInfo();
            if (this.cssRule != null) {
                String string;
                if (Entry.hasStyleProperty(this.cssRule, "background-color", "transparent") || Entry.hasStyleProperty(this.cssRule, "border-top-style", "none") && Entry.hasStyleProperty(this.cssRule, "border-right-style", "none") && Entry.hasStyleProperty(this.cssRule, "border-bottom-style", "none") && Entry.hasStyleProperty(this.cssRule, "border-left-style", "none")) {
                    this.paraMappingInfo.traits |= 1;
                }
                if ((string = Util.getStyleProperty(this.cssRule, "font-family")) != null && XPathFunctions.isMonospacedFontFamily(string)) {
                    this.paraMappingInfo.traits |= 2;
                }
            }
        }

        private static boolean hasStyleProperty(String string, String string2, String ... stringArray) {
            String string3 = Util.getStyleProperty(string, string2);
            if (string3 == null) {
                return false;
            }
            for (String string4 : stringArray) {
                if (!string3.equals(string4)) continue;
                return false;
            }
            return true;
        }

        private void applyParaMappingInfo() {
            if (this.paraMappingInfo != null) {
                int n = this.paraMappingInfo.traits;
                if (this.paraMappingInfo.sequenceCount > 0 && 2 * this.paraMappingInfo.sequenceCount > this.paraMappingInfo.singleCount) {
                    if ((n & 1) != 0 && (n & 4) == 0) {
                        this.styleMappingType = (n & 2) != 0 ? StyleMappingType.PARAGRAPH_STYLE_N_TO_PRE : StyleMappingType.PARAGRAPH_STYLE_N_TO_1;
                    }
                } else if (this.paraMappingInfo.singleCount > 0 && this.paraMappingInfo.singleCount > 2 * this.paraMappingInfo.sequenceCount && (n & 4) != 0 && (n & 2) != 0) {
                    this.styleMappingType = StyleMappingType.PARAGRAPH_STYLE_1_TO_PRE;
                }
                this.paraMappingInfo = null;
            }
        }
    }

    private static final class ParaMappingInfo {
        public int traits;
        public int singleCount;
        public int sequenceCount;

        private ParaMappingInfo() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.traits & 1) != 0) {
                stringBuilder.append("+box");
            }
            if ((this.traits & 2) != 0) {
                stringBuilder.append("+monospaced");
            }
            if ((this.traits & 4) != 0) {
                stringBuilder.append("+linebreaks");
            }
            stringBuilder.append(", singleCount=");
            stringBuilder.append(this.singleCount);
            stringBuilder.append(", sequenceCount=");
            stringBuilder.append(this.sequenceCount);
            return stringBuilder.toString();
        }
    }
}

