/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.util.Console;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.StoppableThread;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.processor.Processor;
import com.xmlmind.w2x_app.Conversion;
import com.xmlmind.w2x_app.ConversionStatus;
import com.xmlmind.w2x_app.Msg;
import java.io.File;

final class ConvertThread
extends StoppableThread {
    public final Conversion conversion;
    public final File inputFile;
    public final File outputFile;
    public final ProgressMonitor progressMonitor;
    private ConversionStatus conversionStatus;

    public ConvertThread(Conversion conversion, File file, File file2, ProgressMonitor progressMonitor) {
        this.conversion = conversion;
        this.inputFile = file;
        this.outputFile = file2;
        this.progressMonitor = progressMonitor;
        this.conversionStatus = ConversionStatus.CREATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.conversionStatus = ConversionStatus.RUNNING;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.progressMonitor.start();
        boolean bl = false;
        ProgressMonitor progressMonitor = new ProgressMonitor(){

            @Override
            public void start() {
            }

            @Override
            public boolean message(String string, Console.MessageType messageType) {
                return ConvertThread.this.progressMonitor.message(string, messageType);
            }

            @Override
            public boolean stepCount(int n) {
                return ConvertThread.this.progressMonitor.stepCount(n);
            }

            @Override
            public boolean step(int n) {
                return ConvertThread.this.progressMonitor.step(n);
            }

            @Override
            public void stop() {
            }
        };
        try {
            Processor processor = new Processor();
            processor.configure(this.conversion.args);
            bl = true;
            Object object = processor.process(this.inputFile, this.outputFile, progressMonitor);
            this.conversionStatus = object == null ? ConversionStatus.CANCELED : ConversionStatus.DONE;
        }
        catch (Exception exception) {
            if (!bl) {
                this.progressMonitor.message(Msg.msg("configurationFailed", ThrowableUtil.reason(exception)), Console.MessageType.ERROR);
            }
            this.conversionStatus = ConversionStatus.FAILED;
        }
        finally {
            this.progressMonitor.stop();
        }
    }

    public ConversionStatus getStatus() {
        return this.conversionStatus;
    }
}

