/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Alert;
import com.xmlmind.guiutil.ChooseFile;
import com.xmlmind.guiutil.ChooseFileOptions;
import com.xmlmind.guiutil.ClipboardHelper;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.LinkButton;
import com.xmlmind.guiutil.Wizard;
import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.Preferences;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.docx.toxhtml.Product;
import com.xmlmind.w2x.processor.XSLTCache;
import com.xmlmind.w2x_app.Conversion;
import com.xmlmind.w2x_app.ConversionStatus;
import com.xmlmind.w2x_app.ConvertThread;
import com.xmlmind.w2x_app.CustomStyles;
import com.xmlmind.w2x_app.Msg;
import com.xmlmind.w2x_app.OptionsWizard;
import com.xmlmind.w2x_app.OptionsWizardState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public final class ConvertPane
extends JPanel
implements ItemListener,
ActionListener,
ProgressMonitor {
    private int maxMessageLevel;
    private Owner owner;
    private JTextField inputField;
    private JButton chooseInputButton;
    private JRadioButton stockConversionToggle;
    private JRadioButton customConversionToggle;
    private ButtonGroup conversionTypeGroup;
    private boolean selectingStockConversion;
    private JButton copyOptionsButton;
    private JComboBox<Conversion> stockConversionCombo;
    private JTextField optionsFileField;
    private JButton clearOptionsFileButton;
    private JButton optionsWizardButton;
    private JButton editOptionsFileButton;
    private JButton chooseOptionsFileButton;
    private URI optionsReferenceURI;
    private LinkButton optionsReferenceButton;
    private JTextField outputField;
    private JButton chooseOutputButton;
    private JCheckBox previewToggle;
    private JButton viewFolderButton;
    private SimpleAttributeSet[] evenStyles;
    private SimpleAttributeSet[] oddStyles;
    private JTextPane console;
    private JProgressBar progressBar;
    private String convertText;
    private IconResource convertIcon;
    private String cancelText;
    private IconResource cancelIcon;
    private JButton convertButton;
    private static final int MESSAGE_MAX_COUNT = 1000;
    private int stepCount;
    private int messageCount;
    private int totalMessageCount;
    private ConvertThread convertThread;
    private boolean canceled;
    private File lastInputFile;
    private File lastOptionsFile;
    private File lastOutputFile;
    private CustomStyles customStyles;

    public ConvertPane(boolean bl) {
        this((File)null, bl);
    }

    public ConvertPane(File file, boolean bl) {
        super(new GridBagLayout());
        JComponent jComponent;
        this.setDebug(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        if (Product.isMangled()) {
            jComponent = this.createMangledInfo();
            ++gridBagConstraints.gridy;
            this.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
            gridBagConstraints.insets.top = 5;
        }
        jComponent = this.createInputPane();
        ++gridBagConstraints.gridy;
        this.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        jComponent = this.createConversionPane(file);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        this.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        jComponent = this.createOutputPane(bl);
        ++gridBagConstraints.gridy;
        this.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        jComponent = this.createConvertPane();
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 20;
        this.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        this.console = this.createConsole(15, 80);
        jComponent = this.createConsolePane(this.console, 15, 80);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        this.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
    }

    private JLabel createMangledInfo() {
        JLabel jLabel = new JLabel(DialogUtil.multiLineToHTML(Msg.msg("mangledInfo")));
        jLabel.setIcon(new IconResource(ConvertPane.class, "info.png"));
        jLabel.setVerticalTextPosition(1);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getFamily(), 0, Math.max(10, font.getSize() - 2)));
        jLabel.setOpaque(true);
        Color color = new Color(255, 255, 240);
        jLabel.setBackground(color);
        jLabel.setForeground(Color.black);
        color = AWTUtil.editHSB(color, -1, 0.0f, -0.15f, false);
        jLabel.setBorder(BorderFactory.createCompoundBorder(DialogUtil.pxLineBorder(color, 1), DialogUtil.pxEmptyBorder(5, 5, 5, 5)));
        return jLabel;
    }

    private JPanel createInputPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Msg.msg("inputFile")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        this.inputField = new JTextField(45);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.inputField, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(ConvertPane.class, "browse.png");
        this.chooseInputButton = new JButton(iconResource);
        this.chooseInputButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.chooseInputButton);
        this.chooseInputButton.setToolTipText(Msg.msg("chooseInputFile"));
        this.chooseInputButton.addActionListener(this);
        this.chooseInputButton.setActionCommand("chooseInputFile");
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.chooseInputButton, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    private JPanel createConversionPane(File file) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Msg.msg("conversionSpec")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("convertTo");
        this.stockConversionToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        this.stockConversionToggle.setSelected(true);
        DialogUtil.setMnemonic(this.stockConversionToggle, string);
        this.stockConversionToggle.addActionListener(this);
        this.stockConversionToggle.setActionCommand("toggleConversionType");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.stockConversionToggle, DialogUtil.px(gridBagConstraints));
        Component component = DialogUtil.pxVerticalStrut(20);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(component, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(ConvertPane.class, "copy_options.png");
        this.copyOptionsButton = new JButton(iconResource);
        this.copyOptionsButton.setDisabledIcon(iconResource);
        this.copyOptionsButton.setToolTipText(Msg.msg("copyOptions"));
        DialogUtil.setIconic(this.copyOptionsButton);
        this.copyOptionsButton.addActionListener(this);
        this.copyOptionsButton.setActionCommand("copyOptions");
        gridBagConstraints.gridx += 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.copyOptionsButton, DialogUtil.px(gridBagConstraints));
        Object[] objectArray = (Conversion[])Conversion.getStockConversions().clone();
        Arrays.sort(objectArray);
        this.stockConversionCombo = new JComboBox<Conversion>((Conversion[])objectArray){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Conversion conversion = (Conversion)ConvertPane.this.stockConversionCombo.getSelectedItem();
                if (conversion == null) {
                    return null;
                }
                return conversion.getToolTip();
            }
        };
        this.stockConversionCombo.setToolTipText("");
        this.stockConversionCombo.addItemListener(this);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 25;
        jPanel.add(this.stockConversionCombo, DialogUtil.px(gridBagConstraints));
        string = Msg.msg("useOptionsFile");
        this.customConversionToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.customConversionToggle, string);
        this.customConversionToggle.addActionListener(this);
        this.customConversionToggle.setActionCommand("toggleConversionType");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this.customConversionToggle, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(ConvertPane.class, "clear.png");
        this.clearOptionsFileButton = new JButton(iconResource);
        this.clearOptionsFileButton.setDisabledIcon(iconResource);
        this.clearOptionsFileButton.setToolTipText(Msg.msg("clearOptionsFile"));
        DialogUtil.setIconic(this.clearOptionsFileButton);
        this.clearOptionsFileButton.addActionListener(this);
        this.clearOptionsFileButton.setActionCommand("clearOptionsFile");
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.clearOptionsFileButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(ConvertPane.class, "options_wizard.png");
        this.optionsWizardButton = new JButton(iconResource);
        this.optionsWizardButton.setDisabledIcon(iconResource);
        this.optionsWizardButton.setToolTipText(Msg.msg("optionsWizard"));
        DialogUtil.setIconic(this.optionsWizardButton);
        this.optionsWizardButton.addActionListener(this);
        this.optionsWizardButton.setActionCommand("optionsWizard");
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.optionsWizardButton, DialogUtil.px(gridBagConstraints));
        component = DialogUtil.pxVerticalStrut(20);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(component, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(ConvertPane.class, "edit.png");
        this.editOptionsFileButton = new JButton(iconResource);
        this.editOptionsFileButton.setDisabledIcon(iconResource);
        this.editOptionsFileButton.setToolTipText(Msg.msg("editOptionsFile"));
        DialogUtil.setIconic(this.editOptionsFileButton);
        this.editOptionsFileButton.addActionListener(this);
        this.editOptionsFileButton.setActionCommand("editOptionsFile");
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.editOptionsFileButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(ConvertPane.class, "browse.png");
        this.chooseOptionsFileButton = new JButton(iconResource);
        this.chooseOptionsFileButton.setDisabledIcon(iconResource);
        this.chooseOptionsFileButton.setToolTipText(Msg.msg("chooseOptionsFile"));
        DialogUtil.setIconic(this.chooseOptionsFileButton);
        this.chooseOptionsFileButton.addActionListener(this);
        this.chooseOptionsFileButton.setActionCommand("chooseOptionsFile");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.chooseOptionsFileButton, DialogUtil.px(gridBagConstraints));
        this.optionsFileField = new JTextField(45);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 25;
        jPanel.add((Component)this.optionsFileField, DialogUtil.px(gridBagConstraints));
        string = Msg.msg("optionsReference");
        this.optionsReferenceButton = new LinkButton(DialogUtil.buttonLabel(string), LinkButton.getStockIcon());
        this.initOptionsReferenceURI(file);
        if (this.optionsReferenceURI != null) {
            this.optionsReferenceButton.setToolTipText(this.optionsReferenceURI.toString());
            this.optionsReferenceButton.addActionListener(this);
            this.optionsReferenceButton.setActionCommand("optionsReference");
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.optionsReferenceButton, DialogUtil.px(gridBagConstraints));
        this.conversionTypeGroup = new ButtonGroup();
        this.conversionTypeGroup.add(this.stockConversionToggle);
        this.conversionTypeGroup.add(this.customConversionToggle);
        this.toggleConversionType();
        return jPanel;
    }

    private void initOptionsReferenceURI(File file) {
        String string = null;
        if (file != null && new File(file, "doc" + File.separator + "manual" + File.separator + "index.html").isFile()) {
            string = FileUtil.fileToURL(file).toExternalForm();
        }
        if (string == null) {
            string = "http://www.xmlmind.com/w2x/_distrib/";
        }
        try {
            this.optionsReferenceURI = new URI(string + "doc/manual/index.html#w2x_command");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private JPanel createOutputPane(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Msg.msg("outputFile")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        if (!bl) {
            gridBagConstraints.insets.bottom = 5;
        }
        gridBagConstraints.anchor = 17;
        this.outputField = new JTextField(45);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.outputField, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(ConvertPane.class, "browse.png");
        this.chooseOutputButton = new JButton(iconResource);
        this.chooseOutputButton.setDisabledIcon(iconResource);
        DialogUtil.setIconic(this.chooseOutputButton);
        this.chooseOutputButton.setToolTipText(Msg.msg("chooseOutputFile"));
        this.chooseOutputButton.addActionListener(this);
        this.chooseOutputButton.setActionCommand("chooseOutputFile");
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.chooseOutputButton, DialogUtil.px(gridBagConstraints));
        if (bl) {
            String string = Msg.msg("openOutputFile");
            this.previewToggle = new JCheckBox(DialogUtil.buttonLabel(string));
            DialogUtil.setMnemonic(this.previewToggle, string);
            this.previewToggle.setEnabled(ConvertPane.canPreviewHTML());
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.insets.right = 0;
            jPanel.add((Component)this.previewToggle, DialogUtil.px(gridBagConstraints));
            iconResource = new IconResource(ConvertPane.class, "viewFolder.png");
            this.viewFolderButton = new JButton(iconResource);
            this.viewFolderButton.setDisabledIcon(iconResource);
            DialogUtil.setIconic(this.viewFolderButton);
            this.viewFolderButton.setToolTipText(Msg.msg("openContainingFolder"));
            this.viewFolderButton.setEnabled(ConvertPane.canOpenContainingFolder() > 0);
            this.viewFolderButton.addActionListener(this);
            this.viewFolderButton.setActionCommand("openContainingFolder");
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 2;
            gridBagConstraints.insets.right = 5;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)this.viewFolderButton, DialogUtil.px(gridBagConstraints));
        }
        return jPanel;
    }

    private static boolean canPreviewHTML() {
        boolean bl = false;
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            bl = desktop.isSupported(Desktop.Action.BROWSE);
        }
        return bl;
    }

    private static int canOpenContainingFolder() {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                Desktop.Action action = Desktop.Action.valueOf("BROWSE_FILE_DIR");
                if (desktop.isSupported(action)) {
                    return 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (desktop.isSupported(Desktop.Action.OPEN)) {
                return 1;
            }
        }
        return 0;
    }

    private JPanel createConvertPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        this.progressBar = new JProgressBar(0, 100);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.progressBar, DialogUtil.px(gridBagConstraints));
        this.convertText = Msg.msg("convert");
        this.convertIcon = new IconResource(ConvertPane.class, "convert.png");
        this.cancelText = Msg.msg("cancel");
        this.cancelIcon = new IconResource(ConvertPane.class, "cancel.png");
        this.convertButton = new JButton(DialogUtil.buttonLabel(this.convertText), this.convertIcon);
        this.convertButton.setDisabledIcon(this.convertIcon);
        DialogUtil.setMnemonic(this.convertButton, this.convertText);
        this.convertButton.addActionListener(this);
        this.convertButton.setActionCommand("convert");
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.convertButton, DialogUtil.px(gridBagConstraints));
        return jPanel;
    }

    private JScrollPane createConsolePane(JTextPane jTextPane, int n, int n2) {
        JScrollPane jScrollPane = DialogUtil.createScrollPane(jTextPane);
        Font font = jTextPane.getFont();
        FontMetrics fontMetrics = jTextPane.getFontMetrics(font);
        jScrollPane.setPreferredSize(new Dimension(fontMetrics.charWidth('x') * (n2 + 1), fontMetrics.getHeight() * (n + 1)));
        return jScrollPane;
    }

    private JTextPane createConsole(int n, int n2) {
        JTextPane jTextPane = new JTextPane();
        Font font = jTextPane.getFont();
        font = new Font("SansSerif", 0, Math.max(10, font.getSize() - 2));
        jTextPane.setFont(font);
        jTextPane.setEditable(false);
        jTextPane.setBackground(Color.white);
        jTextPane.setForeground(Color.black);
        int n3 = Console.MessageType.DEBUG.ordinal() + 1;
        this.evenStyles = new SimpleAttributeSet[n3];
        this.oddStyles = new SimpleAttributeSet[n3];
        for (int i = 0; i < n3; ++i) {
            this.evenStyles[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(this.evenStyles[i], Color.black);
            this.oddStyles[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(this.oddStyles[i], Color.black);
        }
        n3 = Console.MessageType.ERROR.ordinal();
        Color color = new Color(255, 192, 192);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(255, 224, 224);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Console.MessageType.WARNING.ordinal();
        color = new Color(255, 240, 192);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(255, 240, 224);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Console.MessageType.INFO.ordinal();
        color = new Color(255, 255, 240);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(255, 255, 192);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Console.MessageType.VERBOSE.ordinal();
        color = new Color(224, 224, 255);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(240, 240, 255);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Console.MessageType.DEBUG.ordinal();
        color = new Color(224, 224, 224);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(240, 240, 240);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        return jTextPane;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.selectingStockConversion) {
            return;
        }
        if (itemEvent.getStateChange() == 1) {
            this.updateOutputFileExt();
        }
    }

    private void updateOutputFileExt() {
        String string = this.outputField.getText().trim();
        if (string.length() > 0) {
            string = FileUtil.setExtension(string, this.getConversionExtension());
            this.outputField.setText(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("chooseInputFile")) {
            this.chooseInputFile();
        } else if (string.equals("copyOptions")) {
            this.copyOptions();
        } else if (string.equals("toggleConversionType")) {
            this.toggleConversionType();
            this.updateOutputFileExt();
        } else if (string.equals("clearOptionsFile")) {
            this.clearOptionsFile();
        } else if (string.equals("optionsWizard")) {
            this.optionsWizard();
        } else if (string.equals("editOptionsFile")) {
            this.editOptionsFile();
        } else if (string.equals("chooseOptionsFile")) {
            this.chooseOptionsFile();
        } else if (string.equals("optionsReference")) {
            this.optionsReference();
        } else if (string.equals("chooseOutputFile")) {
            this.chooseOutputFile();
        } else if (string.equals("openContainingFolder")) {
            this.openContainingFolder();
        } else if (string.equals("convert")) {
            this.convert((actionEvent.getModifiers() & 1) != 0);
        }
    }

    private void chooseInputFile() {
        File file = null;
        String string = this.inputField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        if (file == null) {
            file = this.lastInputFile;
        }
        ChooseFileOptions chooseFileOptions = ConvertPane.getChooseFileOptions();
        if (file == null || "docx".equalsIgnoreCase(FileUtil.getExtension(file))) {
            chooseFileOptions.setActiveFilter("docx");
        } else {
            chooseFileOptions.addFilter("docx");
        }
        File file2 = ChooseFile.chooseOpenFile(this, file, chooseFileOptions);
        ConvertPane.saveFileChooserSize(chooseFileOptions);
        if (file2 == null) {
            return;
        }
        this.setInputFile(file2);
    }

    void setInputFile(File file) {
        String string;
        File file2;
        File file3;
        this.lastInputFile = file = file.getAbsoluteFile();
        this.inputField.setText(file.getPath());
        String string2 = this.outputField.getText().trim();
        if (string2.length() > 0 && (file3 = new File(string2)).isAbsolute() && (file2 = file3.getParentFile()) != null && (string = file.getName()).length() > 0) {
            file = new File(file2, string);
        }
        file = FileUtil.setExtension(file, this.getConversionExtension());
        this.outputField.setText(file.getPath());
    }

    static ChooseFileOptions getChooseFileOptions() {
        ChooseFileOptions chooseFileOptions = new ChooseFileOptions();
        Preferences preferences = Preferences.getUserPreferences();
        switch (SystemUtil.PLATFORM) {
            case MAC_OS: 
            case WINDOWS: {
                chooseFileOptions.nativeDialog = preferences.getBoolean("useNativeFileChooser", false) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            default: {
                preferences.remove("useNativeFileChooser");
                chooseFileOptions.nativeDialog = Boolean.FALSE;
            }
        }
        int[] nArray = preferences.getInts("fileChooserSize", null);
        chooseFileOptions.size = nArray != null && nArray[0] > 0 && nArray[1] > 0 ? new Dimension(nArray[0], nArray[1]) : new Dimension(-1, -1);
        return chooseFileOptions;
    }

    static void saveFileChooserSize(ChooseFileOptions chooseFileOptions) {
        Preferences preferences = Preferences.getUserPreferences();
        if (chooseFileOptions.size == null || chooseFileOptions.size.width <= 0 || chooseFileOptions.size.height <= 0) {
            preferences.remove("fileChooserSize");
        } else {
            preferences.putInts("fileChooserSize", new int[]{chooseFileOptions.size.width, chooseFileOptions.size.height});
        }
    }

    private String getConversionExtension() {
        Conversion conversion = this.getConversion(null, false);
        if (conversion == null) {
            return "xml";
        }
        return conversion.outFileExt;
    }

    private Conversion getConversion(String string, boolean bl) {
        if (this.stockConversionToggle.isSelected()) {
            return (Conversion)this.stockConversionCombo.getSelectedItem();
        }
        return this.getCustomConversion(string, bl);
    }

    private Conversion getCustomConversion(String string, boolean bl) {
        File file = this.getCustomConversionFile(bl);
        if (file == null) {
            return null;
        }
        return new Conversion("__CUSTOM", "__CUSTOM", string, null, "-f", file.getPath());
    }

    private File getCustomConversionFile(boolean bl) {
        if (this.stockConversionToggle.isSelected()) {
            return null;
        }
        File file = null;
        String string = this.optionsFileField.getText().trim();
        if (string.length() > 0 && !(file = new File(string)).isFile()) {
            file = null;
        }
        if (file == null) {
            if (bl) {
                if (string.length() > 0) {
                    Alert.showError(this, Msg.msg("notAFile", string));
                }
                DialogUtil.badField(this.optionsFileField);
            }
            return null;
        }
        return file.getAbsoluteFile();
    }

    private void copyOptions() {
        int n;
        Conversion conversion = this.getConversion("xml", false);
        if (conversion != null && (n = conversion.args.length) >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                String string = conversion.args[i];
                if (i > 0) {
                    if (string.startsWith("-")) {
                        stringBuilder.append('\n');
                    } else {
                        stringBuilder.append(' ');
                    }
                }
                stringBuilder.append(StringUtil.quoteArgument(string));
            }
            String string = stringBuilder.toString();
            ClipboardHelper.setString(null, string);
            this.appendMessage(Msg.msg("copiedOptions", conversion.label, string), Console.MessageType.INFO);
        }
    }

    private void toggleConversionType() {
        boolean bl = this.stockConversionToggle.isSelected();
        this.stockConversionCombo.setEnabled(bl);
        this.copyOptionsButton.setEnabled(bl);
        this.optionsFileField.setEnabled(!bl);
        this.clearOptionsFileButton.setEnabled(!bl);
        this.optionsWizardButton.setEnabled(!bl);
        this.editOptionsFileButton.setEnabled(!bl && ConvertPane.canEditText());
        this.chooseOptionsFileButton.setEnabled(!bl);
        this.optionsReferenceButton.setEnabled(!bl && ConvertPane.canPreviewHTML() && this.optionsReferenceURI != null);
    }

    private static boolean canEditText() {
        boolean bl = false;
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            bl = desktop.isSupported(Desktop.Action.EDIT);
        }
        return bl;
    }

    private void clearOptionsFile() {
        this.optionsFileField.setText("");
    }

    private void optionsWizard() {
        OptionsWizardState optionsWizardState;
        block6: {
            optionsWizardState = null;
            File file = this.getCustomConversionFile(false);
            if (file != null) {
                try {
                    optionsWizardState = OptionsWizardState.load(file);
                    if (optionsWizardState == null) {
                        throw new RuntimeException(Msg.msg("notCreatedByWizard"));
                    }
                    break block6;
                }
                catch (Exception exception) {
                    Alert.showError(this, Msg.msg("cannotLoadFile", file, ThrowableUtil.reason(exception)));
                    return;
                }
            }
            optionsWizardState = new OptionsWizardState();
        }
        if (this.customStyles == null) {
            this.customStyles = new CustomStyles();
        }
        File file = this.getInputFile(false);
        optionsWizardState.customStyles = this.customStyles;
        optionsWizardState.inputFile = file;
        OptionsWizard optionsWizard = new OptionsWizard((Component)this, optionsWizardState);
        Wizard.Status status = optionsWizard.start();
        if (status == Wizard.Status.DONE) {
            this.optionsFileField.setText(optionsWizardState.saveFile.getPath());
            this.updateOutputFileExt();
            XSLTCache.clear();
        }
    }

    private void editOptionsFile() {
        File file = this.getCustomConversionFile(true);
        if (file == null) {
            return;
        }
        try {
            Desktop.getDesktop().edit(file);
        }
        catch (Exception exception) {
            Alert.showError(this, Msg.msg("cannotEditFile", file, ThrowableUtil.reason(exception)));
        }
    }

    private void chooseOptionsFile() {
        File file = null;
        String string = this.optionsFileField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        if (file == null) {
            file = this.lastOptionsFile;
        }
        if (file == null && (string = this.inputField.getText().trim()).length() > 0) {
            file = new File(string);
            file = FileUtil.setExtension(file, "txt");
        }
        ChooseFileOptions chooseFileOptions = ConvertPane.getChooseFileOptions();
        chooseFileOptions.addFilter("w2x");
        if (file == null || "txt".equalsIgnoreCase(FileUtil.getExtension(file))) {
            chooseFileOptions.setActiveFilter("txt");
        } else {
            chooseFileOptions.addFilter("txt");
        }
        File file2 = ChooseFile.chooseOpenFile(this, file, chooseFileOptions);
        ConvertPane.saveFileChooserSize(chooseFileOptions);
        if (file2 == null) {
            return;
        }
        this.lastOptionsFile = file2 = file2.getAbsoluteFile();
        this.optionsFileField.setText(file2.getPath());
        this.updateOutputFileExt();
    }

    private void optionsReference() {
        try {
            Desktop.getDesktop().browse(this.optionsReferenceURI);
        }
        catch (Exception exception) {
            Alert.showError(this, Msg.msg("cannotBrowseURI", this.optionsReferenceURI, ThrowableUtil.reason(exception)));
        }
    }

    private void chooseOutputFile() {
        Object object;
        File file = null;
        String string = this.outputField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        if (file == null) {
            file = this.lastOutputFile;
        }
        ChooseFileOptions chooseFileOptions = ConvertPane.getChooseFileOptions();
        String string2 = null;
        if (file != null) {
            string2 = FileUtil.getExtension(file);
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if (string2 != null && ("htm".equals(string2 = string2.toLowerCase()) || "shtml".equals(string2))) {
                string2 = "html";
            }
        }
        String[] stringArray = new String[]{"dbk", "dita", "ditamap", "html", "xhtml", "xml"};
        if (string2 != null) {
            stringArray = StringList.remove(stringArray, string2);
        }
        for (String string3 : stringArray) {
            String[] stringArray2 = "html".equals(string3) ? new String[]{"htm", "html", "shtml"} : new String[]{string3};
            chooseFileOptions.addFilter(stringArray2);
        }
        if (string2 != null) {
            object = "html".equals(string2) ? new String[]{"htm", "html", "shtml"} : new String[]{string2};
            chooseFileOptions.setActiveFilter((String[])object);
        }
        object = ChooseFile.chooseSaveFile(this, file, chooseFileOptions);
        ConvertPane.saveFileChooserSize(chooseFileOptions);
        if (object == null) {
            return;
        }
        this.lastOutputFile = object = ((File)object).getAbsoluteFile();
        this.outputField.setText(((File)object).getPath());
    }

    private void openContainingFolder() {
        int n = ConvertPane.canOpenContainingFolder();
        if (n <= 0) {
            return;
        }
        File file = null;
        File file2 = null;
        String string = this.outputField.getText().trim();
        if (!(string.length() <= 0 || (file = (file2 = new File(string).getAbsoluteFile()).getParentFile()) != null && file.isDirectory())) {
            file2 = null;
            file = null;
        }
        if (file == null) {
            DialogUtil.badField(this.outputField);
            return;
        }
        try {
            if (n == 2 && file2.exists()) {
                Method method = Desktop.class.getMethod("browseFileDirectory", File.class);
                method.invoke((Object)Desktop.getDesktop(), file2);
            } else {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Exception exception) {
            Alert.showError(this, Msg.msg("cannotOpenContainingFolder", file, ThrowableUtil.reason(exception)));
        }
    }

    private void convert(boolean bl) {
        if (this.convertThread != null) {
            boolean bl2 = this.canceled;
            this.canceled = true;
            if (bl) {
                this.appendMessage(Msg.msg("stoppingConversion"), Console.MessageType.VERBOSE);
                this.convertThread.requestStop();
                try {
                    this.convertThread.join(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.convertThread.isAlive()) {
                    this.appendMessage(Msg.msg("killingConversion"), Console.MessageType.VERBOSE);
                    this.convertThread.kill();
                } else {
                    this.appendMessage(Msg.msg("conversionStopped"), Console.MessageType.VERBOSE);
                }
                this.endConversion();
            } else {
                this.appendMessage(Msg.msg("cancelingConversion"), Console.MessageType.VERBOSE);
                if (bl2) {
                    this.appendMessage(Msg.msg("stopConversionTip"), Console.MessageType.VERBOSE);
                }
            }
        } else {
            File file = this.getInputFile(true);
            if (file == null) {
                return;
            }
            Conversion conversion = this.getConversion("xml", true);
            if (conversion == null) {
                return;
            }
            String string = this.outputField.getText().trim();
            if (string.length() == 0) {
                DialogUtil.badField(this.outputField);
                return;
            }
            File file2 = new File(string);
            if (!this.checkConversionOutput(conversion, file, file2)) {
                return;
            }
            if (this.owner != null && !this.owner.canConvert(conversion, file, file2)) {
                return;
            }
            this.convertThread = new ConvertThread(conversion, file, file2, this);
            this.beginConversion(conversion, file, file2);
            this.convertThread.start();
        }
    }

    private File getInputFile(boolean bl) {
        File file = null;
        String string = this.inputField.getText().trim();
        if (string.length() > 0 && !(file = new File(string)).isFile()) {
            file = null;
        }
        if (file == null) {
            if (bl) {
                if (string.length() > 0) {
                    Alert.showError(this, Msg.msg("notAFile", string));
                }
                DialogUtil.badField(this.inputField);
            }
            return null;
        }
        return file.getAbsoluteFile();
    }

    private boolean checkConversionOutput(Conversion conversion, File file, File file2) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file2.equals(file)) {
            Alert.showError(this, Msg.msg("willNotOverwriteInputFile", file));
            return false;
        }
        if (!conversion.multiFile.booleanValue()) {
            return true;
        }
        File file3 = file2.getParentFile();
        if (file3 != null && file3.isDirectory() && !FileUtil.isEmptyDir(file3)) {
            Object[] objectArray = new String[]{Msg.msg("chooseAnOption"), Msg.msg("emptyOutputDir"), Msg.msg("keepOutputDirAsIs")};
            Object object = JOptionPane.showInputDialog(DialogUtil.getDialogAnchor(this), Msg.msg("outputDirNotEmpy.question", file3), Msg.msg("outputDirNotEmpy.title"), 3, new IconResource(Alert.class, "question.png"), objectArray, objectArray[0]);
            if (object == null) {
                return false;
            }
            if (object == objectArray[1]) {
                if (ConvertPane.findFile(file3, file)) {
                    Alert.showError(this, Msg.msg("cannotEmptyDir", file3, Msg.msg("outputDirContainsInputFile", file)));
                    return false;
                }
                try {
                    FileUtil.emptyDir(file3);
                }
                catch (IOException iOException) {
                    Alert.showError(this, Msg.msg("cannotEmptyDir", file3, ThrowableUtil.reason(iOException)));
                    return false;
                }
            } else if (object != objectArray[2]) {
                return false;
            }
        }
        return true;
    }

    private static final boolean findFile(File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                boolean bl;
                if (file3.equals(file2)) {
                    return true;
                }
                if (!file3.isDirectory() || !(bl = ConvertPane.findFile(file3, file2))) continue;
                return true;
            }
        }
        return false;
    }

    private void beginConversion(Conversion conversion, File file, File file2) {
        this.canceled = false;
        this.clearMessages();
        this.enableUI(false);
        if (this.owner != null) {
            this.owner.beginConvert(conversion, file, file2);
        }
    }

    private void endConversion() {
        Conversion conversion = null;
        File file = null;
        File file2 = null;
        ConversionStatus conversionStatus = null;
        if (this.convertThread != null) {
            conversion = this.convertThread.conversion;
            file = this.convertThread.inputFile;
            file2 = this.convertThread.outputFile;
            conversionStatus = this.convertThread.getStatus();
        }
        this.convertThread = null;
        this.canceled = false;
        this.enableUI(true);
        if (this.owner != null) {
            this.owner.endConvert(conversion, file, file2, conversionStatus);
        }
        if (conversionStatus == ConversionStatus.DONE) {
            this.appendMessage(Msg.msg("conversionComplete"), Console.MessageType.INFO);
            if (this.previewToggle != null && this.previewToggle.isSelected() && file2 != null) {
                URI uRI = FileUtil.fileToURI(file2);
                try {
                    Desktop.getDesktop().browse(uRI);
                }
                catch (Exception exception) {
                    Alert.showError(this, Msg.msg("cannotBrowseURI", uRI, ThrowableUtil.reason(exception)));
                }
            }
        }
    }

    private void enableUI(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = new Component[]{this.inputField, this.chooseInputButton, this.stockConversionToggle, this.stockConversionCombo, this.copyOptionsButton, this.customConversionToggle, this.optionsFileField, this.clearOptionsFileButton, this.optionsWizardButton, this.editOptionsFileButton, this.chooseOptionsFileButton, this.optionsReferenceButton, this.outputField, this.chooseOutputButton}) {
            component.setEnabled(bl);
        }
        if (bl) {
            this.toggleConversionType();
        }
        if (this.previewToggle != null) {
            this.previewToggle.setEnabled(bl && ConvertPane.canPreviewHTML());
        }
        if (this.viewFolderButton != null) {
            this.viewFolderButton.setEnabled(bl);
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        if (bl) {
            this.convertButton.setText(DialogUtil.buttonLabel(this.convertText));
            DialogUtil.setMnemonic(this.convertButton, this.convertText);
            this.convertButton.setIcon(this.convertIcon);
            this.convertButton.setDisabledIcon(this.convertIcon);
        } else {
            this.convertButton.setText(DialogUtil.buttonLabel(this.cancelText));
            DialogUtil.setMnemonic(this.convertButton, this.cancelText);
            this.convertButton.setIcon(this.cancelIcon);
            this.convertButton.setDisabledIcon(this.cancelIcon);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean message(final String string, final Console.MessageType messageType) {
        ConvertPane.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConvertPane.this.appendMessage(string, messageType);
            }
        });
        return !this.canceled;
    }

    @Override
    public boolean stepCount(int n) {
        this.stepCount = n;
        final boolean bl = n <= 0;
        ConvertPane.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConvertPane.this.progressBar.setIndeterminate(bl);
            }
        });
        return !this.canceled;
    }

    @Override
    public boolean step(final int n) {
        if (this.stepCount > 0) {
            ConvertPane.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ConvertPane.this.setProgress(n, ConvertPane.this.stepCount);
                }
            });
        }
        return !this.canceled;
    }

    @Override
    public void stop() {
        ConvertPane.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ConvertPane.this.endConversion();
            }
        });
    }

    private void setProgress(int n, int n2) {
        int n3 = n * 100 / n2;
        if (this.progressBar.getValue() != n3) {
            this.progressBar.setValue(n3);
        }
    }

    private void clearMessages() {
        Document document = this.console.getEditorKit().createDefaultDocument();
        this.console.setDocument(document);
        this.totalMessageCount = 0;
        this.messageCount = 0;
    }

    private void appendMessage(String string, Console.MessageType messageType) {
        Object object;
        if (messageType.ordinal() > this.maxMessageLevel) {
            return;
        }
        if (this.messageCount >= 1000) {
            int n;
            object = this.console.getDocument();
            Segment segment = new Segment();
            segment.setPartialReturn(true);
            while (this.messageCount >= 1000 && (n = ConvertPane.findEndOfMessage((Document)object, segment)) >= 0) {
                try {
                    object.remove(0, n);
                    --this.messageCount;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    break;
                }
            }
        }
        if (messageType == null) {
            messageType = Console.MessageType.INFO;
        }
        int n = messageType.ordinal();
        object = this.totalMessageCount % 2 == 0 ? this.evenStyles[n] : this.oddStyles[n];
        Document document = this.console.getDocument();
        try {
            document.insertString(document.getLength(), string + "\u00a0\n", (AttributeSet)object);
            ++this.messageCount;
            ++this.totalMessageCount;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static final int findEndOfMessage(Document document, Segment segment) {
        int n = 0;
        try {
            int n2;
            for (int i = document.getLength(); i > 0; i -= n2) {
                document.getText(n, i, segment);
                n2 = segment.count;
                char[] cArray = segment.array;
                char c = '\u0000';
                for (int j = segment.offset; j < n2; ++j) {
                    char c2 = cArray[j];
                    if (c2 == '\n' && c == '\u00a0') {
                        return n + (j - segment.offset) + 1;
                    }
                    c = c2;
                }
                n += n2;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return -1;
    }

    private static final void invokeAndWait(Runnable runnable) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            System.err.println("Internal error: " + ThrowableUtil.detailedReason(exception));
        }
    }

    public void setDebug(boolean bl) {
        this.maxMessageLevel = bl ? Console.MessageType.DEBUG.ordinal() : Console.MessageType.VERBOSE.ordinal();
    }

    public boolean isDebug() {
        return this.maxMessageLevel >= Console.MessageType.DEBUG.ordinal();
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void focusPane() {
        this.inputField.requestFocus();
    }

    public void loadPreferences(Preferences preferences) {
        String string = preferences.getString("w2x.inputFile", "");
        this.inputField.setText(string);
        string = preferences.getString("w2x.optionsFile", "");
        this.optionsFileField.setText(string);
        string = preferences.getString("w2x.outputFile", "");
        this.outputField.setText(string);
        if (this.previewToggle != null) {
            if (preferences.getBoolean("w2x.preview", false)) {
                this.previewToggle.setSelected(ConvertPane.canPreviewHTML());
            } else {
                this.previewToggle.setSelected(false);
            }
        }
        this.selectingStockConversion = true;
        boolean bl = false;
        String string2 = preferences.getString("w2x.conversion", null);
        if (string2 == null) {
            this.stockConversionToggle.setSelected(true);
            this.stockConversionCombo.setSelectedIndex(0);
            bl = true;
        } else if ("__CUSTOM".equals(string2)) {
            this.customConversionToggle.setSelected(true);
            this.stockConversionCombo.setSelectedIndex(0);
        } else {
            int n;
            this.stockConversionToggle.setSelected(true);
            ComboBoxModel<Conversion> comboBoxModel = this.stockConversionCombo.getModel();
            int n2 = comboBoxModel.getSize();
            for (n = 0; n < n2; ++n) {
                Conversion conversion = (Conversion)comboBoxModel.getElementAt(n);
                if (!conversion.id.equals(string2)) continue;
                this.stockConversionCombo.setSelectedIndex(n);
                break;
            }
            if (n >= n2) {
                this.stockConversionCombo.setSelectedIndex(0);
                bl = true;
            }
        }
        this.selectingStockConversion = false;
        this.toggleConversionType();
        if (bl) {
            this.updateOutputFileExt();
        }
    }

    public void savePreferences(Preferences preferences) {
        String string = this.inputField.getText().trim();
        if (string.length() > 0) {
            preferences.putString("w2x.inputFile", string);
        } else {
            preferences.remove("w2x.inputFile");
        }
        string = this.optionsFileField.getText().trim();
        if (string.length() > 0) {
            preferences.putString("w2x.optionsFile", string);
        } else {
            preferences.remove("w2x.optionsFile");
        }
        string = this.outputField.getText().trim();
        if (string.length() > 0) {
            preferences.putString("w2x.outputFile", string);
        } else {
            preferences.remove("w2x.outputFile");
        }
        if (this.previewToggle != null) {
            preferences.putBoolean("w2x.preview", this.previewToggle.isSelected());
        } else {
            preferences.remove("w2x.preview");
        }
        Conversion conversion = this.getConversion("xml", false);
        if (conversion == null) {
            preferences.remove("w2x.conversion");
        } else {
            preferences.putString("w2x.conversion", conversion.id);
        }
    }

    public static interface Owner {
        public boolean canConvert(Conversion var1, File var2, File var3);

        public void beginConvert(Conversion var1, File var2, File var3);

        public void endConvert(Conversion var1, File var2, File var3, ConversionStatus var4);
    }
}

