/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.processor.Plugin;
import com.xmlmind.w2x.processor.Processor;
import com.xmlmind.w2x_app.Msg;
import java.io.File;
import java.io.IOException;

public final class Conversion
implements Comparable<Conversion> {
    public final String id;
    public final String label;
    public final String outFileExt;
    public final Boolean multiFile;
    public final String[] args;
    private static final Conversion[] STOCK_CONVERSIONS = new Conversion[]{new Conversion("xhtml_css", Msg.msg("conv.styled_xhtml", "(X)HTML"), "html", Boolean.FALSE, "-o", "xhtml_css", "-p", "convert.charset", "UTF-8"), new Conversion("xhtml_strict", Msg.msg("conv.semantic_xhtml", "XHTML 1.0 Strict"), "xhtml", Boolean.FALSE, "-o", "xhtml_strict", "-p", "edit.do.sections", ""), new Conversion("xhtml_loose", Msg.msg("conv.semantic_xhtml", "XHTML 1.0 Transitional"), "xhtml", Boolean.FALSE, "-o", "xhtml_loose", "-p", "edit.do.sections", ""), new Conversion("xhtml1_1", Msg.msg("conv.semantic_xhtml", "XHTML 1.1"), "xhtml", Boolean.FALSE, "-o", "xhtml1_1", "-p", "edit.do.sections", ""), new Conversion("xhtml5", Msg.msg("conv.semantic_xhtml", "(X)HTML 5.0"), "html", Boolean.FALSE, "-o", "xhtml5", "-p", "convert.charset", "UTF-8"), new Conversion("frameset", Msg.msg("conv.styled_frameset", "(X)HTML"), "html", Boolean.TRUE, "-p", "convert.charset", "UTF-8", "-p", "split.split-before-level", "0", "-p", "split.use-id-as-filename", "no", "-o", "frameset"), new Conversion("frameset_strict", Msg.msg("conv.semantic_frameset", "(X)HTML 1.0 Strict"), "html", Boolean.TRUE, "-p", "convert.charset", "UTF-8", "-p", "split.split-before-level", "0", "-p", "split.use-id-as-filename", "no", "-o", "frameset_strict"), new Conversion("frameset_loose", Msg.msg("conv.semantic_frameset", "(X)HTML 1.0 Transitional"), "html", Boolean.TRUE, "-p", "convert.charset", "UTF-8", "-p", "split.split-before-level", "0", "-p", "split.use-id-as-filename", "no", "-o", "frameset_loose"), new Conversion("frameset1_1", Msg.msg("conv.semantic_frameset", "(X)HTML 1.1"), "html", Boolean.TRUE, "-p", "convert.charset", "UTF-8", "-p", "split.split-before-level", "0", "-p", "split.use-id-as-filename", "no", "-o", "frameset1_1"), new Conversion("frameset5", Msg.msg("conv.semantic_frameset", "(X)HTML 5.0"), "html", Boolean.TRUE, "-p", "convert.charset", "UTF-8", "-p", "split.split-before-level", "0", "-p", "split.use-id-as-filename", "no", "-o", "frameset5"), new Conversion("webhelp", Msg.msg("conv.styled_xhtml_2", "Web Help", "(X)HTML"), "html", Boolean.TRUE, "-p", "webhelp.split-before-level", "0", "-p", "webhelp.use-id-as-filename", "no", "-p", "webhelp.wh-collapse-toc", "no", "-o", "webhelp"), new Conversion("webhelp_strict", Msg.msg("conv.semantic_xhtml_2", "Web Help", "(X)HTML 1.0 Strict"), "html", Boolean.TRUE, "-p", "webhelp.split-before-level", "0", "-p", "webhelp.use-id-as-filename", "no", "-p", "webhelp.wh-collapse-toc", "no", "-o", "webhelp_strict"), new Conversion("webhelp_loose", Msg.msg("conv.semantic_xhtml_2", "Web Help", "(X)HTML 1.0 Transitional"), "html", Boolean.TRUE, "-p", "webhelp.split-before-level", "0", "-p", "webhelp.use-id-as-filename", "no", "-p", "webhelp.wh-collapse-toc", "no", "-o", "webhelp_loose"), new Conversion("webhelp1_1", Msg.msg("conv.semantic_xhtml_2", "Web Help", "(X)HTML 1.1"), "html", Boolean.TRUE, "-p", "webhelp.split-before-level", "0", "-p", "webhelp.use-id-as-filename", "no", "-p", "webhelp.wh-collapse-toc", "no", "-o", "webhelp1_1"), new Conversion("webhelp5", Msg.msg("conv.semantic_xhtml_2", "Web Help", "(X)HTML 5.0"), "html", Boolean.TRUE, "-p", "webhelp.split-before-level", "0", "-p", "webhelp.use-id-as-filename", "no", "-p", "webhelp.wh-collapse-toc", "no", "-o", "webhelp5"), new Conversion("epub", Msg.msg("conv.styled_xhtml_2", "EPUB 2.0", "XHTML"), "epub", Boolean.FALSE, "-p", "epub.split-before-level", "0", "-p", "epub.use-id-as-filename", "no", "-p", "epub.identifier", "", "-o", "epub"), new Conversion("epub1_1", Msg.msg("conv.semantic_xhtml_2", "EPUB 2.0", "XHTML 1.1"), "epub", Boolean.FALSE, "-p", "epub.split-before-level", "0", "-p", "epub.use-id-as-filename", "no", "-p", "epub.identifier", "", "-o", "epub1_1"), new Conversion("docbook_book", "DocBook V4.5 book", "xml", Boolean.FALSE, "-o", "docbook", "-p", "convert.set-column-number", "yes", "-p", "transform.cals-tables", "yes", "-p", "transform.hierarchy-name", "book"), new Conversion("docbook_article", "DocBook V4.5 article", "xml", Boolean.FALSE, "-o", "docbook", "-p", "convert.set-column-number", "yes", "-p", "transform.cals-tables", "yes", "-p", "transform.hierarchy-name", "article"), new Conversion("docbook5_book", "DocBook V5.0 book", "xml", Boolean.FALSE, "-o", "docbook5", "-p", "convert.set-column-number", "yes", "-p", "transform.cals-tables", "yes", "-p", "transform.hierarchy-name", "book"), new Conversion("docbook5_article", "DocBook V5.0 article", "xml", Boolean.FALSE, "-o", "docbook5", "-p", "convert.set-column-number", "yes", "-p", "transform.cals-tables", "yes", "-p", "transform.hierarchy-name", "article"), new Conversion("docbook51_assembly", "DocBook V5.1 assembly", "xml", Boolean.FALSE, "-o", "assembly", "-p", "convert.set-column-number", "yes", "-p", "transform.cals-tables", "yes", "-p", "transform2.section-depth", "6", "-p", "transform2.topic-path", "%{~no}_files"), new Conversion("dita_topic", "DITA topic", "dita", Boolean.FALSE, "-o", "topic", "-p", "transform.topic-type", "topic"), new Conversion("dita_concept", "DITA concept", "dita", Boolean.FALSE, "-o", "topic", "-p", "transform.topic-type", "concept"), new Conversion("dita_map", "DITA map", "ditamap", Boolean.FALSE, "-o", "map", "-p", "transform2.section-depth", "6", "-p", "transform2.topic-path", "%{~no}_files"), new Conversion("dita_bookmap", "DITA bookmap", "ditamap", Boolean.FALSE, "-o", "bookmap", "-p", "transform2.section-depth", "6", "-p", "transform2.topic-path", "%{~no}_files")};
    private static Conversion[] stockConversions;

    public Conversion(String string, String string2, String string3, Boolean bl, String ... stringArray) {
        Object[] objectArray;
        this.id = string;
        this.label = string2;
        if ((string3 == null || bl == null) && (objectArray = Conversion.guessOutputFileInfo(stringArray)) != null) {
            if (string3 == null) {
                string3 = (String)objectArray[0];
            }
            if (bl == null) {
                bl = (Boolean)objectArray[1];
            }
        }
        if (string3 == null) {
            string3 = "xml";
        }
        this.outFileExt = string3;
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        this.multiFile = bl;
        this.args = stringArray;
    }

    private static Object[] guessOutputFileInfo(String[] stringArray) {
        String string;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 2 && "-f".equals(stringArray[0])) {
            try {
                string = FileUtil.loadString(new File(stringArray[1]), "UTF-8");
                stringArray = Processor.splitOptions(string);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        string = "xhtml";
        boolean bl = false;
        boolean bl2 = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            String string2;
            String string3 = stringArray[i];
            if ("-p".equals(string3)) {
                if (i + 2 >= n) continue;
                string2 = stringArray[++i];
                object = stringArray[++i];
                if (!"convert.charset".equals(string2) || !"UTF-8".equalsIgnoreCase((String)object)) continue;
                bl = true;
                continue;
            }
            if (!"-o".equals(string3) || i + 1 >= n) continue;
            if ("topic".equals(string2 = stringArray[++i])) {
                string = "dita";
                continue;
            }
            if (string2.startsWith("docbook") || "assembly".equals(string2)) {
                string = "xml";
                continue;
            }
            if (string2.startsWith("xhtml")) {
                string = "xhtml";
                continue;
            }
            if (string2.endsWith("map")) {
                string = "ditamap";
                continue;
            }
            if (string2.startsWith("frameset")) {
                string = "xhtml";
                bl2 = true;
                continue;
            }
            if (string2.startsWith("webhelp")) {
                bl = true;
                string = "html";
                bl2 = true;
                continue;
            }
            if (string2.startsWith("epub")) {
                string = "epub";
                continue;
            }
            object = Processor.getPlugin(string2);
            if (object == null) continue;
            string = ((Plugin)object).outputExtension;
        }
        if ("xhtml".equals(string) && bl) {
            string = "html";
        }
        return new Object[]{string, bl2 ? Boolean.TRUE : Boolean.FALSE};
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Conversion)) {
            return false;
        }
        return this.id.equals(((Conversion)object).id);
    }

    public String toString() {
        return this.label;
    }

    @Override
    public int compareTo(Conversion conversion) {
        return this.label.compareTo(conversion.label);
    }

    public String getToolTip() {
        StringBuilder stringBuilder = new StringBuilder("<html><b>");
        XMLText.escapeXML(Msg.msg("conv.toolTip"), stringBuilder);
        stringBuilder.append("</b>");
        if (this.args.length == 0) {
            stringBuilder.append("<br>\n");
            stringBuilder.append("<i>");
            XMLText.escapeXML(Msg.msg("conv.noOptions"), stringBuilder);
            stringBuilder.append("</i>");
        } else {
            for (String string : this.args) {
                if (string.startsWith("-")) {
                    stringBuilder.append("<br>\n");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("<tt style='font-size: 90%;'>");
                XMLText.escapeXML(StringUtil.quoteArgument(string), stringBuilder);
                stringBuilder.append("</tt>");
            }
        }
        return stringBuilder.toString();
    }

    public static Conversion[] getStockConversions() {
        if (stockConversions == null) {
            int n = STOCK_CONVERSIONS.length;
            Plugin[] pluginArray = Processor.getPlugins();
            stockConversions = new Conversion[n + pluginArray.length];
            System.arraycopy(STOCK_CONVERSIONS, 0, stockConversions, 0, n);
            int n2 = n;
            for (Plugin plugin : pluginArray) {
                String string;
                String string2 = plugin.name;
                int n3 = -1;
                for (int i = 0; i < n; ++i) {
                    if (!Conversion.STOCK_CONVERSIONS[i].id.equals(string2)) continue;
                    n3 = i;
                    break;
                }
                if ((string = plugin.outputDescription) == null) {
                    string = plugin.name;
                }
                Conversion conversion = new Conversion(string2, string, plugin.outputExtension, plugin.multiFileOutput, "-o", StringUtil.quoteArgument(string2));
                if (n3 >= 0) {
                    Conversion.stockConversions[n3] = conversion;
                    continue;
                }
                Conversion.stockConversions[n2++] = conversion;
            }
            if (stockConversions.length != n2) {
                stockConversions = ArrayUtil.trimToSize(stockConversions, n2);
            }
        }
        return stockConversions;
    }
}

