/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import org.tartarus.snowball.SnowballStemmer;

final class Stemmer {
    public final String langCode;
    public final String langName;
    private final SnowballStemmer stemmer;
    private static final String[] LANGUAGES = new String[]{"arabic", "ar", "basque", "eu", "catalan", "ca", "danish", "da", "dutch", "nl", "english", "en", "finnish", "fi", "french", "fr", "german", "de", "greek", "el", "hindi", "hi", "hungarian", "hu", "indonesian", "id", "irish", "ga", "italian", "it", "lithuanian", "lt", "nepali", "ne", "norwegian", "no", "portuguese", "pt", "romanian", "ro", "russian", "ru", "serbian", "sr", "spanish", "es", "swedish", "sv", "tamil", "ta", "turkish", "tr"};

    public static Stemmer create(String string) {
        String string2 = null;
        if (string != null) {
            if (string.length() > 2) {
                string = string.substring(0, 2);
            }
            string = string.toLowerCase();
            for (int i = 0; i < LANGUAGES.length; i += 2) {
                if (!LANGUAGES[i + 1].equals(string)) continue;
                string2 = LANGUAGES[i];
                break;
            }
        }
        SnowballStemmer snowballStemmer = null;
        if (string2 != null) {
            try {
                snowballStemmer = (SnowballStemmer)Class.forName("org.tartarus.snowball.ext." + string2 + "Stemmer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (snowballStemmer != null) {
            return new Stemmer(string, string2, snowballStemmer);
        }
        return null;
    }

    private Stemmer(String string, String string2, SnowballStemmer snowballStemmer) {
        this.langCode = string;
        this.langName = string2;
        this.stemmer = snowballStemmer;
    }

    public String stem(String string) {
        this.stemmer.setCurrent(string);
        this.stemmer.stem();
        return this.stemmer.getCurrent();
    }
}

