/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.StringList;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

final class NamespaceHelper {
    public static final String XHTML_NS_URI = "http://www.w3.org/1999/xhtml";
    public static final String SVG_NS_URI = "http://www.w3.org/2000/svg";
    public static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    public static final String XLINK_PREFIX = "xlink";
    public static final String MATHML_NS_URI = "http://www.w3.org/1998/Math/MathML";
    public static final String OPS_NS_URI = "http://www.idpf.org/2007/ops";
    public static final String OPS_PREFIX = "epub";
    private int prefixCounter = 0;
    private Stack<String[]> contextStack = new Stack();

    public NamespaceHelper() {
        this.contextStack.push(new String[]{"", XHTML_NS_URI});
    }

    public void pushContext() {
        this.contextStack.push(StringList.EMPTY_LIST);
    }

    public void popContext() {
        this.contextStack.pop();
    }

    public String getQName(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            string = "";
        }
        String string4 = null;
        if ("".equals(string) && bl) {
            string4 = "";
        } else if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            string4 = "xml";
        }
        if (string4 == null && (string4 = this.findPrefix(string, bl)) == null) {
            String string5 = null;
            boolean bl2 = false;
            if (OPS_NS_URI.equals(string)) {
                string5 = OPS_PREFIX;
            } else if (bl) {
                if (XLINK_NS_URI.equals(string)) {
                    string5 = XLINK_PREFIX;
                }
            } else if (XHTML_NS_URI.equals(string) && "html".equals(string2) || SVG_NS_URI.equals(string) && "svg".equals(string2) || MATHML_NS_URI.equals(string) && "math".equals(string2)) {
                string5 = "";
                bl2 = true;
            }
            if (string5 == null) {
                if ("".equals(string3) && !bl) {
                    string3 = null;
                }
                string5 = string3;
            }
            if (!bl2 && string5 != null && this.findURI(string5) != null) {
                string5 = null;
            }
            if (string5 == null) {
                string4 = "ns";
                ++this.prefixCounter;
                if (this.prefixCounter >= 2) {
                    string4 = string4 + Integer.toString(this.prefixCounter);
                }
            } else {
                string4 = string5;
            }
            String[] stringArray = this.contextStack.peek();
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = string4;
            stringArray2[n + 1] = string;
            this.contextStack.set(this.contextStack.size() - 1, stringArray2);
        }
        return string4.length() == 0 ? string2 : string4 + ":" + string2;
    }

    private String findPrefix(String string, boolean bl) {
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            String[] stringArray = (String[])this.contextStack.get(i);
            int n = stringArray.length;
            for (int j = 0; j < n; j += 2) {
                if (!stringArray[j + 1].equals(string)) continue;
                String string2 = stringArray[j];
                if (bl && string2.length() <= 0) continue;
                return string2;
            }
        }
        return null;
    }

    private String findURI(String string) {
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            String[] stringArray = (String[])this.contextStack.get(i);
            int n = stringArray.length;
            for (int j = 0; j < n; j += 2) {
                if (!stringArray[j].equals(string)) continue;
                return stringArray[j + 1];
            }
        }
        return null;
    }

    public void declarePrefixes(Writer writer) throws IOException {
        String[] stringArray = this.contextStack.peek();
        int n = stringArray.length;
        for (int i = 0; i < n; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            writer.write(" xmlns");
            if (string.length() > 0) {
                writer.write(58);
                writer.write(string);
            }
            writer.write("=\"");
            NamespaceHelper.saveText(string2, writer);
            writer.write(34);
        }
    }

    public static void saveText(String string, Writer writer) throws IOException {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("&quot;");
                    continue block6;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }
}

