/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.LoadText;
import com.xmlmind.util.LocaleUtil;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.whc.DOMUtil;
import com.xmlmind.whc.IndexAnchor;
import com.xmlmind.whc.IndexEntry;
import com.xmlmind.whc.IndexRef;
import com.xmlmind.whc.IndexTerm;
import com.xmlmind.whc.LoadDocument;
import com.xmlmind.whc.Msg;
import com.xmlmind.whc.NodeLocation;
import com.xmlmind.whc.PageTemplateInfo;
import com.xmlmind.whc.SaveDocument;
import com.xmlmind.whc.SearchInfo;
import com.xmlmind.whc.Stemmer;
import com.xmlmind.whc.Util;
import com.xmlmind.whc.WordCollector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Compiler {
    public static final String VERSION = "3.6.1";
    private static final URL[] templateManifestURL = new URL[1];
    public static final String DOCUMENT_LANGUAGE = "document";
    public static final String BROWSER_LANGUAGE = "browser";
    private Console console;
    private boolean verbose;
    private String layout;
    private boolean localJQuery;
    private String jQuery;
    private URL userHeader;
    private URL userFooter;
    private URL userCSS;
    private File userResources;
    private URL favicon;
    private String defaultLang;
    private boolean collapseTOC;
    private boolean useStemming;
    private boolean indexNumbers;
    private String idMapTitle;
    private String idMapHref;
    private String idMapIdPrefix;
    private boolean responsiveUI;
    private String uiLanguage;
    private HashMap<String, String> themeProperties;
    private boolean embedCSS;
    private boolean testMode;
    private boolean noRole;
    private Document userHeaderDoc;
    private Document userFooterDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTemplateManifestURL(URL uRL) {
        URL[] uRLArray = templateManifestURL;
        synchronized (templateManifestURL) {
            Compiler.templateManifestURL[0] = uRL;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getTemplateManifestURL() {
        URL[] uRLArray = templateManifestURL;
        synchronized (templateManifestURL) {
            if (templateManifestURL[0] == null) {
                Compiler.templateManifestURL[0] = Compiler.findTemplateManifestURL();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return templateManifestURL[0];
        }
    }

    private static URL findTemplateManifestURL() {
        File file;
        URL uRL = Compiler.class.getResource("/whc_template/manifest.txt");
        if (uRL == null && (file = Compiler.findJarFile()) != null) {
            File file2 = file.getParentFile();
            File file3 = new File(file2, "whc_template" + File.separator + "manifest.txt");
            if (!file3.isFile() && !(file3 = new File(file2, ".." + File.separator + "whc_template" + File.separator + "manifest.txt")).isFile()) {
                file3 = null;
            }
            if (file3 != null) {
                uRL = FileUtil.fileToURL((File)file3);
            }
        }
        return uRL;
    }

    private static File findJarFile() {
        String[] stringArray;
        String string = System.getProperty("java.class.path");
        if (string == null) {
            return null;
        }
        File file = null;
        for (String string2 : stringArray = StringUtil.split((String)string, (char)File.pathSeparatorChar)) {
            if (!(string2 = string2.trim()).endsWith(".jar")) continue;
            File file2 = null;
            try {
                file2 = new File(string2).getCanonicalFile();
                if (!file2.isFile()) {
                    file2 = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file2 == null || !file2.getName().startsWith("whc")) continue;
            file = file2;
            break;
        }
        return file;
    }

    public Compiler(Console console) {
        this.console = console;
        this.setLayout(null);
        this.setDefaultLanguage(null);
        this.useStemming = true;
        this.responsiveUI = true;
        this.setUILanguage(BROWSER_LANGUAGE);
        this.themeProperties = new HashMap();
    }

    public Console getConsole() {
        return this.console;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setLayout(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            string = "classic";
        }
        this.layout = string;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLocalJQuery(boolean bl) {
        this.localJQuery = bl;
    }

    public boolean isLocalJQuery() {
        return this.localJQuery;
    }

    public void setJQuery(String string) {
        this.jQuery = string;
    }

    public String getJQuery() {
        return this.jQuery;
    }

    public void setUserHeader(URL uRL) {
        this.userHeader = uRL;
        this.userHeaderDoc = null;
    }

    public URL getUserHeader() {
        return this.userHeader;
    }

    public void setUserFooter(URL uRL) {
        this.userFooter = uRL;
        this.userFooterDoc = null;
    }

    public URL getUserFooter() {
        return this.userFooter;
    }

    public void setUserCSS(URL uRL) {
        this.userCSS = uRL;
    }

    public URL getUserCSS() {
        return this.userCSS;
    }

    public void setUserResources(File file) {
        this.userResources = file;
    }

    public File getUserResources() {
        return this.userResources;
    }

    public void setFavicon(URL uRL) {
        this.favicon = uRL;
    }

    public URL getFavicon() {
        return this.favicon;
    }

    public void setDefaultLanguage(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            string = "en";
        }
        this.defaultLang = string;
    }

    public String getDefaultLanguage() {
        return this.defaultLang;
    }

    public void setCollapseTOC(boolean bl) {
        this.collapseTOC = bl;
    }

    public boolean getCollapseTOC() {
        return this.collapseTOC;
    }

    public void setUseStemming(boolean bl) {
        this.useStemming = bl;
    }

    public boolean getUseStemming() {
        return this.useStemming;
    }

    public void setIndexNumbers(boolean bl) {
        this.indexNumbers = bl;
    }

    public boolean getIndexNumbers() {
        return this.indexNumbers;
    }

    public void setIdMapTitle(String string) {
        if (string != null && (string = XMLText.collapseWhiteSpace((String)string)).length() == 0) {
            string = null;
        }
        this.idMapTitle = string;
    }

    public String getIdMapTitle() {
        return this.idMapTitle;
    }

    public void setIdMapHref(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this.idMapHref = string;
    }

    public String getIdMapHref() {
        return this.idMapHref;
    }

    public void setIdMapIdPrefix(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this.idMapIdPrefix = string;
    }

    public String getIdMapIdPrefix() {
        return this.idMapIdPrefix;
    }

    public void setResponsiveUI(boolean bl) {
        this.responsiveUI = bl;
    }

    public boolean getResponsiveUI() {
        return this.responsiveUI;
    }

    public void setUILanguage(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            string = BROWSER_LANGUAGE;
        }
        this.uiLanguage = string;
    }

    public String getUILanguage() {
        return this.uiLanguage;
    }

    public void setThemeProperty(String string, String string2) {
        if (string2 == null) {
            this.themeProperties.remove(string);
        } else {
            this.themeProperties.put(string, string2);
        }
    }

    public Map<String, String> getThemeProperties() {
        return this.themeProperties;
    }

    public void inheritFontAndColors(boolean bl) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"--navigation-font-family", "--navigation-font-size", "--navigation-color", "--navigation-background-color"}) {
            this.setThemeProperty(string, bl ? "inherit" : null);
        }
    }

    public boolean parseParameters(String[] stringArray) {
        return this.parseParameters(stringArray, null);
    }

    public boolean parseParameters(String[] stringArray, URL uRL) {
        int n = stringArray.length / 2 * 2;
        for (int i = 0; i < n; i += 2) {
            URL uRL2;
            String string;
            String string2 = stringArray[i];
            if (string2 == null || (string2 = string2.trim()).length() == 0 || (string = stringArray[i + 1]) == null || (string = string.trim()).length() == 0) continue;
            boolean bl = false;
            if (string2.startsWith("wh-")) {
                string2 = string2.substring(3);
            }
            if ("layout".equals(string2)) {
                this.setLayout(string);
            } else if ("local-jquery".equals(string2)) {
                this.setLocalJQuery(Compiler.parseBoolean(string));
            } else if ("jquery".equals(string2)) {
                this.setJQuery(string);
            } else if ("user-header".equals(string2)) {
                uRL2 = URLUtil.urlOrFile((String)string, (boolean)false, (boolean)false, (URL)uRL);
                if (uRL2 == null) {
                    bl = true;
                } else {
                    this.setUserHeader(uRL2);
                }
            } else if ("user-footer".equals(string2)) {
                uRL2 = URLUtil.urlOrFile((String)string, (boolean)false, (boolean)false, (URL)uRL);
                if (uRL2 == null) {
                    bl = true;
                } else {
                    this.setUserFooter(uRL2);
                }
            } else if ("user-css".equals(string2)) {
                uRL2 = URLUtil.urlOrFile((String)string, (boolean)false, (boolean)false, (URL)uRL);
                if (uRL2 == null) {
                    bl = true;
                } else {
                    this.setUserCSS(uRL2);
                }
            } else if ("user-resources".equals(string2)) {
                uRL2 = URLUtil.urlOrFile((String)string, (boolean)false, (boolean)true, (URL)uRL);
                if (uRL2 == null) {
                    bl = true;
                } else {
                    File file = URLUtil.urlToFile((URL)uRL2);
                    if (file == null || !file.isDirectory()) {
                        bl = true;
                    } else {
                        this.setUserResources(file);
                    }
                }
            } else if ("favicon".equals(string2)) {
                uRL2 = URLUtil.urlOrFile((String)string, (boolean)false, (boolean)false, (URL)uRL);
                if (uRL2 == null) {
                    bl = true;
                } else {
                    this.setFavicon(uRL2);
                }
            } else if ("default-language".equals(string2)) {
                this.setDefaultLanguage(string);
            } else if ("collapse-toc".equals(string2)) {
                this.setCollapseTOC(Compiler.parseBoolean(string));
            } else if ("use-stemming".equals(string2)) {
                this.setUseStemming(Compiler.parseBoolean(string));
            } else if ("index-numbers".equals(string2)) {
                this.setIndexNumbers(Compiler.parseBoolean(string));
            } else if ("id-map-title".equals(string2)) {
                this.setIdMapTitle(string);
            } else if ("id-map-href".equals(string2)) {
                this.setIdMapHref(string);
            } else if ("id-map-id-prefix".equals(string2)) {
                this.setIdMapIdPrefix(string);
            } else if ("responsive-ui".equals(string2)) {
                this.setResponsiveUI(Compiler.parseBoolean(string));
            } else if ("ui-language".equals(string2)) {
                this.setUILanguage(string);
            } else if ("inherit-font-and-colors".equals(string2)) {
                this.inheritFontAndColors(Compiler.parseBoolean(string));
            } else if ("embed-css".equals(string2)) {
                this.embedCSS = Compiler.parseBoolean(string);
            } else if ("test-mode".equals(string2)) {
                this.testMode = Compiler.parseBoolean(string);
            } else if ("no-role".equals(string2)) {
                this.noRole = Compiler.parseBoolean(string);
            } else if (string2.startsWith("-")) {
                if (!string2.startsWith("--")) {
                    string2 = "-" + string2;
                }
                this.setThemeProperty(string2, string);
            } else {
                this.error(Msg.msg("unknownParameter", string2));
                return false;
            }
            if (!bl) continue;
            this.error(Msg.msg("invalidParameter", string, string2));
            return false;
        }
        return true;
    }

    private static boolean parseBoolean(String string) {
        return "yes".equals(string) || "true".equals(string) || "on".equals(string) || "1".equals(string);
    }

    public boolean compile(File[] fileArray, File file, File file2, File file3) throws IOException {
        int n = fileArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            uRLArray[i] = FileUtil.fileToURL((File)fileArray[i]);
        }
        URL uRL = null;
        if (file != null) {
            uRL = FileUtil.fileToURL((File)file);
        }
        URL uRL2 = null;
        if (file2 != null) {
            uRL2 = FileUtil.fileToURL((File)file2);
        }
        return this.compile(uRLArray, uRL, uRL2, file3);
    }

    public boolean compile(URL[] uRLArray, URL uRL, URL uRL2, File file) throws IOException {
        UUID uUID;
        String string;
        String string2;
        String string32;
        Object[] objectArray;
        Object object;
        Object object2;
        String string4;
        Serializable serializable;
        boolean[] blArray;
        PageTemplateInfo pageTemplateInfo;
        int n = uRLArray.length;
        if (n == 0) {
            this.error(Msg.msg("noXHTMLFiles"));
            return false;
        }
        if (file == null) {
            file = this.getOutDir(uRLArray);
        }
        if (file == null) {
            return false;
        }
        if (!file.isDirectory()) {
            this.error(Msg.msg("noOutDir", file));
            return false;
        }
        File file2 = new File(file, "_wh");
        if (file2.exists()) {
            FileUtil.deleteFileOrDir((File)file2);
        }
        FileUtil.checkedMkdir((File)file2);
        String string5 = this.copyExtraCSS(file2);
        String string6 = this.copyFavicon(file2);
        String string7 = this.getLayout();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        URL uRL3 = Compiler.listTemplateResources(Compiler.getTemplateManifestURL(), string7, arrayList, arrayList2);
        if (uRL3 == null) {
            this.error(Msg.msg("cannotFindResource", "whc_template/" + string7 + ".html"));
            return false;
        }
        if (arrayList2.isEmpty()) {
            this.error(Msg.msg("cannotFindResource", "whc_template/_wh/*.{css,js}"));
            return false;
        }
        this.info(Msg.msg("loadingPageTemplate", URLUtil.toLabel((URL)uRL3)));
        Document document = null;
        if (uRL2 != null && (document = this.checkEmptyIndex(uRL2)) == null) {
            uRL2 = null;
        }
        if ((pageTemplateInfo = this.preparePageTemplate(uRL3, file2, string5, string6, blArray = new boolean[]{document != null})) == null) {
            return false;
        }
        if (!blArray[0]) {
            document = null;
        }
        ArrayList<Object> arrayList3 = null;
        HashSet<String> hashSet = null;
        if (this.idMapTitle != null && this.idMapHref != null) {
            arrayList3 = new ArrayList<Object>();
            hashSet = new HashSet<String>();
        }
        String string8 = null;
        Stemmer stemmer = null;
        String string9 = null;
        WordCollector wordCollector = new WordCollector();
        SearchInfo searchInfo = new SearchInfo();
        ArrayList<Document> arrayList4 = this.embedCSS ? new ArrayList<Document>() : null;
        for (int i = 0; i < n; ++i) {
            serializable = uRLArray[i];
            string4 = URLUtil.getRawBaseName((URL)serializable);
            object2 = new File(file, URIComponent.decode((String)string4));
            this.info(Msg.msg("processingXHTMLFile", object2, URLUtil.toLabel((URL)serializable)));
            object = LoadDocument.load(serializable);
            if (arrayList3 != null) {
                hashSet.clear();
                this.collectIds((Document)object, hashSet);
                if (hashSet.size() > 0) {
                    objectArray = hashSet.toArray(StringUtil.EMPTY_LIST);
                    if (objectArray.length > 1) {
                        Arrays.sort(objectArray);
                    }
                    arrayList3.add(string4);
                    arrayList3.add(objectArray);
                }
            }
            if (i == 0) {
                string8 = DOMUtil.getXHTMLLang(object.getDocumentElement());
                if (string8 == null) {
                    string8 = this.defaultLang;
                }
                if (this.useStemming && (stemmer = Stemmer.create(string8)) != null && (string9 = this.loadStemmerJS(stemmer.langCode, arrayList2)) == null) {
                    stemmer = null;
                }
            }
            this.collectSearchInfo((Document)object, (URL)serializable, stemmer, wordCollector, searchInfo);
            if (!this.processPage((Document)object, pageTemplateInfo, !this.embedCSS, (File)object2)) {
                return false;
            }
            if (!this.embedCSS) continue;
            arrayList4.add((Document)object);
        }
        if (arrayList3 != null) {
            this.saveIdMap(arrayList3, new File(file2, "idMap.xml"));
        }
        this.info(Msg.msg("creatingSearchData"));
        String string10 = searchInfo.toJS(string9);
        string10 = this.testMode ? "// -*- coding: utf-8 -*-\n\n" + string10 : Util.compactJS(string10);
        serializable = new File(file2, "search.js");
        this.info(Msg.msg("savingSearchData", searchInfo.wordMap.size(), searchInfo.baseNameList.size(), serializable));
        FileUtil.saveString((String)string10, (File)serializable, (String)"UTF-8");
        this.info(Msg.msg("creatingTOC"));
        string4 = null;
        string4 = uRL == null ? this.simpleTOCToJS(searchInfo.titleList, searchInfo.baseNameList) : this.tocToJS(uRL);
        if (string4 == null) {
            return false;
        }
        if (this.testMode) {
            serializable = new File(file2, "toc.js");
            this.info(Msg.msg("savingTOC", serializable));
            FileUtil.saveString((String)("// -*- coding: utf-8 -*-\n\n" + string4), (File)serializable, (String)"UTF-8");
        }
        assert (string8 != null);
        object2 = null;
        if (document != null) {
            this.info(Msg.msg("creatingIndex"));
            object2 = this.indexToJS(document, string8);
            if (object2 == null) {
                return false;
            }
            if (this.testMode) {
                serializable = new File(file2, "index.js");
                this.info(Msg.msg("savingIndex", serializable));
                FileUtil.saveString((String)("// -*- coding: utf-8 -*-\n\n" + (String)object2), (File)serializable, (String)"UTF-8");
            }
        }
        this.info(Msg.msg("compilingCSS"));
        object = "." + string7 + ".";
        objectArray = new String[arrayList.size()];
        int n2 = 0;
        for (String string32 : arrayList) {
            objectArray[n2++] = "." + string32 + ".";
        }
        Object object3 = this.compileCSS(this.themeProperties, (String)object, (String[])objectArray, this.responsiveUI, arrayList2);
        if (object3 == null) {
            return false;
        }
        object3 = this.testMode ? "@charset \"UTF-8\";\n\n" + (String)object3 : Util.compactCSS((String)object3);
        serializable = new File(file2, "wh.css");
        this.info(Msg.msg("savingCSS", serializable));
        FileUtil.saveString((String)object3, (File)serializable, (String)"UTF-8");
        this.info(Msg.msg("compilingJS"));
        string32 = this.uiLanguage;
        if (string32 != null) {
            if (string32.equals(BROWSER_LANGUAGE)) {
                string32 = null;
            } else if (string32.equals(DOCUMENT_LANGUAGE)) {
                string32 = string8;
            }
        }
        if ((string2 = this.compileJS(string32, string = Long.toString((uUID = UUID.randomUUID()).getMostSignificantBits(), 36) + Long.toString(uUID.getLeastSignificantBits(), 36), string4, (String)object2, (String)object, (String[])objectArray, this.responsiveUI, arrayList2)) == null) {
            return false;
        }
        string2 = this.testMode ? "// -*- coding: utf-8 -*-\n\n" + string2 : Util.compactJS(string2);
        serializable = new File(file2, "wh.js");
        this.info(Msg.msg("savingJS", serializable));
        FileUtil.saveString((String)string2, (File)serializable, (String)"UTF-8");
        if (this.embedCSS) {
            for (Document document2 : arrayList4) {
                URL uRL4 = null;
                try {
                    uRL4 = URLUtil.createURL((String)document2.getDocumentURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (uRL4 == null) {
                    this.internalError("no save URL for page having embedded CSS");
                    return false;
                }
                this.embedCSS(document2, uRL4);
                File file3 = URLUtil.urlToFile((URL)uRL4);
                if (file3 == null) {
                    this.internalError("no save file for page having embedded CSS");
                    return false;
                }
                Compiler.savePage(document2, file3);
            }
        }
        return true;
    }

    private File getOutDir(URL[] uRLArray) {
        File file = null;
        for (URL uRL : uRLArray) {
            File file2 = URLUtil.urlToFile((URL)uRL);
            if (file2 != null) {
                File file3 = file2.getParentFile();
                if (file == null) {
                    file = file3;
                    continue;
                }
                if (file.equals(file3)) continue;
                this.error(Msg.msg("multipleBaseDirs", file));
                return null;
            }
            this.error(Msg.msg("mustSpecifyOutDir"));
            return null;
        }
        return file;
    }

    private String copyExtraCSS(File file) throws IOException {
        String string = null;
        if (this.userCSS != null || this.userResources != null) {
            File file2 = Compiler.createUserDir(file);
            if (this.userCSS != null) {
                String string2 = URLUtil.getRawBaseName((URL)this.userCSS);
                FileUtil.copyFile((URL)this.userCSS, (File)new File(file2, URIComponent.decode((String)string2)));
                string = "_wh/user/" + string2;
            }
            if (this.userResources != null) {
                FileUtil.copyDir((File)this.userResources, (File)new File(file2, this.userResources.getName()), (boolean)false);
            }
        }
        return string;
    }

    private static File createUserDir(File file) throws IOException {
        File file2 = new File(file, "user");
        if (!file2.isDirectory()) {
            FileUtil.checkedMkdir((File)file2);
        }
        return file2;
    }

    private String copyFavicon(File file) throws IOException {
        String string = null;
        if (this.favicon != null) {
            String string2 = URLUtil.getRawBaseName((URL)this.favicon);
            String string3 = Util.getImageType(string2);
            if (string3 != null) {
                File file2 = Compiler.createUserDir(file);
                FileUtil.copyFile((URL)this.favicon, (File)new File(file2, URIComponent.decode((String)string2)));
                string = "_wh/user/" + string2;
            } else {
                this.warning(Msg.msg("unknownImageType", this.favicon));
            }
        }
        return string;
    }

    private static URL listTemplateResources(URL uRL, String string, List<String> list, List<URL> list2) throws IOException {
        URL uRL2 = null;
        String string2 = URLUtil.loadString((URL)uRL, (String)"UTF-8");
        String[] stringArray = StringUtil.split((String)string2, (char)'\n');
        String string3 = string + ".html";
        for (String string4 : stringArray) {
            string4 = string4.trim();
            URL uRL3 = null;
            try {
                uRL3 = URLUtil.createURL((URL)uRL, (String)string4);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(Msg.msg("badManifest", URLUtil.toLabel((URL)uRL), string4));
            }
            if (string4.startsWith("_wh/")) {
                list2.add(uRL3);
                continue;
            }
            if (!string4.endsWith(".html")) continue;
            list.add(string4.substring(0, string4.length() - 5));
            if (!string3.equals(string4)) continue;
            uRL2 = uRL3;
        }
        Collections.sort(list2, new Comparator<URL>(){

            @Override
            public int compare(URL uRL, URL uRL2) {
                String string = URLUtil.getBaseName((URL)uRL);
                String string2 = URLUtil.getBaseName((URL)uRL2);
                if (string == null || string2 == null) {
                    return URLUtil.COMPARATOR.compare(uRL, uRL2);
                }
                string = URIComponent.setExtension((String)string, null);
                string2 = URIComponent.setExtension((String)string2, null);
                return string.compareTo(string2);
            }
        });
        return uRL2;
    }

    private Document checkEmptyIndex(URL uRL) throws IOException {
        Document document = LoadDocument.load(uRL);
        boolean bl = true;
        for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"entry".equals(node.getLocalName())) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.info(Msg.msg("ignoringEmptyIndex", URLUtil.toLabel((URL)uRL)));
            document = null;
        }
        return document;
    }

    private String loadStemmerJS(String string, List<URL> list) {
        String string2 = "snowball_" + string + ".js";
        URL uRL = null;
        for (URL uRL2 : list) {
            if (!string2.equals(URLUtil.getBaseName((URL)uRL2))) continue;
            uRL = uRL2;
            break;
        }
        Object object = null;
        if (uRL != null) {
            try {
                object = URLUtil.loadString(uRL, (String)"UTF-8");
                object = ((String)object).trim();
            }
            catch (IOException iOException) {
                this.error(Msg.msg("cannotLoadFile", URLUtil.toLabel((URL)uRL), ThrowableUtil.reason((Throwable)iOException)));
            }
        }
        return object;
    }

    private PageTemplateInfo preparePageTemplate(URL uRL, File file, String string, String string2, boolean[] blArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Node node;
        Object object6;
        Element element;
        Document document = LoadDocument.load(uRL);
        Element element2 = document.getDocumentElement();
        if (this.noRole) {
            Compiler.removeRoleAttribute(element2);
        }
        if ((element = DOMUtil.getChildElementByLocalName(element2, "head")) == null) {
            this.error(element2, Msg.msg("missingElement", "head"));
            return null;
        }
        if (string != null) {
            object6 = document.createElementNS("http://www.w3.org/1999/xhtml", "link");
            object6.setAttributeNS(null, "type", "text/css");
            object6.setAttributeNS(null, "rel", "stylesheet");
            object6.setAttributeNS(null, "href", string);
            element.appendChild((Node)object6);
        }
        if (string2 != null && (object6 = Util.getImageType(string2)) != null) {
            node = document.createElementNS("http://www.w3.org/1999/xhtml", "link");
            node.setAttributeNS(null, "type", (String)object6);
            node.setAttributeNS(null, "rel", "icon");
            node.setAttributeNS(null, "href", string2);
            element.appendChild(node);
        }
        if ((object6 = DOMUtil.getChildElementByLocalName(element, "title")) == null) {
            this.error(element, Msg.msg("missingElement", "title"));
            return null;
        }
        for (node = object6.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || (object5 = DOMUtil.getAttribute((Element)(object4 = (Element)node), null, "id")) == null) continue;
            object3 = null;
            object2 = null;
            if ("wh-jquery".equals(object5)) {
                object3 = "src";
                if (this.jQuery != null) {
                    object2 = this.jQuery;
                }
            }
            if (object3 == null || object2 == null) continue;
            object4.setAttributeNS(null, (String)object3, (String)object2);
        }
        object4 = new ArrayList();
        for (node = object6.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            object5 = (Element)node;
            object3 = DOMUtil.getAttribute((Element)object5, null, "id");
            if (object3 != null) {
                object2 = null;
                object = null;
                if ("wh-jquery".equals(object3)) {
                    object2 = "src";
                    if (this.localJQuery) {
                        object = this.toLocalJQuery((Element)object5, (String)object2, file);
                    }
                }
                if (object2 != null) {
                    object5.removeAttributeNS(null, "id");
                    if (object != null) {
                        object5.setAttributeNS(null, (String)object2, (String)object);
                    }
                }
            }
            ((ArrayList)object4).add(object5);
        }
        object5 = new Element[((ArrayList)object4).size()];
        ((ArrayList)object4).toArray((T[])object5);
        object3 = DOMUtil.getChildElementByLocalName(element2, "body");
        if (object3 == null) {
            this.error(element2, Msg.msg("missingElement", "body"));
            return null;
        }
        object2 = DOMUtil.findElementById((Node)object3, "wh-index-tab");
        if (object2 == null) {
            blArray[0] = false;
        }
        if (!blArray[0] && (object6 = object2) != null) {
            object6.getParentNode().removeChild((Node)object6);
            object6 = DOMUtil.findElementById((Node)object3, "wh-index-container");
            if (object6 != null) {
                object6.getParentNode().removeChild((Node)object6);
            }
        }
        if (!this.prepareHeaderFooter((Element)object3, "wh-header", this.userHeader)) {
            return null;
        }
        if (!this.prepareHeaderFooter((Element)object3, "wh-footer", this.userFooter)) {
            return null;
        }
        object = DOMUtil.findElementById((Node)object3, "wh-content");
        if (object == null) {
            this.error((Element)object3, Msg.msg("missingElementWithID", "div", "wh-content"));
            return null;
        }
        return new PageTemplateInfo(document, (Element[])object5, (Element)object3);
    }

    private static void removeRoleAttribute(Element element) {
        element.removeAttributeNS(null, "role");
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Compiler.removeRoleAttribute((Element)node);
        }
    }

    private String toLocalJQuery(Element element, String string, File file) {
        String string2 = DOMUtil.getAttribute(element, null, string);
        String string3 = null;
        if (string2 != null) {
            URL uRL = null;
            try {
                uRL = URLUtil.createURL((String)string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL != null) {
                File file2 = new File(file, "jquery");
                String string4 = URIComponent.getRawBaseName((String)string2);
                File file3 = new File(file2, URIComponent.decode((String)string4));
                try {
                    this.copyFile(uRL, file3);
                    string3 = "_wh/jquery/" + string4;
                }
                catch (Exception exception) {
                    this.warning(Msg.msg("cannotCopyFile", uRL, file3, ThrowableUtil.reason((Throwable)exception)));
                }
            }
        }
        return string3 == null ? string2 : string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(URL uRL, File file) throws IOException {
        this.info(Msg.msg("copyingFile", uRL, file));
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory()) {
            FileUtil.checkedMkdirs((File)file2);
        }
        try (InputStream inputStream = URLUtil.openStreamNoCache((URL)uRL);){
            FileUtil.copyFile((InputStream)inputStream, (File)file);
        }
    }

    private boolean prepareHeaderFooter(Element element, String string, URL uRL) throws IOException {
        Element element2 = DOMUtil.findElementById(element, string);
        if (uRL == null) {
            if (element2 != null) {
                element2.getParentNode().removeChild(element2);
            }
        } else {
            Document document;
            if (element2 == null) {
                this.error(element, Msg.msg("missingElementWithID", "div", string));
                return false;
            }
            if ("wh-header".equals(string)) {
                if (this.userHeaderDoc == null) {
                    this.userHeaderDoc = LoadDocument.load(uRL);
                }
                document = this.userHeaderDoc;
            } else {
                if (this.userFooterDoc == null) {
                    this.userFooterDoc = LoadDocument.load(uRL);
                }
                document = this.userFooterDoc;
            }
            Element element3 = document.getDocumentElement();
            Element element4 = DOMUtil.getChildElementByLocalName(element3, "body");
            if (element4 == null) {
                this.error(element3, Msg.msg("missingElement", "body"));
                return false;
            }
            DOMUtil.copyChildren(element4, element2, element2.getOwnerDocument());
        }
        return true;
    }

    private void collectIds(Document document, Set<String> set) {
        Element element = document.getDocumentElement();
        Element element2 = DOMUtil.getChildElementByLocalName(element, "body");
        if (element2 == null) {
            this.warning(element, Msg.msg("missingElement", "body"));
            return;
        }
        Compiler.collectIds(element2, this.idMapIdPrefix, set);
    }

    private static void collectIds(Element element, String string, Set<String> set) {
        Object object;
        if (!"http://www.w3.org/1999/xhtml".equals(element.getNamespaceURI())) {
            return;
        }
        String string2 = null;
        if (string != null && (string2 = DOMUtil.getAttribute(element, null, "id")) != null && !string2.startsWith(string)) {
            string2 = null;
        }
        if (string2 == null) {
            Element element2;
            object = element.getLocalName();
            if ("h1".equals(object) || "h2".equals(object) || "h3".equals(object) || "h4".equals(object) || "h5".equals(object) || "h6".equals(object)) {
                String string3;
                string2 = DOMUtil.getAttribute(element, null, "id");
                if (string2 == null && (element2 = DOMUtil.getFirstChildElement(element)) != null && DOMUtil.hasName(element2, "http://www.w3.org/1999/xhtml", "a") && DOMUtil.getAttribute(element2, null, "href") == null && ((string3 = element2.getTextContent()) == null || string3.length() == 0) && (string2 = DOMUtil.getAttribute(element2, null, "name")) == null) {
                    string2 = DOMUtil.getAttribute(element2, null, "id");
                }
            } else if ("section".equals(object)) {
                string2 = DOMUtil.getAttribute(element, null, "id");
            } else if ("figure".equals(object)) {
                element2 = DOMUtil.getFirstChildElement(element);
                if (element2 != null && DOMUtil.hasName(element2, "http://www.w3.org/1999/xhtml", "figcaption") || (element2 = DOMUtil.getLastChildElement(element)) != null && DOMUtil.hasName(element2, "http://www.w3.org/1999/xhtml", "figcaption")) {
                    string2 = DOMUtil.getAttribute(element, null, "id");
                }
            } else if ("table".equals(object)) {
                element2 = DOMUtil.getFirstChildElement(element);
                if (element2 != null && DOMUtil.hasName(element2, "http://www.w3.org/1999/xhtml", "caption")) {
                    string2 = DOMUtil.getAttribute(element, null, "id");
                }
            } else if (("div".equals(object) || "blockquote".equals(object)) && (element2 = DOMUtil.getFirstChildElement(element)) != null && DOMUtil.hasName(element2, "http://www.w3.org/1999/xhtml", "h1", "h2", "h3", "h4", "h5", "h6")) {
                string2 = DOMUtil.getAttribute(element, null, "id");
            }
        }
        if (string2 != null && XMLText.isNCName((String)string2)) {
            set.add(string2);
        }
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            Compiler.collectIds((Element)object, string, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIdMap(ArrayList<Object> arrayList, File file) throws IOException {
        this.info(Msg.msg("savingIdMap", file));
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            outputStreamWriter.write("<idMap");
            outputStreamWriter.write(" title=");
            outputStreamWriter.write(XMLText.quoteXML((String)this.idMapTitle));
            outputStreamWriter.write(" href=");
            outputStreamWriter.write(XMLText.quoteXML((String)this.idMapHref));
            outputStreamWriter.write(">\n");
            int n = arrayList.size();
            for (int i = 0; i < n; i += 2) {
                String string = (String)arrayList.get(i);
                String[] stringArray = (String[])arrayList.get(i + 1);
                outputStreamWriter.write("  <page href=");
                outputStreamWriter.write(XMLText.quoteXML((String)string));
                outputStreamWriter.write(" ids=");
                outputStreamWriter.write(XMLText.quoteXML((String)StringUtil.join((char)' ', (String[])stringArray)));
                outputStreamWriter.write("/>\n");
            }
            outputStreamWriter.write("</idMap>\n");
            outputStreamWriter.flush();
        }
    }

    private void collectSearchInfo(Document document, URL uRL, Stemmer stemmer, WordCollector wordCollector, SearchInfo searchInfo) {
        int n = searchInfo.baseNameList.size();
        searchInfo.baseNameList.add(URLUtil.getRawBaseName((URL)uRL));
        String string = null;
        Element element = document.getDocumentElement();
        Element element2 = DOMUtil.getChildElementByLocalName(element, "head");
        if (element2 != null && (element2 = DOMUtil.getChildElementByLocalName(element2, "title")) != null && (string = element2.getTextContent()) != null && (string = XMLText.collapseWhiteSpace((String)string)).length() == 0) {
            string = null;
        }
        if (string == null) {
            this.warning(element, Msg.msg("missingElement", "head/title"));
            string = "???";
        }
        searchInfo.titleList.add(XMLText.escapeXML(string));
        element2 = DOMUtil.getChildElementByLocalName(element, "body");
        if (element2 == null) {
            this.warning(element, Msg.msg("missingElement", "body"));
            return;
        }
        String string2 = DOMUtil.getXHTMLLang(element);
        if (string2 == null) {
            string2 = this.defaultLang;
        }
        wordCollector.collect(element2, string2, n, stemmer, this.indexNumbers, searchInfo.wordMap);
    }

    private boolean processPage(Document document, PageTemplateInfo pageTemplateInfo, boolean bl, File file) throws IOException {
        Object object;
        Object object3;
        Object object4;
        Node node;
        Node node2;
        String string;
        Element element = document.getDocumentElement();
        boolean bl2 = false;
        DocumentType documentType = document.getDoctype();
        if (!(documentType != null && ((string = documentType.getPublicId()) != null && string.length() != 0 || (string = documentType.getSystemId()) != null && string.length() != 0 || (string = documentType.getInternalSubset()) != null && string.length() != 0))) {
            bl2 = true;
        }
        if (bl2) {
            node2 = document.getImplementation().createDocumentType("html", null, null);
            if (documentType == null) {
                document.insertBefore(node2, element);
            } else {
                document.replaceChild(node2, documentType);
            }
        }
        if ((node2 = DOMUtil.getChildElementByLocalName(element, "head")) == null) {
            this.error(element, Msg.msg("missingElement", "head"));
            return false;
        }
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            node = node3.getNextSibling();
            if (node3.getNodeType() == 1) {
                object4 = (Element)node3;
                object3 = DOMUtil.getAttribute((Element)object4, null, "charset");
                if (object3 == null && (object3 = DOMUtil.getAttribute((Element)object4, null, "http-equiv")) != null && !"content-type".equalsIgnoreCase((String)object3)) {
                    object3 = null;
                }
                if (object3 != null) {
                    node2.removeChild((Node)object4);
                }
            }
            node3 = node;
        }
        node = document.createElementNS("http://www.w3.org/1999/xhtml", "meta");
        if (bl2) {
            node.setAttributeNS(null, "charset", "UTF-8");
        } else {
            node.setAttributeNS(null, "http-equiv", "content-type");
            node.setAttributeNS(null, "content", "text/html; charset=UTF-8");
        }
        node2.insertBefore(node, node2.getFirstChild());
        object4 = null;
        for (node3 = node.getNextSibling(); node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getNodeType() != 1 || !"script".equals((object3 = (Element)node3).getLocalName())) continue;
            object4 = object3;
            break;
        }
        for (Element object22 : pageTemplateInfo.includes) {
            object = document.importNode(object22, true);
            if ("script".equals(object.getLocalName()) && object4 != null) {
                node2.insertBefore((Node)object, (Node)object4);
                continue;
            }
            node2.appendChild((Node)object);
        }
        object3 = DOMUtil.getChildElementByLocalName(element, "body");
        if (object3 == null) {
            this.error(element, Msg.msg("missingElement", "body"));
            return false;
        }
        String string2 = DOMUtil.getAttribute((Element)object3, null, "style");
        element.removeChild((Node)object3);
        Element element2 = (Element)document.importNode(pageTemplateInfo.body, true);
        element.appendChild(element2);
        Element element3 = DOMUtil.findElementById(element2, "wh-content");
        assert (element3 != null);
        DOMUtil.copyChildren((Element)object3, element3, document);
        if (string2 != null) {
            object = Compiler.splitStyleProps(string2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.startsWith("background")) continue;
                iterator.remove();
            }
            if (object.size() > 0) {
                element3.setAttributeNS(null, "style", Compiler.joinStyleProps((List<String>)object));
            }
        }
        if (bl) {
            Compiler.savePage(document, file);
        } else {
            document.setDocumentURI(FileUtil.fileToURL((File)file).toExternalForm());
        }
        return true;
    }

    private static List<String> splitStyleProps(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        StringBuilder stringBuilder = null;
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case ';': {
                    if (c != '\u0000') {
                        stringBuilder.append(c2);
                        continue block4;
                    }
                    if (stringBuilder == null) continue block4;
                    String string3 = stringBuilder.toString().trim();
                    if (string3.length() > 0) {
                        arrayList.add(string3);
                    }
                    stringBuilder = null;
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (c != '\u0000') {
                        int n2;
                        if (c2 == c && ((n2 = stringBuilder.length() - 1) < 0 || stringBuilder.charAt(n2) != '\\')) {
                            c = '\u0000';
                        }
                    } else {
                        c = c2;
                    }
                }
                default: {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        if (stringBuilder != null && (string2 = stringBuilder.toString().trim()).length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static String joinStyleProps(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    private static void savePage(Document document, File file) throws IOException {
        File file2 = new File(file.getParentFile(), file.getName() + ".WHC");
        SaveDocument.saveXHTML(document, file2);
        if (file.exists()) {
            FileUtil.deleteFileOrDir((File)file);
        }
        FileUtil.checkedRename((File)file2, (File)file);
    }

    private boolean embedCSS(Document document, URL uRL) {
        Element element = document.getDocumentElement();
        Element element2 = DOMUtil.getChildElementByLocalName(element, "head");
        if (element2 == null) {
            this.error(element, Msg.msg("missingElement", "head"));
            return false;
        }
        Node node = element2.getFirstChild();
        while (node != null) {
            String string;
            Element element3;
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 1 && (element3 = (Element)node).getLocalName().equals("link") && (string = this.loadCSS(element3, uRL)) != null) {
                Element element4 = document.createElementNS("http://www.w3.org/1999/xhtml", "style");
                element4.setAttributeNS(null, "type", "text/css");
                element4.appendChild(document.createTextNode(string));
                element2.replaceChild(element4, element3);
            }
            node = node2;
        }
        return true;
    }

    private String loadCSS(Element element, URL uRL) {
        String string = DOMUtil.getAttribute(element, null, "href");
        if (string == null) {
            return null;
        }
        if (!"text/css".equalsIgnoreCase(DOMUtil.getAttribute(element, null, "type")) && !string.endsWith(".css")) {
            return null;
        }
        String string2 = DOMUtil.getAttribute(element, null, "rel");
        if (string2 == null || (string2 = string2.trim().toLowerCase()).length() == 0 || string2.indexOf("stylesheet") < 0 || string2.indexOf("alternate") >= 0) {
            return null;
        }
        URL uRL2 = null;
        try {
            uRL2 = URLUtil.createURL((URL)uRL, (String)string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 == null) {
            this.error(element, Msg.msg("invalidURLOrFile", string));
            return null;
        }
        String string3 = null;
        try {
            string3 = LoadText.loadText((URL)uRL2, (String)"UTF-8", null, (LoadText.EncodingDetector[])new LoadText.EncodingDetector[]{LoadText.CSS_CHARSET_DETECTOR});
        }
        catch (IOException iOException) {
            this.error(element, Msg.msg("cannotLoadFile", uRL2, ThrowableUtil.reason((Throwable)iOException)));
            return null;
        }
        string3 = Util.compactCSS(string3);
        return string3;
    }

    private String simpleTOCToJS(List<String> list, List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("var toc_entries = [\n");
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuilder.append('[');
            Util.appendJSString(list.get(i), stringBuilder);
            stringBuilder.append(',');
            Util.appendJSString(list2.get(i), stringBuilder);
            if (i == n) {
                stringBuilder.append(",null]\n");
                continue;
            }
            stringBuilder.append(",null],\n");
        }
        stringBuilder.append("];\n");
        this.appendCollapseTOC(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendCollapseTOC(StringBuilder stringBuilder) {
        stringBuilder.append("var toc_initiallyCollapsed = ");
        stringBuilder.append(Boolean.toString(this.collapseTOC));
        stringBuilder.append(";\n");
    }

    private String tocToJS(URL uRL) throws IOException {
        Document document = LoadDocument.load(uRL);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("var toc_entries = [\n");
        if (!this.tocEntriesToJS(document.getDocumentElement(), stringBuilder)) {
            return null;
        }
        stringBuilder.append("];\n");
        this.appendCollapseTOC(stringBuilder);
        return stringBuilder.toString();
    }

    private boolean tocEntriesToJS(Element element, StringBuilder stringBuilder) {
        boolean bl = true;
        boolean bl2 = true;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"entry".equals(node.getLocalName())) continue;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",\n");
            }
            if (this.tocEntryToJS((Element)node, stringBuilder)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean tocEntryToJS(Element element, StringBuilder stringBuilder) {
        String string = DOMUtil.getAttribute(element, null, "href");
        if (string != null) {
            string = XMLText.escapeXML((String)string);
        }
        String string2 = null;
        boolean bl = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String string3 = node.getLocalName();
            if ("title".equals(string3)) {
                string2 = SaveDocument.xhtmlToString(node);
                continue;
            }
            if (!"entry".equals(string3)) continue;
            bl = true;
            break;
        }
        if (string2 == null) {
            this.error(element, Msg.msg("missingElement", "title"));
            return false;
        }
        boolean bl2 = true;
        stringBuilder.append('[');
        Util.appendJSString(string2, stringBuilder);
        if (string == null) {
            stringBuilder.append(",null");
        } else {
            stringBuilder.append(',');
            Util.appendJSString(string, stringBuilder);
        }
        if (bl) {
            stringBuilder.append(",[\n");
            bl2 = this.tocEntriesToJS(element, stringBuilder);
            stringBuilder.append("\n]");
        } else {
            stringBuilder.append(",null");
        }
        stringBuilder.append(']');
        return bl2;
    }

    private String indexToJS(Document document, String string) throws IOException {
        IndexEntry[] indexEntryArray = this.loadIndex(document, string);
        if (indexEntryArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("var index_entries = [\n");
        if (!this.indexEntriesToJS(indexEntryArray, stringBuilder)) {
            return null;
        }
        stringBuilder.append("\n];\n");
        return stringBuilder.toString();
    }

    private IndexEntry[] loadIndex(Document document, String string) throws IOException {
        Object object;
        Object object2;
        IndexEntry[] indexEntryArray;
        String string2;
        Element element = document.getDocumentElement();
        String string3 = element.getAttributeNS(null, "termSeparator");
        if (string3 == null || string3.length() == 0) {
            string3 = ", ";
        }
        if ((string2 = DOMUtil.getAttribute(element, "http://www.w3.org/XML/1998/namespace", "lang")) == null) {
            string2 = string;
        }
        assert (string2 != null);
        Locale locale = LocaleUtil.getLocale((String)string2);
        boolean bl = DOMUtil.getBooleanAttribute(element, null, "mergeAndSort", false);
        boolean bl2 = DOMUtil.getBooleanAttribute(element, null, "caseSensitive", false);
        ArrayList<IndexEntry[]> arrayList = new ArrayList<IndexEntry[]>();
        HashMap<Object, IndexEntry[]> hashMap = new HashMap<Object, IndexEntry[]>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"entry".equals(node.getLocalName())) continue;
            try {
                indexEntryArray = IndexEntry.parse((Element)node);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object2 = illegalArgumentException.getMessage();
                object2 = object2 == null || ((String)object2).length() == 0 ? Msg.msg("invalidIndexEntry") : Msg.msg("invalidIndexEntry2", object2);
                this.error((Element)node, (String)object2);
                return null;
            }
            if (bl) {
                object = indexEntryArray.term.text;
                if (!bl2) {
                    object = ((String)object).toLowerCase(locale);
                }
                if ((object2 = (IndexEntry)hashMap.get(object)) == null) {
                    hashMap.put(object, indexEntryArray);
                    arrayList.add(indexEntryArray);
                    continue;
                }
                ((IndexEntry)object2).merge((IndexEntry)indexEntryArray, bl2, locale);
                continue;
            }
            arrayList.add(indexEntryArray);
        }
        indexEntryArray = new IndexEntry[arrayList.size()];
        arrayList.toArray(indexEntryArray);
        arrayList = null;
        if (!this.fixUpRefs(indexEntryArray, string3)) {
            return null;
        }
        if (bl) {
            object = Compiler.createTermCollator(locale);
            object2 = new Comparator<IndexEntry>((Collator)object){
                final /* synthetic */ Collator val$termCollator;
                {
                    this.val$termCollator = collator;
                }

                @Override
                public int compare(IndexEntry indexEntry, IndexEntry indexEntry2) {
                    String string;
                    String string2;
                    String string3 = indexEntry.term.sortAs;
                    String string4 = string3 == null ? indexEntry.term.text : string3;
                    int n = this.val$termCollator.compare(string4, string2 = (string = indexEntry2.term.sortAs) == null ? indexEntry2.term.text : string);
                    if (n != 0) {
                        return n;
                    }
                    return this.val$termCollator.compare(indexEntry.term.text, indexEntry2.term.text);
                }
            };
            Comparator<IndexRef> comparator = new Comparator<IndexRef>((Collator)object){
                final /* synthetic */ Collator val$termCollator;
                {
                    this.val$termCollator = collator;
                }

                @Override
                public int compare(IndexRef indexRef, IndexRef indexRef2) {
                    return this.val$termCollator.compare(indexRef.termText, indexRef2.termText);
                }
            };
            Arrays.sort(indexEntryArray, object2);
            for (IndexEntry indexEntry : indexEntryArray) {
                Compiler.sortEntry(indexEntry, comparator, (Comparator<IndexEntry>)object2);
            }
        }
        return indexEntryArray;
    }

    private boolean fixUpRefs(IndexEntry[] indexEntryArray, String string) {
        Stack<IndexTerm> stack = new Stack<IndexTerm>();
        HashMap<String, IndexTerm> hashMap = new HashMap<String, IndexTerm>();
        for (IndexEntry indexEntry : indexEntryArray) {
            while (!stack.empty()) {
                stack.pop();
            }
            Compiler.mapIdToTerm(indexEntry, string, stack, hashMap);
        }
        for (IndexEntry indexEntry : indexEntryArray) {
            if (this.fixUpRefs(indexEntry, hashMap)) continue;
            return false;
        }
        return true;
    }

    private static void mapIdToTerm(IndexEntry indexEntry, String string, Stack<IndexTerm> stack, Map<String, IndexTerm> map) {
        IndexEntry[] indexEntryArray;
        IndexTerm indexTerm = indexEntry.term;
        if (!stack.empty()) {
            indexTerm = stack.peek().append(indexTerm, string);
        }
        if (indexEntry.id != null) {
            map.put(indexEntry.id, indexTerm);
        }
        if ((indexEntryArray = indexEntry.entryList) != null) {
            stack.push(indexTerm);
            for (IndexEntry indexEntry2 : indexEntryArray) {
                Compiler.mapIdToTerm(indexEntry2, string, stack, map);
            }
            stack.pop();
        }
    }

    private boolean fixUpRefs(IndexEntry indexEntry, Map<String, IndexTerm> map) {
        Object object;
        int n;
        int n2;
        Object[] objectArray;
        IndexRef[] indexRefArray = indexEntry.seeList;
        if (indexRefArray != null) {
            objectArray = indexRefArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (this.fixUpRef("see", (IndexRef)object, map)) continue;
                return false;
            }
        }
        if ((indexRefArray = indexEntry.seeAlsoList) != null) {
            objectArray = indexRefArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (this.fixUpRef("seeAlso", (IndexRef)object, map)) continue;
                return false;
            }
        }
        if ((objectArray = indexEntry.entryList) != null) {
            for (Object object2 : objectArray) {
                this.fixUpRefs((IndexEntry)object2, map);
            }
        }
        return true;
    }

    private boolean fixUpRef(String string, IndexRef indexRef, Map<String, IndexTerm> map) {
        if (indexRef.termText == null) {
            if (indexRef.ref == null) {
                this.error(Msg.msg("voidElement", string));
                return false;
            }
            IndexTerm indexTerm = map.get(indexRef.ref);
            if (indexTerm == null) {
                this.error(Msg.msg("missingElementWithID", "entry", indexRef.ref));
                return false;
            }
            indexRef.termHTML = indexTerm.html;
            indexRef.termText = indexTerm.text;
        }
        return true;
    }

    private static Collator createTermCollator(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        collator.setDecomposition(2);
        collator.setStrength(3);
        return collator;
    }

    private static void sortEntry(IndexEntry indexEntry, Comparator<IndexRef> comparator, Comparator<IndexEntry> comparator2) {
        IndexEntry[] indexEntryArray;
        IndexRef[] indexRefArray = indexEntry.seeList;
        if (indexRefArray != null && indexRefArray.length > 1) {
            Arrays.sort(indexRefArray, comparator);
        }
        if ((indexRefArray = indexEntry.seeAlsoList) != null && indexRefArray.length > 1) {
            Arrays.sort(indexRefArray, comparator);
        }
        if ((indexEntryArray = indexEntry.entryList) != null) {
            if (indexEntryArray.length > 1) {
                Arrays.sort(indexEntryArray, comparator2);
            }
            for (IndexEntry indexEntry2 : indexEntryArray) {
                Compiler.sortEntry(indexEntry2, comparator, comparator2);
            }
        }
    }

    private boolean indexEntriesToJS(IndexEntry[] indexEntryArray, StringBuilder stringBuilder) {
        boolean bl = true;
        for (IndexEntry indexEntry : indexEntryArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",\n");
            }
            if (this.indexEntryToJS(indexEntry, stringBuilder)) continue;
            return false;
        }
        return true;
    }

    private boolean indexEntryToJS(IndexEntry indexEntry, StringBuilder stringBuilder) {
        int n;
        IndexRef[] indexRefArray = indexEntry.seeList;
        IndexAnchor[] indexAnchorArray = indexEntry.anchorList;
        IndexRef[] indexRefArray2 = indexEntry.seeAlsoList;
        IndexEntry[] indexEntryArray = indexEntry.entryList;
        if (indexRefArray == null && indexAnchorArray == null && indexEntryArray == null) {
            this.error(Msg.msg("uselessIndexEntry", indexEntry.term.text));
            return false;
        }
        stringBuilder.append('{');
        if (indexEntry.id != null) {
            stringBuilder.append("id: ");
            Util.appendJSString(indexEntry.id, stringBuilder);
            stringBuilder.append(',');
        }
        stringBuilder.append("term: ");
        Util.appendJSString(indexEntry.term.html, stringBuilder);
        if (indexRefArray != null && (n = indexRefArray.length) > 0) {
            stringBuilder.append(",\nsee: [");
            for (int i = 0; i < n; ++i) {
                IndexRef indexRef = indexRefArray[i];
                if (i > 0) {
                    stringBuilder.append(',');
                }
                if (indexRef.ref != null) {
                    stringBuilder.append('[');
                    Util.appendJSString(indexRef.ref, stringBuilder);
                    stringBuilder.append(',');
                }
                Util.appendJSString(indexRef.termHTML, stringBuilder);
                if (indexRef.ref == null) continue;
                stringBuilder.append(']');
            }
            stringBuilder.append(']');
        } else {
            Object object;
            int n2;
            if (indexAnchorArray != null && (n = indexAnchorArray.length) > 0) {
                stringBuilder.append(",\nanchor: [");
                for (n2 = 0; n2 < n; ++n2) {
                    object = indexAnchorArray[n2];
                    String string = XMLText.escapeXML((String)((IndexAnchor)object).href);
                    String string2 = ((IndexAnchor)object).href2;
                    if (n2 > 0) {
                        stringBuilder.append(',');
                    }
                    Util.appendJSString(string, stringBuilder);
                    if (string2 == null) {
                        stringBuilder.append(",null");
                        continue;
                    }
                    stringBuilder.append(',');
                    string2 = XMLText.escapeXML((String)string2);
                    Util.appendJSString(string2, stringBuilder);
                }
                stringBuilder.append(']');
            }
            if (indexRefArray2 != null && (n = indexRefArray2.length) > 0) {
                stringBuilder.append(",\nseeAlso: [");
                for (n2 = 0; n2 < n; ++n2) {
                    object = indexRefArray2[n2];
                    if (n2 > 0) {
                        stringBuilder.append(',');
                    }
                    if (((IndexRef)object).ref != null) {
                        stringBuilder.append('[');
                        Util.appendJSString(((IndexRef)object).ref, stringBuilder);
                        stringBuilder.append(',');
                    }
                    Util.appendJSString(((IndexRef)object).termHTML, stringBuilder);
                    if (((IndexRef)object).ref == null) continue;
                    stringBuilder.append(']');
                }
                stringBuilder.append(']');
            }
            if (indexEntryArray != null && indexEntryArray.length > 0) {
                stringBuilder.append(",\nentry: [\n");
                if (!this.indexEntriesToJS(indexEntryArray, stringBuilder)) {
                    return false;
                }
                stringBuilder.append("\n]");
            }
        }
        stringBuilder.append('}');
        return true;
    }

    private static String[] listSkippedLayouts(String string, List<String> list) {
        String[] stringArray = StringList.EMPTY_LIST;
        for (String string2 : list) {
            if (string.equals(string2)) continue;
            stringArray = StringList.append((String[])stringArray, (String)("." + string2 + "."));
        }
        return stringArray;
    }

    private String compileCSS(HashMap<String, String> hashMap, String string, String[] stringArray, boolean bl, List<URL> list) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Matcher matcher = Pattern.compile("^(--[^:]+):([^;]+);").matcher("");
        for (URL uRL : list) {
            String string2 = URLUtil.getBaseName((URL)uRL);
            int n = Compiler.parseRank(string2, string, stringArray, bl, ".css");
            if (n < 0) continue;
            String string3 = URLUtil.loadString((URL)uRL, (String)"UTF-8");
            stringBuilder.append("/* ");
            stringBuilder.append(string2);
            stringBuilder.append(" ======================================== */\n\n");
            String[] stringArray2 = StringUtil.split((String)string3, (char)'\n');
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string4 = stringArray2[i];
                matcher.reset(string4.trim());
                if (matcher.find()) {
                    String string5 = matcher.group(1).trim();
                    String string6 = matcher.group(2).trim();
                    if ((string6 = this.substituteCSSVars(string6, hashMap2, uRL, i)) == null) {
                        return null;
                    }
                    hashMap2.putIfAbsent(string5, string6);
                    continue;
                }
                if ((string4 = this.substituteCSSVars(string4, hashMap2, uRL, i)) == null) {
                    return null;
                }
                stringBuilder.append(string4);
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static int parseRank(String string, String string2, String[] stringArray, boolean bl, String string3) {
        if (!string.endsWith(string3)) {
            return -1;
        }
        if (!bl && string.lastIndexOf(".responsive.") >= 0) {
            return -1;
        }
        boolean bl2 = false;
        for (String string4 : stringArray) {
            if (string.lastIndexOf(string4) < 0) continue;
            bl2 = true;
            break;
        }
        if (bl2 && string.lastIndexOf(string2) < 0) {
            return -1;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            n = i;
            break;
        }
        if (n == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String substituteCSSVars(String string, Map<String, String> map, URL uRL, int n) {
        int n2;
        int n3;
        StringBuilder stringBuilder = null;
        int n4 = 0;
        while ((n3 = string.indexOf("var(", n4)) >= 0 && (n2 = string.indexOf(41, n3 + 4)) >= 0) {
            String string2;
            String string3 = string.substring(n3 + 4, n2).trim();
            if (string3.length() == 0 || (string2 = map.get(string3)) == null) {
                this.error(Msg.msg("unknownCSSVar", string3, URLUtil.toLabel((URL)uRL), Integer.toString(1 + n)));
                return null;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (n3 > n4) {
                stringBuilder.append(string.substring(n4, n3));
            }
            stringBuilder.append(string2);
            n4 = n2 + 1;
        }
        if (stringBuilder == null) {
            return string;
        }
        stringBuilder.append(string.substring(n4));
        return stringBuilder.toString();
    }

    private String compileJS(String string, String string2, String string3, String string4, String string5, String[] stringArray, boolean bl, List<URL> list) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (URL uRL : list) {
            String string6;
            String string7;
            String string8 = URLUtil.getBaseName((URL)uRL);
            int n2 = Compiler.parseRank(string8, string5, stringArray, bl, ".js");
            if (n2 < 0) continue;
            String string9 = Integer.toString(n2);
            if (n2 >= 20 && n2 < 80) {
                if (n == 0) {
                    n = 1;
                    stringBuilder.append("var wh = (function () {\n\n");
                }
            } else if (n2 >= 80 && n == 1) {
                n = 2;
                Compiler.endWrapJS(arrayList, stringBuilder);
            }
            boolean bl2 = false;
            if (string8.equals(string9 + "toc.js")) {
                string7 = string3;
                string6 = "toc.js";
                bl2 = true;
            } else if (string8.equals(string9 + "index.js")) {
                string7 = string4;
                string6 = "index.js";
                bl2 = true;
            } else {
                string7 = URLUtil.loadString((URL)uRL, (String)"UTF-8");
                string6 = string8;
            }
            if (string7 == null) continue;
            stringBuilder.append("/* ");
            stringBuilder.append(string6);
            stringBuilder.append(" ============================== */\n\n");
            if (bl2) {
                stringBuilder.append(string7);
            } else {
                String[] stringArray2;
                for (String string10 : stringArray2 = StringUtil.split((String)string7, (char)'\n')) {
                    String string11 = Compiler.getPublicFunctionName(string10);
                    if (string11 != null) {
                        arrayList.add(string11);
                    } else if (string10.indexOf("var storageId =") >= 0) {
                        string10 = "var storageId = \"" + string2 + "\";";
                    } else if (string != null && string10.indexOf("var preferredUserLanguage =") >= 0) {
                        string10 = "var preferredUserLanguage = \"" + string + "\";";
                    }
                    stringBuilder.append(string10);
                    stringBuilder.append('\n');
                }
            }
            stringBuilder.append('\n');
        }
        if (n == 1) {
            n = 2;
            Compiler.endWrapJS(arrayList, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static String getPublicFunctionName(String string) {
        int n = string.indexOf("/*public*/ function ");
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(40, n += "/*public*/ function ".length());
        if (n2 <= n) {
            return null;
        }
        String string2 = string.substring(n, n2).trim();
        return string2.length() == 0 ? null : string2;
    }

    private static void endWrapJS(List<String> list, StringBuilder stringBuilder) {
        stringBuilder.append("return {\n");
        for (String string : list) {
            stringBuilder.append("    ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(string);
            stringBuilder.append(",\n");
        }
        stringBuilder.append("}\n\n})();\n\n");
    }

    private void internalError(String string) {
        string = Msg.msg("internalError") + " " + string;
        if (this.console == null) {
            System.err.println(string);
        } else {
            this.console.showMessage(string, Console.MessageType.ERROR);
        }
    }

    private void error(String string) {
        if (this.console == null) {
            System.err.println(Msg.msg("error") + " " + string);
        } else {
            this.console.showMessage(string, Console.MessageType.ERROR);
        }
    }

    private void warning(String string) {
        if (this.console == null) {
            System.err.println(Msg.msg("warning") + " " + string);
        } else {
            this.console.showMessage(string, Console.MessageType.WARNING);
        }
    }

    private void info(String string) {
        if (this.verbose) {
            if (this.console == null) {
                System.out.println(string);
            } else {
                this.console.showMessage(string, Console.MessageType.INFO);
            }
        }
    }

    private void error(Element element, String string) {
        this.error(Compiler.prependElementLocation(element, string));
    }

    private void warning(Element element, String string) {
        this.warning(Compiler.prependElementLocation(element, string));
    }

    private static String prependElementLocation(Element element, String string) {
        if (element != null) {
            NodeLocation nodeLocation = (NodeLocation)element.getUserData("NODE_LOCATION");
            if (nodeLocation == null) {
                nodeLocation = NodeLocation.UNKNOWN_LOCATION;
            }
            StringBuilder stringBuilder = new StringBuilder();
            nodeLocation.toString(stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Object object;
        Serializable serializable;
        String string;
        int n;
        boolean bl = false;
        URL uRL = null;
        URL uRL2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            string = stringArray[n];
            if ("-v".equals(string)) {
                bl = true;
                continue;
            }
            if ("-toc".equals(string)) {
                if (n + 1 >= n2) {
                    Compiler.usage(null);
                }
                if ((uRL = URLUtil.urlOrFile((String)stringArray[++n])) != null) continue;
                Compiler.usage(Msg.msg("invalidURLOrFile", stringArray[n]));
                continue;
            }
            if ("-index".equals(string)) {
                if (n + 1 >= n2) {
                    Compiler.usage(null);
                }
                if ((uRL2 = URLUtil.urlOrFile((String)stringArray[++n])) != null) continue;
                Compiler.usage(Msg.msg("invalidURLOrFile", stringArray[n]));
                continue;
            }
            if ("-p".equals(string)) {
                if (n + 2 >= n2) {
                    Compiler.usage(null);
                }
                arrayList.add(stringArray[++n]);
                arrayList.add(stringArray[++n]);
                continue;
            }
            if ("-template".equals(string)) {
                if (n + 1 >= n2) {
                    Compiler.usage(null);
                }
                if ((serializable = URLUtil.urlOrFile((String)stringArray[++n])) == null) {
                    Compiler.usage(Msg.msg("invalidURLOrFile", stringArray[n]));
                }
                Compiler.setTemplateManifestURL((URL)serializable);
                continue;
            }
            if (!string.startsWith("-") || "-".equals(string)) break;
            Compiler.usage(null);
            break;
        }
        if (n + 1 >= n2) {
            Compiler.usage(null);
        }
        serializable = null;
        if (!"-".equals(string = stringArray[n++]) && !(serializable = new File(string)).isDirectory()) {
            Compiler.usage(Msg.msg("notADir", string));
        }
        URL[] uRLArray = new URL[n2 - n];
        int n3 = 0;
        while (n < n2) {
            object = URLUtil.urlOrFile((String)stringArray[n]);
            if (object == null) {
                Compiler.usage(Msg.msg("invalidURLOrFile", stringArray[n]));
            }
            uRLArray[n3++] = object;
            ++n;
        }
        object = new Compiler(null);
        ((Compiler)object).setVerbose(bl);
        if (arrayList.size() > 0 && !((Compiler)object).parseParameters(arrayList.toArray(StringUtil.EMPTY_LIST))) {
            System.exit(2);
        }
        String string2 = null;
        try {
            if (!((Compiler)object).compile(uRLArray, uRL, uRL2, (File)serializable)) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            string2 = ThrowableUtil.reason((Throwable)exception);
        }
        if (string2 != null) {
            if (string2.length() > 0) {
                System.err.println(Msg.msg("cannotCompile2", string2));
            } else {
                System.err.println(Msg.msg("cannotCompile"));
            }
            System.exit(3);
        }
    }

    private static void usage(String string) {
        if (string != null) {
            System.err.println(Msg.msg("error") + " " + string);
        }
        System.err.println(Msg.msg("usage"));
        System.exit(1);
    }
}

