/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi;

import java.io.UnsupportedEncodingException;

public final class GdiUtils {
    private static int[][] FBA_SHIFT_JIS = new int[][]{{129, 159}, {224, 252}};
    private static int[][] FBA_HANGUL_CHARSET = new int[][]{{128, 255}};
    private static int[][] FBA_JOHAB_CHARSET = new int[][]{{128, 255}};
    private static int[][] FBA_GB2312_CHARSET = new int[][]{{128, 255}};
    private static int[][] FBA_CHINESEBIG5_CHARSET = new int[][]{{161, 254}};

    public static String convertString(byte[] chars, int charset) {
        int length;
        String str = null;
        for (length = 0; length < chars.length && chars[length] != 0; ++length) {
        }
        try {
            str = new String(chars, 0, length, GdiUtils.getCharset(charset));
        }
        catch (UnsupportedEncodingException e) {
            try {
                str = new String(chars, 0, length, "US-ASCII");
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalStateException(e2);
            }
        }
        return str;
    }

    public static String getCharset(int charset) {
        switch (charset) {
            case 0: {
                return "Cp1252";
            }
            case 2: {
                return "ISO-8859-1";
            }
            case 77: {
                return "MacRoman";
            }
            case 128: {
                return "MS932";
            }
            case 129: {
                return "MS949";
            }
            case 130: {
                return "Johab";
            }
            case 134: {
                return "MS936";
            }
            case 136: {
                return "MS950";
            }
            case 161: {
                return "Cp1253";
            }
            case 162: {
                return "Cp1254";
            }
            case 163: {
                return "Cp1258";
            }
            case 177: {
                return "Cp1255";
            }
            case 178: {
                return "Cp1256";
            }
            case 186: {
                return "Cp1257";
            }
            case 204: {
                return "Cp1251";
            }
            case 222: {
                return "MS874";
            }
            case 238: {
                return "Cp1250";
            }
            case 255: {
                return "Cp1252";
            }
        }
        return "Cp1252";
    }

    public static String getLanguage(int charset) {
        switch (charset) {
            case 0: {
                return "en";
            }
            case 2: {
                return "en";
            }
            case 77: {
                return "en";
            }
            case 128: {
                return "ja";
            }
            case 129: {
                return "ko";
            }
            case 130: {
                return "ko";
            }
            case 134: {
                return "zh-CN";
            }
            case 136: {
                return "zh-TW";
            }
            case 161: {
                return "el";
            }
            case 162: {
                return "tr";
            }
            case 163: {
                return "vi";
            }
            case 177: {
                return "iw";
            }
            case 178: {
                return "ar";
            }
            case 186: {
                return "bat";
            }
            case 204: {
                return "ru";
            }
            case 222: {
                return "th";
            }
            case 238: {
                return null;
            }
            case 255: {
                return null;
            }
        }
        return null;
    }

    public static int[][] getFirstByteArea(int charset) {
        switch (charset) {
            case 128: {
                return FBA_SHIFT_JIS;
            }
            case 129: {
                return FBA_HANGUL_CHARSET;
            }
            case 130: {
                return FBA_JOHAB_CHARSET;
            }
            case 134: {
                return FBA_GB2312_CHARSET;
            }
            case 136: {
                return FBA_CHINESEBIG5_CHARSET;
            }
        }
        return null;
    }
}

