/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpointer;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.xpointer.ElementScheme;
import com.xmlmind.xml.xpointer.ElementXPointer;
import com.xmlmind.xml.xpointer.Msg;
import com.xmlmind.xml.xpointer.NamespaceBindings;
import com.xmlmind.xml.xpointer.SimpleXPointer;
import com.xmlmind.xml.xpointer.SimpleXPointerScheme;
import com.xmlmind.xml.xpointer.XPointerException;
import com.xmlmind.xml.xpointer.XPointerScheme;
import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class XPointer {
    public final SimpleXPointer[] pointers;
    public final String stringForm;
    private static final IdentityHashMap<Name, SimpleXPointerScheme> schemeRegistry = new IdentityHashMap();

    public XPointer(String string) throws XPointerException {
        this.pointers = XPointer.parse(string);
        this.stringForm = string;
    }

    /*
     * WARNING - void declaration
     */
    public Node[] findNodes(Document document) throws XPointerException {
        void var2_5;
        for (SimpleXPointer simpleXPointer : this.pointers) {
            Node[] nodeArray = simpleXPointer.findNodes(document, null);
            if (nodeArray == null || nodeArray.length <= 0) continue;
            return nodeArray;
        }
        String string = "???";
        URL uRL = document.getSourceURL();
        if (uRL != null) {
            String string2 = uRL.toExternalForm();
        }
        throw new XPointerException(Msg.msg("nodesNotFound", this.stringForm, var2_5));
    }

    public static SimpleXPointer[] parse(String string) throws XPointerException {
        SimpleXPointer[] simpleXPointerArray = null;
        String string2 = null;
        if (string == null || (string = string.trim()).length() == 0) {
            string2 = Msg.msg("emptyXPointer");
        } else if (string.indexOf(40) < 0) {
            if (!XMLText.isName(string)) {
                string2 = Msg.msg("notAName", string);
            } else {
                simpleXPointerArray = new SimpleXPointer[]{new ElementXPointer(string)};
            }
        } else {
            String[] stringArray = null;
            try {
                stringArray = XPointer.split(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = illegalArgumentException.getMessage();
            }
            if (stringArray != null) {
                NamespaceBindings namespaceBindings = new NamespaceBindings();
                simpleXPointerArray = new SimpleXPointer[stringArray.length / 2];
                int n = 0;
                for (int i = 0; i < stringArray.length; i += 2) {
                    SimpleXPointer simpleXPointer;
                    String string3 = stringArray[i];
                    String string4 = stringArray[i + 1];
                    if ("xmlns".equals(string3)) {
                        namespaceBindings.add(string4);
                        continue;
                    }
                    Name name = Name.parse(string3, false, namespaceBindings);
                    if (name == null) {
                        string2 = Msg.msg("notAName", string3);
                        break;
                    }
                    SimpleXPointerScheme simpleXPointerScheme = XPointer.getScheme(name);
                    if (simpleXPointerScheme == null) continue;
                    try {
                        simpleXPointer = simpleXPointerScheme.parseXPointer(name, string4, namespaceBindings);
                        if (simpleXPointer == null) {
                            throw new RuntimeException(Msg.msg("xptrSchemeSyntaxError", string4, string3));
                        }
                    }
                    catch (Exception exception) {
                        string2 = ThrowableUtil.reason(exception);
                        break;
                    }
                    simpleXPointerArray[n++] = simpleXPointer;
                }
                if (string2 == null) {
                    if (n == 0) {
                        string2 = Msg.msg("emptyXPointer");
                    } else if (n != simpleXPointerArray.length) {
                        simpleXPointerArray = ArrayUtil.trimToSize(simpleXPointerArray, n);
                    }
                }
                if (string2 != null) {
                    simpleXPointerArray = null;
                }
            }
        }
        if (string2 != null) {
            throw new XPointerException(Msg.msg("cannotParseXPointer", string, string2));
        }
        return simpleXPointerArray;
    }

    public static String[] split(String string) throws IllegalArgumentException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = null;
        int n2 = 0;
        int n3 = string.length();
        block8: for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            if (Character.isWhitespace(c)) {
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder == null) {
                assert (n2 == 0);
                stringBuilder = new StringBuilder();
                if (!XMLText.isNCNameStartChar(c)) {
                    throw new IllegalArgumentException(Msg.msg("charNotAllowed", 1 + n, Character.valueOf(c)));
                }
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case '^': {
                    if (n2 > 0) {
                        if (n + 1 >= n3) continue block8;
                        char c2 = string.charAt(n + 1);
                        switch (c2) {
                            case '(': 
                            case ')': 
                            case '^': {
                                stringBuilder.append(c2);
                                ++n;
                                continue block8;
                            }
                        }
                        throw new IllegalArgumentException(Msg.msg("charNotAllowed", 1 + n + 1, Character.valueOf(c2)));
                    }
                    throw new IllegalArgumentException(Msg.msg("charNotAllowed", 1 + n, Character.valueOf(c)));
                }
                case '(': {
                    if (n2 > 0) {
                        stringBuilder.append(c);
                    } else {
                        String string2 = stringBuilder.toString();
                        if (!XMLText.isName(string2)) {
                            throw new IllegalArgumentException(Msg.msg("notAName", string2));
                        }
                        arrayList.add(string2);
                        stringBuilder = new StringBuilder();
                    }
                    ++n2;
                    continue block8;
                }
                case ')': {
                    if (--n2 > 0) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = null;
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder != null) {
            throw new IllegalArgumentException(Msg.msg("xptrFrameworkSyntaxError"));
        }
        n = arrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException(Msg.msg("emptyXPointer"));
        }
        String[] stringArray = new String[n];
        return arrayList.toArray(stringArray);
    }

    public String toString() {
        return this.stringForm;
    }

    public static Node[] findNodes(String string, Document document) {
        Node[] nodeArray = null;
        try {
            XPointer xPointer = new XPointer(string);
            nodeArray = xPointer.findNodes(document);
        }
        catch (XPointerException xPointerException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerScheme(SimpleXPointerScheme simpleXPointerScheme) {
        IdentityHashMap<Name, SimpleXPointerScheme> identityHashMap = schemeRegistry;
        synchronized (identityHashMap) {
            for (Name name : simpleXPointerScheme.getSchemeNames()) {
                schemeRegistry.put(name, simpleXPointerScheme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleXPointerScheme getScheme(Name name) {
        IdentityHashMap<Name, SimpleXPointerScheme> identityHashMap = schemeRegistry;
        synchronized (identityHashMap) {
            return schemeRegistry.get(name);
        }
    }

    static {
        schemeRegistry.put(ElementScheme.SCHEME_NAMES[0], new ElementScheme());
        schemeRegistry.put(XPointerScheme.SCHEME_NAMES[0], new XPointerScheme());
    }
}

