/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixEntries;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.ExprContextImpl;
import com.xmlmind.xml.xpath.ExprParser;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NodeSetExpr;
import com.xmlmind.xml.xpath.NumberExpr;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.PathPattern;
import com.xmlmind.xml.xpath.StringExpr;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantBase;
import com.xmlmind.xml.xpath.VariantExpr;
import java.util.ArrayList;

public final class XPathUtil {
    private XPathUtil() {
    }

    public static String evalAsString(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsString(string, null, xNode, null);
    }

    public static String evalAsString(String string, PrefixEntry[] prefixEntryArray, XNode xNode, Object[] objectArray) throws ParseException, EvalException {
        StringExpr stringExpr = ExprParser.parseStringExpr(string, XPathUtil.prefixToNS(prefixEntryArray, xNode));
        return stringExpr.eval(xNode, XPathUtil.createExprContext(objectArray));
    }

    private static PrefixToNamespace prefixToNS(PrefixEntry[] prefixEntryArray, XNode xNode) {
        if (prefixEntryArray == null || prefixEntryArray.length == 0) {
            return xNode.namespacePrefixMap();
        }
        return new PrefixEntries(prefixEntryArray);
    }

    private static ExprContext createExprContext(Object[] objectArray) {
        int n;
        ExprContextImpl exprContextImpl = new ExprContextImpl();
        if (objectArray != null && (n = objectArray.length) > 0) {
            n = 2 * (n / 2);
            for (int i = 0; i < n; i += 2) {
                Object object = objectArray[i];
                Object object2 = objectArray[i + 1];
                Name name = null;
                if (object instanceof Name) {
                    name = (Name)object;
                } else if (object instanceof String && XMLText.isNCName((String)object)) {
                    name = Name.get((String)object);
                }
                if (name == null) continue;
                Variant variant = object2 instanceof Variant ? (Variant)object2 : VariantBase.create(object2);
                exprContextImpl.setGlobalVariable(name, variant);
            }
        }
        return exprContextImpl;
    }

    public static double evalAsNumber(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsNumber(string, null, xNode, null);
    }

    public static double evalAsNumber(String string, PrefixEntry[] prefixEntryArray, XNode xNode, Object[] objectArray) throws ParseException, EvalException {
        NumberExpr numberExpr = ExprParser.parseNumberExpr(string, XPathUtil.prefixToNS(prefixEntryArray, xNode));
        return numberExpr.eval(xNode, XPathUtil.createExprContext(objectArray));
    }

    public static boolean evalAsBoolean(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsBoolean(string, null, xNode, null);
    }

    public static boolean evalAsBoolean(String string, PrefixEntry[] prefixEntryArray, XNode xNode, Object[] objectArray) throws ParseException, EvalException {
        BooleanExpr booleanExpr = ExprParser.parseBooleanExpr(string, XPathUtil.prefixToNS(prefixEntryArray, xNode));
        return booleanExpr.eval(xNode, XPathUtil.createExprContext(objectArray));
    }

    public static XNode[] evalAsNodeSet(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsNodeSet(string, null, xNode, null);
    }

    public static XNode[] evalAsNodeSet(String string, PrefixEntry[] prefixEntryArray, XNode xNode, Object[] objectArray) throws ParseException, EvalException {
        XNode[] xNodeArray;
        NodeSetExpr nodeSetExpr = ExprParser.parseNodeSetExpr(string, XPathUtil.prefixToNS(prefixEntryArray, xNode));
        NodeIterator nodeIterator = nodeSetExpr.eval(xNode, XPathUtil.createExprContext(objectArray));
        ArrayList<XNode[]> arrayList = new ArrayList<XNode[]>();
        while ((xNodeArray = nodeIterator.next()) != null) {
            arrayList.add(xNodeArray);
        }
        xNodeArray = new XNode[arrayList.size()];
        arrayList.toArray(xNodeArray);
        return xNodeArray;
    }

    public static Variant evalAsVariant(String string, XNode xNode) throws ParseException, EvalException {
        return XPathUtil.evalAsVariant(string, null, xNode, null);
    }

    public static Variant evalAsVariant(String string, PrefixEntry[] prefixEntryArray, XNode xNode, Object[] objectArray) throws ParseException, EvalException {
        VariantExpr variantExpr = ExprParser.parseVariantExpr(string, XPathUtil.prefixToNS(prefixEntryArray, xNode));
        return variantExpr.eval(xNode, XPathUtil.createExprContext(objectArray));
    }

    public static boolean matches(XNode xNode, String string) throws ParseException, EvalException {
        return XPathUtil.matches(xNode, string, null, null);
    }

    public static boolean matches(XNode xNode, String string, PrefixEntry[] prefixEntryArray, Object[] objectArray) throws ParseException, EvalException {
        PathPattern pathPattern = ExprParser.parsePattern(string, XPathUtil.prefixToNS(prefixEntryArray, xNode));
        return pathPattern.matches(xNode, XPathUtil.createExprContext(objectArray));
    }

    public static Element toElement(NodeIterator nodeIterator) {
        XNode xNode = null;
        try {
            xNode = nodeIterator.next();
        }
        catch (EvalException evalException) {
            // empty catch block
        }
        if (xNode == null || !(xNode instanceof Node)) {
            return null;
        }
        if (xNode.type() == XNode.Type.ELEMENT) {
            return (Element)xNode;
        }
        return ((Node)xNode).getParentElement();
    }
}

