/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function1;
import com.xmlmind.xml.xpath.ParseException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

class URIToFileNameFunction
extends Function1 {
    URIToFileNameFunction() {
    }

    @Override
    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                URL uRL;
                String string = convertibleStringExpr.eval(xNode, exprContext);
                try {
                    uRL = URLUtil.newURL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new EvalException("invalid argument to uri-to-file-name: '" + string + "' not an URL");
                }
                File file = URLUtil.urlToFile(uRL);
                return file == null ? "" : file.getPath();
            }
        };
    }
}

