/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.xpath.EvalException;
import java.net.URL;
import java.util.Iterator;

public final class Token
implements XNode {
    public final String text;
    public final XNode document;

    public Token(String string, XNode xNode) throws EvalException {
        if (string == null || xNode == null) {
            throw new EvalException("cannot initialize Token");
        }
        this.text = string;
        this.document = xNode;
    }

    @Override
    public XNode.Type type() {
        return XNode.Type.TEXT;
    }

    @Override
    public XNode document() {
        return this.document;
    }

    @Override
    public XNode parent() {
        return null;
    }

    @Override
    public XNode following() {
        return null;
    }

    @Override
    public XNode preceding() {
        return null;
    }

    @Override
    public Name name() {
        return null;
    }

    @Override
    public String data() {
        return this.text;
    }

    @Override
    public NamespacePrefixMap namespacePrefixMap() {
        return this.document.namespacePrefixMap();
    }

    @Override
    public XNode firstChild() {
        return null;
    }

    @Override
    public XNode lastChild() {
        return null;
    }

    @Override
    public String attributeValue(Name name) {
        return null;
    }

    @Override
    public Iterator<XNode> attributes() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Token)) {
            return false;
        }
        Token token = (Token)object;
        return this.text.equals(token.text) && this.document == token.document;
    }

    @Override
    public int compareTo(XNode xNode) {
        return this.document.compareTo(xNode.document());
    }

    @Override
    public XNode deepCopy() {
        try {
            return new Token(this.text, this.document);
        }
        catch (EvalException evalException) {
            return null;
        }
    }

    @Override
    public URL getSourceURL() {
        return this.document.getSourceURL();
    }

    @Override
    public URL getBaseURL() {
        return this.document.getBaseURL();
    }

    @Override
    public String getLabel() {
        return "#text";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Token#");
        stringBuilder.append(System.identityHashCode(this));
        stringBuilder.append("[\"");
        stringBuilder.append(this.text);
        stringBuilder.append("\", Document#");
        stringBuilder.append(System.identityHashCode(this.document));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

