/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.clipboard.ClipboardFormat;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function1;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.ParseException;
import java.util.ArrayList;

class SerializeFunction
extends Function1 {
    SerializeFunction() {
    }

    @Override
    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        final ConvertibleNodeSetExpr convertibleNodeSetExpr = convertibleExpr.makeNodeSetExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                Object object;
                XNode xNode2;
                NodeIterator nodeIterator = convertibleNodeSetExpr.eval(xNode, exprContext);
                ArrayList<Node> arrayList = new ArrayList<Node>();
                boolean bl = true;
                PrefixEntry[] prefixEntryArray = null;
                while ((xNode2 = nodeIterator.next()) != null) {
                    switch (xNode2.type()) {
                        case DOCUMENT_TYPE_DECLARATION: {
                            throw new EvalException("cannot serialize DOCTYPE nodes");
                        }
                        case ATTRIBUTE: {
                            throw new EvalException("cannot serialize attribute nodes");
                        }
                        case DOCUMENT: {
                            throw new EvalException("cannot serialize document nodes");
                        }
                    }
                    if (!(xNode2 instanceof Node)) {
                        throw new EvalException("cannot serialize " + xNode2.getClass().getName() + " objects");
                    }
                    if (bl) {
                        bl = false;
                        object = (Document)xNode2.document();
                        if (object != null) {
                            prefixEntryArray = object.getPrefixPreferences(false);
                        }
                    }
                    arrayList.add((Node)xNode2);
                }
                int n = arrayList.size();
                if (n == 0) {
                    throw new EvalException("cannot serialize the empty node-set");
                }
                object = new Node[n];
                arrayList.toArray((T[])object);
                object = ClipboardFormat.checkForFormat(object, n);
                return ClipboardFormat.format(object, n, prefixEntryArray, true);
            }
        };
    }
}

