/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.ParseException;
import java.net.MalformedURLException;
import java.net.URL;

class ResolveURIFunction
implements Function {
    ResolveURIFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length < 1 || convertibleExprArray.length > 2) {
            throw new ParseException("expected 1 or 2 arguments");
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExprArray[0].makeStringExpr();
        final ConvertibleStringExpr convertibleStringExpr2 = convertibleExprArray.length == 1 ? null : convertibleExprArray[1].makeStringExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                String string = convertibleStringExpr.eval(xNode, exprContext);
                try {
                    URLUtil.newURL(string);
                    return string;
                }
                catch (MalformedURLException malformedURLException) {
                    URL uRL;
                    Object object;
                    if (convertibleStringExpr2 != null) {
                        object = convertibleStringExpr2.eval(xNode, exprContext);
                        try {
                            uRL = URLUtil.newURL((String)object);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            throw new EvalException("invalid argument to resolve-uri: '" + (String)object + "' malformed URL");
                        }
                    } else {
                        uRL = xNode.getBaseURL();
                        if (uRL == null) {
                            throw new EvalException("resolve-uri cannot use the context node to resolve its relative URI argument: the context node has no \"sourceURL\" property");
                        }
                    }
                    try {
                        object = URLUtil.newURL(uRL, string);
                    }
                    catch (MalformedURLException malformedURLException3) {
                        throw new EvalException("invalid argument to resolve-uri: '" + string + "' malformed URL");
                    }
                    return ((URL)object).toExternalForm();
                }
            }
        };
    }
}

