/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.ParseException;
import java.net.MalformedURLException;
import java.net.URL;

class RelativizeURIFunction
implements Function {
    RelativizeURIFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length < 1 || convertibleExprArray.length > 2) {
            throw new ParseException("expected 1 or 2 arguments");
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExprArray[0].makeStringExpr();
        final ConvertibleStringExpr convertibleStringExpr2 = convertibleExprArray.length == 1 ? null : convertibleExprArray[1].makeStringExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                URL uRL;
                String string;
                URL uRL2;
                String string2 = convertibleStringExpr.eval(xNode, exprContext);
                try {
                    uRL2 = URLUtil.newURL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new EvalException("invalid argument to relativize-uri: '" + string2 + "' malformed URL");
                }
                if (convertibleStringExpr2 != null) {
                    string = convertibleStringExpr2.eval(xNode, exprContext);
                    try {
                        uRL = URLUtil.newURL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new EvalException("invalid argument to relativize-uri: '" + string + "' malformed URL");
                    }
                } else {
                    uRL = xNode.getBaseURL();
                    if (uRL == null) {
                        throw new EvalException("relativize-uri cannot use the context node to relativize its absolute URI argument: the context node has no \"sourceURL\" property");
                    }
                }
                if ((string = uRL2.getRef()) != null) {
                    uRL2 = URLUtil.setRawFragment(uRL2, null);
                    if (string.length() == 0) {
                        string = null;
                    }
                }
                if (uRL2.sameFile(uRL) && string != null) {
                    return "#" + string;
                }
                Object object = URLUtil.getRawRelativePath(uRL2, uRL);
                if (object == null) {
                    return string2;
                }
                if (string != null) {
                    object = (String)object + "#" + string;
                }
                return object;
            }
        };
    }
}

