/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NodeUtil;

class FollowingNodeIterator
implements NodeIterator {
    private NodeIterator iter;
    private XNode parent;

    public FollowingNodeIterator(XNode xNode) {
        if (xNode.type() == XNode.Type.ATTRIBUTE) {
            xNode = xNode.parent();
        }
        this.parent = xNode.parent();
        if (this.parent == null) {
            this.parent = xNode;
        }
        this.iter = NodeUtil.getFollowingSiblings(xNode);
    }

    @Override
    public XNode next() throws EvalException {
        while (true) {
            XNode xNode;
            if ((xNode = this.iter.next()) != null) {
                this.parent = xNode;
                this.iter = NodeUtil.getChildren(xNode);
                return xNode;
            }
            this.iter = NodeUtil.getFollowingSiblings(this.parent);
            xNode = this.parent.parent();
            if (xNode == null) break;
            this.parent = xNode;
        }
        return null;
    }
}

